/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class DocInfo {
    private static final Font textFont = new Font("Serif", 0, 12);
    private static final Font headFont = new Font("SansSerif", 1, 14);
    private static boolean sortFontsByDir = true;
    private static final String user_dir = System.getProperty("user.dir");
    private static final JScrollPane fontScrollPane = new JScrollPane();

    public static void execute(Object[] objectArray, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        if (objectArray == null) {
            if (!values.isPDF()) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
            } else if (values.getSelectedFile() == null) {
                gUIFactory.showMessageDialog((Object)Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
            } else {
                DocInfo.getDocumentProperties(values.getSelectedFile(), values.getFileSize(), values.getPageCount(), values.getCurrentPage(), pdfDecoderInt, gUIFactory);
            }
        }
    }

    private static void getDocumentProperties(String string, long l, int n, int n2, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        PdfFileInformation pdfFileInformation;
        String string2;
        int n3;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(Color.WHITE);
        if (LogWriter.isRunningFromIDE) {
            jTabbedPane.setName("docProp");
        }
        if ((n3 = string.lastIndexOf(92)) == -1) {
            n3 = string.lastIndexOf(47);
        }
        String string3 = string.substring(n3 + 1, string.length());
        String string4 = string.substring(0, n3 + 1);
        int n4 = 0;
        jTabbedPane.add(DocInfo.getPropertiesBox(string3, string4, user_dir, l, n, n2, pdfDecoderInt));
        jTabbedPane.setTitleAt(n4++, Messages.getMessage("PdfViewerTab.Properties"));
        jTabbedPane.add(DocInfo.getFontInfoBox(pdfDecoderInt.getInfo(373243460)));
        jTabbedPane.setTitleAt(n4++, Messages.getMessage("PdfViewerTab.Fonts"));
        if (ImageCommands.trackImages) {
            jTabbedPane.add(DocInfo.getImageInfoBox(pdfDecoderInt));
            jTabbedPane.setTitleAt(n4++, Messages.getMessage("PdfViewerTab.Images"));
        }
        jTabbedPane.add(DocInfo.getFontsFoundInfoBox());
        jTabbedPane.setTitleAt(n4++, "Available");
        jTabbedPane.add(DocInfo.getFontsAliasesInfoBox());
        jTabbedPane.setTitleAt(n4++, "Aliases");
        int n5 = n4;
        if (DocInfo.getFormList(pdfDecoderInt) != null) {
            jTabbedPane.add(DocInfo.getFormList(pdfDecoderInt));
            jTabbedPane.setTitleAt(n5, "Forms");
            ++n5;
        }
        if (!(string2 = (pdfFileInformation = pdfDecoderInt.getFileInformationData()).getFileXMLMetaData()).isEmpty()) {
            jTabbedPane.add(DocInfo.getXMLInfoBox(string2));
            jTabbedPane.setTitleAt(n5, "XML");
        }
        gUIFactory.showMessageDialog((Object)jTabbedPane, Messages.getMessage("PdfViewerTab.DocumentProperties"), -1);
    }

    private static JScrollPane getPropertiesBox(String string, String string2, String string3, long l, int n, int n2, PdfDecoderInt pdfDecoderInt) {
        PdfFileInformation pdfFileInformation = pdfDecoderInt.getFileInformationData();
        if (pdfFileInformation != null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(true);
            jPanel.setBackground(Color.white);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerGeneral"));
            jLabel.setFont(headFont);
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerFileName") + string);
            jLabel2.setFont(textFont);
            jLabel2.setOpaque(false);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfViewerFilePath") + string2);
            jLabel3.setFont(textFont);
            jLabel3.setOpaque(false);
            jPanel.add(jLabel3);
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + string3);
            jLabel4.setFont(textFont);
            jLabel4.setOpaque(false);
            jPanel.add(jLabel4);
            JLabel jLabel5 = new JLabel(Messages.getMessage("PdfViewerFileSize") + l + " K");
            jLabel5.setFont(textFont);
            jLabel5.setOpaque(false);
            jPanel.add(jLabel5);
            JLabel jLabel6 = new JLabel(Messages.getMessage("PdfViewerPageCount") + n);
            jLabel6.setOpaque(false);
            jLabel6.setFont(textFont);
            jPanel.add(jLabel6);
            StringBuilder stringBuilder = new StringBuilder("PDF ");
            stringBuilder.append(pdfDecoderInt.getPDFVersion());
            if (pdfDecoderInt.getJPedalObject(2004845231) != null) {
                stringBuilder.append(" (").append(Messages.getMessage("PdfViewerLinearized.text")).append(") ");
            }
            JLabel jLabel7 = new JLabel(stringBuilder.toString());
            jLabel7.setOpaque(false);
            jLabel7.setFont(textFont);
            jPanel.add(jLabel7);
            jPanel.add(Box.createVerticalStrut(10));
            JLabel jLabel8 = new JLabel(Messages.getMessage("PdfViewerProperties"));
            jLabel8.setFont(headFont);
            jLabel8.setOpaque(false);
            jPanel.add(jLabel8);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = PdfFileInformation.getFieldNames();
            int n3 = stringArray2.length;
            JLabel[] jLabelArray = new JLabel[n3];
            for (int i = 0; i < n3; ++i) {
                if (stringArray[i].isEmpty()) continue;
                jLabelArray[i] = new JLabel(stringArray2[i] + " = " + stringArray[i]);
                jLabelArray[i].setFont(textFont);
                jLabelArray[i].setOpaque(false);
                jPanel.add(jLabelArray[i]);
            }
            jPanel.add(Box.createVerticalStrut(10));
            PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
            if (pdfPageData != null) {
                JLabel jLabel9 = new JLabel(Messages.getMessage("PdfViewerCoords.text"));
                jLabel9.setFont(headFont);
                jPanel.add(jLabel9);
                JLabel jLabel10 = new JLabel(Messages.getMessage("PdfViewermediaBox.text") + pdfPageData.getMediaValue(n2));
                jLabel10.setFont(textFont);
                jPanel.add(jLabel10);
                JLabel jLabel11 = new JLabel(Messages.getMessage("PdfViewercropBox.text") + pdfPageData.getCropValue(n2));
                jLabel11.setFont(textFont);
                jPanel.add(jLabel11);
                JLabel jLabel12 = new JLabel(Messages.getMessage("PdfViewerLabel.Rotation") + pdfPageData.getRotation(n2));
                jLabel12.setFont(textFont);
                jPanel.add(jLabel12);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            return jScrollPane;
        }
        return new JScrollPane();
    }

    private static JScrollPane getFontInfoBox(String string) {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        StringBuilder stringBuilder = new StringBuilder("Font Substitution mode: ");
        switch (FontMappings.getFontSubstitutionMode()) {
            case 1: {
                stringBuilder.append("using file name");
                break;
            }
            case 2: {
                stringBuilder.append("using PostScript name");
                break;
            }
            case 3: {
                stringBuilder.append("using family name");
                break;
            }
            case 4: {
                stringBuilder.append("using the full font name");
                break;
            }
            default: {
                stringBuilder.append("Unknown FontSubstitutionMode");
            }
        }
        stringBuilder.append('\n');
        if (!string.isEmpty()) {
            JTextArea jTextArea = new JTextArea();
            JLabel jLabel = new JLabel();
            jLabel.setAlignmentX(0.5f);
            jLabel.setText(stringBuilder.toString());
            jLabel.setForeground(Color.BLUE);
            jTextArea.setLineWrap(false);
            jTextArea.setForeground(Color.BLACK);
            jTextArea.setText('\n' + string);
            jPanel.add(jLabel);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
        }
        return jScrollPane;
    }

    private static JScrollPane getImageInfoBox(PdfDecoderInt pdfDecoderInt) {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        String string = pdfDecoderInt.getInfo(1026635598);
        if (!string.isEmpty()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(false);
            jTextArea.setForeground(Color.BLACK);
            jTextArea.setText('\n' + string);
            jPanel.add(jTextArea);
            jTextArea.setCaretPosition(0);
            jTextArea.setOpaque(false);
        }
        return jScrollPane;
    }

    private static void displayAvailableFonts(DefaultMutableTreeNode defaultMutableTreeNode) {
        fontScrollPane.getViewport().removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)new JTree(defaultMutableTreeNode), "West");
        fontScrollPane.getViewport().add(jPanel);
    }

    private static DefaultMutableTreeNode populateAvailableFonts(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        block10: {
            if (FontMappings.fontSubstitutionTable == null) break block10;
            Set set = FontMappings.fontSubstitutionTable.keySet();
            Iterator iterator = FontMappings.fontSubstitutionTable.keySet().iterator();
            int n = set.size();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toString());
            }
            Collections.sort(arrayList);
            if (sortFontsByDir) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<DefaultMutableTreeNode> arrayList3 = new ArrayList<DefaultMutableTreeNode>();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    Object e = arrayList.get(i);
                    String string2 = (String)FontMappings.fontSubstitutionLocation.get(e);
                    int n2 = string2.lastIndexOf(System.getProperty("file.separator"));
                    if (n2 == -1 && string2.indexOf(47) != -1) {
                        n2 = string2.lastIndexOf(47);
                    }
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2);
                    }
                    if (string != null && !((String)e).toLowerCase().contains(string.toLowerCase())) continue;
                    if (!arrayList2.contains(string2)) {
                        arrayList2.add(string2);
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DefaultMutableTreeNode(string2));
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        arrayList3.add(defaultMutableTreeNode2);
                    }
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(e + " = " + FontMappings.fontSubstitutionLocation.get(e));
                    int n3 = arrayList2.indexOf(string2);
                    ((DefaultMutableTreeNode)arrayList3.get(n3)).add(defaultMutableTreeNode2);
                    String string3 = (String)FontMappings.fontPropertiesTable.get(e + "_path");
                    Integer n4 = (Integer)FontMappings.fontPropertiesTable.get(e + "_type");
                    Map map = StandardFonts.getFontDetails(n4, string3);
                    if (map == null) continue;
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(k + " = " + v);
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList.get(i);
                    if (string != null && !((String)e).toLowerCase().contains(string.toLowerCase())) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(e + " = " + FontMappings.fontSubstitutionLocation.get(e));
                    defaultMutableTreeNode.add(defaultMutableTreeNode4);
                    Map map = (Map)FontMappings.fontPropertiesTable.get(e);
                    if (map == null) continue;
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(k + " = " + v);
                        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    }
                }
            }
        }
        return defaultMutableTreeNode;
    }

    private static JScrollPane getFontsAliasesInfoBox() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setEnabled(false);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : FontMappings.fontSubstitutionAliasTable.keySet()) {
            stringBuilder.append(object);
            stringBuilder.append(" ==> ");
            stringBuilder.append(FontMappings.fontSubstitutionAliasTable.get(object));
            stringBuilder.append('\n');
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            Object object;
            object = new JTextArea();
            ((JTextArea)object).setLineWrap(false);
            ((JTextComponent)object).setText(string);
            jPanel.add((Component)object);
            ((JTextComponent)object).setCaretPosition(0);
            ((JComponent)object).setOpaque(false);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        return jScrollPane;
    }

    private static JPanel getFontsFoundInfoBox() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(Color.WHITE);
        fontScrollPane.setBackground(Color.WHITE);
        fontScrollPane.getViewport().setBackground(Color.WHITE);
        fontScrollPane.setPreferredSize(new Dimension(400, 300));
        fontScrollPane.getViewport().add(jPanel);
        fontScrollPane.setVerticalScrollBarPolicy(20);
        fontScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel("Filter Font List");
        jPanel3.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Sort By Folder");
        jRadioButton.setBackground(Color.WHITE);
        JRadioButton jRadioButton2 = new JRadioButton("Sort By Name");
        jRadioButton2.setBackground(Color.WHITE);
        final JTextField jTextField = new JTextField();
        if (sortFontsByDir) {
            jRadioButton.setSelected(true);
        } else {
            jRadioButton2.setSelected(true);
        }
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBackground(Color.WHITE);
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)jRadioButton, "West");
        jPanel4.add((Component)jTextField, "Center");
        jPanel4.add((Component)jRadioButton2, "East");
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!sortFontsByDir) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Fonts");
                    sortFontsByDir = true;
                    defaultMutableTreeNode = DocInfo.populateAvailableFonts(defaultMutableTreeNode, jTextField.getText());
                    DocInfo.displayAvailableFonts(defaultMutableTreeNode);
                }
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (sortFontsByDir) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Fonts");
                    sortFontsByDir = false;
                    defaultMutableTreeNode = DocInfo.populateAvailableFonts(defaultMutableTreeNode, jTextField.getText());
                    DocInfo.displayAvailableFonts(defaultMutableTreeNode);
                }
            }
        });
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Fonts");
                DocInfo.populateAvailableFonts(defaultMutableTreeNode, ((JTextField)keyEvent.getSource()).getText());
                DocInfo.displayAvailableFonts(defaultMutableTreeNode);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Fonts");
        defaultMutableTreeNode = DocInfo.populateAvailableFonts(defaultMutableTreeNode, null);
        JTree jTree = new JTree(defaultMutableTreeNode);
        jPanel.add((Component)jTree, "West");
        jPanel2.add((Component)jPanel4, "North");
        jPanel2.add((Component)fontScrollPane, "Center");
        jPanel2.setPreferredSize(new Dimension(400, 300));
        return jPanel2;
    }

    private static JScrollPane getFormList(PdfDecoderInt pdfDecoderInt) {
        Object[] objectArray;
        JScrollPane jScrollPane = null;
        AcroRenderer acroRenderer = pdfDecoderInt.getFormRenderer();
        if (acroRenderer != null && (objectArray = acroRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, pdfDecoderInt.getPageNumber())) != null) {
            int n = objectArray.length;
            JPanel jPanel = new JPanel();
            jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JLabel jLabel = new JLabel("This page contains " + n + " form objects");
            jLabel.setFont(headFont);
            jPanel.add(jLabel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            for (Object object : objectArray) {
                Object object22;
                String string = (String)object;
                Object[] objectArray2 = acroRenderer.getFormComponents(string, ReturnValues.GUI_FORMS_FROM_NAME, -1);
                if (objectArray2 == null) continue;
                FormObject formObject = null;
                StringBuilder stringBuilder = new StringBuilder("PDF ref=");
                Object[] objectArray3 = acroRenderer.getFormComponents(string, ReturnValues.FORMOBJECTS_FROM_NAME, -1);
                for (Object object22 : objectArray3) {
                    formObject = (FormObject)object22;
                    stringBuilder.append(' ').append(formObject.getObjectRefAsString());
                }
                JLabel jLabel2 = new JLabel(stringBuilder.toString());
                JLabel jLabel3 = new JLabel(string);
                JLabel jLabel4 = new JLabel();
                jLabel4.setText("Type=" + PdfDictionary.showAsConstant(formObject.getParameterConstant(608780341)) + " Subtype=" + PdfDictionary.showAsConstant(formObject.getParameterConstant(1147962727)));
                object22 = "java class=" + objectArray2[0].getClass();
                JLabel jLabel5 = new JLabel((String)object22);
                jLabel3.setFont(headFont);
                jLabel3.setForeground(Color.blue);
                jLabel4.setFont(textFont);
                jLabel4.setForeground(Color.blue);
                jLabel5.setFont(textFont);
                jLabel5.setForeground(Color.blue);
                jLabel2.setFont(textFont);
                jLabel2.setForeground(Color.blue);
                jPanel.add(jLabel3);
                jPanel.add(jLabel4);
                jPanel.add(jLabel5);
                jPanel.add(jLabel2);
            }
        }
        return jScrollPane;
    }

    private static JScrollPane getXMLInfoBox(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.getViewport().add(jPanel);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(5);
        jTextArea.setColumns(15);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string);
        jPanel.add(new JScrollPane(jTextArea));
        jTextArea.setCaretPosition(0);
        jTextArea.setOpaque(true);
        jTextArea.setBackground(Color.white);
        return jScrollPane;
    }
}

