/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Exit {
    public static void execute(Object[] objectArray, GUIThumbnailPanel gUIThumbnailPanel, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile) {
        if (objectArray == null) {
            Exit.exit(gUIThumbnailPanel, gUIFactory, values, pdfDecoderInt, propertiesFile);
        }
    }

    public static void exit(GUIThumbnailPanel gUIThumbnailPanel, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile) {
        gUIThumbnailPanel.terminateDrawing();
        SaveForm.handleUnsaveForms(gUIFactory, values, pdfDecoderInt);
        if (LogWriter.isRunningFromIDE) {
            int n = !DevFlags.GUITESTINGINPROGRESS && gUIFactory.confirmClose() ? JOptionPane.showConfirmDialog(null, new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), 2, -1) : 0;
            if (n == 2) {
                return;
            }
            if (pdfDecoderInt.getDisplayView() == 5) {
                pdfDecoderInt.getPages().stopGeneratingPage();
            }
        }
        pdfDecoderInt.closePdfFile();
        try {
            propertiesFile.setValue("lastDocumentPage", String.valueOf(values.getCurrentPage()));
            if (propertiesFile.getValue("trackViewerSize").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startViewerWidth", String.valueOf(((Container)gUIFactory.getFrame()).getWidth()));
                propertiesFile.setValue("startViewerHeight", String.valueOf(((Container)gUIFactory.getFrame()).getHeight()));
            }
            if (propertiesFile.getValue("trackScaling").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startScaling", String.valueOf(((GUI)gUIFactory).getSelectedComboItem(252)));
            }
            if (propertiesFile.getValue("trackView").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startView", String.valueOf(pdfDecoderInt.getDisplayView()));
            }
            if (propertiesFile.getValue("startSideTabOpen").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startSideTabOpen", "true");
            }
            if (propertiesFile.getValue("trackSelectedSideTab").equalsIgnoreCase("true")) {
                JTabbedPane jTabbedPane = (JTabbedPane)gUIFactory.getSideTabBar();
                if (DecoderOptions.isRunningOnMac) {
                    propertiesFile.setValue("startSelectedSideTab", jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex()));
                } else {
                    propertiesFile.setValue("startSelectedSideTab", jTabbedPane.getIconAt(jTabbedPane.getSelectedIndex()).toString());
                }
            }
            if (propertiesFile.getValue("trackSideTabExpandedSize").equalsIgnoreCase("true")) {
                propertiesFile.setValue("sideTabBarExpandLength", String.valueOf(gUIFactory.getSplitDividerLocation()));
            }
            propertiesFile.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception attempting to Write proterties: " + exception);
        }
        if (DevFlags.GUITESTINGINPROGRESS || !Viewer.exitOnClose) {
            ((Container)gUIFactory.getFrame()).setVisible(false);
            if (gUIFactory.getFrame() instanceof JFrame) {
                ((JFrame)gUIFactory.getFrame()).dispose();
            }
            pdfDecoderInt.dispose();
            gUIFactory.dispose();
        } else {
            ((Container)gUIFactory.getFrame()).setVisible(false);
            if (gUIFactory.getFrame() instanceof JFrame) {
                ((JFrame)gUIFactory.getFrame()).dispose();
            }
            pdfDecoderInt.dispose();
            gUIFactory.dispose();
            System.exit(0);
        }
    }
}

