/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.IconiseImage;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    public static void execute(Values values, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt) {
        ExtractSelectionAsImage.extractSelectedScreenAsImage(values, gUIFactory, pdfDecoderInt);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (snapShot == null) {
            return;
        }
        Object object = new IconiseImage(snapShot);
        jPanel.add((Component)new JLabel((Icon)object), "Center");
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jPanel);
        int n = snapShot.getWidth();
        if (n < snapShot.getHeight()) {
            n = snapShot.getHeight();
        }
        if ((n += 50) > 450) {
            n = 450;
        }
        Container container = (Container)gUIFactory.getFrame();
        final JDialog jDialog = new JDialog((Frame)null, true);
        jDialog.setDefaultCloseOperation(2);
        if (values.getModeOfOperation() != 1) {
            jDialog.setLocationRelativeTo(null);
            jDialog.setLocation(container.getLocationOnScreen().x + 10, container.getLocationOnScreen().y + 10);
        }
        jDialog.setSize(n, n);
        jDialog.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
        jButton.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener((JScrollPane)object, gUIFactory){
            final /* synthetic */ JScrollPane val$image_scroll;
            final /* synthetic */ GUIFactory val$currentGUI;
            {
                this.val$image_scroll = jScrollPane;
                this.val$currentGUI = gUIFactory;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                boolean bl = false;
                while (!bl) {
                    JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                    FileFilterer fileFilterer = new FileFilterer(new String[]{"png", "png"}, "PNG");
                    jFileChooser.setFileFilter(fileFilterer);
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int n = jFileChooser.showSaveDialog(this.val$image_scroll);
                    if (n == 0) {
                        int n2;
                        File file = jFileChooser.getSelectedFile();
                        StringBuffer stringBuffer = new StringBuffer(file.getAbsolutePath());
                        String string = jFileChooser.getFileFilter().getDescription();
                        if (string.equals("All Files")) {
                            string = "TIFF";
                        }
                        if (!stringBuffer.toString().toLowerCase().endsWith(('.' + string).toLowerCase())) {
                            stringBuffer.append('.').append(string);
                            file = new File(stringBuffer.toString());
                        }
                        if (file.exists() && (n2 = this.val$currentGUI.showConfirmDialog(stringBuffer.append('\n') + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (snapShot != null) {
                            try {
                                DefaultImageHelper.write(snapShot, string, stringBuffer.toString());
                            }
                            catch (IOException iOException) {
                                LogWriter.writeLog("Exception in writing image " + iOException);
                            }
                        }
                        bl = true;
                        continue;
                    }
                    return;
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
        jButton2.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton2, "East");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }
}

