/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.commands.generic.GUIExtractText;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

public class ExtractText
extends GUIExtractText {
    public static void execute(Object[] objectArray, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, Values values) {
        if (objectArray == null) {
            ExtractText.extractSelectedText(gUIFactory, pdfDecoderInt, values);
        }
    }

    private static void extractSelectedText(final GUIFactory gUIFactory, final PdfDecoderInt pdfDecoderInt, final Values values) {
        if (!pdfDecoderInt.isExtractionAllowed()) {
            gUIFactory.showMessageDialog("Not allowed");
            return;
        }
        final int[][] nArray = pdfDecoderInt.getTextLines().getHighlightedAreasAs2DArray(values.getCurrentPage());
        if (nArray == null) {
            return;
        }
        JScrollPane jScrollPane = new JScrollPane();
        final JPanel jPanel = new JPanel();
        final ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("Extract as Text");
        final JRadioButton jRadioButton2 = new JRadioButton("Extract  as  XML");
        final JRadioButton jRadioButton3 = new JRadioButton(Messages.getMessage("PdfViewerRect.label"));
        final JRadioButton jRadioButton4 = new JRadioButton(Messages.getMessage("PdfViewerTable.label"));
        final JRadioButton jRadioButton5 = new JRadioButton(Messages.getMessage("PdfViewerWordList.label"));
        final SpringLayout springLayout = new SpringLayout();
        final JFrame jFrame = new JFrame(Messages.getMessage("PdfViewerCoords.message") + ' ' + values.m_x1 + " , " + values.m_y1 + " , " + (values.m_x2 - values.m_x1) + " , " + (values.m_y2 - values.m_y1));
        jFrame.setDefaultCloseOperation(2);
        JLabel jLabel = new JLabel("                         ");
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerHelpMenu.text"), Messages.getMessage("PdfViewerCancel.text"), Messages.getMessage("PdfViewerextract.text")};
        JButton jButton = new JButton((String)objectArray[0]);
        JButton jButton2 = new JButton((String)objectArray[1]);
        JButton jButton3 = new JButton((String)objectArray[2]);
        jPanel.setLayout(springLayout);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    Component[] componentArray = jPanel.getComponents();
                    for (int i = 0; i != componentArray.length; ++i) {
                        if (!(componentArray[i] instanceof JScrollPane)) continue;
                        jPanel.remove(componentArray[i]);
                    }
                    try {
                        JScrollPane jScrollPane = ExtractText.updateExtractionExample(pdfDecoderInt, values, gUIFactory, abstractButton, jRadioButton2.isSelected());
                        if (jScrollPane != null) {
                            springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
                            springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
                            jPanel.add(jScrollPane);
                            break;
                        }
                        JLabel jLabel = new JLabel("No Example Available");
                        Font font = jLabel.getFont();
                        font = font.deriveFont(font.getStyle(), 20.0f);
                        jLabel.setFont(font);
                        jLabel.setForeground(Color.RED);
                        springLayout.putConstraint("East", (Component)jLabel, -75, "East", (Component)jPanel);
                        springLayout.putConstraint("North", (Component)jLabel, 50, "South", (Component)jRadioButton4);
                        jPanel.add(jLabel);
                    }
                    catch (PdfException pdfException) {
                        Logger.getLogger(ExtractText.class.getName()).log(Level.SEVERE, null, pdfException);
                    }
                    break;
                }
                jPanel.updateUI();
            }
        };
        jLabel.setFont(new Font("SansSerif", 1, 10));
        jLabel.setForeground(Color.red);
        springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jLabel, -5, "South", (Component)jPanel);
        jPanel.add(jLabel);
        jRadioButton3.setSelected(true);
        jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton3);
        jRadioButton3.setToolTipText(Messages.getMessage("PdfViewerRect.message"));
        springLayout.putConstraint("West", (Component)jRadioButton3, 10, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton3, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton3);
        jRadioButton4.setSelected(true);
        jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract as XHTML");
                jRadioButton.setText("Extract as CSV");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton4);
        jRadioButton4.setToolTipText(Messages.getMessage("PdfViewerTable.message"));
        springLayout.putConstraint("West", (Component)jRadioButton4, 50, "East", (Component)jRadioButton3);
        springLayout.putConstraint("North", (Component)jRadioButton4, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton4);
        jRadioButton5.setSelected(true);
        jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton5);
        jRadioButton5.setToolTipText(Messages.getMessage("PdfViewerWordList.message"));
        springLayout.putConstraint("East", (Component)jRadioButton5, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton5, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton5);
        jScrollPane.setPreferredSize(new Dimension(315, 150));
        jScrollPane.setMinimumSize(new Dimension(315, 150));
        springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
        jPanel.add(jScrollPane);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.setSelected(true);
        springLayout.putConstraint("West", (Component)jRadioButton2, 5, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton2, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton2);
        springLayout.putConstraint("East", (Component)jRadioButton, -5, "East", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton);
        springLayout.putConstraint("South", (Component)jButton3, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton3, -5, "East", (Component)jPanel);
        jPanel.add(jButton3);
        springLayout.putConstraint("South", (Component)jButton2, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton2, -5, "West", (Component)jButton3);
        jPanel.add(jButton2);
        springLayout.putConstraint("South", (Component)jButton, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton, -5, "West", (Component)jButton2);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
                gUIFactory.showMessageDialog(jTextArea);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block22: {
                    try {
                        Object object;
                        String string = "";
                        PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
                        int n = pdfPageData.getCropBoxX(values.getCurrentPage());
                        int n2 = pdfPageData.getCropBoxY(values.getCurrentPage());
                        int n3 = pdfPageData.getCropBoxWidth(values.getCurrentPage());
                        int n4 = pdfPageData.getCropBoxHeight(values.getCurrentPage());
                        if (nArray != null) {
                            for (int i = 0; i != nArray.length; ++i) {
                                int n5;
                                object = "";
                                nArray[i] = GUICopy.adjustHighlightForExtraction(nArray[i]);
                                int n6 = nArray[i][0];
                                int n7 = nArray[i][0] + nArray[i][2];
                                int n8 = nArray[i][1] + nArray[i][3];
                                int n9 = nArray[i][1];
                                if (n8 < n9) {
                                    n5 = n9;
                                    n9 = n8;
                                    n8 = n5;
                                }
                                if (n6 > n7) {
                                    n5 = n7;
                                    n7 = n6;
                                    n6 = n5;
                                }
                                if (n6 < n) {
                                    n6 = n;
                                }
                                if (n6 > n3 - n) {
                                    n6 = n3 - n;
                                }
                                if (n7 < n) {
                                    n7 = n;
                                }
                                if (n7 > n3 - n) {
                                    n7 = n3 - n;
                                }
                                if (n8 < n2) {
                                    n8 = n2;
                                }
                                if (n8 > n4 - n2) {
                                    n8 = n4 - n2;
                                }
                                if (n9 < n2) {
                                    n9 = n2;
                                }
                                if (n9 > n4 - n2) {
                                    n9 = n4 - n2;
                                }
                                if (jRadioButton3.isSelected()) {
                                    object = ExtractText.extractTextRectangle(values, pdfDecoderInt, gUIFactory, jRadioButton2.isSelected(), n6, n7, n8, n9) + '\r' + '\n';
                                } else if (jRadioButton4.isSelected()) {
                                    object = ExtractText.extractTextTable(values, pdfDecoderInt, jRadioButton2.isSelected(), n6, n7, n8, n9);
                                } else if (jRadioButton5.isSelected()) {
                                    object = ExtractText.extractTextList(pdfDecoderInt, values, gUIFactory, jRadioButton2.isSelected(), n6, n7, n8, n9);
                                }
                                string = string + (String)object;
                            }
                        }
                        if (string == null) break block22;
                        JScrollPane jScrollPane = new JScrollPane();
                        try {
                            object = new JTextPane();
                            jScrollPane = ExtractText.createPane((JTextPane)object, string, true);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        jScrollPane.setHorizontalScrollBarPolicy(31);
                        jScrollPane.setVerticalScrollBarPolicy(20);
                        jScrollPane.setPreferredSize(new Dimension(400, 400));
                        object = new JDialog((Frame)null, true);
                        ((JDialog)object).setDefaultCloseOperation(2);
                        if (values.getModeOfOperation() != 1) {
                            Container container = (Container)gUIFactory.getFrame();
                            ((Window)object).setLocation(container.getLocationOnScreen().x + 10, container.getLocationOnScreen().y + 10);
                        }
                        ((Window)object).setSize(450, 450);
                        ((Dialog)object).setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
                        ((JDialog)object).getContentPane().setLayout(new BorderLayout());
                        ((JDialog)object).getContentPane().add((Component)jScrollPane, "Center");
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BorderLayout());
                        ((JDialog)object).getContentPane().add((Component)jPanel, "South");
                        JButton jButton = new JButton(Messages.getMessage("PdfViewerMenu.return"));
                        jButton.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton, "West");
                        jButton.addActionListener(new ActionListener((JDialog)object){
                            final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                this.val$displayFrame.dispose();
                            }
                        });
                        JButton jButton2 = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
                        jButton2.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton2, "East");
                        jButton2.addActionListener(new ActionListener((JDialog)object){
                            final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                this.val$displayFrame.dispose();
                            }
                        });
                        ((Dialog)object).setVisible(true);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setSize(350, 300);
        SwingUtilities.invokeLater(runnable);
        jFrame.setLocationRelativeTo((Container)gUIFactory.getFrame());
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    private static JScrollPane createPane(JTextPane jTextPane, String string, boolean bl) throws BadLocationException {
        Object object;
        jTextPane.setEditable(true);
        jTextPane.setFont(new Font("Lucida", 0, 14));
        jTextPane.setToolTipText(Messages.getMessage("PdfViewerTooltip.text"));
        Document document = jTextPane.getDocument();
        jTextPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), Messages.getMessage("PdfViewerTitle.text")));
        jTextPane.setForeground(Color.black);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.blue);
        StyleConstants.setForeground(simpleAttributeSet2, Color.black);
        StyleConstants.setForeground(simpleAttributeSet3, Color.black);
        int n = 0;
        if (bl && string != null) {
            object = new StringTokenizer(string, "<>", true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("<") && ((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = string2 + ((StringTokenizer)object).nextToken() + ((StringTokenizer)object).nextToken();
                    document.insertString(n, string3, simpleAttributeSet);
                    n += string3.length();
                    continue;
                }
                document.insertString(n, string2, simpleAttributeSet2);
                n += string2.length();
            }
        } else {
            document.insertString(n, string, simpleAttributeSet3);
        }
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jTextPane);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
        ((JScrollPane)object).setVerticalScrollBarPolicy(20);
        return object;
    }

    private static JScrollPane updateExtractionExample(PdfDecoderInt pdfDecoderInt, Values values, GUIFactory gUIFactory, AbstractButton abstractButton, boolean bl) throws PdfException {
        int n;
        int n2;
        JScrollPane jScrollPane = new JScrollPane();
        String string = "";
        PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
        int n3 = pdfPageData.getCropBoxX(values.getCurrentPage());
        int n4 = pdfPageData.getCropBoxY(values.getCurrentPage());
        int n5 = pdfPageData.getCropBoxWidth(values.getCurrentPage());
        int n6 = pdfPageData.getCropBoxHeight(values.getCurrentPage());
        int[][] nArray = pdfDecoderInt.getTextLines().getHighlightedAreasAs2DArray(values.getCurrentPage());
        if (nArray != null) {
            for (int i = 0; i != nArray.length; ++i) {
                int n7;
                if (nArray[i] == null) continue;
                nArray[i] = GUICopy.adjustHighlightForExtraction(nArray[i]);
                n2 = nArray[i][0];
                int n8 = nArray[i][0] + nArray[i][2];
                int n9 = nArray[i][1] + nArray[i][3];
                n = nArray[i][1];
                if (n9 < n) {
                    n7 = n;
                    n = n9;
                    n9 = n7;
                }
                if (n2 > n8) {
                    n7 = n8;
                    n8 = n2;
                    n2 = n7;
                }
                if (n2 < n3) {
                    n2 = n3;
                }
                if (n2 > n3 + n5) {
                    n2 = n3 + n5;
                }
                if (n8 < n3) {
                    n8 = n3;
                }
                if (n8 > n3 + n5) {
                    n8 = n3 + n5;
                }
                if (n9 < n4) {
                    n9 = n4;
                }
                if (n9 > n4 + n6) {
                    n9 = n4 + n6;
                }
                if (n < n4) {
                    n = n4;
                }
                if (n > n4 + n6) {
                    n = n4 + n6;
                }
                if (abstractButton.getText().equals("Table")) {
                    string = string + ExtractText.extractTextTable(values, pdfDecoderInt, bl, n2, n8, n9, n);
                }
                if (abstractButton.getText().equals("Rectangle")) {
                    string = string + ExtractText.extractTextRectangle(values, pdfDecoderInt, gUIFactory, bl, n2, n8, n9, n) + ' ';
                }
                if (!abstractButton.getText().equals("WordList")) continue;
                string = string + ExtractText.extractTextList(pdfDecoderInt, values, gUIFactory, bl, n2, n8, n9, n);
            }
        }
        if (!string.isEmpty()) {
            try {
                jScrollPane = ExtractText.createPane(new JTextPane(), string, bl);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            jScrollPane.setPreferredSize(new Dimension(315, 150));
            jScrollPane.setMinimumSize(new Dimension(315, 150));
            Component[] componentArray = jScrollPane.getComponents();
            for (n2 = 0; n2 != componentArray.length; ++n2) {
                if (!(jScrollPane.getComponent(n2) instanceof JViewport)) continue;
                JViewport jViewport = (JViewport)jScrollPane.getComponent(n2);
                Component[] componentArray2 = jViewport.getComponents();
                for (n = 0; n != componentArray2.length; ++n) {
                    if (!(componentArray2[n] instanceof JTextPane)) continue;
                    ((JTextPane)componentArray2[n]).setEditable(false);
                }
            }
            return jScrollPane;
        }
        return null;
    }
}

