/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

public class FullScreen {
    private static Window win;
    private static Point screenPosition;

    public static void execute(Object[] objectArray, final GUIFactory gUIFactory, GUIThumbnailPanel gUIThumbnailPanel, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile) {
        if (objectArray == null) {
            Component component;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            if (graphicsDevice.isFullScreenSupported()) {
                // empty if block
            }
            if (win == null) {
                component = new Frame(graphicsDevice.getDefaultConfiguration());
                win = new Window((Frame)component);
            } else if (graphicsDevice.getFullScreenWindow() != null && graphicsDevice.getFullScreenWindow().equals(win)) {
                FullScreen.exitFullScreen(gUIFactory);
                return;
            }
            if (gUIFactory.getFrame() instanceof JFrame) {
                ((JFrame)gUIFactory.getFrame()).getContentPane().remove((JSplitPane)gUIFactory.getDisplayPane());
                ((Container)gUIFactory.getFrame()).setVisible(false);
            } else {
                ((Container)gUIFactory.getFrame()).remove((JSplitPane)gUIFactory.getDisplayPane());
            }
            win.add((Component)((JSplitPane)gUIFactory.getDisplayPane()), "Center");
            component = new Button("Return");
            win.add(component, "North");
            ((Button)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FullScreen.exitFullScreen(gUIFactory);
                }
            });
            try {
                screenPosition = ((Container)gUIFactory.getFrame()).getLocation();
                graphicsDevice.setFullScreenWindow(win);
                win.validate();
                gUIFactory.scaleAndRotate();
            }
            catch (Error error) {
                gUIFactory.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit " + error);
                Exit.exit(gUIThumbnailPanel, gUIFactory, values, pdfDecoderInt, propertiesFile);
            }
        }
    }

    private static void exitFullScreen(final GUIFactory gUIFactory) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                graphicsDevice.setFullScreenWindow(null);
                win.remove((JSplitPane)gUIFactory.getDisplayPane());
                if (gUIFactory.getFrame() instanceof JFrame) {
                    ((JFrame)gUIFactory.getFrame()).getContentPane().add((Component)((JSplitPane)gUIFactory.getDisplayPane()), "Center");
                    ((Container)gUIFactory.getFrame()).setVisible(true);
                    if (screenPosition != null) {
                        ((Container)gUIFactory.getFrame()).setLocation(screenPosition);
                    }
                    screenPosition = null;
                } else {
                    ((Container)gUIFactory.getFrame()).add((Component)((JSplitPane)gUIFactory.getDisplayPane()), "Center");
                }
                ((JSplitPane)gUIFactory.getDisplayPane()).invalidate();
                ((JSplitPane)gUIFactory.getDisplayPane()).updateUI();
                if (gUIFactory.getFrame() instanceof JFrame) {
                    ((JFrame)gUIFactory.getFrame()).getContentPane().validate();
                } else {
                    ((Container)gUIFactory.getFrame()).validate();
                }
                win.dispose();
                win = null;
                gUIFactory.scaleAndRotate();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

