/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jpedal.display.GUIDisplay;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Info {
    private static final Font textFont1 = new Font("SansSerif", 0, 12);
    private static final Font headFont = new Font("SansSerif", 1, 14);

    public static void execute(Object[] objectArray, GUIFactory gUIFactory) {
        if (objectArray == null) {
            Info.getInfoBox(gUIFactory);
        }
    }

    private static void getInfoBox(GUIFactory gUIFactory) {
        Accessible accessible;
        final JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(400, 280));
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        jLabel.setOpaque(false);
        jLabel.setFont(headFont);
        jLabel.setAlignmentX(0.5f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        String string = Messages.getMessage("PdfViewerInfo1");
        if (!string.isEmpty()) {
            accessible = new JTextArea();
            ((JTextArea)accessible).setFont(textFont1);
            ((JComponent)((Object)accessible)).setOpaque(false);
            ((JTextComponent)accessible).setText(string + "\n\n                    Versions\n                     JPedal: " + "6.6.30" + "          " + "Java: " + System.getProperty("java.version"));
            ((JTextArea)accessible).setLineWrap(true);
            ((JTextArea)accessible).setWrapStyleWord(true);
            ((JTextComponent)accessible).setEditable(false);
            jPanel.add((Component)((Object)accessible));
            ((JComponent)((Object)accessible)).setAlignmentX(0.5f);
        }
        accessible = new ImageIcon(Info.class.getClass().getResource("/org/jpedal/examples/viewer/res/logo.png"));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel2 = new JLabel((Icon)((Object)accessible));
        jLabel2.setAlignmentX(0.5f);
        jPanel.add(jLabel2);
        final JLabel jLabel3 = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text"));
        jLabel3.setForeground(Color.blue);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setAlignmentX(0.5f);
        jLabel3.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    jPanel.setCursor(new Cursor(12));
                }
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + "</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    jPanel.setCursor(new Cursor(0));
                }
                jLabel3.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text"));
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception attempting launch browser: " + exception);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(jLabel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gUIFactory.showMessageDialog((Object)jPanel, Messages.getMessage("PdfViewerInfo3"), -1);
    }
}

