/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Container;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

class ModeChange {
    ModeChange() {
    }

    static void changeModeInSwing(final int n, final PdfDecoderInt pdfDecoderInt, final GUIFactory gUIFactory, final Values values, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow) {
        if (SwingUtilities.isEventDispatchThread()) {
            gUIFactory.setDisplayView(n, 2);
            ModeChange.chooseMode(pdfDecoderInt, values, gUIFactory);
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
            if (pdfDecoderInt.getDisplayView() == 5) {
                ModeChange.selectCurrentGui(gUIFactory);
            } else {
                ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
                ((Container)gUIFactory.getFrame()).setMinimumSize(new Dimension(0, 0));
            }
        } else {
            gUIFactory.setCommandInThread(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    gUIFactory.setDisplayView(n, 2);
                    ModeChange.chooseMode(pdfDecoderInt, values, gUIFactory);
                    gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
                    if (pdfDecoderInt.getDisplayView() == 5) {
                        ModeChange.selectCurrentGui(gUIFactory);
                    } else {
                        ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
                        ((Container)gUIFactory.getFrame()).setMinimumSize(new Dimension(0, 0));
                    }
                    gUIFactory.setExecutingCommand(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    static void changeModeInJavaFX(final int n, final PdfDecoderInt pdfDecoderInt, final GUIFactory gUIFactory, Values values, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow) {
        if (Platform.isFxApplicationThread()) {
            gUIFactory.setDisplayView(n, 2);
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
            ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
            Stage stage = (Stage)gUIFactory.getFrame();
            if (stage != null) {
                ((Stage)gUIFactory.getFrame()).setMinWidth(0.0);
                ((Stage)gUIFactory.getFrame()).setMinHeight(0.0);
            }
        } else {
            gUIFactory.setCommandInThread(true);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    gUIFactory.setDisplayView(n, 2);
                    gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
                    if (pdfDecoderInt.getDisplayView() == 5) {
                        ModeChange.selectCurrentGui(gUIFactory);
                    } else {
                        ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
                        ((Stage)gUIFactory.getFrame()).setMinWidth(0.0);
                        ((Stage)gUIFactory.getFrame()).setMinHeight(0.0);
                    }
                }
            };
            Platform.runLater((Runnable)runnable);
        }
    }

    static void chooseMode(PdfDecoderInt pdfDecoderInt, Values values, GUIFactory gUIFactory) {
        if (pdfDecoderInt.getDisplayView() == 4) {
            int n = values.getCurrentPage();
            if (pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (n & 1) == 1 && n != 1) {
                --n;
            } else if (!pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (n & 1) == 0) {
                --n;
            }
            values.setCurrentPage(n);
            gUIFactory.setPage(n);
            gUIFactory.decodePage();
        } else if (pdfDecoderInt.getDisplayView() == 3) {
            int n = values.getCurrentPage();
            if ((n & 1) == 1 && n != 1) {
                --n;
            }
            values.setCurrentPage(n);
            gUIFactory.setPage(n);
        }
    }

    static void selectCurrentGui(GUIFactory gUIFactory) {
        gUIFactory.decodePage();
        if (((GUI)gUIFactory).getSelectedComboIndex(252) != 0) {
            ((GUI)gUIFactory).setSelectedComboIndex(252, 0);
            ((GUI)gUIFactory).getSelectedComboItem(252);
        }
        if (((GUI)gUIFactory).getSelectedComboIndex(252) == 0) {
            int n = gUIFactory.getPdfDecoder().getPdfPageData().getCropBoxWidth(gUIFactory.getValues().getCurrentPage()) / 2;
            int n2 = gUIFactory.getPdfDecoder().getPdfPageData().getCropBoxHeight(gUIFactory.getValues().getCurrentPage()) / 2;
            if (n > 800) {
                n = 800;
            }
            if (n2 > 600) {
                n2 = 600;
            }
            if (Viewer.isFX()) {
                ((Stage)gUIFactory.getFrame()).setMinWidth((double)n);
                ((Stage)gUIFactory.getFrame()).setMinHeight((double)n2);
            } else {
                ((Container)gUIFactory.getFrame()).setMinimumSize(new Dimension(n, n2));
            }
        }
    }
}

