/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.popups.DownloadProgress;
import org.jpedal.examples.viewer.gui.popups.ErrorDialog;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class OpenFile {
    public static boolean isPDf;
    private static InputStream inputStream;
    private static int startX;
    private static int startY;

    public static void executeOpenURL(Object[] objectArray, Values values, GUISearchWindow gUISearchWindow, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        inputStream = null;
        if (objectArray == null) {
            SaveForm.handleUnsaveForms(gUIFactory, values, pdfDecoderInt);
            String string = OpenFile.selectURL(values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
            if (string != null) {
                values.setSelectedFile(string);
                values.setFileIsURL(true);
            }
        } else {
            gUIFactory.resetNavBar();
            String string = (String)objectArray[0];
            if (string != null) {
                values.setSelectedFile(string);
                values.setFileIsURL(true);
                boolean bl = false;
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection.getContent() == null) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    bl = true;
                    LogWriter.writeLog("Unable to open as URL " + string + ' ' + exception);
                }
                if (bl) {
                    string = null;
                }
                if (string != null) {
                    values.setFileSize(0L);
                    gUIFactory.setViewerTitle(null);
                    if (!Values.isProcessing()) {
                        gUIThumbnailPanel.terminateDrawing();
                        pdfDecoderInt.flushObjectValues(true);
                        pdfDecoderInt.resetViewableArea();
                        gUIFactory.stopThumbnails();
                        try {
                            OpenFile.openFile(values.getSelectedFile(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LogWriter.writeLog("Exception attempting to open file: " + interruptedException);
                        }
                    }
                }
            }
        }
    }

    public static void executeOpenFile(Object[] objectArray, Values values, GUISearchWindow gUISearchWindow, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        inputStream = null;
        if (objectArray == null) {
            SaveForm.handleUnsaveForms(gUIFactory, values, pdfDecoderInt);
            if (Values.isProcessing()) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            } else {
                OpenFile.selectFile(values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
                values.setFileIsURL(false);
            }
        } else if (objectArray.length == 2 && objectArray[0] instanceof byte[] && objectArray[1] instanceof String) {
            byte[] byArray = (byte[])objectArray[0];
            String string = (String)objectArray[1];
            values.setFileSize(byArray.length);
            values.setSelectedFile(string);
            gUIFactory.setViewerTitle(null);
            if (values.getSelectedFile() != null && !Values.isProcessing()) {
                pdfDecoderInt.resetViewableArea();
                try {
                    String string2;
                    isPDf = true;
                    values.setMultiTiff(false);
                    String string3 = System.getProperty("org.jpedal.hires");
                    if (DecoderOptions.hires || string3 != null) {
                        values.setUseHiresImage(true);
                    }
                    if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
                        values.setUseHiresImage(false);
                    }
                    gUIThumbnailPanel.resetToDefault();
                    gUIFactory.reinitThumbnails();
                    gUIFactory.setNoPagesDecoded();
                    if (gUISearchWindow != null) {
                        gUISearchWindow.removeSearchWindow(false);
                        gUISearchWindow.resetSearchWindow();
                    }
                    values.maxViewY = 0;
                    gUIFactory.setQualityBoxVisible(isPDf);
                    values.setCurrentPage(1);
                    if (gUIFactory.isSingle()) {
                        pdfDecoderInt.closePdfFile();
                    }
                    pdfDecoderInt.openPdfArray(byArray);
                    gUIFactory.updateStatusMessage("opening file");
                    boolean bl = true;
                    if (pdfDecoderInt.isEncrypted() && !pdfDecoderInt.isFileViewable()) {
                        bl = false;
                        String string4 = System.getProperty("org.jpedal.password");
                        if (string4 == null) {
                            string4 = gUIFactory.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                        }
                        if (string4 != null) {
                            pdfDecoderInt.setEncryptionPassword(string4);
                            if (pdfDecoderInt.isFileViewable()) {
                                bl = true;
                            }
                        }
                        if (!bl) {
                            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                        }
                    }
                    if (bl) {
                        if (propertiesFile.getValue("Recentdocuments").equals("true")) {
                            propertiesFile.addRecentDocument(values.getSelectedFile());
                            gUIFactory.getRecentDocument().updateRecentDocuments(propertiesFile.getRecentDocuments());
                        }
                        gUIFactory.getRecentDocument().addToFileList(values.getSelectedFile());
                        values.setCurrentPage(1);
                    }
                    OpenFile.processPage(values, pdfDecoderInt, gUIFactory, gUIThumbnailPanel);
                }
                catch (PdfException pdfException) {
                    LogWriter.writeLog("Exception attempting to open file: " + pdfException);
                }
            }
        } else if (objectArray.length >= 1) {
            if (objectArray[0] instanceof InputStream) {
                inputStream = (InputStream)objectArray[0];
                String string = "InputStream-" + System.currentTimeMillis() + ".pdf";
                values.setSelectedFile(string);
                values.setFileIsURL(true);
                if (inputStream != null) {
                    try {
                        values.setFileSize(0L);
                        gUIFactory.setViewerTitle(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (!Values.isProcessing()) {
                        gUIThumbnailPanel.terminateDrawing();
                        pdfDecoderInt.flushObjectValues(true);
                        pdfDecoderInt.resetViewableArea();
                        gUIFactory.stopThumbnails();
                        try {
                            OpenFile.openFile(values.getSelectedFile(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
                            while (Values.isProcessing()) {
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LogWriter.writeLog("Exception attempting to open file: " + interruptedException);
                        }
                    }
                }
            } else {
                Object object;
                String string;
                File file;
                if (objectArray[0] instanceof File) {
                    file = (File)objectArray[0];
                } else if (objectArray[0] instanceof String) {
                    string = (String)objectArray[0];
                    object = string.toCharArray();
                    if (object[1] == ':' || object[0] == '\\' || object[0] == '/') {
                        file = new File(string);
                    } else {
                        String string5 = new File(values.getSelectedFile()).getParent();
                        file = new File(string5, string);
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            file = new File(string5, string);
                            LogWriter.writeLog("Exception in IO " + iOException);
                        }
                    }
                } else {
                    file = null;
                }
                if (file != null) {
                    try {
                        values.setInputDir(file.getParentFile().getCanonicalPath());
                        OpenFile.open(file.getAbsolutePath(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
                        string = null;
                        if (objectArray.length > 1 && objectArray[1] instanceof String) {
                            object = (String)objectArray[1];
                            string = pdfDecoderInt.getIO().convertNameToRef((String)object);
                        }
                        if (string != null) {
                            object = new OutlineObject(string);
                            pdfDecoderInt.getIO().readObject((PdfObject)object);
                            pdfDecoderInt.getFormRenderer().getActionHandler().gotoDest((PdfObject)object, 3, 339034948);
                        }
                        while (Values.isProcessing()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                LogWriter.writeLog("Exception attempting to open file: " + interruptedException);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        LogWriter.writeLog("Exception attempting to open file: " + iOException);
                    }
                } else {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                }
            }
        }
    }

    public static void open(String string, Values values, GUISearchWindow gUISearchWindow, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        gUIFactory.removePageListener();
        gUIFactory.setDisplayView(1, pdfDecoderInt.getPageAlignment());
        boolean bl = string.startsWith("http:") || string.startsWith("file:");
        try {
            if (!bl) {
                values.setFileIsURL(false);
                values.setFileSize(new File(string).length() >> 10);
            } else {
                values.setFileIsURL(true);
            }
            values.setSelectedFile(string);
            gUIFactory.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(values.getSelectedFile());
        if (!bl && !file.exists()) {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + values.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (values.getSelectedFile() != null && !Values.isProcessing()) {
            if (gUIFactory.isSingle()) {
                pdfDecoderInt.flushObjectValues(true);
            }
            pdfDecoderInt.resetViewableArea();
            OpenFile.openFile(values.getSelectedFile(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
        }
    }

    public static void openFile(String string, Values values, GUISearchWindow gUISearchWindow, final GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        String string2;
        isPDf = false;
        values.setMultiTiff(false);
        String string3 = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || string3 != null) {
            values.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            values.setUseHiresImage(false);
        }
        gUIThumbnailPanel.resetToDefault();
        gUIFactory.setNoPagesDecoded();
        if (gUISearchWindow != null) {
            gUISearchWindow.removeSearchWindow(false);
        }
        values.maxViewY = 0;
        String string4 = string.toLowerCase().trim();
        values.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        if (string4.endsWith(".pdf") || string4.endsWith(".fdf")) {
            isPDf = true;
        }
        if (!values.isPDF()) {
            if (SwingUtilities.isEventDispatchThread()) {
                gUIFactory.setDisplayView(1, 2);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        gUIFactory.setDisplayView(1, 2);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
        gUIFactory.setQualityBoxVisible(values.isPDF());
        values.setCurrentPage(1);
        try {
            boolean bl = OpenFile.openUpFile(values.getSelectedFile(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
            if (bl) {
                OpenFile.processPage(values, pdfDecoderInt, gUIFactory, gUIThumbnailPanel);
            } else {
                gUIFactory.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                pdfDecoderInt.getDynamicRenderer().flush();
                pdfDecoderInt.getPages().refreshDisplay();
                gUIFactory.scaleAndRotate();
                values.setPageCount(1);
                values.setCurrentPage(1);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    public static boolean openUpFile(String string, final Values values, GUISearchWindow gUISearchWindow, final GUIFactory gUIFactory, final PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, final GUIThumbnailPanel gUIThumbnailPanel) throws PdfException {
        values.maxViewY = 0;
        gUISearchWindow.resetSearchWindow();
        values.setMultiTiff(false);
        boolean bl = true;
        if (gUIFactory.isSingle()) {
            pdfDecoderInt.closePdfFile();
        }
        try {
            if (values.isPDF()) {
                block41: {
                    if (inputStream != null || string.startsWith("http") || string.startsWith("file:") || string.startsWith("jar:")) {
                        try {
                            boolean bl2 = false;
                            if (inputStream != null) {
                                bl2 = true;
                            } else if (values.getModeOfOperation() != 1) {
                                bl2 = Commands.isPDFLinearized(values.getSelectedFile());
                            }
                            if (!bl2) {
                                if (values.getSelectedFile().startsWith("jar:")) {
                                    InputStream inputStream = Commands.class.getClass().getResourceAsStream(values.getSelectedFile().substring(4));
                                    pdfDecoderInt.openPdfFileFromInputStream(inputStream, false);
                                } else {
                                    final DownloadProgress downloadProgress = new DownloadProgress(values.getSelectedFile());
                                    Thread thread = new Thread(){

                                        @Override
                                        public void run() {
                                            while (downloadProgress.isDownloading()) {
                                                gUIFactory.setDownloadProgress("download", downloadProgress.getProgress());
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    LogWriter.writeLog("Exception attempting to open file: " + interruptedException);
                                                }
                                            }
                                        }
                                    };
                                    thread.setDaemon(true);
                                    thread.start();
                                    downloadProgress.startDownload();
                                    File file = downloadProgress.getFile();
                                    pdfDecoderInt.openPdfFile(file.getCanonicalPath());
                                }
                                break block41;
                            }
                            gUIFactory.setViewerTitle("Loading linearized PDF " + values.getSelectedFile());
                            if (inputStream != null) {
                                pdfDecoderInt.openPdfFileFromInputStream(inputStream, true);
                            } else {
                                pdfDecoderInt.openPdfFileFromURL(values.getSelectedFile(), true);
                            }
                            PdfObject pdfObject = (PdfObject)pdfDecoderInt.getJPedalObject(2004845231);
                            int n = pdfObject.getInt(28);
                            StringBuilder stringBuilder = new StringBuilder("Downloading ");
                            if ((n /= 1024) < 1024) {
                                stringBuilder.append(n).append(" kB");
                            } else {
                                stringBuilder.append(n /= 1024).append(" M");
                            }
                            final String string2 = stringBuilder.toString();
                            Thread thread = new Thread(){

                                @Override
                                public void run() {
                                    LinearThread linearThread = (LinearThread)pdfDecoderInt.getJPedalObject(-1276915978);
                                    while (linearThread != null && linearThread.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            interruptedException.printStackTrace();
                                        }
                                        gUIFactory.setDownloadProgress(string2, linearThread.getPercentageLoaded());
                                    }
                                    gUIFactory.setDownloadProgress(string2, 100);
                                    OpenFile.processPage(values, pdfDecoderInt, gUIFactory, gUIThumbnailPanel);
                                }
                            };
                            thread.setDaemon(true);
                            thread.start();
                        }
                        catch (Exception exception) {
                            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + string + '\n' + exception.getMessage());
                            pdfDecoderInt.closePdfFile();
                            bl = false;
                        }
                    } else {
                        try {
                            pdfDecoderInt.openPdfFile(values.getSelectedFile());
                        }
                        catch (RuntimeException runtimeException) {
                            String string3 = runtimeException.getMessage() != null && runtimeException.getMessage().contains("bouncycastle") ? runtimeException.getMessage() : "Exception in code " + runtimeException.getMessage() + " please send to IDRsolutions";
                            gUIFactory.showMessageDialog(string3);
                            LogWriter.writeLog("Exception " + runtimeException.getMessage());
                        }
                        if (pdfDecoderInt.getPageCount() > 1) {
                            gUIFactory.getButtons().setPageLayoutButtonsEnabled(true);
                        }
                    }
                }
                gUIFactory.reinitThumbnails();
            } else {
                boolean bl3;
                pdfDecoderInt.resetForNonPDFPage(1);
                PageNavigator.setLastPageDecoded(1);
                boolean bl4 = string.toLowerCase().contains(".tif");
                boolean bl5 = bl3 = string.startsWith("http:") || string.startsWith("file:");
                if (bl4) {
                    try {
                        PageNavigator.setTiffHelper(new TiffHelper(values.getSelectedFile()));
                        int n = PageNavigator.getTiffHelper().getTiffPageCount();
                        values.setTiffImageToLoad(0);
                        if (n > 1) {
                            pdfDecoderInt.resetForNonPDFPage(n);
                            values.setPageCount(n);
                            PageNavigator.setLastPageDecoded(1);
                            values.setMultiTiff(true);
                            values.setMultiTiff(true);
                        }
                        PageNavigator.drawMultiPageTiff(values, pdfDecoderInt);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogWriter.writeLog("Exception " + exception + Messages.getMessage("PdfViewerError.Loading") + values.getSelectedFile());
                    }
                } else {
                    try {
                        if (bl3) {
                            values.setBufferedImg(ImageIO.read(new URL(string)));
                        } else {
                            values.setBufferedImg(ImageIO.read(new File(string)));
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + "loading " + values.getSelectedFile());
                    }
                }
            }
            gUIFactory.updateStatusMessage("opening file");
            if (bl && pdfDecoderInt.isEncrypted() && !pdfDecoderInt.isFileViewable()) {
                bl = false;
                String string4 = System.getProperty("org.jpedal.password");
                if (string4 == null) {
                    string4 = gUIFactory.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                }
                if (string4 != null) {
                    pdfDecoderInt.setEncryptionPassword(string4);
                    if (pdfDecoderInt.isFileViewable()) {
                        bl = true;
                    }
                }
                if (!bl) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            gUIFactory.setBookmarks(true);
            if (bl) {
                if (propertiesFile.getValue("Recentdocuments").equals("true")) {
                    propertiesFile.addRecentDocument(values.getSelectedFile());
                    gUIFactory.getRecentDocument().updateRecentDocuments(propertiesFile.getRecentDocuments());
                }
                gUIFactory.getRecentDocument().addToFileList(values.getSelectedFile());
                values.setCurrentPage(1);
            }
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception " + pdfException + " opening file");
            if (gUIFactory.isSingle()) {
                if (GUI.showMessages) {
                    ErrorDialog.showError(pdfException, Messages.getMessage("PdfViewerOpenerror"), (Container)gUIFactory.getFrame(), values.getSelectedFile());
                }
                Exit.exit(gUIThumbnailPanel, gUIFactory, values, pdfDecoderInt, propertiesFile);
            }
            throw pdfException;
        }
        if (!pdfDecoderInt.isOpen() && values.isPDF() && pdfDecoderInt.getJPedalObject(2004845231) == null) {
            return false;
        }
        return bl;
    }

    public static void selectFile(Values values, GUISearchWindow gUISearchWindow, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        if (gUISearchWindow != null) {
            gUISearchWindow.removeSearchWindow(false);
        }
        JFileChooser jFileChooser = new JFileChooser(values.getInputDir());
        jFileChooser.setName("chooser");
        if (values.getSelectedFile() != null) {
            jFileChooser.setSelectedFile(new File(values.getSelectedFile()));
        }
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        String[] stringArray2 = new String[]{"fdf"};
        String[] stringArray3 = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Images (Tiff, Jpeg,Png)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "fdf (*.fdf)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = jFileChooser.showOpenDialog((Container)gUIFactory.getFrame());
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            boolean bl;
            String string = file.getName().toLowerCase();
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (bl) {
                try {
                    values.setInputDir(jFileChooser.getCurrentDirectory().getCanonicalPath());
                    OpenFile.open(file.getAbsolutePath(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    public static void processPage(Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory, GUIThumbnailPanel gUIThumbnailPanel) {
        if (values.isPDF() && (pdfDecoderInt.isOpen() || !values.isPDF() || pdfDecoderInt.getJPedalObject(2004845231) != null)) {
            int n;
            PdfFileInformation pdfFileInformation = pdfDecoderInt.getFileInformationData();
            pdfDecoderInt.setRenderMode(3);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = PdfFileInformation.getFieldNames();
            String[] stringArray3 = new String[]{"TeleForm", "dgn2pdf"};
            for (n = 0; n < stringArray2.length; ++n) {
                if (!stringArray2[n].equals("Creator") && !stringArray2[n].equals("Producer")) continue;
                for (String string : stringArray3) {
                    if (!stringArray[n].equals(string)) continue;
                    pdfDecoderInt.setRenderMode(2);
                }
                if (!stringArray[n].equals("ABBYY FineReader 8.0 Professional Edition")) continue;
                pdfDecoderInt.setRenderMode(35);
            }
            n = Values.isProcessing() ? 1 : 0;
            Values.setProcessing(true);
            if (values.isUseHiresImage()) {
                pdfDecoderInt.useHiResScreenDisplay(true);
                ((GUI)gUIFactory).setSelectedComboIndex(250, 1);
            } else {
                pdfDecoderInt.useHiResScreenDisplay(false);
                ((GUI)gUIFactory).setSelectedComboIndex(250, 0);
            }
            Values.setProcessing(n != 0);
        }
        if (values.isPDF()) {
            values.setPageCount(pdfDecoderInt.getPageCount());
        } else if (!values.isMultiTiff()) {
            values.setPageCount(1);
            pdfDecoderInt.useHiResScreenDisplay(true);
        }
        if (values.getPageCount() < values.getCurrentPage()) {
            values.setCurrentPage(values.getPageCount());
            System.err.println(values.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(values.getCurrentPage() + " out of range. Opening on last page");
        }
        pdfDecoderInt.setExtractionMode(1, gUIFactory.getScaling());
        gUIFactory.setPageNumber();
        gUIFactory.resetRotationBox();
        if (values.isPDF()) {
            gUIFactory.decodePage();
        }
    }

    private static String selectURL(Values values, GUISearchWindow gUISearchWindow, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUIThumbnailPanel gUIThumbnailPanel) {
        boolean bl;
        String string = gUIFactory.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (string != null) {
            string = string.trim();
        }
        if (!(string == null || string.trim().startsWith("http://") || string.trim().startsWith("https://") || string.trim().startsWith("file:/"))) {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            string = null;
        }
        if (string != null) {
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (!bl) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                string = null;
            }
        }
        if (string != null) {
            values.setSelectedFile(string);
            bl = false;
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection.getContent() == null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
                LogWriter.writeLog("Exception in handling URL " + exception);
            }
            if (bl) {
                string = null;
                gUIFactory.showMessageDialog("URL " + string + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (string != null) {
            try {
                values.setFileSize(0L);
                gUIFactory.setViewerTitle(null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (string != null && !Values.isProcessing()) {
                gUIThumbnailPanel.terminateDrawing();
                pdfDecoderInt.flushObjectValues(true);
                pdfDecoderInt.resetViewableArea();
                gUIFactory.stopThumbnails();
                OpenFile.openFile(values.getSelectedFile(), values, gUISearchWindow, gUIFactory, pdfDecoderInt, propertiesFile, gUIThumbnailPanel);
            }
        } else {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return string;
    }

    public static void setPageProperties(Object object, Object object2) {
    }
}

