/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.ModeChange;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageFlow {
    public static void execute(Object[] objectArray, final GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow) {
        if (!pdfDecoderInt.isOpen() || pdfDecoderInt.getDisplayView() == 5) {
            return;
        }
        gUISearchWindow.removeSearchWindow(false);
        if (objectArray == null) {
            if (values.getModeOfOperation() != 1) {
                if (!JavaFXHelper.isJavaFXAvailable()) {
                    String string = System.getProperty("org.jpedal.suppressViewerPopups");
                    boolean bl = false;
                    if (string != null && string.equalsIgnoreCase("true")) {
                        bl = true;
                    }
                    String string2 = propertiesFile.getValue("showpageflowmessage");
                    if (!bl && propertiesFile != null && !string2.isEmpty() && string2.equals("true")) {
                        final JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Message"));
                        jLabel.setHorizontalTextPosition(0);
                        jPanel.add(jLabel);
                        MouseAdapter mouseAdapter = new MouseAdapter(){

                            @Override
                            public void mouseEntered(MouseEvent mouseEvent) {
                                if (GUIDisplay.allowChangeCursor) {
                                    jPanel.setCursor(new Cursor(12));
                                }
                            }

                            @Override
                            public void mouseExited(MouseEvent mouseEvent) {
                                if (GUIDisplay.allowChangeCursor) {
                                    jPanel.setCursor(new Cursor(0));
                                }
                            }

                            @Override
                            public void mouseClicked(MouseEvent mouseEvent) {
                                try {
                                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Link"));
                                }
                                catch (Exception exception) {
                                    LogWriter.writeLog("Exception " + exception.getMessage());
                                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                                }
                            }
                        };
                        JLabel jLabel2 = new JLabel("<html><u>" + Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Download") + "</u></html>");
                        jLabel2.setForeground(Color.BLUE);
                        jLabel2.addMouseListener(mouseAdapter);
                        jLabel2.setHorizontalAlignment(0);
                        jPanel.add(jLabel2);
                        Object[] objectArray2 = new Object[]{Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Continue")};
                        JOptionPane.showOptionDialog((Container)gUIFactory.getFrame(), jPanel, Messages.getMessage("PdfViewer.PageFlowJarsNeeded.Title"), -1, -1, null, objectArray2, objectArray2[0]);
                        return;
                    }
                }
                gUIFactory.getCombo(252).setEnabled(false);
                gUIFactory.getButtons().getButton(29).setEnabled(false);
                gUIFactory.getButtons().getButton(13).setEnabled(false);
                gUIFactory.getButtons().alignLayoutMenuOption(5);
                if (Viewer.isFX()) {
                    ModeChange.changeModeInJavaFX(5, pdfDecoderInt, gUIFactory, values, propertiesFile, gUISearchWindow);
                } else {
                    ModeChange.changeModeInSwing(5, pdfDecoderInt, gUIFactory, values, propertiesFile, gUISearchWindow);
                }
            } else {
                if (values.getModeOfOperation() == 1) {
                    gUIFactory.showMessageDialog("PageFlow temporarily disabled for Applet");
                }
                gUIFactory.getButtons().alignLayoutMenuOption(1);
                if (SwingUtilities.isEventDispatchThread()) {
                    gUIFactory.setDisplayView(1, 2);
                    gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
                    ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
                } else {
                    gUIFactory.setCommandInThread(true);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            gUIFactory.setDisplayView(1, 2);
                            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
                            ((GUI)gUIFactory).setSelectedComboIndex(251, 0);
                            gUIFactory.setExecutingCommand(false);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            gUIFactory.getCombo(251).setEnabled(false);
        }
    }
}

