/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageNavigator {
    private static boolean pageTurnAnimating;
    private static int lastPageDecoded;
    private static TiffHelper tiffHelper;
    private static boolean pageChanging;

    public static void gotoPage(String string, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        int n;
        string = string.split("/")[0];
        try {
            n = Integer.parseInt(string);
            if (!pdfDecoderInt.isPageAvailable(n)) {
                gUIFactory.showMessageDialog("Page " + n + " is not yet loaded");
                gUIFactory.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(values.getCurrentPage()));
                return;
            }
            if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                if ((pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) && (n & 1) == 1 && n != 1) {
                    --n;
                } else if (!pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (n & 1) == 0) {
                    --n;
                }
            }
            if (n > pdfDecoderInt.getPageCount() | n < 1) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + string + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + pdfDecoderInt.getPageCount());
                n = values.getCurrentPage();
                gUIFactory.setPageNumber();
            }
        }
        catch (Exception exception) {
            gUIFactory.showMessageDialog('>' + string + "< " + Messages.getMessage("PdfViewerInvalidNumber.text") + ' ' + exception);
            n = values.getCurrentPage();
            gUIFactory.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(values.getCurrentPage()));
        }
        PageNavigator.navigatePages(n - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
        if (pdfDecoderInt.getDisplayView() == 5) {
            PageNavigator.navigatePages(0, values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goPage(Object[] objectArray, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        if (objectArray == null) {
            String string = gUIFactory.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
            if (string != null) {
                PageNavigator.gotoPage(string, gUIFactory, values, pdfDecoderInt);
            }
        } else {
            PageNavigator.gotoPage((String)objectArray[0], gUIFactory, values, pdfDecoderInt);
        }
    }

    public static void goLastPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null && values.getPageCount() > 1 && values.getPageCount() - values.getCurrentPage() > 0) {
            PageNavigator.navigatePages(values.getPageCount() - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goFirstPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null && values.getPageCount() > 1 && values.getCurrentPage() != 1) {
            PageNavigator.navigatePages(-(values.getCurrentPage() - 1), values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goFForwardPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null) {
            if (values.getPageCount() < values.getCurrentPage() + 10) {
                PageNavigator.navigatePages(values.getPageCount() - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
            } else {
                PageNavigator.navigatePages(10, values, pdfDecoderInt, gUIFactory);
            }
        }
    }

    public static void goForwardPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null) {
            if (values.getSelectedFile() != null) {
                PageNavigator.navigatePages(1, values, pdfDecoderInt, gUIFactory);
            }
        } else {
            if (values.getSelectedFile() != null) {
                PageNavigator.navigatePages(Integer.parseInt((String)objectArray[0]), values, pdfDecoderInt, gUIFactory);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to set propeties values " + exception);
                }
            }
        }
    }

    public static void goBackPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null) {
            if (values.getSelectedFile() != null) {
                PageNavigator.navigatePages(-1, values, pdfDecoderInt, gUIFactory);
            }
        } else {
            if (values.getSelectedFile() != null) {
                PageNavigator.navigatePages(-Integer.parseInt((String)objectArray[0]), values, pdfDecoderInt, gUIFactory);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to set propeties values " + exception);
                }
            }
        }
    }

    public static void goFBackPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null) {
            if (values.getCurrentPage() <= 10) {
                PageNavigator.navigatePages(-(values.getCurrentPage() - 1), values, pdfDecoderInt, gUIFactory);
            } else {
                PageNavigator.navigatePages(-10, values, pdfDecoderInt, gUIFactory);
            }
        }
    }

    private static int getUpdatedPageNumber(int n, int n2, int n3, int n4) {
        if (n == 4 || n == 3) {
            if (n4 == -1 && n2 != 2) {
                n4 = -2;
            }
            if (n4 == 1 && n2 != n3 - 1) {
                n4 = 2;
            }
        }
        return n2 + n4;
    }

    private static void changePage(PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory, Values values, int n) {
        values.setCurrentPage(n);
        if (pdfDecoderInt.getDisplayView() == 2 || pdfDecoderInt.getDisplayView() == 3) {
            gUIFactory.decodePage();
            gUIFactory.setPageNumber();
            pageChanging = false;
            return;
        }
        gUIFactory.resetStatusMessage("Loading Page " + values.getCurrentPage());
        pdfDecoderInt.setPageParameters(gUIFactory.getScaling(), values.getCurrentPage());
        if (values.isPDF()) {
            gUIFactory.decodePage();
        }
    }

    private static void navigatePagePrevious(int n, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        int n2 = PageNavigator.getUpdatedPageNumber(pdfDecoderInt.getDisplayView(), values.getCurrentPage(), pdfDecoderInt.getPageCount(), n);
        if (!pdfDecoderInt.isPageAvailable(n2)) {
            gUIFactory.showMessageDialog("Page " + n2 + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (n2 <= values.getPageCount()) {
                if (values.isMultiTiff()) {
                    PageNavigator.changeTiffPage(values, pdfDecoderInt, gUIFactory, n, n2);
                } else {
                    if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                        if (pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) {
                            if (n2 > values.getPageCount()) {
                                n2 = values.getPageCount();
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (pdfDecoderInt.getDisplayView() == 4) {
                                n = n2 / 2 - values.getCurrentPage() / 2;
                            }
                        } else {
                            if ((n2 & 1) == 0) {
                                --n2;
                            }
                            n = (n2 + 1) / 2 - (values.getCurrentPage() + 1) / 2;
                        }
                    }
                    PageNavigator.changePage(pdfDecoderInt, gUIFactory, values, n2);
                }
            }
        } else {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    private static void navigatePageNext(int n, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        int n2 = PageNavigator.getUpdatedPageNumber(pdfDecoderInt.getDisplayView(), values.getCurrentPage(), pdfDecoderInt.getPageCount(), n);
        if (!pdfDecoderInt.isPageAvailable(n2)) {
            gUIFactory.showMessageDialog("Page " + n2 + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (n2 >= 1) {
                if (values.isMultiTiff()) {
                    PageNavigator.changeTiffPage(values, pdfDecoderInt, gUIFactory, n, n2);
                } else {
                    if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                        if (pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) {
                            if (n == -1) {
                                --n2;
                            }
                            if (n2 < 1) {
                                n2 = 1;
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (pdfDecoderInt.getDisplayView() == 4) {
                                n = n2 / 2 - values.getCurrentPage() / 2;
                            }
                        } else {
                            if ((n2 & 1) == 0) {
                                --n2;
                            }
                            if (pdfDecoderInt.getDisplayView() == 4) {
                                n = (n2 + 1) / 2 - (values.getCurrentPage() + 1) / 2;
                            }
                        }
                    }
                    PageNavigator.changePage(pdfDecoderInt, gUIFactory, values, n2);
                }
            }
        } else {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    public static void navigatePages(int n, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (n == 0) {
            return;
        }
        if (!pageChanging) {
            pageChanging = true;
            if (n > 0) {
                PageNavigator.navigatePageNext(n, values, pdfDecoderInt, gUIFactory);
            } else {
                PageNavigator.navigatePagePrevious(n, values, pdfDecoderInt, gUIFactory);
            }
            if (gUIFactory.getThumbnailScrollBar() != null) {
                gUIFactory.setThumbnailScrollBarValue(values.getCurrentPage() - 1);
            }
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
            gUIFactory.setPageNumber();
            pageChanging = false;
        }
    }

    private static void changeTiffPage(Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory, int n, int n2) {
        values.setTiffImageToLoad(lastPageDecoded - 1 + n);
        PageNavigator.drawMultiPageTiff(values, pdfDecoderInt);
        values.setCurrentPage(n2);
        lastPageDecoded = values.getTiffImageToLoad() + 1;
        gUIFactory.setPageNumber();
    }

    public static void drawMultiPageTiff(Values values, PdfDecoderInt pdfDecoderInt) {
    }

    public static void setPageTurnAnimating(boolean bl, GUIFactory gUIFactory) {
        pageTurnAnimating = bl;
        if (bl) {
            gUIFactory.getButtons().getButton(53).setEnabled(false);
            gUIFactory.getButtons().getButton(52).setEnabled(false);
            gUIFactory.getButtons().getButton(54).setEnabled(false);
            gUIFactory.getButtons().getButton(51).setEnabled(false);
            gUIFactory.getButtons().getButton(55).setEnabled(false);
            gUIFactory.getButtons().getButton(50).setEnabled(false);
        } else {
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
        }
    }

    public static boolean getPageTurnAnimating() {
        return pageTurnAnimating;
    }

    public static void setLastPageDecoded(int n) {
        lastPageDecoded = n;
    }

    public static TiffHelper getTiffHelper() {
        return tiffHelper;
    }

    public static void setTiffHelper(TiffHelper tiffHelper) {
        PageNavigator.tiffHelper = tiffHelper;
    }

    static {
        lastPageDecoded = -1;
    }
}

