/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SaveFile {
    public static void execute(Object[] objectArray, GUIFactory gUIFactory, Values values) {
        if (objectArray == null) {
            SaveFile.saveFile(gUIFactory, values);
        }
    }

    private static void saveFile(GUIFactory gUIFactory, Values values) {
        boolean bl = false;
        while (!bl) {
            JFileChooser jFileChooser = new JFileChooser(values.getInputDir());
            jFileChooser.setSelectedFile(new File(values.getInputDir() + '/' + values.getSelectedFile()));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                int n2;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                if (!string.endsWith(".pdf")) {
                    string = string + ".pdf";
                    file = new File(string);
                }
                if (string.equals(values.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n2 = gUIFactory.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int n3;
                    fileInputStream = new FileInputStream(values.getSelectedFile());
                    fileOutputStream = new FileOutputStream(string);
                    byte[] byArray = new byte[4096];
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                }
                catch (Exception exception) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile") + ' ' + exception);
                }
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception attempting close IOStream: " + iOException);
                }
                bl = true;
                continue;
            }
            return;
        }
    }
}

