/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.File;
import javax.swing.JFileChooser;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.ItextFunctions;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.utils.Messages;

public class SaveForm {
    public static void execute(Object[] objectArray, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, Values values) {
        if (objectArray == null) {
            SaveForm.saveChangedForm(gUIFactory, pdfDecoderInt, values);
        }
    }

    public static void saveChangedForm(GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, Values values) {
        AcroRenderer acroRenderer = pdfDecoderInt.getFormRenderer();
        if (acroRenderer == null) {
            return;
        }
        Object[] objectArray = acroRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, -1);
        if (objectArray == null) {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            Object object;
            String string = "";
            boolean bl = false;
            while (!bl) {
                object = new JFileChooser(values.getInputDir());
                ((JFileChooser)object).setSelectedFile(new File(values.getInputDir() + '/' + values.getSelectedFile()));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                ((JFileChooser)object).setFileSelectionMode(0);
                int n = ((JFileChooser)object).showSaveDialog(null);
                if (n == 0) {
                    int n2;
                    File file = ((JFileChooser)object).getSelectedFile();
                    string = file.getAbsolutePath();
                    if (!string.endsWith(".pdf")) {
                        string = string + ".pdf";
                        file = new File(string);
                    }
                    if (string.equals(values.getSelectedFile())) {
                        gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n2 = gUIFactory.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    bl = true;
                    continue;
                }
                return;
            }
            object = new ItextFunctions(gUIFactory, values.getSelectedFile(), pdfDecoderInt);
            ItextFunctions.saveFormsData(string);
            values.setFormsChanged(false);
            gUIFactory.setViewerTitle(null);
        }
    }

    public static void handleUnsaveForms(GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        int n;
        if (values.isFormsChanged() && (n = gUIFactory.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            SaveForm.saveChangedForm(gUIFactory, pdfDecoderInt, values);
        }
        values.setFormsChanged(false);
    }
}

