/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.generic;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class GUICopy {
    public static String copySelectedText(PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory, Values values) {
        if (!pdfDecoderInt.isExtractionAllowed()) {
            gUIFactory.showMessageDialog("Not allowed");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        int[][] nArray = pdfDecoderInt.getTextLines().getHighlightedAreasAs2DArray(values.getCurrentPage());
        if (nArray == null) {
            return "";
        }
        boolean bl = nArray.length > 1;
        PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
        int n = pdfPageData.getCropBoxX(values.getCurrentPage());
        int n2 = pdfPageData.getCropBoxY(values.getCurrentPage());
        int n3 = pdfPageData.getCropBoxWidth(values.getCurrentPage());
        int n4 = pdfPageData.getCropBoxHeight(values.getCurrentPage());
        if (nArray != null) {
            for (int i = 0; i != nArray.length; ++i) {
                int n5;
                nArray[i] = GUICopy.adjustHighlightForExtraction(nArray[i]);
                int n6 = nArray[i][0];
                int n7 = nArray[i][0] + nArray[i][2];
                int n8 = nArray[i][1] + nArray[i][3];
                int n9 = nArray[i][1];
                if (n8 < n9) {
                    n5 = n9;
                    n9 = n8;
                    n8 = n5;
                }
                if (n6 > n7) {
                    n5 = n7;
                    n7 = n6;
                    n6 = n5;
                }
                if (n6 < n) {
                    n6 = n;
                }
                if (n6 > n3 + n) {
                    n6 = n3 + n;
                }
                if (n7 < n) {
                    n7 = n;
                }
                if (n7 > n3 + n) {
                    n7 = n3 + n;
                }
                if (n8 < n2) {
                    n8 = n2;
                }
                if (n8 > n4 + n2) {
                    n8 = n4 + n2;
                }
                if (n9 < n2) {
                    n9 = n2;
                }
                if (n9 > n4 + n2) {
                    n9 = n4 + n2;
                }
                try {
                    PdfGroupingAlgorithms pdfGroupingAlgorithms = pdfDecoderInt.getGroupingObject();
                    String string = pdfGroupingAlgorithms.extractTextInRectangle(n6, n8, n7, n9, values.getCurrentPage(), false, true);
                    if (string == null || string.isEmpty()) {
                        if (!bl) {
                            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                        }
                    } else {
                        string = Strip.stripXML(string, pdfDecoderInt.isXMLExtraction()).toString();
                    }
                    if (string == null) continue;
                    stringBuilder.append(string).append('\r').append('\n');
                    continue;
                }
                catch (PdfException pdfException) {
                    System.err.println("Exception " + pdfException.getMessage() + " in file " + values.getSelectedFile());
                    pdfException.printStackTrace();
                }
            }
        }
        if (stringBuilder.length() > 2) {
            return stringBuilder.substring(0, stringBuilder.length() - 2);
        }
        return "";
    }

    public static int[] adjustHighlightForExtraction(int[] nArray) {
        int n = nArray[0] - 1;
        int n2 = nArray[1] - 3;
        int n3 = nArray[2] + 2;
        int n4 = nArray[3] + 6;
        return new int[]{n, n2, n3, n4};
    }
}

