/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.generic;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class GUIExtractText {
    protected static String extractTextList(PdfDecoderInt pdfDecoderInt, Values values, GUIFactory gUIFactory, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        List list;
        int n5;
        String string = "";
        PdfGroupingAlgorithms.useUnrotatedCoords = true;
        PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
        int n6 = pdfPageData.getRotation(values.getCurrentPage());
        if (n6 != 0 && (n5 = gUIFactory.showConfirmDialog(Messages.getMessage("PdfViewerRotatedCoords.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0)) == 0) {
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
        }
        if ((list = pdfDecoderInt.getGroupingObject().extractTextAsWordlist(n, n3, n2, n4, values.getCurrentPage(), true, null)) == null) {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
        }
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!bl) {
                    string2 = Strip.convertToText(string2, pdfDecoderInt.isXMLExtraction());
                }
                int n7 = (int)Float.parseFloat((String)iterator.next());
                int n8 = (int)Float.parseFloat((String)iterator.next());
                int n9 = (int)Float.parseFloat((String)iterator.next());
                int n10 = (int)Float.parseFloat((String)iterator.next());
                stringBuilder.append(string2).append(',').append(n7).append(',').append(n8).append(',').append(n9).append(',').append(n10).append('\n');
            }
            if (stringBuilder.toString() != null) {
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    protected static String extractTextTable(Values values, PdfDecoderInt pdfDecoderInt, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        Map map = !bl ? pdfDecoderInt.getGroupingObject().extractTextAsTable(n, n3, n2, n4, values.getCurrentPage(), true, false, false, false, 0) : pdfDecoderInt.getGroupingObject().extractTextAsTable(n, n3, n2, n4, values.getCurrentPage(), false, true, true, false, 1);
        if (map.get("content") != null) {
            return (String)map.get("content");
        }
        return "";
    }

    protected static String extractTextRectangle(Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        String string = pdfDecoderInt.getGroupingObject().extractTextInRectangle(n, n3, n2, n4, values.getCurrentPage(), false, true);
        if (string == null) {
            gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
            return "";
        }
        if (!bl) {
            string = Strip.stripXML(string, pdfDecoderInt.isXMLExtraction()).toString();
        }
        return string;
    }
}

