/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.utils.Messages;

public class JavaFXDocInfo {
    private static final Font headerFont = Font.font((String)"SanSerif", (FontWeight)FontWeight.BOLD, (double)14.0);
    private static final Font textFont = Font.font((String)"SanSerif", (double)12.0);
    private static final String lb = "\n";
    private static final StackPane treeContainer = new StackPane();

    public static void execute(Object[] objectArray, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        if (objectArray == null) {
            if (!values.isPDF()) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
            } else if (values.getSelectedFile() == null) {
                gUIFactory.showMessageDialog((Object)Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
            } else {
                JavaFXDocInfo.getPropertiesBox(values.getSelectedFile(), values.getFileSize(), values.getPageCount(), values.getCurrentPage(), pdfDecoderInt);
            }
        }
    }

    private static void getPropertiesBox(String string, long l, int n, int n2, PdfDecoderInt pdfDecoderInt) {
        Object object;
        Object object2;
        String string2 = System.getProperty("user.dir");
        PdfFileInformation pdfFileInformation = pdfDecoderInt.getFileInformationData();
        int n3 = 0;
        if (n3 == -1) {
            n3 = string.lastIndexOf(47);
        }
        String string3 = string.substring(n3 + 1, string.length());
        String string4 = string.substring(0, n3 + 1);
        TabPane tabPane = new TabPane();
        tabPane.setId("docProp");
        Tab tab = new Tab("Properties");
        Tab tab2 = new Tab("Fonts");
        Tab tab3 = new Tab("Available");
        Tab tab4 = new Tab("Aliases");
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tab.setContent((Node)JavaFXDocInfo.getPropTab(pdfFileInformation, string3, string4, string2, l, n, n2, pdfDecoderInt));
        tab2.setContent((Node)JavaFXDocInfo.getFontTab(pdfDecoderInt.getInfo(373243460)));
        tab3.setContent((Node)JavaFXDocInfo.getAvailableTab());
        tab4.setContent((Node)JavaFXDocInfo.getAliasesTab());
        tabPane.getTabs().addAll((Object[])new Tab[]{tab, tab2, tab3, tab4});
        if (JavaFXDocInfo.getFormsTab(pdfDecoderInt) != null) {
            object2 = new Tab("Forms");
            object2.setContent((Node)JavaFXDocInfo.getFormsTab(pdfDecoderInt));
            tabPane.getTabs().add(object2);
        }
        if (ImageCommands.trackImages) {
            object2 = new Tab("Image");
            object2.setContent((Node)JavaFXDocInfo.getImageTab(pdfDecoderInt));
            tabPane.getTabs().add(object2);
        }
        if (!((String)(object2 = pdfFileInformation.getFileXMLMetaData())).isEmpty()) {
            object = new Tab("XML");
            object.setContent((Node)JavaFXDocInfo.getXMLTab((String)object2));
            tabPane.getTabs().add(object);
        }
        object = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)tabPane, 400.0, 300.0);
        ((FXDialog)object).show();
    }

    private static ScrollPane getPropTab(PdfFileInformation pdfFileInformation, String string, String string2, String string3, long l, int n, int n2, PdfDecoderInt pdfDecoderInt) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        if (pdfFileInformation != null) {
            VBox vBox = new VBox();
            Text text = new Text(lb + Messages.getMessage("PdfViewerGeneral"));
            text.setFont(headerFont);
            StringBuffer stringBuffer = new StringBuffer("PDF");
            stringBuffer.append(pdfDecoderInt.getPDFVersion());
            if (pdfDecoderInt.getJPedalObject(2004845231) != null) {
                stringBuffer.append(" (").append(Messages.getMessage("PdfViewerLinearized.text")).append(") ");
            }
            Text text2 = new Text(Messages.getMessage("PdfViewerFileName") + string + lb + Messages.getMessage("PdfViewerFilePath") + string2 + lb + Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + string3 + lb + Messages.getMessage("PdfViewerFileSize") + l + " K" + lb + Messages.getMessage("PdfViewerPageCount") + n + lb + stringBuffer + lb);
            text2.setFont(textFont);
            Text text3 = new Text(Messages.getMessage("PdfViewerProperties"));
            text3.setFont(headerFont);
            Text text4 = new Text();
            text4.setFont(textFont);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = PdfFileInformation.getFieldNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray[i].isEmpty()) continue;
                text4.setText(text4.getText() + stringArray2[i] + " = " + stringArray[i] + lb);
            }
            vBox.getChildren().addAll((Object[])new Node[]{text, text2, text3, text4});
            PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
            if (pdfPageData != null) {
                Text text5 = new Text(Messages.getMessage("PdfViewerCoords.text"));
                text5.setFont(headerFont);
                Text text6 = new Text(Messages.getMessage("PdfViewermediaBox.text") + pdfPageData.getMediaValue(n2) + lb + Messages.getMessage("PdfViewercropBox.text") + pdfPageData.getCropValue(n2) + lb + Messages.getMessage("PdfViewerLabel.Rotation") + pdfPageData.getRotation(n2) + lb);
                text6.setFont(textFont);
                vBox.getChildren().addAll((Object[])new Node[]{text5, text6});
            }
            scrollPane.setContent((Node)vBox);
        }
        return scrollPane;
    }

    private static ScrollPane getFontTab(String string) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        StringBuilder stringBuilder = new StringBuilder("Font Substitution Mode: ");
        switch (FontMappings.getFontSubstitutionMode()) {
            case 1: {
                stringBuilder.append("Using File Name");
                break;
            }
            case 2: {
                stringBuilder.append("Using PostScript Name");
                break;
            }
            case 3: {
                stringBuilder.append("Using Family Name");
                break;
            }
            case 4: {
                stringBuilder.append("Using The Full Font Name");
                break;
            }
            default: {
                stringBuilder.append("Unknown Font Substitution Mode");
            }
        }
        stringBuilder.append(lb);
        if (!string.isEmpty()) {
            VBox vBox = new VBox();
            Text text = new Text("\nGeneral");
            text.setFont(headerFont);
            Text text2 = new Text(stringBuilder.toString());
            text2.setFont(textFont);
            Text text3 = new Text("Fonts Used");
            text3.setFont(headerFont);
            Text text4 = new Text(string);
            text4.setFont(textFont);
            vBox.getChildren().addAll((Object[])new Node[]{text, text2, text3, text4});
            scrollPane.setContent((Node)vBox);
        }
        return scrollPane;
    }

    private static ScrollPane getImageTab(PdfDecoderInt pdfDecoderInt) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        String string = pdfDecoderInt.getInfo(1026635598);
        if (!string.isEmpty()) {
            VBox vBox = new VBox();
            Text text = new Text("\nImages Used");
            text.setFont(headerFont);
            Text text2 = new Text(string);
            text2.setFont(textFont);
            vBox.getChildren().addAll((Object[])new Node[]{text, text2});
            scrollPane.setContent((Node)vBox);
        }
        return scrollPane;
    }

    private static ScrollPane getXMLTab(String string) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        VBox vBox = new VBox();
        Text text = new Text("\nXML Content");
        text.setFont(headerFont);
        Text text2 = new Text(string);
        text2.setFont(textFont);
        vBox.getChildren().addAll((Object[])new Node[]{text, text2});
        scrollPane.setContent((Node)vBox);
        return scrollPane;
    }

    private static ScrollPane getFormsTab(PdfDecoderInt pdfDecoderInt) {
        Object[] objectArray;
        ScrollPane scrollPane = null;
        AcroRenderer acroRenderer = pdfDecoderInt.getFormRenderer();
        if (acroRenderer != null && (objectArray = acroRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, pdfDecoderInt.getPageNumber())) != null) {
            int n = objectArray.length;
            scrollPane = new ScrollPane();
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            VBox vBox = new VBox();
            Text text = new Text("\nPage Contains " + n + " Form Objects" + lb);
            text.setFont(headerFont);
            vBox.getChildren().addAll((Object[])new Node[]{text});
            for (Object object : objectArray) {
                Object[] objectArray2;
                String string = (String)object;
                Object[] objectArray3 = acroRenderer.getFormComponents(string, ReturnValues.GUI_FORMS_FROM_NAME, -1);
                if (objectArray3 == null) continue;
                Text text2 = new Text(string);
                text2.setFont(headerFont);
                FormObject formObject = null;
                StringBuilder stringBuilder = new StringBuilder("PDF ref=");
                for (Object object2 : objectArray2 = acroRenderer.getFormComponents(string, ReturnValues.FORMOBJECTS_FROM_NAME, -1)) {
                    formObject = (FormObject)object2;
                    stringBuilder.append(' ').append(formObject.getObjectRefAsString());
                }
                String object3 = "Type = " + PdfDictionary.showAsConstant(formObject.getParameterConstant(608780341)) + " Subtype=" + PdfDictionary.showAsConstant(formObject.getParameterConstant(1147962727));
                String string2 = "Java Class = " + objectArray3[0].getClass();
                Text text3 = new Text(stringBuilder + lb + object3 + lb + string2);
                text3.setFont(textFont);
                vBox.getChildren().addAll((Object[])new Node[]{text2, text3});
            }
            scrollPane.setContent((Node)vBox);
        }
        return scrollPane;
    }

    private static ScrollPane getAliasesTab() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Text text = new Text("\nAliases Content");
        text.setFont(headerFont);
        Text text2 = new Text();
        text2.setFont(textFont);
        for (Object k : FontMappings.fontSubstitutionAliasTable.keySet()) {
            text2.setText(text2.getText() + k + " ==> " + FontMappings.fontSubstitutionAliasTable.get(k) + lb);
        }
        if (text2.getText() != null) {
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{text, text2});
            scrollPane.setContent((Node)vBox);
        }
        return scrollPane;
    }

    private static VBox getAvailableTab() {
        VBox vBox = new VBox();
        Text text = new Text("\nAvailable Fonts");
        text.setFont(headerFont);
        GridPane gridPane = new GridPane();
        Text text2 = new Text("Filter Font List");
        text2.setFont(textFont);
        final TextField textField = new TextField();
        textField.setMaxSize(150.0, 0.0);
        textField.setFont(textFont);
        final RadioButton radioButton = new RadioButton("Sort By Folder ");
        radioButton.setFont(textFont);
        RadioButton radioButton2 = new RadioButton("Sort By Name ");
        radioButton.setFont(textFont);
        gridPane.addColumn(1, new Node[]{radioButton, radioButton2});
        gridPane.addColumn(2, new Node[]{text2, textField});
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setHgap(20.0);
        ToggleGroup toggleGroup = new ToggleGroup();
        radioButton.setSelected(true);
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{radioButton, radioButton2});
        JavaFXDocInfo.getAvailableFonts(textField, radioButton.isSelected());
        ChangeListener<Toggle> changeListener = new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                JavaFXDocInfo.getAvailableFonts(textField, radioButton.isSelected());
            }
        };
        toggleGroup.selectedToggleProperty().addListener((ChangeListener)changeListener);
        text2.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                JavaFXDocInfo.getAvailableFonts(textField, radioButton.isSelected());
            }
        });
        vBox.getChildren().addAll((Object[])new Node[]{text, gridPane, treeContainer});
        vBox.setAlignment(Pos.CENTER);
        return vBox;
    }

    private static TreeItem populateAvailableFonts(TreeItem treeItem, String string, boolean bl) {
        block10: {
            if (FontMappings.fontSubstitutionTable == null) break block10;
            Set set = FontMappings.fontSubstitutionTable.keySet();
            Iterator iterator = FontMappings.fontSubstitutionTable.keySet().iterator();
            int n = set.size();
            ArrayList<String> arrayList = new ArrayList<String>(n);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toString());
            }
            Collections.sort(arrayList);
            if (bl) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<TreeItem> arrayList3 = new ArrayList<TreeItem>();
                for (int i = 0; i < n; ++i) {
                    TreeItem treeItem2;
                    Object e = arrayList.get(i);
                    String string2 = (String)FontMappings.fontSubstitutionLocation.get(e);
                    int n2 = string2.lastIndexOf(System.getProperty("file.separator"));
                    if (n2 == -1 && string2.indexOf(47) != -1) {
                        n2 = string2.lastIndexOf(47);
                    }
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2);
                    }
                    if (string != null && !((String)e).toLowerCase().contains(string.toLowerCase())) continue;
                    if (!arrayList2.contains(string2)) {
                        arrayList2.add(string2);
                        treeItem2 = new TreeItem((Object)new TreeItem((Object)string2));
                        treeItem.getChildren().add((Object)treeItem2);
                        arrayList3.add(treeItem2);
                    }
                    treeItem2 = new TreeItem((Object)(e + " = " + FontMappings.fontSubstitutionLocation.get(e)));
                    int n3 = arrayList2.indexOf(string2);
                    ((TreeItem)arrayList3.get(n3)).getChildren().add((Object)treeItem2);
                    String string3 = (String)FontMappings.fontPropertiesTable.get(e + "_path");
                    Integer n4 = (Integer)FontMappings.fontPropertiesTable.get(e + "_type");
                    Map map = StandardFonts.getFontDetails(n4, string3);
                    if (map == null) continue;
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        TreeItem treeItem3 = new TreeItem((Object)(k + " = " + v));
                        treeItem2.getChildren().add((Object)treeItem3);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList.get(i);
                    if (string != null && !((String)e).toLowerCase().contains(string.toLowerCase())) continue;
                    TreeItem treeItem4 = new TreeItem((Object)(e + " = " + FontMappings.fontSubstitutionLocation.get(e)));
                    treeItem.getChildren().add((Object)treeItem4);
                    Map map = (Map)FontMappings.fontPropertiesTable.get(e);
                    if (map == null) continue;
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        TreeItem treeItem5 = new TreeItem((Object)(k + " = " + v));
                        treeItem4.getChildren().add((Object)treeItem5);
                    }
                }
            }
        }
        return treeItem;
    }

    private static void getAvailableFonts(TextField textField, boolean bl) {
        TreeItem treeItem = new TreeItem((Object)"Fonts");
        treeItem = JavaFXDocInfo.populateAvailableFonts(treeItem, textField.getText(), bl);
        treeContainer.getChildren().clear();
        treeContainer.getChildren().add((Object)new TreeView(treeItem));
    }
}

