/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;

public class JavaFXExit {
    public static void execute(Object[] objectArray, GUIThumbnailPanel gUIThumbnailPanel, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile) {
        if (objectArray == null) {
            JavaFXExit.exit(gUIThumbnailPanel, gUIFactory, values, pdfDecoderInt, propertiesFile);
        }
    }

    public static void exit(GUIThumbnailPanel gUIThumbnailPanel, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt, PropertiesFile propertiesFile) {
        Stage stage;
        gUIThumbnailPanel.terminateDrawing();
        SaveForm.handleUnsaveForms(gUIFactory, values, pdfDecoderInt);
        if (pdfDecoderInt.getDisplayView() == 5) {
            pdfDecoderInt.getPages().stopGeneratingPage();
        }
        pdfDecoderInt.closePdfFile();
        try {
            propertiesFile.setValue("lastDocumentPage", String.valueOf(values.getCurrentPage()));
            if (propertiesFile.getValue("trackViewerSize").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startViewerWidth", String.valueOf(((Stage)gUIFactory.getFrame()).getWidth()));
                propertiesFile.setValue("startViewerHeight", String.valueOf(((Stage)gUIFactory.getFrame()).getHeight()));
            }
            if (propertiesFile.getValue("trackScaling").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startScaling", String.valueOf(((GUI)gUIFactory).getSelectedComboItem(252)));
            }
            if (propertiesFile.getValue("trackView").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startView", String.valueOf(pdfDecoderInt.getDisplayView()));
            }
            if (propertiesFile.getValue("startSideTabOpen").equalsIgnoreCase("true")) {
                propertiesFile.setValue("startSideTabOpen", "true");
            }
            if (propertiesFile.getValue("trackSelectedSideTab").equalsIgnoreCase("true")) {
                stage = (TabPane)gUIFactory.getSideTabBar();
                if (DecoderOptions.isRunningOnMac) {
                    propertiesFile.setValue("startSelectedSideTab", ((Tab)stage.getTabs().get(stage.getSelectionModel().getSelectedIndex())).getText());
                } else {
                    propertiesFile.setValue("startSelectedSideTab", ((Tab)stage.getTabs().get(stage.getSelectionModel().getSelectedIndex())).getText());
                }
            }
            if (propertiesFile.getValue("trackSideTabExpandedSize").equalsIgnoreCase("true")) {
                propertiesFile.setValue("sideTabBarExpandLength", String.valueOf(gUIFactory.getSplitDividerLocation()));
            }
            propertiesFile.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception attempting to Write proterties: " + exception);
        }
        if (DevFlags.GUITESTINGINPROGRESS || !Viewer.exitOnClose) {
            gUIFactory.dispose();
        } else if (Viewer.exitOnClose) {
            pdfDecoderInt.dispose();
            gUIFactory.dispose();
        } else {
            stage = (Stage)gUIFactory.getFrame();
            if (stage == null) {
                pdfDecoderInt.dispose();
            } else {
                ((Stage)gUIFactory.getFrame()).close();
                pdfDecoderInt.dispose();
                gUIFactory.dispose();
            }
        }
    }
}

