/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;

public class JavaFXExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    protected static final int BUTTONWIDTH = 55;

    public static void execute(Values values, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt) {
        JavaFXExtractSelectionAsImage.extractSelectedScreenAsImage(values, gUIFactory, pdfDecoderInt);
        VBox vBox = new VBox();
        final FXDialog fXDialog = new FXDialog((Stage)gUIFactory.getFrame(), Modality.APPLICATION_MODAL, (Pane)vBox);
        fXDialog.setResizeable(false);
        String string = null;
        if (snapShot == null) {
            return;
        }
        ImageView imageView = new ImageView();
        imageView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)snapShot, null));
        fXDialog.setWidth(imageView.getImage().getWidth());
        fXDialog.setHeight(imageView.getImage().getHeight() + 50.0);
        vBox.getChildren().add((Object)imageView);
        imageView = new HBox();
        Button button = new Button("Save");
        Button button2 = new Button("Cancel");
        imageView.getChildren().addAll((Object[])new Node[]{button, button2});
        imageView.setAlignment(Pos.BOTTOM_RIGHT);
        if (string != null) {
            imageView.setStyle(string);
        }
        button.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        button2.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        vBox.getChildren().add((Object)imageView);
        fXDialog.getDialog().sizeToScene();
        button.setPrefWidth(55.0);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXDialog.getDialog().hide();
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Open PDF file");
                fileChooser.setInitialDirectory(new File(System.getProperty("user.dir")));
                FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("TIFF (*.tif)", new String[]{"*.tif", "*.tiff"});
                fileChooser.getExtensionFilters().add((Object)extensionFilter);
                FileChooser.ExtensionFilter extensionFilter2 = new FileChooser.ExtensionFilter("JPEG (*.jpg)", new String[]{"*.jpg", "*.jpeg"});
                fileChooser.getExtensionFilters().add((Object)extensionFilter2);
                File file = fileChooser.showSaveDialog((Window)fXDialog.getDialog());
                if (file != null) {
                    StringBuilder stringBuilder = new StringBuilder(file.getAbsolutePath());
                    FileChooser.ExtensionFilter extensionFilter3 = fileChooser.getSelectedExtensionFilter();
                    String string = "tif";
                    if (extensionFilter3.getDescription().toLowerCase().contains("jp")) {
                        string = "jpg";
                    }
                    if (!stringBuilder.toString().toLowerCase().endsWith(('.' + string).toLowerCase())) {
                        stringBuilder.append('.').append(string);
                    }
                    if (snapShot != null) {
                        try {
                            DefaultImageHelper.write(snapShot, string, stringBuilder.toString());
                        }
                        catch (IOException iOException) {
                            LogWriter.writeLog("Exception in writing image " + iOException);
                        }
                    }
                }
            }
        });
        button2.setPrefWidth(55.0);
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXDialog.close();
            }
        });
        fXDialog.show();
    }
}

