/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.commands.generic.GUIExtractText;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;

public class JavaFXExtractText
extends GUIExtractText {
    public static void execute(Object[] objectArray, GUIFactory gUIFactory, PdfDecoderInt pdfDecoderInt, Values values) {
        if (objectArray == null) {
            JavaFXExtractText.extractSelectedText(gUIFactory, pdfDecoderInt, values);
        }
    }

    private static void extractSelectedText(final GUIFactory gUIFactory, final PdfDecoderInt pdfDecoderInt, final Values values) {
        if (!pdfDecoderInt.isExtractionAllowed()) {
            gUIFactory.showMessageDialog("Not allowed");
            return;
        }
        int[][] nArray = pdfDecoderInt.getTextLines().getHighlightedAreasAs2DArray(values.getCurrentPage());
        if (nArray == null) {
            return;
        }
        BorderPane borderPane = new BorderPane();
        final FXDialog fXDialog = new FXDialog((Stage)gUIFactory.getFrame(), Modality.APPLICATION_MODAL, (Parent)borderPane, 300.0, 300.0);
        fXDialog.setTitle("Text Extraction Options");
        HBox hBox = new HBox();
        RadioButton radioButton = new RadioButton("Rectangle");
        radioButton.setId("rectangleExtraction");
        RadioButton radioButton2 = new RadioButton("Table");
        radioButton2.setId("tableExtraction");
        RadioButton radioButton3 = new RadioButton("WordList");
        radioButton3.setId("wordListExtraction");
        hBox.getChildren().addAll((Object[])new Node[]{radioButton, radioButton2, radioButton3});
        radioButton2.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
        radioButton3.setPadding(new Insets(0.0, 0.0, 0.0, 45.0));
        borderPane.setTop((Node)hBox);
        final TextArea textArea = new TextArea();
        borderPane.setCenter((Node)textArea);
        VBox vBox = new VBox();
        HBox hBox2 = new HBox(15.0);
        HBox hBox3 = new HBox();
        final RadioButton radioButton4 = new RadioButton("Extract as XML");
        RadioButton radioButton5 = new RadioButton("Extract as Text");
        Button button = new Button("Help");
        Button button2 = new Button("Cancel");
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                fXDialog.close();
            }
        });
        Button button3 = new Button("Extract");
        button3.setVisible(true);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        hBox3.getChildren().addAll((Object[])new Node[]{radioButton4, region, radioButton5});
        hBox2.setAlignment(Pos.BOTTOM_RIGHT);
        hBox2.getChildren().addAll((Object[])new Node[]{button, button2, button3});
        vBox.getChildren().addAll((Object[])new Node[]{hBox3, hBox2});
        radioButton4.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        radioButton5.setPadding(new Insets(0.0, 10.0, 13.0, 0.0));
        hBox2.setPadding(new Insets(0.0, 5.0, 10.0, 0.0));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerGroupingInfo.message"));
            }
        });
        final ToggleGroup toggleGroup = new ToggleGroup();
        radioButton.setSelected(true);
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{radioButton, radioButton2, radioButton3});
        ChangeListener<Toggle> changeListener = new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                textArea.setText(JavaFXExtractText.updateSelection(toggleGroup.getSelectedToggle(), radioButton4.isSelected(), pdfDecoderInt, values, gUIFactory));
            }
        };
        toggleGroup.selectedToggleProperty().addListener((ChangeListener)changeListener);
        ToggleGroup toggleGroup2 = new ToggleGroup();
        radioButton5.setSelected(true);
        toggleGroup2.getToggles().addAll((Object[])new Toggle[]{radioButton4, radioButton5});
        toggleGroup2.selectedToggleProperty().addListener((ChangeListener)changeListener);
        button3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXExtractText.createExtractionWindow(toggleGroup.getSelectedToggle(), radioButton4.isSelected(), pdfDecoderInt, values, gUIFactory);
            }
        });
        textArea.setText(JavaFXExtractText.updateSelection(toggleGroup.getSelectedToggle(), radioButton4.isSelected(), pdfDecoderInt, values, gUIFactory));
        borderPane.setBottom((Node)vBox);
        BorderPane.setMargin((Node)textArea, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)hBox, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)hBox3, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        BorderPane.setMargin((Node)hBox2, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        fXDialog.show();
    }

    private static String updateSelection(Toggle toggle, boolean bl, PdfDecoderInt pdfDecoderInt, Values values, GUIFactory gUIFactory) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            PdfPageData pdfPageData = pdfDecoderInt.getPdfPageData();
            int n = pdfPageData.getCropBoxX(values.getCurrentPage());
            int n2 = pdfPageData.getCropBoxY(values.getCurrentPage());
            int n3 = pdfPageData.getCropBoxWidth(values.getCurrentPage());
            int n4 = pdfPageData.getCropBoxHeight(values.getCurrentPage());
            int[][] nArray = pdfDecoderInt.getTextLines().getHighlightedAreasAs2DArray(values.getCurrentPage());
            if (nArray != null) {
                for (int i = 0; i != nArray.length; ++i) {
                    int n5;
                    String string = "";
                    if (nArray[i] == null) continue;
                    nArray[i] = GUICopy.adjustHighlightForExtraction(nArray[i]);
                    int n6 = nArray[i][0];
                    int n7 = nArray[i][0] + nArray[i][2];
                    int n8 = nArray[i][1] + nArray[i][3];
                    int n9 = nArray[i][1];
                    if (n8 < n9) {
                        n5 = n9;
                        n9 = n8;
                        n8 = n5;
                    }
                    if (n6 > n7) {
                        n5 = n7;
                        n7 = n6;
                        n6 = n5;
                    }
                    if (n6 < n) {
                        n6 = n;
                    }
                    if (n6 > n + n3) {
                        n6 = n + n3;
                    }
                    if (n7 < n) {
                        n7 = n;
                    }
                    if (n7 > n + n3) {
                        n7 = n + n3;
                    }
                    if (n8 < n2) {
                        n8 = n2;
                    }
                    if (n8 > n2 + n4) {
                        n8 = n2 + n4;
                    }
                    if (n9 < n2) {
                        n9 = n2;
                    }
                    if (n9 > n2 + n4) {
                        n9 = n2 + n4;
                    }
                    if ("rectangleExtraction".equals(((RadioButton)toggle).getId())) {
                        string = JavaFXExtractText.extractTextRectangle(values, pdfDecoderInt, gUIFactory, bl, n6, n7, n8, n9) + '\r' + '\n';
                    } else if ("tableExtraction".equals(((RadioButton)toggle).getId())) {
                        string = JavaFXExtractText.extractTextTable(values, pdfDecoderInt, bl, n6, n7, n8, n9);
                    } else if ("wordListExtraction".equals(((RadioButton)toggle).getId())) {
                        string = JavaFXExtractText.extractTextList(pdfDecoderInt, values, gUIFactory, bl, n6, n7, n8, n9);
                    }
                    stringBuilder.append(string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private static void createExtractionWindow(Toggle toggle, boolean bl, PdfDecoderInt pdfDecoderInt, Values values, GUIFactory gUIFactory) {
        Stage stage = new Stage();
        TextArea textArea = new TextArea();
        Scene scene = new Scene((Parent)textArea);
        stage.setTitle("Extracted Text");
        stage.setScene(scene);
        textArea.setText(JavaFXExtractText.updateSelection(toggle, bl, pdfDecoderInt, values, gUIFactory));
        stage.show();
    }
}

