/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXPageNavigator {
    private static boolean pageTurnAnimating;
    private static int lastPageDecoded;
    private static TiffHelper tiffHelper;
    private static boolean pageChanging;

    public static void gotoPage(String string, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        int n;
        string = string.split("/")[0];
        try {
            n = Integer.parseInt(string);
            if (!pdfDecoderInt.isPageAvailable(n)) {
                gUIFactory.showMessageDialog("Page " + n + " is not yet loaded");
                gUIFactory.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(values.getCurrentPage()));
                return;
            }
            if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                if ((pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) && (n & 1) == 1 && n != 1) {
                    --n;
                } else if (!pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (n & 1) == 0) {
                    --n;
                }
            }
            if (n > pdfDecoderInt.getPageCount() | n < 1) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + string + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + pdfDecoderInt.getPageCount());
                n = values.getCurrentPage();
                gUIFactory.setPageNumber();
            }
        }
        catch (Exception exception) {
            gUIFactory.showMessageDialog('>' + string + "< " + Messages.getMessage("PdfViewerInvalidNumber.text") + ' ' + exception);
            n = values.getCurrentPage();
            gUIFactory.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(values.getCurrentPage()));
        }
        JavaFXPageNavigator.navigatePages(n - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
        if (pdfDecoderInt.getDisplayView() == 5) {
            JavaFXPageNavigator.navigatePages(0, values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goPage(Object[] objectArray, GUIFactory gUIFactory, Values values, PdfDecoderInt pdfDecoderInt) {
        if (objectArray == null) {
            String string = gUIFactory.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
            if (string != null) {
                JavaFXPageNavigator.gotoPage(string, gUIFactory, values, pdfDecoderInt);
            }
        } else {
            JavaFXPageNavigator.gotoPage((String)objectArray[0], gUIFactory, values, pdfDecoderInt);
        }
    }

    public static void goLastPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null && values.getPageCount() > 1 && values.getPageCount() - values.getCurrentPage() > 0) {
            JavaFXPageNavigator.navigatePages(values.getPageCount() - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goFirstPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null && values.getPageCount() > 1 && values.getCurrentPage() != 1) {
            JavaFXPageNavigator.navigatePages(-(values.getCurrentPage() - 1), values, pdfDecoderInt, gUIFactory);
        }
    }

    public static void goFForwardPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null) {
            if (values.getPageCount() < values.getCurrentPage() + 10) {
                JavaFXPageNavigator.navigatePages(values.getPageCount() - values.getCurrentPage(), values, pdfDecoderInt, gUIFactory);
            } else {
                JavaFXPageNavigator.navigatePages(10, values, pdfDecoderInt, gUIFactory);
            }
        }
    }

    public static void goForwardPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        block7: {
            block5: {
                block6: {
                    if (objectArray != null) break block5;
                    if (values.getSelectedFile() == null) break block6;
                    JavaFXPageNavigator.navigatePages(1, values, pdfDecoderInt, gUIFactory);
                    break block7;
                }
                if (pdfDecoderInt.getPageCount() <= 0) break block7;
                if (values.getPageCount() != pdfDecoderInt.getPageCount()) {
                    values.setPageCount(pdfDecoderInt.getPageCount());
                }
                JavaFXPageNavigator.navigatePages(1, values, pdfDecoderInt, gUIFactory);
                break block7;
            }
            if (values.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(Integer.parseInt((String)objectArray[0]), values, pdfDecoderInt, gUIFactory);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to set propeties values " + exception);
                }
            }
        }
    }

    public static void goBackPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null) {
            if (values.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(-1, values, pdfDecoderInt, gUIFactory);
            }
        } else {
            if (values.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(-Integer.parseInt((String)objectArray[0]), values, pdfDecoderInt, gUIFactory);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to set propeties values " + exception);
                }
            }
        }
    }

    public static void goFBackPage(Object[] objectArray, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (objectArray == null && values.getSelectedFile() != null) {
            if (values.getCurrentPage() <= 10) {
                JavaFXPageNavigator.navigatePages(-(values.getCurrentPage() - 1), values, pdfDecoderInt, gUIFactory);
            } else {
                JavaFXPageNavigator.navigatePages(-10, values, pdfDecoderInt, gUIFactory);
            }
        }
    }

    public static void navigatePages(int n, Values values, PdfDecoderInt pdfDecoderInt, GUIFactory gUIFactory) {
        if (n == 0) {
            return;
        }
        if (!pageChanging) {
            pageChanging = true;
            if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                if (n == -1 && values.getCurrentPage() != 2) {
                    n = -2;
                }
                if (n == 1 && values.getCurrentPage() != pdfDecoderInt.getPageCount() - 1) {
                    n = 2;
                }
            }
            int n2 = values.getCurrentPage() + n;
            if (n > 0) {
                if (!pdfDecoderInt.isPageAvailable(n2)) {
                    gUIFactory.showMessageDialog("Page " + n2 + " is not yet loaded");
                    pageChanging = false;
                    return;
                }
                if (!Values.isProcessing()) {
                    if (n2 <= values.getPageCount()) {
                        if (values.isMultiTiff()) {
                            values.setTiffImageToLoad(lastPageDecoded - 1 + n);
                            JavaFXPageNavigator.drawMultiPageTiff(values, pdfDecoderInt);
                            values.setCurrentPage(n2);
                            lastPageDecoded = values.getTiffImageToLoad() + 1;
                            gUIFactory.setPageNumber();
                        } else {
                            if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                                if (pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) {
                                    if (n2 > values.getPageCount()) {
                                        n2 = values.getPageCount();
                                    }
                                    if ((n2 & 1) == 1 && n2 != 1) {
                                        --n2;
                                    }
                                    if (pdfDecoderInt.getDisplayView() == 4) {
                                        n = n2 / 2 - values.getCurrentPage() / 2;
                                    }
                                } else {
                                    if ((n2 & 1) == 0) {
                                        --n2;
                                    }
                                    n = (n2 + 1) / 2 - (values.getCurrentPage() + 1) / 2;
                                }
                            }
                            values.setCurrentPage(n2);
                            if (pdfDecoderInt.getDisplayView() == 2 || pdfDecoderInt.getDisplayView() == 3) {
                                gUIFactory.decodePage();
                                gUIFactory.setPageNumber();
                                pageChanging = false;
                                return;
                            }
                            gUIFactory.resetStatusMessage("Loading Page " + values.getCurrentPage());
                            pdfDecoderInt.setPageParameters(gUIFactory.getScaling(), values.getCurrentPage());
                            if (values.isPDF()) {
                                gUIFactory.decodePage();
                            }
                        }
                    }
                } else {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                }
            } else {
                if (!pdfDecoderInt.isPageAvailable(n2)) {
                    gUIFactory.showMessageDialog("Page " + n2 + " is not yet loaded");
                    pageChanging = false;
                    return;
                }
                if (!Values.isProcessing()) {
                    if (n2 >= 1) {
                        if (values.isMultiTiff()) {
                            values.setTiffImageToLoad(lastPageDecoded - 1 + n);
                            JavaFXPageNavigator.drawMultiPageTiff(values, pdfDecoderInt);
                            values.setCurrentPage(n2);
                            lastPageDecoded = values.getTiffImageToLoad() + 1;
                            gUIFactory.setPageNumber();
                        } else {
                            if (pdfDecoderInt.getDisplayView() == 4 || pdfDecoderInt.getDisplayView() == 3) {
                                if (pdfDecoderInt.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || pdfDecoderInt.getDisplayView() != 4) {
                                    if (n == -1) {
                                        --n2;
                                    }
                                    if (n2 < 1) {
                                        n2 = 1;
                                    }
                                    if ((n2 & 1) == 1 && n2 != 1) {
                                        --n2;
                                    }
                                    if (pdfDecoderInt.getDisplayView() == 4) {
                                        n = n2 / 2 - values.getCurrentPage() / 2;
                                    }
                                } else {
                                    if ((n2 & 1) == 0) {
                                        --n2;
                                    }
                                    if (pdfDecoderInt.getDisplayView() == 4) {
                                        n = (n2 + 1) / 2 - (values.getCurrentPage() + 1) / 2;
                                    }
                                }
                            }
                            values.setCurrentPage(n2);
                            if (pdfDecoderInt.getDisplayView() == 2 || pdfDecoderInt.getDisplayView() == 3) {
                                gUIFactory.decodePage();
                                gUIFactory.setPageNumber();
                                pageChanging = false;
                                return;
                            }
                            gUIFactory.resetStatusMessage("loading page " + values.getCurrentPage());
                            pdfDecoderInt.setPageParameters(gUIFactory.getScaling(), values.getCurrentPage());
                            if (values.isPDF()) {
                                gUIFactory.decodePage();
                            }
                        }
                    }
                } else {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                }
            }
            if (gUIFactory.getThumbnailScrollBar() != null) {
                gUIFactory.setThumbnailScrollBarValue(values.getCurrentPage() - 1);
            }
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
            gUIFactory.setPageNumber();
            pageChanging = false;
        }
    }

    public static void drawMultiPageTiff(Values values, PdfDecoderInt pdfDecoderInt) {
    }

    public static void setPageTurnAnimating(boolean bl, GUIFactory gUIFactory) {
        pageTurnAnimating = bl;
        if (bl) {
            gUIFactory.getButtons().getButton(53).setEnabled(false);
            gUIFactory.getButtons().getButton(52).setEnabled(false);
            gUIFactory.getButtons().getButton(54).setEnabled(false);
            gUIFactory.getButtons().getButton(51).setEnabled(false);
            gUIFactory.getButtons().getButton(55).setEnabled(false);
            gUIFactory.getButtons().getButton(50).setEnabled(false);
        } else {
            gUIFactory.getButtons().hideRedundentNavButtons(gUIFactory);
        }
    }

    public static boolean getPageTurnAnimating() {
        return pageTurnAnimating;
    }

    public static void setLastPageDecoded(int n) {
        lastPageDecoded = n;
    }

    public static TiffHelper getTiffHelper() {
        return tiffHelper;
    }

    public static void setTiffHelper(TiffHelper tiffHelper) {
        JavaFXPageNavigator.tiffHelper = tiffHelper;
    }

    static {
        lastPageDecoded = -1;
    }
}

