/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXOptionDialog;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.mozilla.javascript.ScriptRuntime;
import org.w3c.dom.NodeList;

public class JavaFXPreferences {
    private static final Map reverseMessage = new HashMap();
    private static final String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    private static FXDialog preferenceDialog;
    private static final int contentGap = 10;
    private static final BorderPane borderPane;
    private static final Font titleFont;
    private static final Text title;
    private static ScrollPane contentScrollPane;
    private static PropertiesFile properties;
    private static final int GENERAL = 0;
    private static final int PAGEDISPLAY = 1;
    private static final int INTERFACE = 2;
    private static final int COLOR = 3;
    private static final int MENU = 4;
    private static final int PRINTING = 5;
    private static final int EXTENSION = 6;
    private static TextField resolutionTF;
    private static CheckBox trueTypeCB;
    private static CheckBox autoScrollCB;
    private static CheckBox confirmCloseCB;
    private static CheckBox checkUpdatesCB;
    private static CheckBox openDocCB;
    private static Button clearRecentDocsBtn;
    private static CheckBox enhancedViewerCB;
    private static CheckBox showBorderCB;
    private static TextField pageInsetsTF;
    private static ComboBox displayCombo;
    private static CheckBox enablePageFlipCB;
    private static CheckBox scrollableThumbsCB;
    private static TextField winTitleTF;
    private static TextField iconLocTF;
    private static ComboBox searchStyle;
    private static TextField maxViewerTF;
    private static TextField sideTabTF;
    private static CheckBox consistentSideTabCB;
    private static CheckBox rightClickCB;
    private static CheckBox wheelZoomCB;
    private static CheckBox mouseSelectCB;
    private static ComboBox voiceSelect;
    private static ComboBox transitionSelect;
    private static ColorPicker highlightsPicker;
    private static TextField highlightTF;
    private static CheckBox invertHighlightsCB;
    private static ColorPicker pageColorPicker;
    private static CheckBox replaceTextColorCB;
    private static ColorPicker textColorPicker;
    private static CheckBox changeLineArtColorCB;
    private static CheckBox replaceDisplayCB;
    private static ColorPicker displayBGColorPicker;
    private static CheckBox hiResPrintingCB;
    private static ComboBox printerCombo;
    private static ComboBox paperSizesCombo;
    private static TextField defaultDPITF;
    private static TextField blackListTF;
    private static TabPane tabs;
    private static Speech speech;

    public static void execute(Object[] objectArray, GUIFactory gUIFactory) {
        if (objectArray == null) {
            JavaFXPreferences.showPreferenceWindow(gUIFactory);
        }
    }

    private static void init(final GUIFactory gUIFactory) {
        ObservableList observableList;
        Object object;
        speech = (Speech)gUIFactory.getPdfDecoder().getExternalHandler(32);
        resolutionTF = new TextField();
        trueTypeCB = new CheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        autoScrollCB = new CheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        confirmCloseCB = new CheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        checkUpdatesCB = new CheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
        openDocCB = new CheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        clearRecentDocsBtn = new Button(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        clearRecentDocsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                gUIFactory.getRecentDocument().clearRecentDocuments(gUIFactory.getProperties());
            }
        });
        enhancedViewerCB = new CheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        showBorderCB = new CheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        pageInsetsTF = new TextField();
        ObservableList observableList2 = FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        displayCombo = new ComboBox(observableList2);
        enablePageFlipCB = new CheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        scrollableThumbsCB = new CheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        winTitleTF = new TextField();
        iconLocTF = new TextField();
        ObservableList observableList3 = gUIFactory.isSingle() ? FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")}) : FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch")});
        searchStyle = new ComboBox(observableList3);
        maxViewerTF = new TextField();
        sideTabTF = new TextField();
        consistentSideTabCB = new CheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        rightClickCB = new CheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        wheelZoomCB = new CheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        mouseSelectCB = new CheckBox("Show Mouse Selection Box");
        if (speech != null) {
            object = new ArrayList(Arrays.asList(speech.listVoices()));
            observableList = FXCollections.observableList((List)object);
            voiceSelect = new ComboBox(observableList);
        } else {
            object = FXCollections.observableArrayList((Object[])new String[]{"No Voice Options Detected"});
            voiceSelect = new ComboBox((ObservableList)object);
        }
        object = new ArrayList();
        for (FXViewerTransitions.TransitionType transitionType : FXViewerTransitions.TransitionType.values()) {
            object.add(transitionType.name().replace("_", " "));
        }
        observableList = FXCollections.observableArrayList((Collection)object);
        transitionSelect = new ComboBox(observableList);
        transitionSelect.getSelectionModel().select(0);
        tabs = new TabPane();
        hiResPrintingCB = new CheckBox(Messages.getMessage("Printing.HiRes"));
        defaultDPITF = new TextField();
        blackListTF = new TextField();
    }

    private static void showPreferenceWindow(GUIFactory gUIFactory) {
        properties = gUIFactory.getProperties();
        JavaFXPreferences.init(gUIFactory);
        JavaFXPreferences.loadSettings();
        borderPane.setLeft((Node)JavaFXPreferences.setupSideNavBar(gUIFactory));
        borderPane.setCenter((Node)JavaFXPreferences.getGeneralContent());
        borderPane.setBottom((Node)JavaFXPreferences.setupBottomBar(gUIFactory));
        preferenceDialog = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)borderPane, 550.0, 450.0);
        preferenceDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        preferenceDialog.show();
    }

    private static ScrollPane setupSideNavBar(final GUIFactory gUIFactory) {
        VBox vBox = new VBox();
        final ToggleGroup toggleGroup = new ToggleGroup();
        final ToggleButton[] toggleButtonArray = new ToggleButton[]{new ToggleButton(Messages.getMessage("PdfPreferences.GeneralTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/display.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/pagedisplay.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/interface.png"))), new ToggleButton("Color", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/color.png"))), new ToggleButton("Menu", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/menu.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.PrintingTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/printing.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.ExtensionsTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/extensions.png")))};
        toggleButtonArray[0].setSelected(true);
        for (ToggleButton toggleButton : toggleButtonArray) {
            toggleButton.setContentDisplay(ContentDisplay.TOP);
            toggleButton.setTextFill((Paint)Color.BLACK);
            toggleButton.setStyle("-fx-base: transparent;");
            toggleButton.setToggleGroup(toggleGroup);
        }
        vBox.getChildren().addAll((Object[])toggleButtonArray);
        vBox.setAlignment(Pos.CENTER);
        toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                for (int i = 0; i < toggleButtonArray.length; ++i) {
                    if (toggleGroup.getSelectedToggle() != toggleButtonArray[i]) continue;
                    JavaFXPreferences.updateDisplay(i, gUIFactory);
                }
            }
        });
        ToggleButton[] toggleButtonArray2 = new ScrollPane();
        toggleButtonArray2.setContent((Node)vBox);
        return toggleButtonArray2;
    }

    private static void updateDisplay(int n, GUIFactory gUIFactory) {
        switch (n) {
            case 0: {
                borderPane.setCenter((Node)JavaFXPreferences.getGeneralContent());
                break;
            }
            case 1: {
                borderPane.setCenter((Node)JavaFXPreferences.getPageDisplayContent());
                break;
            }
            case 2: {
                borderPane.setCenter((Node)JavaFXPreferences.getInterfaceContent(gUIFactory));
                break;
            }
            case 3: {
                borderPane.setCenter((Node)JavaFXPreferences.getColorContent());
                break;
            }
            case 4: {
                borderPane.setCenter((Node)JavaFXPreferences.getMenuContent());
                break;
            }
            case 5: {
                borderPane.setCenter((Node)JavaFXPreferences.getPrintingContent());
                break;
            }
            case 6: {
                borderPane.setCenter((Node)JavaFXPreferences.getExtensionContent());
                break;
            }
            default: {
                System.out.println("menu selection not available");
            }
        }
    }

    private static HBox setupBottomBar(final GUIFactory gUIFactory) {
        Button button = new Button(Messages.getMessage("PdfPreferences.ResetToDefault"));
        Button button2 = new Button("OK");
        Button button3 = new Button(Messages.getMessage("PdfPreferences.SaveAs"));
        Button button4 = new Button("Cancel");
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(8.0));
        hBox.setSpacing(8.0);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{button, region, button2, button3, button4});
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXPreferences.updateSettings(gUIFactory);
                preferenceDialog.close();
            }
        });
        button4.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                preferenceDialog.close();
            }
        });
        button3.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                String string = gUIFactory.getPropertiesFileLocation();
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML File", new String[]{"*.xml"})});
                fileChooser.setInitialFileName("*.xml");
                File file = fileChooser.showSaveDialog(null);
                if (file != null) {
                    gUIFactory.setPropertiesFileLocation(file.getAbsolutePath());
                    JavaFXPreferences.updateSettings(gUIFactory);
                    try {
                        properties.writeDoc();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception attempting to Write proterties: " + exception);
                    }
                }
                gUIFactory.setPropertiesFileLocation(string);
            }
        });
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                int n = new FXOptionDialog(preferenceDialog.getDialog(), Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0, null, null).showOptionDialog();
                if (n == 0) {
                    String string = gUIFactory.getPropertiesFileLocation();
                    File file = new File(string);
                    if (file.exists()) {
                        file.delete();
                    }
                    properties.loadProperties(string);
                    try {
                        properties.writeDoc();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception attempting to Write proterties: " + exception);
                    }
                    if (GUI.showMessages) {
                        new FXMessageDialog(preferenceDialog.getDialog(), Modality.APPLICATION_MODAL, Messages.getMessage("PdfPreferences.restart")).showAndWait();
                    }
                    preferenceDialog.close();
                }
            }
        });
        return hBox;
    }

    private static ScrollPane getGeneralContent() {
        contentScrollPane = new ScrollPane();
        VBox vBox = new VBox();
        title.setText(Messages.getMessage("PdfPreferences.GeneralTitle"));
        title.setFont(titleFont);
        Text text = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text.setFont(titleFont);
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.Resolution")), resolutionTF});
        Text text2 = new Text(Messages.getMessage("PdfPreferences.StartUp"));
        text2.setFont(titleFont);
        vBox.getChildren().addAll((Object[])new Node[]{title, text, hBox, trueTypeCB, autoScrollCB, confirmCloseCB, text2, checkUpdatesCB, openDocCB, clearRecentDocsBtn});
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        contentScrollPane.setContent((Node)vBox);
        return contentScrollPane;
    }

    private static ScrollPane getPageDisplayContent() {
        contentScrollPane = new ScrollPane();
        VBox vBox = new VBox();
        title.setText(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
        Text text = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text.setFont(titleFont);
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.pageInsets")), pageInsetsTF});
        Text text2 = new Text(Messages.getMessage("PdfPreferences.DisplayModes"));
        text2.setFont(titleFont);
        HBox hBox2 = new HBox();
        hBox2.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PageLayoutViewMenu.PageLayout")), displayCombo});
        vBox.getChildren().addAll((Object[])new Node[]{title, text, enhancedViewerCB, showBorderCB, hBox, text2, hBox2, enablePageFlipCB, scrollableThumbsCB});
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        contentScrollPane.setContent((Node)vBox);
        return contentScrollPane;
    }

    private static ScrollPane getInterfaceContent(GUIFactory gUIFactory) {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.InterfaceTitle"));
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab tab = new Tab(Messages.getMessage("PdfPreferences.AppearanceTab"));
        VBox vBox = new VBox();
        Text text = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text.setFont(titleFont);
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfCustomGui.windowTitle")), winTitleTF});
        HBox hBox2 = new HBox();
        hBox2.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.iconLocation")), iconLocTF});
        HBox hBox3 = new HBox();
        hBox3.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PageLayoutViewMenu.SearchLayout")), searchStyle});
        HBox hBox4 = new HBox();
        hBox4.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfPreferences.MaxMultiViewers")), maxViewerTF});
        Text text2 = new Text(Messages.getMessage("PdfPreferences.SideTab"));
        text2.setFont(titleFont);
        HBox hBox5 = new HBox();
        hBox5.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfCustomGui.SideTabLength")), sideTabTF});
        HBox hBox6 = new HBox();
        hBox6.getChildren().addAll((Object[])new Node[]{new Label("Transition type: "), transitionSelect});
        vBox.getChildren().addAll((Object[])new Node[]{text, hBox, hBox2, hBox3, hBox4, text2, hBox5, consistentSideTabCB, hBox6});
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        tab.setContent((Node)vBox);
        Tab tab2 = new Tab(Messages.getMessage("PdfPreferences.Mouse"));
        VBox vBox2 = new VBox();
        Text text3 = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text3.setFont(titleFont);
        vBox2.getChildren().addAll((Object[])new Node[]{text3, rightClickCB, wheelZoomCB, mouseSelectCB});
        vBox2.setPadding(new Insets(10.0));
        vBox2.setSpacing(10.0);
        tab2.setContent((Node)vBox2);
        Tab tab3 = new Tab(Messages.getMessage("PdfPreferences.Voice"));
        VBox vBox3 = new VBox();
        Text text4 = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text4.setFont(titleFont);
        vBox3.getChildren().addAll((Object[])new Node[]{text4, voiceSelect});
        vBox3.setPadding(new Insets(10.0));
        vBox3.setSpacing(10.0);
        tab3.setContent((Node)vBox3);
        tabPane.getTabs().addAll((Object[])new Tab[]{tab, tab2, tab3});
        VBox vBox4 = new VBox();
        vBox4.setPadding(new Insets(10.0));
        vBox4.setSpacing(10.0);
        vBox4.getChildren().addAll((Object[])new Node[]{title, tabPane});
        contentScrollPane.setContent((Node)vBox4);
        return contentScrollPane;
    }

    private static ScrollPane getColorContent() {
        contentScrollPane = new ScrollPane();
        title.setText("Color");
        VBox vBox = new VBox();
        Text text = new Text("Highlights");
        text.setFont(titleFont);
        final HBox hBox = new HBox();
        Label label = new Label(Messages.getMessage("PdfPreferences.ChangeHighlightColor") + ' ');
        hBox.getChildren().addAll((Object[])new Node[]{label, highlightsPicker});
        final HBox hBox2 = new HBox();
        Label label2 = new Label(Messages.getMessage("PdfPreferences.ChangeHighlightTransparency") + ' ');
        hBox2.getChildren().addAll((Object[])new Node[]{label2, highlightTF});
        String string = properties.getValue("invertHighlights");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            hBox2.setDisable(true);
            hBox.setDisable(true);
        } else {
            hBox2.setDisable(false);
            hBox.setDisable(false);
        }
        invertHighlightsCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (invertHighlightsCB.isSelected()) {
                    hBox2.setDisable(true);
                    hBox.setDisable(true);
                } else {
                    hBox2.setDisable(false);
                    hBox.setDisable(false);
                }
            }
        });
        Text text2 = new Text("Display Colors");
        text2.setFont(titleFont);
        HBox hBox3 = new HBox();
        Label label3 = new Label(Messages.getMessage("PdfPreferences.ChangeBackgroundColor") + ' ');
        hBox3.getChildren().addAll((Object[])new Node[]{label3, pageColorPicker});
        final HBox hBox4 = new HBox();
        Label label4 = new Label(Messages.getMessage("PdfPreferences.ChangeForegroundColor") + ' ');
        hBox4.getChildren().addAll((Object[])new Node[]{label4, textColorPicker});
        String string2 = properties.getValue("replaceDocumentTextColors");
        if (!string2.isEmpty() && string2.equalsIgnoreCase("true")) {
            replaceTextColorCB.setSelected(true);
            hBox4.setDisable(false);
            changeLineArtColorCB.setDisable(false);
        } else {
            replaceTextColorCB.setSelected(false);
            hBox4.setDisable(true);
            changeLineArtColorCB.setDisable(true);
        }
        replaceTextColorCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (replaceTextColorCB.isSelected()) {
                    hBox4.setDisable(false);
                    changeLineArtColorCB.setDisable(false);
                } else {
                    hBox4.setDisable(true);
                    changeLineArtColorCB.setDisable(true);
                }
            }
        });
        final HBox hBox5 = new HBox();
        Label label5 = new Label(Messages.getMessage("PdfPreferences.ChangeDisplayBackgroundColor") + ' ');
        hBox5.getChildren().addAll((Object[])new Node[]{label5, displayBGColorPicker});
        String string3 = properties.getValue("replacePdfDisplayBackground");
        if (!string3.isEmpty() && string3.equalsIgnoreCase("true")) {
            replaceDisplayCB.setSelected(true);
            hBox5.setDisable(false);
        } else {
            replaceDisplayCB.setSelected(false);
            hBox5.setDisable(true);
        }
        replaceDisplayCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (replaceDisplayCB.isSelected()) {
                    hBox5.setDisable(false);
                } else {
                    hBox5.setDisable(true);
                }
            }
        });
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{title, text, hBox, hBox2, invertHighlightsCB, text2, hBox3, replaceTextColorCB, hBox4, changeLineArtColorCB, replaceDisplayCB, hBox5});
        contentScrollPane.setContent((Node)vBox);
        return contentScrollPane;
    }

    public static Color shiftColorSpaceToFX(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return Color.rgb((int)n2, (int)n3, (int)n4);
    }

    private static int shiftColorSpaceToSwing(Color color) {
        int n = (int)(color.getRed() * 255.0);
        int n2 = (int)(color.getGreen() * 255.0);
        int n3 = (int)(color.getBlue() * 255.0);
        return (n << 16) + (n2 << 8) + n3;
    }

    private static void addMenuToTree(NodeList nodeList, CheckBoxTreeItem checkBoxTreeItem, List list) {
        for (int i = 0; i != nodeList.getLength(); ++i) {
            String string;
            if (i >= nodeList.getLength() || JavaFXPreferences.removeOption(string = nodeList.item(i).getNodeName()) || string.startsWith("#")) continue;
            final CheckBoxTreeItem checkBoxTreeItem2 = new CheckBoxTreeItem((Object)Messages.getMessage("PdfCustomGui." + string));
            reverseMessage.put(Messages.getMessage("PdfCustomGui." + string), string);
            String string2 = properties.getValue(string);
            if (!string2.isEmpty() && string2.equals("true")) {
                checkBoxTreeItem2.setSelected(true);
            } else {
                checkBoxTreeItem2.setSelected(false);
            }
            if (string.equals("Preferences")) {
                checkBoxTreeItem2.selectedProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue observableValue, Object object, Object object2) {
                        int n;
                        if (!checkBoxTreeItem2.isSelected() && (n = new FXOptionDialog(null, "Disabling this option will mean you can not acces this menu using this properties file. Do you want to continue?", "Preferences Access", 0, null, null).showOptionDialog()) == 1) {
                            checkBoxTreeItem2.setSelected(true);
                        }
                    }
                });
            }
            if (nodeList.item(i).hasChildNodes()) {
                list.add(checkBoxTreeItem);
                checkBoxTreeItem.getChildren().add((Object)checkBoxTreeItem2);
                JavaFXPreferences.addMenuToTree(nodeList.item(i).getChildNodes(), checkBoxTreeItem2, list);
                continue;
            }
            checkBoxTreeItem.getChildren().add((Object)checkBoxTreeItem2);
        }
    }

    private static boolean removeOption(String string) {
        if (string.equals("Helpbutton")) {
            return true;
        }
        if (string.equals("RSSbutton")) {
            return true;
        }
        return string.equals("Helpforum");
    }

    private static ScrollPane getMenuContent() {
        contentScrollPane = new ScrollPane();
        VBox vBox = new VBox();
        title.setText("Menu");
        tabs.getTabs().clear();
        tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        for (int i = 0; i != menuTabs.length; ++i) {
            reverseMessage.put(Messages.getMessage("PdfCustomGui." + menuTabs[i]), menuTabs[i]);
            CheckBoxTreeItem checkBoxTreeItem = new CheckBoxTreeItem((Object)Messages.getMessage("PdfCustomGui." + menuTabs[i]));
            checkBoxTreeItem.setSelected(true);
            ArrayList<CheckBoxTreeItem> arrayList = new ArrayList<CheckBoxTreeItem>();
            arrayList.add(checkBoxTreeItem);
            NodeList nodeList = properties.getChildren(Messages.getMessage("PdfCustomGui." + menuTabs[i]) + "Menu");
            JavaFXPreferences.addMenuToTree(nodeList, checkBoxTreeItem, arrayList);
            checkBoxTreeItem.setExpanded(true);
            TreeView treeView = new TreeView((TreeItem)checkBoxTreeItem);
            treeView.setCellFactory(CheckBoxTreeCell.forTreeView());
            tabs.getTabs().addAll((Object[])new Tab[]{new Tab(Messages.getMessage("PdfCustomGui." + menuTabs[i]))});
            ((Tab)tabs.getTabs().get(i)).setContent((Node)treeView);
        }
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{title, tabs});
        contentScrollPane.setContent((Node)vBox);
        return contentScrollPane;
    }

    private static ScrollPane getPrintingContent() {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.PrintingTitle"));
        VBox vBox = new VBox();
        Text text = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        text.setFont(titleFont);
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultPrinter")), printerCombo});
        HBox hBox2 = new HBox();
        hBox2.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultPagesize")), paperSizesCombo});
        HBox hBox3 = new HBox();
        hBox3.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultDPI")), defaultDPITF});
        HBox hBox4 = new HBox();
        hBox4.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.blacklist")), blackListTF});
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{title, text, hiResPrintingCB, hBox, hBox2, hBox3, hBox4});
        contentScrollPane.setContent((Node)vBox);
        return contentScrollPane;
    }

    private static ScrollPane getExtensionContent() {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.ExtensionsTitle"));
        VBox vBox = new VBox();
        GridPane gridPane = new GridPane();
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(100.0), new ColumnConstraints(200.0)});
        Text text = new Text(Messages.getMessage("PdfPreferences.ExtensionName"));
        Text text2 = new Text("BCMail");
        Text text3 = new Text("CID");
        Text text4 = new Text("JCE");
        Text text5 = new Text("Rhino");
        text.setFont(titleFont);
        Text text6 = new Text(Messages.getMessage("PdfPreferences.ExtensionDescription"));
        Text text7 = new Text(Messages.getMessage("PdfExtensions.BCMail.text"));
        Text text8 = new Text(Messages.getMessage("PdfExtensions.CID.text"));
        Text text9 = new Text(Messages.getMessage("PdfExtensions.JCE.text"));
        Text text10 = new Text(Messages.getMessage("PdfExtensions.Rhino.text"));
        text6.setFont(titleFont);
        Text text11 = new Text(Messages.getMessage("PdfPreferences.ExtensionVersion"));
        text11.setFont(titleFont);
        Hyperlink hyperlink = new Hyperlink();
        String string = JavaFXPreferences.getBCMailVersion(hyperlink);
        Hyperlink hyperlink2 = new Hyperlink();
        string = string + JavaFXPreferences.getCidVersion(hyperlink2);
        Hyperlink hyperlink3 = new Hyperlink();
        string = string + JavaFXPreferences.getJCEVersion(hyperlink3);
        Hyperlink hyperlink4 = new Hyperlink();
        string = string + JavaFXPreferences.getRhinoVersion(hyperlink4);
        Button button = JavaFXPreferences.createCopyDetailsButton(string);
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        vBox.getChildren().addAll((Object[])new Node[]{title, gridPane, button});
        contentScrollPane.setContent((Node)vBox);
        int n = 0;
        JavaFXPreferences.addLineToExtensionGrid(gridPane, (Node)text, (Node)text6, (Node)text11, n);
        JavaFXPreferences.addLineToExtensionGrid(gridPane, (Node)text2, (Node)text7, (Node)hyperlink, ++n);
        JavaFXPreferences.addLineToExtensionGrid(gridPane, (Node)text3, (Node)text8, (Node)hyperlink2, ++n);
        JavaFXPreferences.addLineToExtensionGrid(gridPane, (Node)text4, (Node)text9, (Node)hyperlink3, ++n);
        JavaFXPreferences.addLineToExtensionGrid(gridPane, (Node)text5, (Node)text10, (Node)hyperlink4, ++n);
        return contentScrollPane;
    }

    private static Button createCopyDetailsButton(String string) {
        Button button = new Button(Messages.getMessage("PdfPreferences.CopyToClipboard"));
        final String string2 = "java: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + '\n' + "os: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n' + "jpedal: " + "6.6.30" + '\n' + string;
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXMessageDialog fXMessageDialog = new FXMessageDialog(null, Modality.APPLICATION_MODAL, Messages.getMessage("PdfExtensions.clipboard"));
                fXMessageDialog.show();
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(string2);
                clipboard.setContent((Map)clipboardContent);
            }
        });
        return button;
    }

    private static String getRhinoVersion(Hyperlink hyperlink) {
        String string = "";
        InputStream inputStream = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
        if (inputStream != null) {
            String string2 = ScriptRuntime.getMessage0((String)"implementation.version");
            string = string + "rhino: " + string2 + '\n';
            String string3 = "";
            if (!string2.replaceAll("release 1", "").equals(string2)) {
                string3 = " R1";
            }
            if (!string2.replaceAll("release 2", "").equals(string2)) {
                string3 = " R2";
            }
            string2 = string2.substring(0, 12).replaceAll("[^0-9|.]", "");
            hyperlink.setText(string2 + string3);
        } else {
            hyperlink.setText(Messages.getMessage("PdfExtensions.getText"));
            hyperlink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.Rhino.link"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        return string;
    }

    private static String getJCEVersion(Hyperlink hyperlink) {
        String string = "";
        String string2 = "Unknown Version";
        try {
            Class<?> clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            String string3 = clazz.getName().replace('.', '/');
            String[] stringArray = clazz.getResource('/' + string3 + ".class").getPath().split("!");
            URL uRL = new URL(stringArray[0]);
            JarFile jarFile = new JarFile(uRL.getFile());
            if (!jarFile.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                string2 = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
            }
            hyperlink.setText(string2);
            string = string + "jce: " + string2 + '\n';
        }
        catch (Exception exception) {
            hyperlink.setText(Messages.getMessage("PdfExtensions.getText") + ' ' + exception);
            hyperlink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.JCE.link"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        return string;
    }

    private static String getCidVersion(Hyperlink hyperlink) {
        String string = "";
        try {
            if (JavaFXPreferences.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf") != null) {
                hyperlink.setText("1.0");
                string = string + "cid: 1.0\n";
            } else {
                hyperlink.setText(Messages.getMessage("PdfExtensions.getText"));
                hyperlink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        try {
                            BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.CID.link"));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private static String getBCMailVersion(Hyperlink hyperlink) {
        String string = "";
        String string2 = "Unknown Version";
        try {
            Class<?> clazz = Class.forName("org.bouncycastle.jcajce.JcaJceHelper");
            String string3 = clazz.getName().replace('.', '/');
            String[] stringArray = clazz.getResource('/' + string3 + ".class").getPath().split("!");
            URL uRL = new URL(stringArray[0]);
            JarFile jarFile = new JarFile(uRL.getFile());
            if (!jarFile.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                string2 = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
            }
            hyperlink.setText(string2);
            string = string + "bcmail: " + string2 + '\n';
        }
        catch (Exception exception) {
            hyperlink.setText(Messages.getMessage("PdfExtensions.getText") + ' ' + exception);
            hyperlink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.BCMail.link"));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        return string;
    }

    private static void addLineToExtensionGrid(GridPane gridPane, Node node, Node node2, Node node3, int n) {
        gridPane.add(node, 0, n);
        gridPane.add(node2, 1, n);
        gridPane.add(node3, 2, n);
    }

    private static void updateSettings(GUIFactory gUIFactory) {
        properties.setValue("resolution", String.valueOf(resolutionTF.getText()));
        properties.setValue("useHinting", String.valueOf(trueTypeCB.isSelected()));
        properties.setValue("autoScroll", String.valueOf(autoScrollCB.isSelected()));
        properties.setValue("confirmClose", String.valueOf(confirmCloseCB.isSelected()));
        properties.setValue("automaticupdate", String.valueOf(checkUpdatesCB.isSelected()));
        properties.setValue("openLastDocument", String.valueOf(openDocCB.isSelected()));
        properties.setValue("enhancedViewerMode", String.valueOf(enhancedViewerCB.isSelected()));
        properties.setValue("pageInsets", String.valueOf(pageInsetsTF.getText()));
        properties.setValue("enhancedFacingMode", String.valueOf(enablePageFlipCB.isSelected()));
        properties.setValue("previewOnSingleScroll", String.valueOf(scrollableThumbsCB.isSelected()));
        properties.setValue("windowTitle", String.valueOf(winTitleTF.getText()));
        String string = iconLocTF.getText();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + '/';
        }
        properties.setValue("iconLocation", String.valueOf(string));
        properties.setValue("searchWindowType", Integer.toString(searchStyle.getItems().indexOf(searchStyle.getValue())));
        properties.setValue("maxmultiviewers", String.valueOf(maxViewerTF.getText()));
        properties.setValue("sideTabBarCollapseLength", String.valueOf(sideTabTF.getText()));
        properties.setValue("consistentTabBar", String.valueOf(consistentSideTabCB.isSelected()));
        properties.setValue("allowRightClick", String.valueOf(rightClickCB.isSelected()));
        properties.setValue("allowScrollwheelZoom", String.valueOf(wheelZoomCB.isSelected()));
        properties.setValue("showMouseSelectionBox", String.valueOf(mouseSelectCB.isSelected()));
        properties.setValue("transitionType", transitionSelect.getSelectionModel().getSelectedItem().toString());
        ((JavaFxGUI)gUIFactory).updateTransitionType();
        if (speech != null) {
            properties.setValue("voice", String.valueOf(voiceSelect.getValue()));
        }
        Color color = (Color)highlightsPicker.getValue();
        properties.setValue("highlightBoxColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(color)));
        properties.setValue("highlightComposite", String.valueOf(highlightTF.getText()));
        properties.setValue("invertHighlights", String.valueOf(invertHighlightsCB.isSelected()));
        color = (Color)pageColorPicker.getValue();
        properties.setValue("vbgColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(color)));
        properties.setValue("replaceDocumentTextColors", String.valueOf(replaceTextColorCB.isSelected()));
        color = (Color)displayBGColorPicker.getValue();
        properties.setValue("pdfDisplayBackground", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(color)));
        properties.setValue("changeTextAndLineart", String.valueOf(changeLineArtColorCB.isSelected()));
        properties.setValue("replacePdfDisplayBackground", String.valueOf(replaceDisplayCB.isSelected()));
        color = (Color)textColorPicker.getValue();
        properties.setValue("vfgColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(color)));
        properties.setValue("useHiResPrinting", String.valueOf(hiResPrintingCB.isSelected()));
        if (((String)printerCombo.getValue()).startsWith("System Default")) {
            properties.setValue("defaultPrinter", "");
        } else {
            properties.setValue("defaultPrinter", String.valueOf(printerCombo.getValue()));
        }
        properties.setValue("defaultPagesize", String.valueOf(paperSizesCombo.getValue()));
        properties.setValue("defaultDPI", String.valueOf(defaultDPITF.getText()));
        properties.setValue("printerBlacklist", String.valueOf(blackListTF.getText()));
        JavaFXPreferences.saveGUIPreferences(gUIFactory);
    }

    private static void saveMenuPreferencesChildren(CheckBoxTreeItem<String> checkBoxTreeItem, GUIFactory gUIFactory) {
        for (int i = 0; i != checkBoxTreeItem.getChildren().size(); ++i) {
            CheckBoxTreeItem checkBoxTreeItem2 = (CheckBoxTreeItem)checkBoxTreeItem.getChildren().get(i);
            String string = (String)reverseMessage.get(checkBoxTreeItem2.getValue());
            if (checkBoxTreeItem2.isSelected()) {
                properties.setValue(string, "true");
                gUIFactory.alterProperty(string, true);
            } else {
                properties.setValue(string, "false");
                gUIFactory.alterProperty(string, false);
            }
            if (checkBoxTreeItem2.getChildren().isEmpty()) continue;
            JavaFXPreferences.saveMenuPreferencesChildren((CheckBoxTreeItem<String>)checkBoxTreeItem2, gUIFactory);
        }
    }

    private static void saveGUIPreferences(GUIFactory gUIFactory) {
        for (int i = 0; i != tabs.getTabs().size(); ++i) {
            Tab tab = (Tab)tabs.getTabs().get(i);
            TreeView treeView = (TreeView)tab.getContent();
            CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)treeView.getRoot();
            if (checkBoxTreeItem.getChildren().isEmpty()) continue;
            JavaFXPreferences.saveMenuPreferencesChildren((CheckBoxTreeItem<String>)checkBoxTreeItem, gUIFactory);
        }
    }

    private static void loadSettings() {
        int n;
        String string = properties.getValue("resolution");
        if (!string.isEmpty()) {
            resolutionTF.setText(string);
        } else {
            resolutionTF.setText("72");
        }
        string = properties.getValue("useHinting");
        if (!string.isEmpty() && string.equals("true")) {
            trueTypeCB.setSelected(true);
        } else {
            trueTypeCB.setSelected(false);
        }
        string = properties.getValue("autoScroll");
        if (string.equals("true")) {
            autoScrollCB.setSelected(true);
        } else {
            autoScrollCB.setSelected(false);
        }
        string = properties.getValue("confirmClose");
        if (string.equals("true")) {
            confirmCloseCB.setSelected(true);
        } else {
            confirmCloseCB.setSelected(false);
        }
        string = properties.getValue("automaticupdate");
        if (string.equals("true")) {
            checkUpdatesCB.setSelected(true);
        } else {
            checkUpdatesCB.setSelected(false);
        }
        string = properties.getValue("openLastDocument");
        if (string.equals("true")) {
            openDocCB.setSelected(true);
        } else {
            openDocCB.setSelected(false);
        }
        string = properties.getValue("enhancedViewerMode");
        if (!string.isEmpty() && string.equals("true")) {
            enhancedViewerCB.setSelected(true);
        } else {
            enhancedViewerCB.setSelected(false);
        }
        string = properties.getValue("borderType");
        if (!string.isEmpty()) {
            if (Integer.parseInt(string) == 1) {
                showBorderCB.setSelected(true);
            } else {
                showBorderCB.setSelected(false);
            }
        }
        if ((string = properties.getValue("pageInsets")) != null && !string.isEmpty()) {
            pageInsetsTF.setText(string);
        } else {
            pageInsetsTF.setText("25");
        }
        string = properties.getValue("startView");
        if (!string.isEmpty()) {
            n = Integer.parseInt(string);
            if (n < 1 || n > 5) {
                n = 1;
            }
            displayCombo.setValue(displayCombo.getItems().get(n - 1));
        }
        if (!(string = properties.getValue("enhancedFacingMode")).isEmpty() && string.equals("true")) {
            enablePageFlipCB.setSelected(true);
        } else {
            enablePageFlipCB.setSelected(false);
        }
        string = properties.getValue("previewOnSingleScroll");
        if (!string.isEmpty() && string.equals("true")) {
            scrollableThumbsCB.setSelected(true);
        } else {
            scrollableThumbsCB.setSelected(false);
        }
        string = properties.getValue("windowTitle");
        if (string != null && !string.isEmpty()) {
            winTitleTF.setText(string);
        }
        if ((string = properties.getValue("iconLocation")) != null && !string.isEmpty()) {
            iconLocTF.setText(string);
        } else {
            iconLocTF.setText("/org/jpedal/examples/viewer/res/");
        }
        string = properties.getValue("searchWindowType");
        if (!string.isEmpty()) {
            n = Integer.parseInt(string);
            if (n < searchStyle.getItems().size()) {
                searchStyle.setValue(searchStyle.getItems().get(Integer.parseInt(string)));
            } else {
                searchStyle.setValue(searchStyle.getItems().get(0));
            }
        } else {
            searchStyle.setValue(searchStyle.getItems().get(0));
        }
        string = properties.getValue("maxmultiviewers");
        if (!string.isEmpty()) {
            maxViewerTF.setText(string);
        } else {
            maxViewerTF.setText("20");
        }
        string = properties.getValue("sideTabBarCollapseLength");
        if (string != null && !string.isEmpty()) {
            sideTabTF.setText(string);
        } else {
            sideTabTF.setText("30");
        }
        string = properties.getValue("consistentTabBar");
        if (!string.isEmpty() && string.equals("true")) {
            consistentSideTabCB.setSelected(true);
        } else {
            consistentSideTabCB.setSelected(false);
        }
        string = properties.getValue("allowRightClick");
        if (!string.isEmpty() && string.equals("true")) {
            rightClickCB.setSelected(true);
        } else {
            rightClickCB.setSelected(false);
        }
        string = properties.getValue("allowScrollwheelZoom");
        if (!string.isEmpty() && string.equals("true")) {
            wheelZoomCB.setSelected(true);
        } else {
            wheelZoomCB.setSelected(false);
        }
        string = properties.getValue("showMouseSelectionBox");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            mouseSelectCB.setSelected(true);
        } else {
            mouseSelectCB.setSelected(false);
        }
        voiceSelect.setValue((Object)properties.getValue("voice"));
        string = properties.getValue("transitionType");
        if (!string.isEmpty()) {
            transitionSelect.getSelectionModel().select((Object)string);
        }
        if (!(string = properties.getValue("useHiResPrinting")).isEmpty() && string.equals("true")) {
            hiResPrintingCB.setSelected(true);
        } else {
            hiResPrintingCB.setSelected(false);
        }
        string = properties.getValue("defaultPrinter");
        if (string != null && !string.isEmpty()) {
            printerCombo.setValue((Object)string);
        } else {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService != null) {
                printerCombo.setValue((Object)("System Default (" + printService.getName() + ')'));
            } else {
                printerCombo.setValue((Object)"System Default");
            }
        }
        string = properties.getValue("defaultDPI");
        if (string != null && !string.isEmpty()) {
            try {
                string = string.replaceAll("[^0-9]", "");
                defaultDPITF.setText(Integer.parseInt(string) + "dpi");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception attempting Load Printing Settings: " + exception);
            }
        }
        if ((string = properties.getValue("printerBlacklist")) != null && !string.isEmpty()) {
            blackListTF.setText(string);
        }
        int n2 = !(string = properties.getValue("highlightBoxColor")).isEmpty() ? Integer.parseInt(string) : DecoderOptions.highlightColor.getRGB();
        highlightsPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(n2));
        highlightTF = new TextField();
        String string2 = properties.getValue("highlightComposite");
        if (!string2.isEmpty()) {
            highlightTF.setText(string2);
        }
        invertHighlightsCB = new CheckBox(Messages.getMessage("PdfPreferences.InvertHighlight"));
        String string3 = properties.getValue("invertHighlights");
        if (!string3.isEmpty() && string3.equalsIgnoreCase("true")) {
            invertHighlightsCB.setSelected(true);
        } else {
            invertHighlightsCB.setSelected(false);
        }
        string = properties.getValue("vbgColor");
        if (!string.isEmpty()) {
            n2 = Integer.parseInt(string);
        } else if (DecoderOptions.backgroundColor != null) {
            n2 = DecoderOptions.backgroundColor.getRGB();
        }
        pageColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(n2));
        replaceTextColorCB = new CheckBox("Replace Document Text Colors");
        String string4 = properties.getValue("replaceDocumentTextColors");
        if (!string4.isEmpty() && string4.equalsIgnoreCase("true")) {
            replaceTextColorCB.setSelected(true);
        } else {
            replaceTextColorCB.setSelected(false);
        }
        string = properties.getValue("vfgColor");
        if (!string.isEmpty()) {
            n2 = Integer.parseInt(string);
        }
        textColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(n2));
        changeLineArtColorCB = new CheckBox("Change Color of Text and Line Art");
        String string5 = properties.getValue("changeTextAndLineart");
        if (!string5.isEmpty() && string5.equalsIgnoreCase("true")) {
            changeLineArtColorCB.setSelected(true);
        } else {
            changeLineArtColorCB.setSelected(false);
        }
        replaceDisplayCB = new CheckBox("Replace Display Background Color");
        String string6 = properties.getValue("replacePdfDisplayBackground");
        if (!string6.isEmpty() && string6.equalsIgnoreCase("true")) {
            replaceDisplayCB.setSelected(true);
        } else {
            replaceDisplayCB.setSelected(false);
        }
        string = properties.getValue("pdfDisplayBackground");
        if (!string.isEmpty()) {
            n2 = Integer.parseInt(string);
        }
        displayBGColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(n2));
    }

    static {
        borderPane = new BorderPane();
        titleFont = Font.font((String)"SansSerif", (FontWeight)FontWeight.BOLD, (double)14.0);
        title = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        printerCombo = new ComboBox();
        paperSizesCombo = new ComboBox();
    }
}

