/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.examples.viewer.Values;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXSaveFile {
    public static void execute(Object[] objectArray, GUIFactory gUIFactory, Values values) {
        if (objectArray == null) {
            JavaFXSaveFile.saveFile(gUIFactory, values);
        }
    }

    private static void saveFile(GUIFactory gUIFactory, Values values) {
        boolean bl = false;
        while (!bl) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("PDF file (*.pdf)", new String[]{"*.pdf"}), new FileChooser.ExtensionFilter("FDF file (*.fdf)", new String[]{"*.fdf"})});
            String string = new File(values.getSelectedFile()).getName();
            fileChooser.setInitialFileName(string);
            File file = fileChooser.showSaveDialog((Window)((Stage)gUIFactory.getFrame()));
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            if (file != null) {
                int n;
                String string2 = file.getAbsolutePath();
                if (!string2.endsWith(".pdf")) {
                    string2 = string2 + ".pdf";
                    file = new File(string2);
                }
                if (string2.equals(values.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n = gUIFactory.showConfirmDialog(string2 + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int n2;
                    fileInputStream = new FileInputStream(values.getSelectedFile());
                    fileOutputStream = new FileOutputStream(string2);
                    byte[] byArray = new byte[4096];
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (Exception exception) {
                    gUIFactory.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile") + ' ' + exception);
                }
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception attempting to Read File: " + exception);
                }
            }
            bl = true;
        }
    }
}

