/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

public class JavaFXTipOfTheDay {
    private static FXDialog tipOfDayPopup;
    private static final List urls;
    private static final BorderPane border;
    private static WebEngine webEngine;
    private static int currentTip;
    private static final CheckBox show;

    public static void execute(Object[] objectArray, GUIFactory gUIFactory, PropertiesFile propertiesFile) {
        if (objectArray == null) {
            try {
                JavaFXTipOfTheDay.populateTipsList("/org/jpedal/examples/viewer/res/tips");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            JavaFXTipOfTheDay.getTip(propertiesFile);
        }
    }

    private static void getTip(final PropertiesFile propertiesFile) {
        JavaFXTipOfTheDay.setupStage();
        JavaFXTipOfTheDay.bottomButtons();
        String string = propertiesFile.getValue("displaytipsonstartup");
        if (!string.isEmpty()) {
            show.setSelected(string.equals("true"));
        }
        show.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                propertiesFile.setValue("displaytipsonstartup", String.valueOf(show.isSelected()));
            }
        });
        tipOfDayPopup.show();
    }

    private static void setupStage() {
        tipOfDayPopup = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)border, 500.0, 400.0);
        tipOfDayPopup.setTitle("Tip Of The Day");
        HBox hBox = new HBox();
        Label label = new Label("Did you know...?", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/tip.png")));
        hBox.getChildren().addAll((Object[])new Node[]{label});
        hBox.setPadding(new Insets(10.0, 0.0, 20.0, 10.0));
        border.setTop((Node)hBox);
        VBox vBox = new VBox();
        Random random = new Random();
        currentTip = random.nextInt(urls.size());
        WebView webView = new WebView();
        webEngine = webView.getEngine();
        URL uRL = JavaFXTipOfTheDay.class.getResource("/org/jpedal/examples/viewer/res/tips/apps/javabean.html");
        webEngine.load(uRL.toExternalForm());
        vBox.getChildren().addAll((Object[])new Node[]{webView});
        vBox.setAlignment(Pos.CENTER);
        vBox.setPadding(new Insets(0.0, 10.0, 20.0, 10.0));
        border.setCenter((Node)vBox);
    }

    private static void bottomButtons() {
        HBox hBox = new HBox();
        Button button = new Button("Next Tip");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (currentTip < urls.size() - 1) {
                    currentTip++;
                } else {
                    currentTip = 0;
                }
                URL uRL = JavaFXTipOfTheDay.class.getResource(urls.get(currentTip).toString());
                webEngine.load(uRL.toExternalForm());
            }
        });
        Button button2 = new Button("Previous Tip");
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (currentTip < urls.size() && currentTip > 0) {
                    currentTip--;
                } else {
                    currentTip = urls.size() - 1;
                }
                URL uRL = JavaFXTipOfTheDay.class.getResource(urls.get(currentTip).toString());
                webEngine.load(uRL.toExternalForm());
            }
        });
        show.setAlignment(Pos.BOTTOM_LEFT);
        show.setPadding(new Insets(0.0, 0.0, 10.0, 10.0));
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{show, region, button2, button});
        hBox.setAlignment(Pos.BOTTOM_RIGHT);
        hBox.setPadding(new Insets(0.0, 10.0, 10.0, 0.0));
        hBox.setSpacing(10.0);
        border.setBottom((Node)hBox);
    }

    private static void populateTipsList(String string) throws IOException {
        URL uRL = JavaFXTipOfTheDay.class.getResource(string);
        if (uRL.toString().startsWith("jar")) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string2 = jarEntry.getName();
                if (jarEntry.isDirectory() || !string2.contains("/res/tips/") || !string2.endsWith(".html")) continue;
                urls.add('/' + string2);
            }
        } else {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(46) == -1) {
                    JavaFXTipOfTheDay.populateTipsList(string + '/' + string3);
                    continue;
                }
                if (!string3.endsWith(".htm") && !string3.endsWith(".html")) continue;
                urls.add(string + '/' + string3);
            }
            bufferedReader.close();
        }
    }

    static {
        urls = new ArrayList();
        border = new BorderPane();
        show = new CheckBox("Show Tips On Start Up");
    }
}

