/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BaseTransferHandler
extends TransferHandler {
    protected final Commands currentCommands;
    protected final GUIFactory currentGUI;
    protected final Values commonValues;

    public BaseTransferHandler(Values values, GUIFactory gUIFactory, Commands commands) {
        this.commonValues = values;
        this.currentGUI = gUIFactory;
        this.currentCommands = commands;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return true;
    }

    protected Object getImport(Transferable transferable) throws Exception {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        DataFlavor dataFlavor = null;
        int n = dataFlavorArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
            dataFlavor = dataFlavorArray[i];
        }
        try {
            DataFlavor dataFlavor2 = DataFlavor.selectBestTextFlavor(dataFlavorArray);
            if (dataFlavor2 != null) {
                Reader reader = dataFlavor2.getReaderForText(transferable);
                String string = BaseTransferHandler.readTextDate(reader);
                if ((string = BaseTransferHandler.removeChar(string, '\u0000')).contains("ftp:/")) {
                    this.currentGUI.showMessageDialog("Files cannot be opened via FTP");
                    return null;
                }
                string = BaseTransferHandler.getURL(string);
                string = string.replaceAll("%20", " ");
                return string;
            }
            if (dataFlavor != null) {
                return transferable.getTransferData(dataFlavor);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Caught exception decoding transfer:" + exception.getMessage());
            return null;
        }
        return null;
    }

    private static String removeChar(String string, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    private static String getURL(String string) throws ParserConfigurationException, SAXException, IOException {
        if (!string.startsWith("http://") && !string.startsWith("file://")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(StringUtils.toBytes(string)));
            Element element = (Element)document.getElementsByTagName("a").item(0);
            string = BaseTransferHandler.getHrefAttribute(element);
        }
        return string;
    }

    private static String readTextDate(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string);
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private static String getHrefAttribute(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Node node = namedNodeMap.getNamedItem("href");
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }
}

