/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public abstract class GUI
implements GUIFactory {
    public static boolean deletePropertiesOnExit = false;
    public static boolean alwaysShowMouse = false;
    protected static int expandedSize = 190;
    protected static int collapsedSize = 30;
    boolean isJavaFX;
    public static String windowTitle;
    protected RecentDocumentsFactory recent;
    protected CommandListener currentCommandListener;
    protected Commands currentCommands;
    protected CustomMessageHandler customMessageHandler;
    public static boolean showMessages;
    protected GUIMenuItems menuItems;
    protected PdfLayerList layersObject;
    protected boolean finishedDecoding;
    public static final int CURSOR = 1;
    public static final int GRAB_CURSOR = 1;
    public static final int GRABBING_CURSOR = 2;
    public static final int DEFAULT_CURSOR = 3;
    public static final int PAN_CURSOR = 4;
    public static final int PAN_CURSORL = 5;
    public static final int PAN_CURSORTL = 6;
    public static final int PAN_CURSORT = 7;
    public static final int PAN_CURSORTR = 8;
    public static final int PAN_CURSORR = 9;
    public static final int PAN_CURSORBR = 10;
    public static final int PAN_CURSORB = 11;
    public static final int PAN_CURSORBL = 12;
    protected Font textFont = new Font("Serif", 0, 12);
    protected Font headFont = new Font("SansSerif", 1, 14);
    protected boolean previewOnSingleScroll = true;
    protected static final int glowThickness = 11;
    protected final Color glowOuterColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    protected final Color glowInnerColor = new Color(0.8f, 0.75f, 0.45f, 0.8f);
    private boolean commandInThread;
    private boolean executingCommand;
    protected boolean hiResPrinting;
    protected Map objs;
    protected boolean bookmarksGenerated;
    protected GUISearchWindow searchFrame;
    protected String pageTitle;
    protected String bookmarksTitle;
    protected String signaturesTitle;
    protected String layersTitle;
    public static final boolean debugFX = false;
    protected PdfDecoderInt decode_pdf;
    protected static final int minimumScreenWidth = 700;
    private long start = System.currentTimeMillis();
    protected GUIOutline tree;
    protected boolean allowScrolling = true;
    protected boolean confirmClose;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static int inset;
    protected int rotation;
    protected GUICombo rotationBox;
    protected GUICombo qualityBox;
    protected GUICombo scalingBox;
    protected static int defaultSelection;
    protected final Values commonValues;
    protected final GUIThumbnailPanel thumbnails;
    protected final PropertiesFile properties;
    protected String propValue;
    protected String propValue2;

    public GUI(PdfDecoderInt pdfDecoderInt, Values values, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile) {
        this.decode_pdf = pdfDecoderInt;
        this.commonValues = values;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
    }

    public boolean useHiResPrinting() {
        return this.hiResPrinting;
    }

    public void setHiResPrinting(boolean bl) {
        this.hiResPrinting = bl;
    }

    public void setProperties(String string, boolean bl) {
        this.properties.setValue(string, String.valueOf(bl));
    }

    public void setPreferences(int n, int n2, int n3, boolean bl, int n4, boolean bl2, int n5, boolean bl3) {
        this.decode_pdf.setBorderPresent(n3 == 1);
        this.properties.setValue("borderType", String.valueOf(n3));
        this.allowScrolling = bl;
        this.properties.setValue("autoScroll", String.valueOf(bl));
        this.decode_pdf.getDPIFactory().setDpi(n);
        this.properties.setValue("resolution", String.valueOf(n));
        if (n4 < 1 || n4 > 5) {
            n4 = 1;
        }
        this.decode_pdf.setPageMode(n4);
        this.properties.setValue("startView", String.valueOf(n4));
        String string = this.properties.getValue("searchWindowType");
        if (!string.isEmpty() && !string.equals(String.valueOf(n2)) && showMessages) {
            ShowGUIMessage.showGUIMessage(Messages.getMessage("PageLayoutViewMenu.ResetSearch"), null);
        }
        this.properties.setValue("searchWindowType", String.valueOf(n2));
        this.properties.setValue("automaticupdate", String.valueOf(bl2));
        this.commonValues.setMaxMiltiViewers(n5);
        this.properties.setValue("maxmultiviewers", String.valueOf(n5));
        this.hiResPrinting = bl3;
        this.properties.setValue("useHiResPrinting", String.valueOf(bl3));
    }

    @Override
    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    @Override
    public boolean confirmClose() {
        return this.confirmClose;
    }

    @Override
    public void setAutoScrolling(boolean bl) {
        this.allowScrolling = bl;
    }

    @Override
    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public Values getValues() {
        return this.commonValues;
    }

    protected void addCombo(String string, String string2, int n) {
        GUICombo gUICombo = null;
        switch (n) {
            case 250: {
                gUICombo = this.qualityBox;
                break;
            }
            case 252: {
                gUICombo = this.scalingBox;
                break;
            }
            case 251: {
                gUICombo = this.rotationBox;
            }
        }
        gUICombo.setID(n);
        if (!string2.isEmpty()) {
            gUICombo.setToolTipText(string2);
        }
        this.addGUIComboBoxes(gUICombo);
        this.addComboListenerAndLabel(gUICombo, string);
    }

    @Override
    public Map getHotspots() {
        return Collections.unmodifiableMap(this.objs);
    }

    public void setScaling(float f) {
        this.scaling = f;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public static int getPDFDisplayInset() {
        return inset;
    }

    public void createUniqueAnnotationIcons() {
        if (this.objs == null) {
            this.objs = new HashMap();
        } else {
            this.objs.clear();
        }
        ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).handleAnnotations(this.decode_pdf, this.objs, this.commonValues.getCurrentPage());
    }

    public void setDpi(int n) {
        this.decode_pdf.getDPIFactory().setDpi(n);
    }

    @Override
    public void dispose() {
        this.tree = null;
        this.scalingFloatValues = null;
        this.rotationBox = null;
        this.qualityBox = null;
        this.scalingBox = null;
    }

    public void init(Commands commands) {
        this.currentCommandListener = new CommandListener(commands);
        this.customMessageHandler = (CustomMessageHandler)this.decode_pdf.getExternalHandler(15);
        if (this.customMessageHandler != null) {
            DecoderOptions.showErrorMessages = false;
            showMessages = false;
        }
        try {
            String string;
            this.propValue = this.properties.getValue("pageInsets");
            if (!this.propValue.isEmpty()) {
                inset = Integer.parseInt(this.propValue);
            }
            this.propValue = this.properties.getValue("changeTextAndLineart");
            if (!this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true")) {
                commands.executeCommand(713, new Object[]{Boolean.parseBoolean(this.propValue)});
            }
            this.propValue = this.properties.getValue("windowTitle");
            windowTitle = !this.propValue.isEmpty() ? this.propValue : "LGPL PDF JavaFX Viewer 6.6.30";
            this.propValue = this.properties.getValue("vbgColor");
            if (!this.propValue.isEmpty()) {
                commands.executeCommand(709, new Object[]{Integer.parseInt(this.propValue)});
            }
            this.propValue = this.properties.getValue("replaceDocumentTextColors");
            if (!this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true")) {
                this.propValue = this.properties.getValue("vfgColor");
                if (!this.propValue.isEmpty()) {
                    commands.executeCommand(712, new Object[]{Integer.parseInt(this.propValue)});
                }
            }
            this.propValue = this.properties.getValue("TextColorThreshold");
            if (!this.propValue.isEmpty()) {
                commands.executeCommand(715, new Object[]{Integer.parseInt(this.propValue)});
            }
            this.propValue = this.properties.getValue("autoScroll");
            if (!this.propValue.isEmpty()) {
                this.allowScrolling = Boolean.getBoolean(this.propValue);
            }
            this.propValue = this.properties.getValue("confirmClose");
            if (!this.propValue.isEmpty()) {
                this.confirmClose = this.propValue.equals("true");
            }
            this.propValue = this.properties.getValue("resolution");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.getDPIFactory().setDpi(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("startView");
            if (!this.propValue.isEmpty()) {
                int n = Integer.parseInt(this.propValue);
                if (n < 1 || n > 5) {
                    n = 1;
                }
                this.decode_pdf.setPageMode(n);
            }
            this.propValue = this.properties.getValue("maxmuliviewers");
            if (!this.propValue.isEmpty()) {
                this.commonValues.setMaxMiltiViewers(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("useHiResPrinting");
            if (!this.propValue.isEmpty()) {
                this.hiResPrinting = Boolean.valueOf(this.propValue);
            }
            if (!(string = this.properties.getValue("highlightBoxColor")).isEmpty()) {
                DecoderOptions.highlightColor = new Color(Integer.parseInt(string));
            }
            this.propValue = this.properties.getValue("highlightTextColor");
            if (!this.propValue.isEmpty()) {
                DecoderOptions.backgroundColor = new Color(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("showMouseSelectionBox");
            if (!this.propValue.isEmpty()) {
                DecoderOptions.showMouseBox = Boolean.valueOf(this.propValue);
            }
            this.propValue = this.properties.getValue("enhancedViewerMode");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.useNewGraphicsMode(Boolean.valueOf(this.propValue));
            }
            this.propValue = this.properties.getValue("highlightComposite");
            if (!this.propValue.isEmpty()) {
                float f = Float.parseFloat(this.propValue);
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (f < 0.0f) {
                    f = 0.0f;
                }
                DecoderOptions.highlightComposite = f;
            }
            this.propValue = this.properties.getValue("borderType");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.setBorderPresent(Integer.parseInt(this.propValue) == 1);
            }
            this.propValue = this.properties.getValue("allowCursorToChange");
            if (!this.propValue.isEmpty()) {
                GUIDisplay.allowChangeCursor = this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("invertHighlights");
            if (!this.propValue.isEmpty()) {
                BaseDisplay.invertHighlight = Boolean.valueOf(this.propValue);
            }
            this.propValue = this.properties.getValue("enhancedFacingMode");
            if (!this.propValue.isEmpty()) {
                GUIDisplay.default_turnoverOn = Boolean.valueOf(this.propValue);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentCommands = commands;
        this.setViewerTitle(windowTitle);
        this.setViewerIcon();
        this.decode_pdf.setInset(inset, inset);
    }

    @Override
    public boolean isCommandInThread() {
        return this.commandInThread;
    }

    @Override
    public void setCommandInThread(boolean bl) {
        this.commandInThread = bl;
    }

    @Override
    public boolean isExecutingCommand() {
        return this.executingCommand;
    }

    @Override
    public void setExecutingCommand(boolean bl) {
        this.executingCommand = bl;
    }

    protected static void getFlattenedTreeNodes(TreeNode treeNode, List list) {
        list.add(treeNode);
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            GUI.getFlattenedTreeNodes(enumeration.nextElement(), list);
        }
    }

    public int getGlowThickness() {
        return 11;
    }

    public Color getGlowOuterColor() {
        return this.glowOuterColor;
    }

    public Color getGlowInnerColor() {
        return this.glowInnerColor;
    }

    @Override
    public void setSearchFrame(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
    }

    protected void setRotation() {
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (Values.isProcessing() || !Viewer.isFX()) {
            // empty if block
        }
    }

    public int getSelectedComboIndex(int n) {
        switch (n) {
            case 250: {
                return this.qualityBox.getSelectedIndex();
            }
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int n, int n2) {
        switch (n) {
            case 250: {
                this.qualityBox.setSelectedIndex(n2);
                break;
            }
            case 252: {
                this.scalingBox.setSelectedIndex(n2);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(n2);
            }
        }
    }

    public Object getSelectedComboItem(int n) {
        switch (n) {
            case 250: {
                return this.qualityBox.getSelectedItem();
            }
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    public void setSelectedComboItem(int n, String string) {
        switch (n) {
            case 250: {
                this.qualityBox.setSelectedItem(string);
                break;
            }
            case 252: {
                if (StringUtils.isNumber(string)) {
                    string = string + '%';
                }
                this.scalingBox.setSelectedItem(string);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(string);
            }
        }
    }

    public void setPdfDecoder(PdfDecoderInt pdfDecoderInt) {
        this.decode_pdf = pdfDecoderInt;
    }

    public void decodeGUIPage(GUIFactory gUIFactory) {
        FXAdditionalData fXAdditionalData;
        Object object;
        AcroRenderer acroRenderer;
        Object object2;
        Object object3;
        this.decode_pdf.getPages().setHighlightedImage(null);
        gUIFactory.resetRotationBox();
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
        }
        if (this.thumbnails.isShownOnscreen() && ((object3 = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978)) == null || object3 != null && !((Thread)object3).isAlive())) {
            gUIFactory.setupThumbnailPanel();
        }
        if (this.decode_pdf.getDisplayView() == 1) {
            gUIFactory.setPageCounterText(PageCounter.PAGECOUNTER2, String.valueOf(this.commonValues.getCurrentPage()));
            gUIFactory.setPageCounterText(PageCounter.PAGECOUNTER3, Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
        }
        gUIFactory.updateTextBoxSize();
        gUIFactory.setTabsNotInitialised(false);
        this.decode_pdf.setExtractionMode(65);
        this.decode_pdf.getTextLines().clearHighlights();
        if (this.decode_pdf.getDisplayView() == 4) {
            gUIFactory.scaleAndRotate();
            gUIFactory.scrollToPage(this.commonValues.getCurrentPage());
            this.decode_pdf.getPages().decodeOtherPages(this.commonValues.getCurrentPage(), this.commonValues.getPageCount());
            return;
        }
        if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 3) {
            gUIFactory.scaleAndRotate();
            gUIFactory.scrollToPage(this.commonValues.getCurrentPage());
            if (!Viewer.isFX()) {
                return;
            }
        } else if (this.decode_pdf.getDisplayView() == 5) {
            return;
        }
        gUIFactory.resetComboBoxes(false);
        gUIFactory.getButtons().setPageLayoutButtonsEnabled(false);
        Values.setProcessing(true);
        try {
            if (!Viewer.isFX()) {
                ((StatusBar)gUIFactory.getStatusBar()).updateStatus("Decoding Page", 0);
            }
            try {
                this.decode_pdf.decodePage(this.commonValues.getCurrentPage());
                this.decode_pdf.waitForDecodingToFinish();
                if (this.decode_pdf.getPageDecodeStatus(64)) {
                    gUIFactory.showMessageDialog("Too many shapes on page");
                }
                if (!this.decode_pdf.getPageDecodeStatus(2)) {
                    object3 = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                    gUIFactory.showMessageDialog((String)object3);
                }
                if (this.decode_pdf.getPageDecodeStatus(32)) {
                    object3 = Messages.getMessage("PdfCustomGui.ttHintingRequired");
                    gUIFactory.showMessageDialog((String)object3);
                }
                if (this.decode_pdf.getPageDecodeStatus(4)) {
                    object3 = "This page contains non-embedded CID fonts \n" + this.decode_pdf.getPageDecodeStatusReport(4) + "\nwhich may need mapping to display correctly.\n" + "See http://www.idrsolutions.com/how-do-fonts-work";
                    gUIFactory.showMessageDialog((String)object3);
                }
                if (this.decode_pdf.getExternalHandler(25) != null) {
                    object3 = this.decode_pdf.getFormRenderer().getFormFactory();
                    if (object3.getType() == 1) {
                        object2 = new Runnable(){

                            @Override
                            public void run() {
                                GUI.this.createUniqueAnnotationIcons();
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object2);
                    } else {
                        this.createUniqueAnnotationIcons();
                    }
                }
                if (!Viewer.isFX()) {
                    ((StatusBar)gUIFactory.getStatusBar()).updateStatus("Displaying Page", 0);
                }
            }
            catch (Exception exception) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                exception.printStackTrace();
                Values.setProcessing(false);
            }
            if (DecoderOptions.showErrorMessages && ((String)(object3 = this.decode_pdf.getPageDecodeReport())).contains("java.lang.OutOfMemoryError")) {
                object3 = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                gUIFactory.showMessageDialog((String)object3);
            }
            Values.setProcessing(false);
            gUIFactory.setViewerTitle(null);
            OpenFile.setPageProperties(this.getSelectedComboItem(251), this.getSelectedComboItem(252));
            if (LogWriter.isRunningFromIDE) {
                System.out.println((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L + "K");
                System.out.println((float)Math.abs((System.currentTimeMillis() - this.start) / 100L) / 10.0f + "s");
            }
            if (this.decode_pdf.getPageCount() > 0 && this.thumbnails.isShownOnscreen() && this.decode_pdf.getDisplayView() == 1) {
                this.thumbnails.generateOtherVisibleThumbnails(this.commonValues.getCurrentPage());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Values.setProcessing(false);
            gUIFactory.setViewerTitle(null);
        }
        gUIFactory.selectBookmark();
        if (!Viewer.isFX()) {
            ((StatusBar)gUIFactory.getStatusBar()).setProgress(100);
        }
        gUIFactory.setMultibox(new int[0]);
        gUIFactory.resetComboBoxes(true);
        if (this.decode_pdf.getPageCount() > 1) {
            gUIFactory.getButtons().setPageLayoutButtonsEnabled(true);
        }
        this.commonValues.setFormsChanged(false);
        boolean bl = false;
        object2 = System.getProperty("org.jpedal.listenforms");
        if (object2 != null) {
            bl = true;
        }
        if ((acroRenderer = this.decode_pdf.getFormRenderer()) == null) {
            return;
        }
        Object[] objectArray = acroRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, this.commonValues.getCurrentPage());
        if (objectArray == null) {
            if (bl) {
                gUIFactory.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
            }
            return;
        }
        if (bl) {
            int n = objectArray.length;
            object = new JPanel();
            ((Container)object).setLayout(new BoxLayout((Container)object, 1));
            JLabel jLabel = new JLabel("This page contains " + n + " form objects");
            jLabel.setFont(this.headFont);
            ((Container)object).add(jLabel);
            ((Container)object).add(Box.createRigidArea(new Dimension(10, 10)));
            JTextPane jTextPane = new JTextPane();
            jTextPane.setPreferredSize(new Dimension(450, 180));
            jTextPane.setEditable(false);
            jTextPane.setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.viewer.Viewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            jTextPane.setFont(this.textFont);
            ((Container)object).add(jTextPane);
            ((Container)object).add(Box.createRigidArea(new Dimension(10, 10)));
            final JDialog jDialog = new JDialog((Frame)null, true);
            jDialog.setDefaultCloseOperation(2);
            if (this.commonValues.getModeOfOperation() != 1) {
                jDialog.setLocationRelativeTo(null);
                jDialog.setLocation(((Container)gUIFactory.getFrame()).getLocationOnScreen().x + 10, ((Container)gUIFactory.getFrame()).getLocationOnScreen().y + 10);
            }
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add((Component)object);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jDialog.setSize(500, 500);
            jDialog.setTitle("List of forms on this page");
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jPanel, "South");
            JButton jButton = new JButton(Messages.getMessage("PdfViewerButton.Close"));
            jButton.setFont(new Font("SansSerif", 0, 12));
            jPanel.add((Component)jButton, "East");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.setVisible(true);
        }
        if (this.isJavaFX && (fXAdditionalData = (FXAdditionalData)this.decode_pdf.getExternalHandler(33)) != null) {
            object = this.decode_pdf.getDynamicRenderer();
            try {
                object.drawAdditionalObjectsOverPage(fXAdditionalData.getType(), null, fXAdditionalData.getObj());
            }
            catch (PdfException pdfException) {
                LogWriter.writeLog("Exception attempting to draw additional objects " + pdfException);
            }
        }
        if (gUIFactory.getFrame() != null) {
            gUIFactory.reinitialiseTabs(gUIFactory.getDividerLocation() > gUIFactory.getStartSize());
        }
        this.finishedDecoding = true;
        gUIFactory.scaleAndRotate();
    }

    @Override
    public void setViewerTitle(String string) {
        if (string == null) {
            string = windowTitle + ' ' + this.commonValues.getSelectedFile();
            PdfObject pdfObject = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
            if (pdfObject != null) {
                LinearThread linearThread = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978);
                string = linearThread != null && linearThread.isAlive() ? string + " (still loading)" : string + " (Linearized)";
            }
            if (this.commonValues.isFormsChanged()) {
                string = "* " + string;
            }
        }
        this.setTitle(string);
    }

    protected void setTitle(String string) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setViewerIcon() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void addComboListenerAndLabel(GUICombo gUICombo, String string) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void addGUIComboBoxes(GUICombo gUICombo) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupCenterPanelBackground() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupComboBoxes() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupKeyboardControl() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupPDFDisplayPane() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupBorderPanes() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createOtherToolBars() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupBottomToolBarItems() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupPDFBorder() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createTopMenuBar() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createMainViewerWindow(int n, int n2) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupSidebarTitles() {
        this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
        this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
        this.layersTitle = Messages.getMessage("PdfViewerJPanel.layers");
        this.signaturesTitle = Messages.getMessage("PdfViewerJPanel.signatures");
    }

    static {
        showMessages = true;
        inset = 25;
    }

    public static enum PageCounter {
        PAGECOUNTER1,
        PAGECOUNTER2,
        PAGECOUNTER3,
        ALL;

    }

    public static enum ScrollPolicy {
        VERTICAL_AS_NEEDED,
        HORIZONTAL_AS_NEEDED,
        VERTICAL_NEVER,
        HORIZONTAL_NEVER;

    }
}

