/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import org.jpedal.DevFlags;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoderFX;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.GUIModes;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.javafx.SingleDisplayFX;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.JavaFXRecentDocuments;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.javafx.JavaFXOpenFile;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.GUIModifier;
import org.jpedal.examples.viewer.gui.PageMoveTracker;
import org.jpedal.examples.viewer.gui.SwingCursor;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.javafx.FXProgressBarWithText;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButtons;
import org.jpedal.examples.viewer.gui.javafx.JavaFXCombo;
import org.jpedal.examples.viewer.gui.javafx.JavaFXLayersPanel;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseListener;
import org.jpedal.examples.viewer.gui.javafx.JavaFXOutline;
import org.jpedal.examples.viewer.gui.javafx.JavaFXPageChanger;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSignaturesPanel;
import org.jpedal.examples.viewer.gui.javafx.JavaFXThumbnailPanel;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXInputDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXOptionDialog;
import org.jpedal.examples.viewer.gui.popups.PrintPanelFX;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.StatusBarFX;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Document;

public class JavaFxGUI
extends GUI
implements GUIFactory {
    private RefreshLayout viewListener;
    private static final int bottomPaneHeight = 40;
    protected final JavaFXButtons fxButtons;
    private final SwingCursor guiCursor = new SwingCursor();
    private GUIMouseHandler mouseHandler;
    protected Timeline memoryMonitor;
    private boolean debugThumbnail;
    private boolean sideTabBarOpenByDefault;
    private String startSelectedTab = "Pages";
    public static String windowTitle;
    private boolean hasListener;
    private boolean isSetup;
    private int lastTabSelected = -1;
    private boolean tabsExpanded;
    private PaperSizes paperSizes;
    protected HBox multiboxfx;
    protected FXProgressBarWithText memoryBarFX;
    protected TextField coordsFX;
    private static final boolean pageTurnScalingAppropriate = true;
    protected HBox navButtons;
    private TabPane navOptionsPanel;
    private static final boolean firstTimeFormMessage = true;
    private boolean isSingle = true;
    private Label pageCounter1;
    public TextField pageCounter2;
    private Label pageCounter3;
    private final JavaFXSignaturesPanel signaturesPanel;
    private final JavaFXLayersPanel layersPanel;
    private boolean tabsNotInitialised = true;
    private boolean hasPageChanged;
    private ToolBar navToolBar;
    protected ToolBar pagesToolBar;
    private final Stage stage;
    private Scene scene;
    private final BorderPane root;
    private static final int dropshadowDepth = 40;
    private Group group;
    private ScrollPane pageContainer;
    private SplitPane center;
    protected final VBox topPane;
    protected StatusBarFX downloadBar;
    private boolean searchInMenu;
    private TextField searchText;
    private GUISearchList results;
    private MenuBar options;
    private boolean cursorOverPage;
    private PrintPanelFX printPanel;
    private FXViewerTransitions.TransitionType transitionType = FXViewerTransitions.TransitionType.None;
    private ScrollBar pageScroll;
    private ChangeListener<Bounds> fxChangeListener;

    public JavaFxGUI(Stage stage, PdfDecoderInt pdfDecoderInt, Values values, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile) {
        super(pdfDecoderInt, values, gUIThumbnailPanel, propertiesFile);
        this.isJavaFX = true;
        this.stage = stage;
        this.root = new BorderPane();
        this.topPane = new VBox();
        this.pageCounter2 = new TextField();
        this.navButtons = new HBox();
        this.fxButtons = new JavaFXButtons();
        this.pageCounter3 = new Label();
        this.navToolBar = new ToolBar();
        this.pagesToolBar = new ToolBar();
        this.tree = new JavaFXOutline();
        this.layersPanel = new JavaFXLayersPanel();
        this.signaturesPanel = new JavaFXSignaturesPanel();
        this.setLookAndFeel();
        this.setupDisplay();
    }

    @Override
    public Object getThumbnailScrollBar() {
        return this.pageScroll;
    }

    @Override
    public void setThumbnailScrollBarVisibility(boolean bl) {
        this.pageScroll.setVisible(bl);
        if (bl) {
            this.pageScroll.setStyle("-fx-padding:0px");
        } else {
            this.pageScroll.setStyle("-fx-padding:-10px");
        }
    }

    @Override
    public void setThumbnailScrollBarValue(int n) {
        this.pageScroll.setValue((double)n);
    }

    private void setLookAndFeel() {
        this.root.getStylesheets().clear();
        this.root.getStylesheets().add((Object)this.getClass().getResource("/org/jpedal/examples/viewer/res/css/JavaFXForms.css").toExternalForm());
        this.root.getStylesheets().add((Object)this.getClass().getResource("/org/jpedal/examples/viewer/res/css/JavaFXPages.css").toExternalForm());
    }

    private void setupDisplay() {
        this.setDisplayView(1, 2);
        this.decode_pdf.addExternalHandler(this, 11);
        this.menuItems = new JavaFXMenuItems(this.properties);
    }

    public SplitPane getDisplayPane() {
        return this.center;
    }

    @Override
    public Object getMultiViewerFrames() {
        return null;
    }

    @Override
    public String getPropertiesFileLocation() {
        return this.properties.getConfigFile();
    }

    @Override
    public String getBookmark(String string) {
        return this.tree.getPage(string);
    }

    @Override
    public void reinitialiseTabs(boolean bl) {
        if (this.commonValues.getModeOfOperation() == 4) {
            return;
        }
        if (this.properties.getValue("ShowSidetabbar").equalsIgnoreCase("true")) {
            if (!this.isSingle) {
                return;
            }
            if (!bl && !this.properties.getValue("consistentTabBar").equalsIgnoreCase("true")) {
                if (this.sideTabBarOpenByDefault) {
                    this.setSplitDividerLocation(expandedSize);
                    this.tabsExpanded = true;
                } else {
                    this.setSplitDividerLocation(collapsedSize);
                    this.tabsExpanded = false;
                }
            }
            this.lastTabSelected = -1;
            if (!this.commonValues.isPDF()) {
                this.navOptionsPanel.setVisible(false);
            } else {
                int n;
                int n2;
                this.navOptionsPanel.setVisible(true);
                if (!this.decode_pdf.hasOutline()) {
                    n2 = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (n = 0; n < this.navOptionsPanel.getTabs().size(); ++n) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(n)).getText().equals(this.bookmarksTitle)) continue;
                            n2 = n;
                        }
                    } else {
                        for (n = 0; n < this.navOptionsPanel.getTabs().size(); ++n) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(n)).getText().equals(this.bookmarksTitle)) continue;
                            n2 = n;
                        }
                    }
                    if (n2 != -1) {
                        this.navOptionsPanel.getTabs().remove(n2);
                    }
                } else if (this.properties.getValue("Bookmarkstab").equalsIgnoreCase("true")) {
                    n2 = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (n = 0; n < this.navOptionsPanel.getTabs().size(); ++n) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(n)).getText().equals(this.bookmarksTitle)) continue;
                            n2 = n;
                        }
                        if (n2 == -1) {
                            this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)((JavaFXOutline)this.tree));
                        }
                    } else {
                        for (n = 0; n < this.navOptionsPanel.getTabs().size(); ++n) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(n)).getText().equals(this.bookmarksTitle)) continue;
                            n2 = n;
                        }
                        if (n2 == -1) {
                            this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)((JavaFXOutline)this.tree));
                        }
                    }
                }
                AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
                Iterator<FormObject> iterator = null;
                if (acroRenderer != null) {
                    iterator = acroRenderer.getSignatureObjects();
                }
                if (iterator != null) {
                    this.signaturesPanel.reinitialise(this.decode_pdf, iterator);
                    this.checkTabShown(this.signaturesTitle);
                } else {
                    this.removeTab(this.signaturesTitle);
                }
                this.layersObject = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
                if (this.layersObject != null && this.layersObject.getLayersCount() > 0) {
                    this.checkTabShown(this.layersTitle);
                    this.layersPanel.reinitialise(this.layersObject, this.decode_pdf, null, this.commonValues.getCurrentPage());
                } else {
                    this.removeTab(this.layersTitle);
                }
                this.setBookmarks(false);
            }
            if (this.tabsNotInitialised) {
                for (int i = 0; i != this.navOptionsPanel.getTabs().size(); ++i) {
                    if (DecoderOptions.isRunningOnMac) {
                        if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(this.startSelectedTab)) continue;
                        this.navOptionsPanel.getSelectionModel().select(i);
                        break;
                    }
                    if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getGraphic().toString().equals(this.startSelectedTab)) continue;
                    this.navOptionsPanel.getSelectionModel().select(i);
                    break;
                }
            }
        }
    }

    private void checkTabShown(String string) {
        int n = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int i = 0; i < this.navOptionsPanel.getTabs().size(); ++i) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(string)) continue;
                n = i;
            }
            if (n == -1) {
                if (string.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.signaturesPanel);
                } else if (string.equals(this.layersTitle) && this.properties.getValue("Layerstab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.layersPanel);
                }
            }
        } else {
            for (int i = 0; i < this.navOptionsPanel.getTabs().size(); ++i) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(string)) continue;
                n = i;
            }
            if (n == -1) {
                if (string.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.signaturesPanel);
                } else if (string.equals(this.layersTitle) && this.properties.getValue("Layerstab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.layersPanel);
                }
            }
        }
    }

    private void removeTab(String string) {
        int n = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int i = 0; i < this.navOptionsPanel.getTabs().size(); ++i) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(string)) continue;
                n = i;
            }
        } else {
            for (int i = 0; i < this.navOptionsPanel.getTabs().size(); ++i) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(string)) continue;
                n = i;
            }
        }
        if (n != -1) {
            this.navOptionsPanel.getTabs().remove(n);
        }
    }

    @Override
    public void stopThumbnails() {
        if (!this.isSingle) {
            return;
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    @Override
    public void reinitThumbnails() {
        this.isSetup = false;
    }

    @Override
    public void resetNavBar() {
        if (!this.isSingle) {
            return;
        }
        if (!this.properties.getValue("consistentTabBar").equalsIgnoreCase("true")) {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.tabsNotInitialised = true;
        }
        this.fxButtons.setPageLayoutButtonsEnabled(false);
    }

    @Override
    public void setNoPagesDecoded() {
        this.bookmarksGenerated = false;
        this.resetNavBar();
    }

    @Override
    public void setDisplayMode(Integer n) {
        if (n.equals(GUIFactory.MULTIPAGE)) {
            this.isSingle = false;
        }
    }

    @Override
    public boolean isSingle() {
        return this.isSingle;
    }

    @Override
    public Object getThumbnailPanel() {
        return this.thumbnails;
    }

    @Override
    public Object getOutlinePanel() {
        return this.tree;
    }

    @Override
    public Object getVerticalScrollBar() {
        if (this.pageScroll.isVisible()) {
            return this.pageScroll;
        }
        return null;
    }

    @Override
    public void setRootContainer(Object object) {
        String string;
        if (object == null) {
            throw new RuntimeException("Null containers not allowed.");
        }
        Parent parent = (Parent)object;
        if (parent instanceof Pane) {
            ((Pane)parent).getChildren().add((Object)this.root);
        } else if (parent instanceof ScrollPane) {
            ((ScrollPane)parent).setContent((Node)this.root);
        }
        int n = Integer.parseInt(this.properties.getValue("startViewerWidth"));
        int n2 = Integer.parseInt(this.properties.getValue("startViewerHeight"));
        Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
        if (n < 0) {
            n = (int)(rectangle2D.getWidth() / 2.0);
            if (n < 700) {
                n = 700;
            }
            this.properties.setValue("startViewerWidth", String.valueOf(n));
        }
        if (n2 < 0) {
            n2 = (int)(rectangle2D.getHeight() / 2.0);
            this.properties.setValue("startViewerHeight", String.valueOf(n2));
        }
        if ((string = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
            System.out.println(stringTokenizer.countTokens());
            if (stringTokenizer.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + string + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
        }
    }

    @Override
    public void resetRotationBox() {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!Values.isProcessing()) {
            // empty if block
        }
    }

    @Override
    public PropertiesFile getProperties() {
        return this.properties;
    }

    @Override
    public void searchInTab(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        this.searchFrame.init(this.decode_pdf, this.commonValues);
        if (!DecoderOptions.isRunningOnMac || this.thumbnails.isShownOnscreen()) {
            // empty if block
        }
    }

    private MenuBar createMenuBarSearchOptions() {
        final CheckMenuItem checkMenuItem = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.WholeWords"));
        final CheckMenuItem checkMenuItem2 = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.CaseSense"));
        final CheckMenuItem checkMenuItem3 = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.MultiLine"));
        checkMenuItem.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                JavaFxGUI.this.searchFrame.setWholeWords(checkMenuItem.isSelected());
            }
        });
        checkMenuItem2.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                JavaFxGUI.this.searchFrame.setCaseSensitive(checkMenuItem2.isSelected());
            }
        });
        checkMenuItem3.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue observableValue, Boolean bl, Boolean bl2) {
                JavaFxGUI.this.searchFrame.setMultiLine(checkMenuItem3.isSelected());
            }
        });
        Menu menu = new Menu();
        Image image = new Image(this.guiCursor.getURLForImage("menuSearchOptions.png").toString());
        menu.setGraphic((Node)new ImageView(image));
        menu.getItems().addAll((Object[])new MenuItem[]{checkMenuItem, checkMenuItem2, checkMenuItem3});
        this.options = new MenuBar();
        this.options.setBackground(Background.EMPTY);
        this.options.setFocusTraversable(false);
        this.options.setTooltip(new Tooltip(Messages.getMessage("PdfViewerSearch.Options")));
        this.options.getMenus().add((Object)menu);
        return this.options;
    }

    private void searchInMenu(GUISearchWindow gUISearchWindow) {
        this.searchFrame = gUISearchWindow;
        this.searchInMenu = true;
        gUISearchWindow.find(this.decode_pdf, this.commonValues);
        this.fxButtons.getTopButtons().getItems().add((Object)this.searchText);
        this.fxButtons.getTopButtons().getItems().add((Object)this.createMenuBarSearchOptions());
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Previous"), "search_previous.gif", 18, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Next"), "search_next.gif", 19, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.getButton(19).setEnabled(false);
        this.fxButtons.getButton(18).setEnabled(false);
        this.fxButtons.getButton(19).setVisible(true);
        this.fxButtons.getButton(18).setVisible(true);
    }

    @Override
    public void setPropertiesFileLocation(String string) {
        this.properties.loadProperties(string);
    }

    @Override
    public Commands getCommand() {
        return this.currentCommands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(Commands commands, Object object) {
        this.updateTransitionType();
        this.mouseHandler = new JavaFXMouseListener((PdfDecoderFX)this.decode_pdf, this, this.commonValues, commands);
        this.mouseHandler.setupMouse();
        super.init(commands);
        try {
            this.propValue = this.properties.getValue("useHinting");
            this.propValue2 = System.getProperty("org.jpedal.useTTFontHinting");
            if (this.propValue2 != null) {
                if (!this.propValue.isEmpty() && !this.propValue2.equalsIgnoreCase(this.propValue.toLowerCase())) {
                    this.showMessageDialog(Messages.getMessage("PdfCustomGui.hintingFlagFileConflict"));
                }
                TTGlyph.useHinting = this.propValue2.equalsIgnoreCase("true");
            } else {
                TTGlyph.useHinting = !this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("iconLocation");
            if (this.propValue.isEmpty()) {
                // empty if block
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setupComboBoxes();
        if (LogWriter.isRunningFromIDE) {
            this.nameElements();
        }
        this.fxButtons.init(this.isSingle);
        this.createTopMenuBar();
        this.createOtherToolBars();
        this.setupBottomToolBarItems();
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "open.gif", 10, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "print.gif", 6, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.searchFrame != null && (this.searchFrame.getViewStyle() == 0 || this.searchFrame.getViewStyle() == 2 && !this.isSingle)) {
            this.searchFrame.setViewStyle(0);
            this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "find.gif", 12, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "properties.gif", 9, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), "about.gif", 1, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "snapshot.gif", 13, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        Separator separator = new Separator();
        separator.setPrefSize(5.0, 32.0);
        this.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.mouseMode"), "mouse_select.png", 29, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.getTopButtons().getItems().add((Object)separator);
        this.initMultiBox();
        this.createNavbar();
        if (this.searchFrame != null && this.searchFrame.getViewStyle() == 2 && this.isSingle) {
            this.searchInMenu(this.searchFrame);
        }
        this.initStatus();
        if (this.commonValues.getModeOfOperation() != 1) {
            String string;
            int n = Integer.parseInt(this.properties.getValue("startViewerWidth"));
            int n2 = Integer.parseInt(this.properties.getValue("startViewerHeight"));
            Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
            if (n < 0) {
                n = (int)rectangle2D.getWidth() / 2;
                if (n < 700) {
                    n = 700;
                }
                this.properties.setValue("startViewerWidth", String.valueOf(n));
            }
            if (n2 < 0) {
                n2 = (int)rectangle2D.getHeight() / 2;
                this.properties.setValue("startViewerHeight", String.valueOf(n2));
            }
            if ((string = System.getProperty("org.jpedal.startWindowSize")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
                System.out.println(stringTokenizer.countTokens());
                if (stringTokenizer.countTokens() != 2) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + string + "\nValue should be in format org.jpedal.startWindowSize=200x300");
                }
                try {
                    n = Integer.parseInt(stringTokenizer.nextToken().trim());
                    n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + string + "\nValue should be in format org.jpedal.startWindowSize=200x300 " + exception);
                }
            }
            this.setupPDFDisplayPane(n, n2);
            this.setupBorderPanes();
            this.createMainViewerWindow(n, n2);
        }
        this.setupCenterPanelBackground();
        this.setupPDFBorder();
        if (this.sideTabBarOpenByDefault) {
            this.setSplitDividerLocation(expandedSize);
            this.tabsExpanded = true;
        } else {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
        }
        try {
            GUIModifier.load(this.properties, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((JavaFXMenuItems)this.menuItems).disableUnimplementedItems(-10, false);
        this.fxButtons.disableUnimplementedItems(-10);
    }

    private void nameElements() {
        ((JavaFXMenuItems)this.menuItems).getCurrentMenuFX().setId("menuBar");
        this.pageCounter2.setId("pageCounter");
        if (DevFlags.GUITESTINGINPROGRESS) {
            this.rotationBox.setName("rotationBox");
            this.scalingBox.setName("scalingBox");
        }
    }

    @Override
    protected void createOtherToolBars() {
        this.menuItems.createMainMenu(true, this.currentCommandListener, this.isSingle, this.commonValues, this.currentCommands, this.fxButtons);
        this.topPane.getChildren().add((Object)((JavaFXMenuItems)this.menuItems).getCurrentMenuFX());
        this.topPane.getChildren().add((Object)this.fxButtons.getTopButtons());
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int n = this.navOptionsPanel.getSelectionModel().getSelectedIndex();
        if (n == -1) {
            return;
        }
        if (!this.tabsExpanded) {
            String string = ((Tab)this.navOptionsPanel.getTabs().get(n)).getText();
            if (string != null && string.equals(this.pageTitle)) {
                this.thumbnails.setIsDisplayedOnscreen(true);
            } else {
                this.thumbnails.setIsDisplayedOnscreen(false);
            }
            if (!((Tab)this.navOptionsPanel.getSelectionModel().getSelectedItem()).isDisable()) {
                this.setSplitDividerLocation(expandedSize);
                this.tabsExpanded = true;
            }
        } else if (this.lastTabSelected == n && !this.hasPageChanged) {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.thumbnails.setIsDisplayedOnscreen(false);
        }
        this.lastTabSelected = n;
        this.hasPageChanged = false;
    }

    private void initMultiBox() {
        this.multiboxfx = new HBox();
        this.initCoordBox();
        this.initMemoryBar();
        this.initDownloadBar();
    }

    @Override
    public void setMultibox(int[] nArray) {
        if (GUI.alwaysShowMouse) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.coordsFX);
            return;
        }
        if (nArray.length > 1 && nArray[0] == 1) {
            if (this.cursorOverPage != (nArray[1] == 1)) {
                this.cursorOverPage = nArray[1] == 1;
            } else {
                return;
            }
        }
        if (this.cursorOverPage && this.decode_pdf.isOpen()) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.coordsFX);
            return;
        }
        if (!(this.downloadBar.isDisable() || !this.downloadBar.isVisible() || this.downloadBar.isDone() || !this.decode_pdf.isLoadingLinearizedPDF() && this.decode_pdf.isOpen())) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.downloadBar.getStatusObject());
            return;
        }
        if (this.memoryBarFX.isVisible()) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.memoryBarFX);
        }
    }

    private void initDownloadBar() {
        this.downloadBar = new StatusBarFX(new Color(0.7254901960784313, 0.8196078431372549, 0.0, 1.0));
        this.downloadBar.getStatusObject().prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.downloadBar.getStatusObject().prefWidthProperty().bind((ObservableValue)this.multiboxfx.widthProperty());
        this.downloadBar.setVisible(false);
    }

    private void initMemoryBar() {
        this.memoryBarFX = new FXProgressBarWithText();
        this.memoryBarFX.prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.memoryBarFX.prefWidthProperty().bind((ObservableValue)this.multiboxfx.widthProperty());
        if (this.memoryMonitor == null) {
            this.memoryMonitor = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    final int n = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                    final int n2 = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                    final double d = (double)(n2 - n) / (double)n2;
                    if (JavaFxGUI.this.finishedDecoding) {
                        JavaFxGUI.this.finishedDecoding = false;
                    }
                    if (Platform.isFxApplicationThread()) {
                        JavaFxGUI.this.memoryBarFX.setProgress(d);
                        JavaFxGUI.this.memoryBarFX.setText(n2 - n + "M of " + n2 + 'M');
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JavaFxGUI.this.memoryBarFX.setProgress(d);
                                JavaFxGUI.this.memoryBarFX.setText(n2 - n + "M of " + n2 + 'M');
                            }
                        });
                    }
                }
            }, new KeyValue[0])});
            this.memoryMonitor.setCycleCount(-1);
            this.memoryMonitor.play();
        }
    }

    @Override
    protected void setViewerIcon() {
        URL uRL = this.guiCursor.getURLForImage("icon.png");
        if (this.stage != null && uRL != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(uRL);
                WritableImage writableImage = new WritableImage(bufferedImage.getWidth(), bufferedImage.getHeight());
                writableImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, (WritableImage)writableImage);
                this.stage.getIcons().add((Object)writableImage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception attempting to set Icon " + exception);
            }
        }
    }

    private boolean setDisplayView2(int n, int n2) {
        DynamicVectorRenderer dynamicVectorRenderer;
        boolean bl;
        DecoderOptions decoderOptions = this.decode_pdf.getDecoderOptions();
        Display display = this.decode_pdf.getPages();
        int n3 = this.decode_pdf.getDisplayView();
        FileAccess fileAccess = (FileAccess)this.decode_pdf.getExternalHandler(35);
        int n4 = this.decode_pdf.getPageNumber();
        ExternalHandlers externalHandlers = this.decode_pdf.getExternalHandler();
        PdfDecoderFX pdfDecoderFX = (PdfDecoderFX)this.decode_pdf;
        final Pane pane = pdfDecoderFX.highlightsPane;
        decoderOptions.setPageAlignment(n2);
        if (display != null) {
            display.stopGeneratingPage();
        }
        if (Platform.isFxApplicationThread()) {
            if (pane != null && pane.getParent() != null) {
                ((Group)pane.getParent()).getChildren().remove((Object)pane);
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (pane != null && pane.getParent() != null) {
                        ((Group)pane.getParent()).getChildren().remove((Object)pane);
                    }
                }
            };
            Platform.runLater((Runnable)runnable);
        }
        boolean bl2 = bl = n != 1 || n3 != 1;
        if (bl && (n3 == 4 || n == 4)) {
            bl = false;
        }
        boolean bl3 = n != n3;
        decoderOptions.setDisplayView(n);
        if (n3 != n && n3 == 5) {
            display.dispose();
        }
        Object object = externalHandlers.getExternalHandler(4);
        switch (n) {
            case 1: {
                if (display != null && !bl3) break;
                dynamicVectorRenderer = this.decode_pdf.getDynamicRenderer();
                display = new SingleDisplayFX(n4, dynamicVectorRenderer, pdfDecoderFX, decoderOptions);
                break;
            }
        }
        if (n3 != 5 || n != 5) {
            // empty if block
        }
        if (fileAccess.getOffset() == null) {
            fileAccess.setOffset(new PageOffsets(this.decode_pdf.getPageCount(), this.decode_pdf.getPdfPageData()));
        }
        display.setup(decoderOptions.useHardwareAcceleration(), fileAccess.getOffset());
        dynamicVectorRenderer = this.decode_pdf.getDynamicRenderer();
        if (this.decode_pdf.isOpen()) {
            display.init(this.scaling, this.decode_pdf.getDisplayRotation(), n4, dynamicVectorRenderer, true);
        }
        display.forceRedraw();
        display.refreshDisplay();
        pdfDecoderFX.pages = display;
        return bl3;
    }

    @Override
    public void setDisplayView(int n, int n2) {
        if (this.viewListener != null) {
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        boolean bl = this.setDisplayView2(n, n2);
        int n3 = this.decode_pdf.getPageNumber();
        if (n3 > 0) {
            if (bl && n == 1 && this.decode_pdf.isOpen()) {
                try {
                    this.decode_pdf.getPages().getYCordForPage(n3, this.scaling);
                    this.decode_pdf.setPageParameters(this.scaling, n3, this.decode_pdf.getDisplayRotation());
                    this.decode_pdf.decodePage(n3);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            } else if (n == 2 || n == 3) {
                try {
                    this.decode_pdf.getPages().getYCordForPage(n3, this.scaling);
                    this.decode_pdf.setPageParameters(this.scaling, n3, this.decode_pdf.getDisplayRotation());
                    this.decode_pdf.decodePage(n3);
                    this.scrollToPage(n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (n != 1 && n != 2 && n != 3) {
            this.enableSearchItems(false);
        } else {
            this.enableSearchItems(true);
        }
        if (this.viewListener == null) {
            this.viewListener = new RefreshLayout(this.decode_pdf);
            this.addComponentListener(this.viewListener);
        }
    }

    @Override
    protected void setTitle(String string) {
        if (this.stage != null) {
            this.stage.setTitle(string);
        }
    }

    @Override
    public void resetComboBoxes(boolean bl) {
        if (this.properties.getValue("Imageopdisplay").equalsIgnoreCase("true")) {
            this.qualityBox.setEnabled(bl);
        }
        this.scalingBox.setEnabled(bl);
        this.rotationBox.setEnabled(bl);
    }

    @Override
    public GUICombo getCombo(int n) {
        switch (n) {
            case 250: {
                return this.qualityBox;
            }
            case 252: {
                return this.scalingBox;
            }
            case 251: {
                return this.rotationBox;
            }
        }
        return null;
    }

    @Override
    public void scaleAndRotate() {
        if (this.decode_pdf.getDisplayView() == 5) {
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            return;
        }
        if (!this.decode_pdf.isOpen() && OpenFile.isPDf) {
            return;
        }
        double d = this.pageContainer.getViewportBounds().getWidth() * 0.95;
        double d2 = this.pageContainer.getViewportBounds().getHeight() * 0.95;
        float f = 1.5f;
        if (this.decode_pdf != null) {
            int n;
            for (n = 0; n < this.group.getChildren().size(); ++n) {
                if (((Node)this.group.getChildren().get(n)).equals(this.decode_pdf)) continue;
                this.group.getChildren().remove(this.group.getChildren().get(n));
            }
            n = this.getSelectedComboIndex(252);
            if (this.decode_pdf.getDisplayView() == 5) {
                this.setSelectedComboIndex(252, 0);
                n = 0;
                this.scalingBox.setEnabled(false);
            } else if (this.decode_pdf.getDisplayView() != 5) {
                this.scalingBox.setEnabled(true);
            }
            int n2 = this.commonValues.getCurrentPage();
            if (this.commonValues.isMultiTiff()) {
                n2 = 1;
            }
            if (n != -1) {
                int n3 = 0;
                int n4 = 0;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                int n5 = pdfPageData.getCropBoxWidth(n2);
                int n6 = pdfPageData.getCropBoxHeight(n2);
                switch (this.rotation) {
                    case 0: {
                        n3 = n5;
                        n4 = n6;
                        break;
                    }
                    case 90: {
                        n3 = n6;
                        n4 = n5;
                        break;
                    }
                    case 180: {
                        n3 = n5;
                        n4 = n6;
                        break;
                    }
                    case 270: {
                        n3 = n6;
                        n4 = n5;
                    }
                }
                switch (this.decode_pdf.getDisplayView()) {
                    case 1: {
                        switch (n) {
                            case 0: {
                                f = (float)JavaFxGUI.getScalingRatio(n3, n4, d, d2);
                                break;
                            }
                            case 1: {
                                f = (float)(d2 / (double)n4);
                                break;
                            }
                            case 2: {
                                f = (float)(d / (double)n3);
                                break;
                            }
                            default: {
                                f = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[n]);
                            }
                        }
                        double d3 = (int)(f * (float)n3);
                        double d4 = (int)(f * (float)n4);
                        if (d3 < d) {
                            this.group.setTranslateX((d - d3) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        if (!(d4 < d2) || d3 < d) {
                            // empty if block
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 2: {
                        switch (n) {
                            case 0: {
                                f = (float)JavaFxGUI.getScalingRatio(n3, n4, d, d2);
                                break;
                            }
                            case 1: {
                                f = (float)(d2 / (double)n4);
                                break;
                            }
                            case 2: {
                                f = (float)(d / (double)n3);
                                break;
                            }
                            default: {
                                f = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[n]);
                            }
                        }
                        double d5 = (int)(f * (float)n3);
                        if (d5 < d) {
                            this.group.setTranslateX((d - d5) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 3: {
                        n3 *= 2;
                        switch (n) {
                            case 0: {
                                f = (float)JavaFxGUI.getScalingRatio(n3, n4, d, d2);
                                break;
                            }
                            case 1: {
                                f = (float)(d2 / (double)n4);
                                break;
                            }
                            case 2: {
                                f = (float)(d / (double)n3);
                                break;
                            }
                            default: {
                                f = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[n]);
                            }
                        }
                        double d6 = (int)(f * (float)n3);
                        if (d6 < d) {
                            this.group.setTranslateX((d - d6) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        System.err.println("unsupported page display ");
                    }
                }
            }
            this.scaling = f;
            if (Float.isInfinite(this.scaling)) {
                this.scaling = 1.0f;
            }
            this.decode_pdf.setPageParameters(this.scaling, n2, this.rotation);
        }
        if (LogWriter.isRunningFromIDE) {
            System.out.println("Memory usage after zoom=" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000L);
        }
    }

    public static double getScalingRatio(double d, double d2, double d3, double d4) {
        return Math.min(d3 / d, d4 / d2);
    }

    @Override
    public void snapScalingToDefaults(float f) {
        float f2;
        int n;
        int n2;
        f = this.decode_pdf.getDPIFactory().adjustScaling(f / 100.0f);
        float f3 = (float)this.pageContainer.getWidth() * 0.95f;
        float f4 = (float)this.pageContainer.getHeight() * 0.95f;
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        int n3 = 0;
        if (this.decode_pdf.getDisplayView() == 4) {
            n3 = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        }
        boolean bl = (this.rotation + n3) % 180 == 90;
        PageOffsets pageOffsets = (PageOffsets)this.decode_pdf.getExternalHandler(17);
        switch (this.decode_pdf.getDisplayView()) {
            case 3: {
                if (bl) {
                    n2 = pageOffsets.getMaxH() * 2;
                    n = pageOffsets.getMaxW();
                    break;
                }
                n2 = pageOffsets.getMaxW() * 2;
                n = pageOffsets.getMaxH();
                break;
            }
            case 2: {
                if (bl) {
                    n2 = pageOffsets.getMaxH();
                    n = pageOffsets.getMaxW();
                    break;
                }
                n2 = pageOffsets.getMaxW();
                n = pageOffsets.getMaxH();
                break;
            }
            case 4: {
                int n4;
                if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                    n4 = this.commonValues.getCurrentPage() / 2 * 2;
                    if (this.commonValues.getPageCount() == 2) {
                        n4 = 1;
                    }
                } else {
                    n4 = this.commonValues.getCurrentPage();
                    if ((n4 & 1) == 0) {
                        --n4;
                    }
                }
                if (bl) {
                    n2 = pdfPageData.getCropBoxHeight(n4);
                    n2 = n4 + 1 > this.commonValues.getPageCount() || n4 == 1 ? (n2 *= 2) : (n2 += pdfPageData.getCropBoxHeight(n4 + 1));
                    n = pdfPageData.getCropBoxWidth(n4);
                    if (n4 + 1 > this.commonValues.getPageCount() || n >= pdfPageData.getCropBoxWidth(n4 + 1)) break;
                    n = pdfPageData.getCropBoxWidth(n4 + 1);
                    break;
                }
                n2 = pdfPageData.getCropBoxWidth(n4);
                n2 = n4 + 1 > this.commonValues.getPageCount() ? (n2 *= 2) : (n2 += pdfPageData.getCropBoxWidth(n4 + 1));
                n = pdfPageData.getCropBoxHeight(n4);
                if (n4 + 1 > this.commonValues.getPageCount() || n >= pdfPageData.getCropBoxHeight(n4 + 1)) break;
                n = pdfPageData.getCropBoxHeight(n4 + 1);
                break;
            }
            default: {
                if (bl) {
                    n2 = pdfPageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                    n = pdfPageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                    break;
                }
                n2 = pdfPageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                n = pdfPageData.getCropBoxHeight(this.commonValues.getCurrentPage());
            }
        }
        float f5 = f3 / (float)n2;
        float f6 = f4 / (float)n;
        if (f5 < f6) {
            f2 = f5;
            f5 = -1.0f;
        } else {
            f2 = f6;
            f6 = -1.0f;
        }
        if (this.getSelectedComboIndex(252) != 0 && ((double)f < (double)f2 * 1.1 && (double)f > (double)f2 * 0.91 || f2 > this.scaling && f2 < f || f2 < this.scaling && f2 > f)) {
            this.setSelectedComboIndex(252, 0);
            this.scaling = f2;
        } else if (f6 != -1.0f && this.getSelectedComboIndex(252) != 1 && ((double)f < (double)f6 * 1.1 && (double)f > (double)f6 * 0.91 || f6 > this.scaling && f6 < f || f6 < this.scaling && f6 > f)) {
            this.setSelectedComboIndex(252, 1);
            this.scaling = f6;
        } else if (f5 != -1.0f && this.getSelectedComboIndex(252) != 2 && ((double)f < (double)f5 * 1.1 && (double)f > (double)f5 * 0.91 || f5 > this.scaling && f5 < f || f5 < this.scaling && f5 > f)) {
            this.setSelectedComboIndex(252, 2);
            this.scaling = f5;
        } else {
            this.setSelectedComboItem(252, String.valueOf((int)this.decode_pdf.getDPIFactory().removeScaling(f * 100.0f)));
            this.scaling = f;
        }
    }

    @Override
    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.scaleAndRotate();
    }

    @Override
    public void scrollToPage(int n) {
        this.commonValues.setCurrentPage(n);
        if (this.commonValues.getCurrentPage() > 0) {
            int n2 = this.decode_pdf.getPageCount();
            this.decode_pdf.getPages().getYCordForPage(n, this.scaling);
            PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
            double d = 0.0;
            switch (this.decode_pdf.getDisplayView()) {
                case 1: {
                    break;
                }
                case 2: {
                    int n3;
                    double d2 = 0.0;
                    for (n3 = 1; n3 < n2; ++n3) {
                        d += (double)pdfPageData.getScaledCropBoxHeight(n3);
                    }
                    for (n3 = 1; n3 < n; ++n3) {
                        d2 += (double)pdfPageData.getScaledCropBoxHeight(n3);
                    }
                    double d3 = d2 / d;
                    this.pageContainer.setVvalue(d3);
                    break;
                }
                case 3: {
                    int n4;
                    double d4 = 0.0;
                    for (n4 = 1; n4 < n2; n4 += 2) {
                        d += (double)pdfPageData.getScaledCropBoxHeight(n4);
                    }
                    for (n4 = 1; n4 < n; n4 += 2) {
                        d4 += (double)pdfPageData.getScaledCropBoxHeight(n4);
                    }
                    double d5 = d4 / d;
                    this.pageContainer.setVvalue(d5);
                }
            }
        }
        if (this.decode_pdf.getPageCount() > 1) {
            this.fxButtons.setPageLayoutButtonsEnabled(true);
        }
    }

    @Override
    public void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(this.decode_pdf.getPageCount(), null, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Button[] buttonArray = (Button[])this.thumbnails.getButtons();
            for (int i = 0; i < this.commonValues.getPageCount(); ++i) {
                buttonArray[i].setOnAction((EventHandler)new JavaFXPageChanger(this, this.commonValues, i));
            }
            this.thumbnails.addComponentListener();
        }
    }

    @Override
    public void setBookmarks(boolean bl) {
        if (this.bookmarksGenerated) {
            return;
        }
        this.bookmarksGenerated = true;
        Document document = this.decode_pdf.getOutlineAsXML();
        org.w3c.dom.Node node = null;
        if (document != null) {
            node = document.getFirstChild();
        }
        if (node != null) {
            this.tree.reset(node);
            EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    String string = ((JavaFXOutline.OutlineNode)((Object)((Labeled)mouseEvent.getSource()).getUserData())).getObjectRef();
                    JavaFxGUI.this.gotoPageByRef(string);
                }
            };
            ((TreeView)this.tree.getTree()).getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Label>>((EventHandler)eventHandler){
                final /* synthetic */ EventHandler val$reselectionListener;
                {
                    this.val$reselectionListener = eventHandler;
                }

                public void changed(ObservableValue<? extends TreeItem<Label>> observableValue, TreeItem<Label> treeItem, TreeItem<Label> treeItem2) {
                    if (treeItem2 == null) {
                        return;
                    }
                    if (treeItem != null) {
                        ((Label)treeItem.getValue()).setOnMouseClicked(null);
                    }
                    ((Label)treeItem2.getValue()).setOnMouseClicked(this.val$reselectionListener);
                    String string = ((JavaFXOutline.OutlineNode)treeItem2).getObjectRef();
                    JavaFxGUI.this.gotoPageByRef(string);
                }
            });
        } else {
            this.tree.reset(null);
        }
    }

    private void gotoPageByRef(String string) {
        PdfObject pdfObject = this.decode_pdf.getOutlineData().getAobj(string);
        if (pdfObject != null) {
            this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(pdfObject, 3, 339034948);
        }
    }

    @Override
    public void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    private void initStatus() {
        this.setMultibox(new int[0]);
    }

    @Override
    public void setCoordText(String string) {
        this.coordsFX.setText(string);
    }

    private void initCoordBox() {
        this.coordsFX = new TextField();
        this.coordsFX.prefWidthProperty().bind((ObservableValue)this.multiboxfx.prefWidthProperty());
        this.coordsFX.prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.coordsFX.setAlignment(Pos.CENTER);
        this.coordsFX.setEditable(false);
        this.coordsFX.setVisible(false);
        this.coordsFX.setText("  X:  Y:   ");
    }

    @Override
    public void setPageNumber() {
        if (Platform.isFxApplicationThread()) {
            this.setPageNumberWorker();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JavaFxGUI.this.setPageNumberWorker();
                }
            });
        }
        if (this.isSetup) {
            this.setThumbnails();
        }
    }

    private void setPageNumberWorker() {
        if (this.pageCounter2 == null) {
            return;
        }
        if (!this.decode_pdf.isOpen() && !this.commonValues.isMultiTiff()) {
            this.pageCounter2.setText("0");
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + " 0");
        } else {
            if (this.previewOnSingleScroll && this.pageScroll != null) {
                this.pageScroll.setMax((double)(this.decode_pdf.getPageCount() - 1));
                this.pageScroll.setValue((double)(this.commonValues.getCurrentPage() - 1));
                if (this.debugThumbnail) {
                    System.out.println("setpage=" + this.commonValues.getCurrentPage());
                }
            }
            int n = this.commonValues.getCurrentPage();
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
                if (this.decode_pdf.getPageCount() == 2) {
                    this.pageCounter2.setText("1/2");
                } else if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 3) {
                    int n2 = n & 0xFFFFFFFE;
                    if (n2 != this.decode_pdf.getPageCount() && n2 != 0) {
                        this.pageCounter2.setText(n2 + "/" + (n2 + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(n));
                    }
                } else {
                    int n3 = n - (1 - (n & 1));
                    if (n3 != this.decode_pdf.getPageCount()) {
                        this.pageCounter2.setText(n3 + "/" + (n3 + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(n));
                    }
                }
            } else {
                this.pageCounter2.setText(String.valueOf(n));
            }
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.decode_pdf.getPageCount());
            this.fxButtons.hideRedundentNavButtons(this);
        }
    }

    private void createNavbar() {
        this.navButtons.getChildren().add((Object)this.multiboxfx);
        Region region = new Region();
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        this.navButtons.getChildren().add((Object)region);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "start.gif", 50, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "fback.gif", 51, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "back.gif", 52, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.pageCounter1 = new Label(Messages.getMessage("PdfViewerPageLabel.text"));
        this.navToolBar.getItems().add((Object)this.pageCounter1);
        this.navToolBar.getItems().add((Object)this.pageCounter2);
        this.navToolBar.getItems().add((Object)this.pageCounter3);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "forward.gif", 53, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "fforward.gif", 54, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "end.gif", 55, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.isSingle) {
            this.fxButtons.addButton(2, Messages.getMessage("PageLayoutButton.SinglePage"), "single.gif", 57, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.getTopButtons().getItems().add((Object)this.pagesToolBar);
        } else {
            this.navButtons.getChildren().add((Object)this.navToolBar);
        }
        Region region2 = new Region();
        HBox.setHgrow((Node)region2, (Priority)Priority.ALWAYS);
        this.navButtons.getChildren().add((Object)region2);
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.getTopButtons().getItems().add((Object)this.pagesToolBar);
        } else {
            this.navButtons.getChildren().add((Object)this.pagesToolBar);
        }
        this.multiboxfx.prefWidthProperty().bind((ObservableValue)this.pagesToolBar.widthProperty());
    }

    @Override
    public void setPage(int n) {
        if ((this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 3) && (n & 1) == 1 && n != 1) {
            --n;
        } else if (this.decode_pdf.getDisplayView() == 4 && !this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (n & 1) == 0) {
            --n;
        }
        this.commonValues.setCurrentPage(n);
        this.setPageNumber();
    }

    @Override
    public Enum getType() {
        return GUIModes.JAVAFX;
    }

    @Override
    public void resetPageNav() {
        this.pageCounter2.setText("");
        this.pageCounter3.setText("");
    }

    @Override
    public void setRotationFromExternal(int n) {
        this.rotation = n;
        this.rotationBox.setSelectedIndex(this.rotation / 90);
    }

    @Override
    public void setScalingFromExternal(String string) {
        if (string.startsWith("Fit ")) {
            this.scalingBox.setSelectedItem(string);
        } else {
            this.scaling = Float.parseFloat(string);
            this.scalingBox.setSelectedItem(string + '%');
        }
        if (!Values.isProcessing()) {
            // empty if block
        }
    }

    public Stage getFrame() {
        return this.stage;
    }

    @Override
    public int showMessageDialog(Object object, Object[] objectArray, int n) {
        int n2 = 0;
        boolean bl = true;
        if (this.customMessageHandler != null) {
            bl = this.customMessageHandler.showMessage(object);
        }
        if (bl) {
            FXOptionDialog fXOptionDialog = new FXOptionDialog(this.stage, object.toString(), "Message", 1, objectArray, objectArray[n]);
            n2 = fXOptionDialog.showOptionDialog();
        }
        return n2;
    }

    @Override
    public void showMessageDialog(Object object, String string, int n) {
        boolean bl = true;
        if (this.customMessageHandler != null) {
            bl = this.customMessageHandler.showMessage(object);
        }
        if (bl) {
            FXMessageDialog fXMessageDialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, object.toString());
            fXMessageDialog.setTitle(string);
            fXMessageDialog.show();
        }
    }

    @Override
    public String showInputDialog(Object object, String string, int n) {
        String string2 = null;
        if (this.customMessageHandler != null) {
            string2 = this.customMessageHandler.requestInput(new Object[]{object, string, string});
        }
        if (string2 == null) {
            FXInputDialog fXInputDialog = new FXInputDialog(this.stage, object.toString());
            fXInputDialog.setTitle(string);
            return fXInputDialog.showInputDialog();
        }
        return string2;
    }

    @Override
    public String showInputDialog(String string) {
        String string2 = null;
        if (this.customMessageHandler != null) {
            string2 = this.customMessageHandler.requestInput(new String[]{string});
        }
        if (string2 == null) {
            FXInputDialog fXInputDialog = new FXInputDialog(this.stage, string);
            return fXInputDialog.showInputDialog();
        }
        return string2;
    }

    @Override
    public int showConfirmDialog(String string, String string2, int n) {
        int n2 = -1;
        if (this.customMessageHandler != null) {
            n2 = this.customMessageHandler.requestConfirm(new Object[]{string, string2, String.valueOf(n)});
        }
        if (n2 == -1) {
            FXOptionDialog fXOptionDialog = new FXOptionDialog(this.stage, string, string2, n, null, null);
            return fXOptionDialog.showOptionDialog();
        }
        return n2;
    }

    @Override
    public int showOverwriteDialog(String string, boolean bl) {
        int n;
        int n2 = -1;
        if (this.customMessageHandler != null) {
            n2 = this.customMessageHandler.requestConfirm(new Object[]{string, String.valueOf(bl)});
        }
        if (n2 != -1) {
            return n2;
        }
        String string2 = string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave");
        if (bl) {
            Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            FXOptionDialog fXOptionDialog = new FXOptionDialog(this.stage, string2, Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, objectArray, objectArray[0]);
            n = fXOptionDialog.showOptionDialog();
        } else {
            FXOptionDialog fXOptionDialog = new FXOptionDialog(this.stage, string2, Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, null);
            n = fXOptionDialog.showOptionDialog();
        }
        return n;
    }

    @Override
    public void showMessageDialog(final String string) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMessageDialog fXMessageDialog = new FXMessageDialog(JavaFxGUI.this.stage, Modality.APPLICATION_MODAL, string);
                fXMessageDialog.show();
            }
        });
    }

    public void showMessageDialog(String string, String string2) {
        FXMessageDialog fXMessageDialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, string);
        fXMessageDialog.showAndWait();
    }

    @Override
    public void showMessageDialog(Object object) {
        boolean bl = true;
        if (this.customMessageHandler != null) {
            bl = this.customMessageHandler.showMessage(object);
        }
        if (bl) {
            FXMessageDialog fXMessageDialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, (Parent)object);
            fXMessageDialog.show();
        }
    }

    @Override
    public void showFirstTimePopup() {
        boolean bl;
        boolean bl2 = bl = this.customMessageHandler != null && this.customMessageHandler.showMessage("first time popup") || this.customMessageHandler == null;
        if (!bl || this.commonValues.getModeOfOperation() == 1) {
            return;
        }
        try {
            VBox vBox = new VBox();
            vBox.setAlignment(Pos.CENTER);
            Hyperlink hyperlink = new Hyperlink("", (Node)new ImageView(this.getClass().getResource("/org/jpedal/examples/viewer/res/supportScreenshot.png").toExternalForm()));
            hyperlink.setBorder(Border.EMPTY);
            Hyperlink hyperlink2 = new Hyperlink(Messages.getMessage("PdfViewer.SupportLink.Text1") + ' ' + Messages.getMessage("PdfViewer.SupportLink.Text2"));
            hyperlink2.setBorder(Border.EMPTY);
            hyperlink2.setTextAlignment(TextAlignment.CENTER);
            hyperlink2.setWrapText(true);
            EventHandler<ActionEvent> eventHandler = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.SupportLink.Link"));
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception.getMessage());
                        JavaFxGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            };
            hyperlink.setOnAction((EventHandler)eventHandler);
            hyperlink2.setOnAction((EventHandler)eventHandler);
            vBox.getChildren().addAll((Object[])new Node[]{hyperlink, hyperlink2});
            FXMessageDialog fXMessageDialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, (Parent)vBox);
            fXMessageDialog.setResizeable(true);
            fXMessageDialog.setWidth(280.0);
            fXMessageDialog.setHeight(220.0);
            fXMessageDialog.setTitle(Messages.getMessage("PdfViewerTitle.RunningFirstTime"));
            fXMessageDialog.show();
        }
        catch (Exception exception) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error") + ' ' + exception);
        }
        catch (Error error) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error") + ' ' + error);
        }
    }

    @Override
    public int showConfirmDialog(Object object, String string, int n, int n2) {
        int n3 = -1;
        if (this.customMessageHandler != null) {
            n3 = this.customMessageHandler.requestConfirm(new Object[]{object, string, String.valueOf(n), String.valueOf(n2)});
        }
        if (n3 == -1) {
            FXOptionDialog fXOptionDialog = new FXOptionDialog(this.stage, object, string, n, n2, null, null);
            return fXOptionDialog.showOptionDialog();
        }
        return n3;
    }

    @Override
    public void setDownloadProgress(String string, int n) {
        this.downloadBar.setProgress(string, n);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFxGUI.this.setMultibox(new int[0]);
            }
        });
    }

    @Override
    public void updateStatusMessage(String string) {
    }

    @Override
    public void resetStatusMessage(String string) {
    }

    @Override
    public void setStatusProgress(int n) {
        this.setMultibox(new int[0]);
    }

    private void setSplitDividerLocation(int n) {
        double d = this.center.getWidth();
        if (d == 0.0) {
            d = 1.0;
        }
        this.center.setDividerPosition(0, (double)n / d);
    }

    @Override
    public int getSplitDividerLocation() {
        return 0;
    }

    @Override
    public Object printDialog(String[] stringArray, String string) {
        String string2 = this.properties.getValue("defaultDPI");
        int n = -1;
        if (string2 != null && !string2.isEmpty()) {
            try {
                string2 = string2.replaceAll("[^0-9]", "");
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception attempting get properties value" + exception);
            }
        }
        if (this.printPanel == null) {
            this.printPanel = new PrintPanelFX(stringArray, string, this.getPaperSizes(), n, this.commonValues.getCurrentPage(), this.decode_pdf);
        } else {
            this.printPanel.resetDefaults(stringArray, string, this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
        }
        this.printPanel.setVisible(true);
        return this.printPanel;
    }

    @Override
    public PaperSizes getPaperSizes() {
        if (this.paperSizes == null) {
            this.paperSizes = new PaperSizes(this.properties.getValue("defaultPagesize"));
        }
        return this.paperSizes;
    }

    @Override
    public void setQualityBoxVisible(boolean bl) {
        if (this.properties.getValue("Imageopdisplay").equalsIgnoreCase("true") && this.qualityBox != null) {
            this.qualityBox.setVisibility(bl);
        }
    }

    private void setThumbnails() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                if (JavaFxGUI.this.thumbnails.isShownOnscreen()) {
                    JavaFxGUI.this.setupThumbnailPanel();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFxGUI.this.thumbnails.generateOtherVisibleThumbnails(JavaFxGUI.this.commonValues.getCurrentPage());
                        }
                    });
                }
                return null;
            }
        };
        new Thread((Runnable)task).start();
    }

    @Override
    public void setSearchText(Object object) {
        this.searchText = (TextField)object;
    }

    @Override
    public void setResults(GUISearchList gUISearchList) {
        this.results = gUISearchList;
        if (this.searchInMenu && this.results.getResultCount() == 0) {
            this.showMessageDialog((Object)(Messages.getMessage("PdfViewerFileMenuFind.noResultText") + " \"" + gUISearchList.getSearchTerm() + '\"'), Messages.getMessage("PdfViewerFileMenuFind.noResultTitle"), 1);
        }
    }

    @Override
    public Object getSideTabBar() {
        return this.navOptionsPanel;
    }

    @Override
    public void enableSearchItems(boolean bl) {
        if (this.searchInMenu) {
            this.searchText.setDisable(!bl);
            this.options.setDisable(!bl);
            this.fxButtons.getButton(19).setEnabled(false);
            this.fxButtons.getButton(18).setEnabled(false);
        } else if (this.fxButtons.getButton(12) != null) {
            this.fxButtons.getButton(12).setEnabled(bl);
        }
    }

    @Override
    public void removeSearchWindow(boolean bl) {
        this.searchFrame.removeSearchWindow(bl);
    }

    @Override
    public void alterProperty(String string, boolean bl) {
    }

    @Override
    public void dispose() {
        if (this.pageContainer != null) {
            if (this.fxChangeListener != null) {
                this.pageContainer.viewportBoundsProperty().removeListener(this.fxChangeListener);
                this.fxChangeListener = null;
            }
            this.pageContainer = null;
        }
        this.fxButtons.dispose();
        super.dispose();
        this.mouseHandler = null;
        this.pageTitle = null;
        this.bookmarksTitle = null;
        this.signaturesTitle = null;
        this.layersTitle = null;
        this.currentCommandListener = null;
        if (this.navButtons != null) {
            this.navButtons.getChildren().removeAll((Collection)this.navButtons.getChildren());
        }
        this.navButtons = null;
        this.menuItems.dispose();
        if (this.navOptionsPanel != null) {
            this.navOptionsPanel.getTabs().removeAll((Object[])new Tab[0]);
        }
        this.navOptionsPanel = null;
        this.headFont = null;
        this.textFont = null;
        this.pageCounter2 = null;
        this.pageCounter3 = null;
        if (this.navToolBar != null) {
            this.navToolBar.getItems().removeAll((Collection)this.navToolBar.getItems());
        }
        this.navToolBar = null;
        if (this.pagesToolBar != null) {
            this.pagesToolBar = null;
        }
        this.layersObject = null;
        if (this.memoryMonitor != null) {
            this.memoryMonitor.stop();
        }
    }

    @Override
    public boolean getPageTurnScalingAppropriate() {
        return true;
    }

    @Override
    public SwingCursor getGUICursor() {
        return this.guiCursor;
    }

    @Override
    public void rescanPdfLayers() {
    }

    @Override
    public String getTitles(String string) {
        if (string.equals(this.pageTitle)) {
            return this.pageTitle;
        }
        if (string.equals(this.bookmarksTitle)) {
            return this.bookmarksTitle;
        }
        if (string.equals(this.signaturesTitle)) {
            return this.signaturesTitle;
        }
        if (string.equals(this.layersTitle)) {
            return this.layersTitle;
        }
        return null;
    }

    @Override
    public Object getStatusBar() {
        return null;
    }

    @Override
    public GUIButtons getButtons() {
        return this.fxButtons;
    }

    @Override
    public GUIMenuItems getMenuItems() {
        return this.menuItems;
    }

    @Override
    public void setTabsNotInitialised(boolean bl) {
        this.tabsNotInitialised = bl;
    }

    @Override
    public void decodePage() {
        Object var1_1 = null;
        if (this.decode_pdf.getDisplayView() == 1) {
            // empty if block
        }
        if (var1_1 != null) {
            this.decode_pdf.addExternalHandler(new FXAdditionalData(), 33);
            final JavaFxGUI javaFxGUI = this;
            this.resetPDFBorder(Color.TRANSPARENT);
            final Transition transition = FXViewerTransitions.entryTransition((PdfDecoderFX)this.decode_pdf, this.transitionType, FXViewerTransitions.TransitionDirection.NONE);
            transition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    JavaFxGUI.this.resetPDFBorder(Color.DARKGOLDENROD);
                }
            });
            var1_1.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFxGUI.this.decodeGUIPage(javaFxGUI);
                        }
                    });
                    transition.play();
                }
            });
            var1_1.play();
        } else {
            if (this.getThumbnailScrollBar() != null) {
                this.setThumbnailScrollBarValue(this.commonValues.getCurrentPage() - 1);
            }
            ((PdfDecoderFX)this.decode_pdf).setOpacity(1.0);
            this.resetPDFBorder(Color.DARKGOLDENROD);
            this.decodeGUIPage(this);
        }
    }

    public void updateTransitionType() {
        this.transitionType = FXViewerTransitions.TransitionType.valueOf(this.properties.getValue("transitionType").replace(" ", "_"));
    }

    public ScrollPane getPageContainer() {
        return this.pageContainer;
    }

    @Override
    public PdfDecoderFX getPdfDecoder() {
        return (PdfDecoderFX)this.decode_pdf;
    }

    @Override
    protected void addComboListenerAndLabel(GUICombo gUICombo, String string) {
        ((JavaFXCombo)gUICombo).setOnAction((EventHandler)this.currentCommandListener.getCommandListener());
    }

    @Override
    protected void addGUIComboBoxes(GUICombo gUICombo) {
        this.fxButtons.getTopButtons().getItems().add((Object)((JavaFXCombo)gUICombo));
    }

    @Override
    protected void setupCenterPanelBackground() {
        String string = this.properties.getValue("replacePdfDisplayBackground");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            string = this.properties.getValue("pdfDisplayBackground");
            if (!string.isEmpty()) {
                this.currentCommands.executeCommand(714, new Object[]{Integer.parseInt(string)});
            }
            int n = Integer.parseInt(string);
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n & 0xFF;
            this.pageContainer.setStyle("-fx-background:rgb(" + n2 + ',' + n3 + ',' + n4 + ");");
        } else if (this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            int n = this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor().getRGB();
            int n5 = n >> 16 & 0xFF;
            int n6 = n >> 8 & 0xFF;
            int n7 = n & 0xFF;
            this.pageContainer.setStyle("-fx-background:rgb(" + n5 + ',' + n6 + ',' + n7 + ");");
        } else if (this.decode_pdf.useNewGraphicsMode()) {
            this.pageContainer.setStyle("-fx-background:#555565;");
        } else {
            this.pageContainer.setStyle("-fx-background:#190190190;");
        }
    }

    @Override
    protected void setupComboBoxes() {
        String[] stringArray = new String[]{Messages.getMessage("PdfViewerToolbarComboBox.imageQual")};
        String[] stringArray2 = new String[]{"0", "90", "180", "270"};
        String[] stringArray3 = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25%", "50%", "75%", "100%", "125%", "150%", "200%", "250%", "500%", "750%", "1000%"};
        this.qualityBox = new JavaFXCombo(stringArray);
        ((JavaFXCombo)this.qualityBox).setStyle("-fx-background-color: #FFFFFF;");
        this.qualityBox.setSelectedIndex(0);
        String string = System.getProperty("org.jpedal.defaultViewerScaling");
        if (string == null) {
            string = this.properties.getValue("startScaling");
        }
        if (string != null) {
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray3[i].equals(string)) continue;
                defaultSelection = i;
                i = n;
            }
        }
        this.scalingBox = new JavaFXCombo(stringArray3);
        ((JavaFXCombo)this.scalingBox).setStyle("-fx-background-color: #FFFFFF;");
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(defaultSelection);
        this.rotationBox = new JavaFXCombo(stringArray2);
        ((JavaFXCombo)this.rotationBox).setStyle("-fx-background-color: #FFFFFF;");
        this.rotationBox.setSelectedIndex(0);
    }

    @Override
    protected void setupKeyboardControl() {
    }

    private void setupPDFDisplayPane(int n, int n2) {
        if (this.isSingle) {
            this.previewOnSingleScroll = this.properties.getValue("previewOnSingleScroll").equalsIgnoreCase("true");
            if (this.previewOnSingleScroll) {
                // empty if block
            }
            this.pageContainer = new ScrollPane();
            this.pageContainer.setPannable(true);
            this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.decode_pdf.setInset(0, 0);
            this.group = new Group();
            this.group.getChildren().add((Object)((PdfDecoderFX)this.decode_pdf));
            this.pageContainer.setContent((Node)this.group);
            this.fxChangeListener = new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
                    if (JavaFxGUI.this.decode_pdf.getDisplayView() == 1) {
                        JavaFxGUI.this.scaleAndRotate();
                    }
                }
            };
            this.pageContainer.viewportBoundsProperty().addListener(this.fxChangeListener);
            this.setupKeyboardControl();
        }
    }

    @Override
    protected void setupBorderPanes() {
        if (this.isSingle) {
            this.setupSidebarTitles();
            this.center = new SplitPane();
            this.setupTabPane();
            this.center.getItems().addAll((Object[])new Node[]{this.navOptionsPanel, this.pageContainer});
            if (this.pageScroll != null) {
                this.center.getItems().add((Object)this.pageScroll);
            }
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            ((SplitPane.Divider)this.center.getDividers().get(0)).positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    if (JavaFxGUI.this.tabsExpanded) {
                        GUI.expandedSize = (int)JavaFxGUI.this.navOptionsPanel.getWidth();
                    }
                }
            });
            this.propValue = this.properties.getValue("startSideTabOpen");
            if (!this.propValue.isEmpty()) {
                this.sideTabBarOpenByDefault = this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("startSelectedSideTab");
            if (!this.propValue.isEmpty()) {
                this.startSelectedTab = this.propValue;
            }
            if (!this.hasListener) {
                this.navOptionsPanel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent mouseEvent) {
                        if (mouseEvent.getX() < 30.0) {
                            JavaFxGUI.this.handleTabbedPanes();
                        }
                    }
                });
                this.hasListener = true;
            }
        }
    }

    @Override
    protected void setupBottomToolBarItems() {
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setTooltip(new Tooltip(Messages.getMessage("PdfViewerTooltip.goto")));
        this.pageCounter2.setPrefColumnCount(2);
        this.pageCounter2.setMaxSize(this.pageCounter2.getPrefWidth(), this.pageCounter2.getPrefHeight());
        this.pageCounter2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFxGUI.this.commonValues.setSelectedFile(JavaFxGUI.this.decode_pdf.getFileName());
                JavaFxGUI.this.commonValues.setPageCount(JavaFxGUI.this.decode_pdf.getPageCount());
                JavaFxGUI.this.commonValues.setCurrentPage(JavaFxGUI.this.decode_pdf.getPageNumber());
                String string = JavaFxGUI.this.pageCounter2.getText().trim();
                JavaFxGUI.this.currentCommands.executeCommand(56, new Object[]{string});
            }
        });
        this.pageCounter2.setAlignment(Pos.CENTER);
        this.setPageNumber();
        this.navButtons.setPrefSize(5.0, 24.0);
    }

    @Override
    protected void setupPDFBorder() {
        this.resetPDFBorder(Color.DARKGOLDENROD);
    }

    private void resetPDFBorder(final Color color) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DropShadow dropShadow = new DropShadow();
                dropShadow.setOffsetY(0.0);
                dropShadow.setOffsetX(0.0);
                dropShadow.setColor(color);
                dropShadow.setWidth(40.0);
                dropShadow.setHeight(40.0);
                ((PdfDecoderFX)JavaFxGUI.this.decode_pdf).setEffect((Effect)dropShadow);
            }
        });
    }

    @Override
    protected void createTopMenuBar() {
        this.topPane.setStyle("-fx-background-color: #F5F6F7;");
    }

    @Override
    protected void createMainViewerWindow(int n, int n2) {
        this.root.setTop((Node)this.topPane);
        this.root.setCenter((Node)this.center);
        this.root.setBottom((Node)this.navButtons);
        if (this.stage != null) {
            this.scene = new Scene((Parent)this.root, (double)n, (double)n2);
            this.stage.setScene(this.scene);
            this.stage.show();
        }
    }

    @Override
    public void setScrollBarPolicy(GUI.ScrollPolicy scrollPolicy) {
        switch (scrollPolicy) {
            case VERTICAL_NEVER: {
                this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                break;
            }
            case VERTICAL_AS_NEEDED: {
                this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
                break;
            }
            case HORIZONTAL_NEVER: {
                this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                break;
            }
            case HORIZONTAL_AS_NEEDED: {
                this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            }
        }
    }

    private void setupTabPane() {
        this.navOptionsPanel = new TabPane();
        this.navOptionsPanel.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.navOptionsPanel.setSide(Side.LEFT);
        final Tab tab = new Tab("");
        tab.setDisable(true);
        tab.setStyle("-fx-opacity:0;");
        final Tab tab2 = new Tab("Search");
        ((JavaFXThumbnailPanel)this.thumbnails).setText(this.pageTitle);
        ((JavaFXOutline)this.tree).setText(this.bookmarksTitle);
        this.layersPanel.setText(this.layersTitle);
        this.signaturesPanel.setText(this.signaturesTitle);
        this.navOptionsPanel.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observableValue, Tab tab3, Tab tab22) {
                if (JavaFxGUI.this.navOptionsPanel.getSelectionModel().getSelectedItem() == tab2) {
                    tab2.setContent((Node)((JavaFXSearchWindow)JavaFxGUI.this.searchFrame).getContentVB());
                }
                if (!JavaFxGUI.this.tabsExpanded && !tab.isSelected()) {
                    JavaFxGUI.this.setSplitDividerLocation(GUI.expandedSize);
                    JavaFxGUI.this.tabsExpanded = true;
                } else if (JavaFxGUI.this.tabsExpanded && tab22.equals(tab3)) {
                    JavaFxGUI.this.setSplitDividerLocation(GUI.collapsedSize);
                    JavaFxGUI.this.tabsExpanded = false;
                }
            }
        });
        SplitPane.setResizableWithParent((Node)this.navOptionsPanel, (Boolean)Boolean.FALSE);
        if (this.searchFrame.getViewStyle() == 1) {
            this.navOptionsPanel.getTabs().addAll((Object[])new Tab[]{(JavaFXThumbnailPanel)this.thumbnails, tab2, tab});
        } else {
            this.navOptionsPanel.getTabs().addAll((Object[])new Tab[]{(JavaFXThumbnailPanel)this.thumbnails, tab});
        }
        this.navOptionsPanel.getSelectionModel().select((Object)tab);
        this.tabsNotInitialised = false;
    }

    @Override
    public RecentDocumentsFactory getRecentDocument() {
        if (this.recent != null) {
            return this.recent;
        }
        this.recent = new JavaFXRecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
        return this.recent;
    }

    @Override
    public void setRecentDocument() {
        this.recent = new JavaFXRecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
    }

    @Override
    public void openFile(String string) {
        if (string != null) {
            JavaFXOpenFile.open(string, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
        }
    }

    @Override
    public void open(String string) {
        JavaFXOpenFile.open(string, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
    }

    @Override
    public void enablePageCounter(GUI.PageCounter pageCounter, boolean bl, boolean bl2) {
        switch (pageCounter) {
            case PAGECOUNTER1: {
                this.pageCounter1.setVisible(bl2);
                this.pageCounter1.setDisable(!bl);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setVisible(bl2);
                this.pageCounter2.setDisable(!bl);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setVisible(bl2);
                this.pageCounter3.setDisable(!bl);
                break;
            }
            case ALL: {
                this.pageCounter1.setVisible(bl2);
                this.pageCounter1.setDisable(!bl);
                this.pageCounter2.setVisible(bl2);
                this.pageCounter2.setDisable(!bl);
                this.pageCounter3.setVisible(bl2);
                this.pageCounter3.setDisable(!bl);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    @Override
    public void removePageListener() {
        if (this.viewListener != null) {
            this.decode_pdf.getPages().flushPageCaches();
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
    }

    @Override
    public void setPageCounterText(GUI.PageCounter pageCounter, String string) {
        switch (pageCounter) {
            case PAGECOUNTER1: {
                this.pageCounter1.setText(string);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setText(string);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setText(string);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    @Override
    public Object getPageCounter(GUI.PageCounter pageCounter) {
        switch (pageCounter) {
            case PAGECOUNTER1: {
                return this.pageCounter1;
            }
            case PAGECOUNTER2: {
                return this.pageCounter2;
            }
            case PAGECOUNTER3: {
                return this.pageCounter3;
            }
        }
        System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
        return 0;
    }

    @Override
    public void updateTextBoxSize() {
        int n = String.valueOf(this.commonValues.getPageCount()).length();
        if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
            n *= 2;
        }
        if (n < 2) {
            n = 2;
        }
        if (n > 10) {
            n = 10;
        }
        this.pageCounter2.setPrefColumnCount(n);
        this.pageCounter2.setMaxSize(this.pageCounter2.getPrefWidth(), this.pageCounter2.getPrefHeight());
    }

    @Override
    public void enableCursor(boolean bl, boolean bl2) {
        this.coordsFX.setDisable(!bl);
        this.coordsFX.setVisible(bl2);
    }

    @Override
    public void enableMemoryBar(boolean bl, boolean bl2) {
        this.memoryBarFX.setDisable(!bl);
        this.memoryBarFX.setVisible(bl2);
    }

    @Override
    public void enableNavigationBar(boolean bl, boolean bl2) {
        this.navButtons.setDisable(!bl);
        this.navButtons.setVisible(bl);
    }

    @Override
    public void enableDownloadBar(boolean bl, boolean bl2) {
        this.downloadBar.setDisable(!bl);
        this.downloadBar.setVisible(bl2);
    }

    @Override
    public int getSidebarTabCount() {
        return this.navOptionsPanel.getTabs().size();
    }

    @Override
    public String getSidebarTabTitleAt(int n) {
        return ((Tab)this.navOptionsPanel.getTabs().get(n)).getText();
    }

    @Override
    public void removeSidebarTabAt(int n) {
        this.navOptionsPanel.getTabs().remove(n);
    }

    @Override
    public double getDividerLocation() {
        double d = this.center.getWidth();
        if (d == 0.0) {
            d = 1.0;
        }
        return d * ((SplitPane.Divider)this.center.getDividers().get(0)).getPosition();
    }

    @Override
    public double getStartSize() {
        return collapsedSize;
    }

    @Override
    public void setStartSize(int n) {
        collapsedSize = n;
    }

    @Override
    public float scaleToVisible(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7 = (float)this.pageContainer.getWidth() * 0.95f;
        float f8 = (f2 - f) / f7;
        float f9 = f8 > (f6 = (f3 - f4) / (f5 = (float)this.pageContainer.getHeight() * 0.95f)) ? f8 : f6;
        f9 = this.decode_pdf.getDPIFactory().adjustScaling(f9);
        return f9;
    }

    @Override
    public int getDropShadowDepth() {
        return 40;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    @Override
    public void setPannable(boolean bl) {
        this.pageContainer.setPannable(bl);
    }

    @Override
    public void setupSplitPaneDivider(int n, boolean bl) {
        this.center.setDisable(!bl);
        this.center.setVisible(bl);
    }

    @Override
    public void enableStatusBar(boolean bl, boolean bl2) {
    }

    private void removeComponentListener(RefreshLayout refreshLayout) {
        ScrollPane scrollPane = this.pageContainer;
        scrollPane.viewportBoundsProperty().removeListener((ChangeListener)refreshLayout);
        scrollPane.vvalueProperty().removeListener((ChangeListener)refreshLayout);
        scrollPane.hvalueProperty().removeListener((ChangeListener)refreshLayout);
    }

    private void addComponentListener(RefreshLayout refreshLayout) {
        ScrollPane scrollPane = this.pageContainer;
        if (scrollPane != null) {
            scrollPane.viewportBoundsProperty().addListener((ChangeListener)refreshLayout);
            scrollPane.vvalueProperty().addListener((ChangeListener)refreshLayout);
            scrollPane.hvalueProperty().addListener((ChangeListener)refreshLayout);
        }
    }

    class RefreshLayout
    implements ChangeListener {
        final PageMoveTracker tracker = new PageMoveTracker();
        final PdfDecoderInt decode_pdf;

        RefreshLayout(PdfDecoderInt pdfDecoderInt) {
            this.decode_pdf = pdfDecoderInt;
        }

        public void dispose() {
            this.tracker.dispose();
        }

        public void changed(ObservableValue observableValue, Object object, Object object2) {
            this.tracker.startTimer(this.decode_pdf.getPages(), this.decode_pdf.getPageNumber(), (FileAccess)this.decode_pdf.getExternalHandler(35));
        }
    }
}

