/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.util.Timer;
import java.util.TimerTask;
import org.jpedal.FileAccess;
import org.jpedal.display.Display;

public class PageMoveTracker {
    final Timer t2 = new Timer();
    TimerTask listener;

    public void dispose() {
        if (this.t2 != null) {
            this.t2.cancel();
        }
    }

    void startTimer(Display display, int n, FileAccess fileAccess) {
        if (this.listener != null) {
            this.listener.cancel();
            this.t2.purge();
        }
        this.listener = new PageListener(display, n, fileAccess);
        this.t2.schedule(this.listener, 500L);
    }

    private class PageListener
    extends TimerTask {
        final Display pages;
        final FileAccess fileAccess;
        final int pageNumber;
        final int pageCount;

        private PageListener(Display display, int n, FileAccess fileAccess) {
            this.pages = display;
            this.pageNumber = n;
            this.fileAccess = fileAccess;
            this.pageCount = fileAccess.getPageCount();
        }

        @Override
        public void run() {
            if (this.pages != null) {
                this.pages.stopGeneratingPage();
                if (this.pageNumber < 1) {
                    this.fileAccess.setPageNumber(1);
                }
                if (this.pages != null) {
                    this.pages.decodeOtherPages(this.pageNumber, this.pageCount);
                }
            }
            this.cancel();
        }
    }
}

