/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.jpedal.utils.LogWriter;

public class SwingCursor {
    private String iconLocation = "/org/jpedal/examples/viewer/res/";
    private Cursor grabCursor;
    private Cursor grabbingCursor;
    private Cursor panCursor;
    private Cursor panCursorL;
    private Cursor panCursorTL;
    private Cursor panCursorT;
    private Cursor panCursorTR;
    private Cursor panCursorR;
    private Cursor panCursorBR;
    private Cursor panCursorB;
    private Cursor panCursorBL;

    public Cursor getCursor(int n) {
        switch (n) {
            case 1: {
                if (this.grabCursor == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "grab32.png"));
                    this.grabCursor = toolkit.createCustomCursor(image, new Point(8, 8), "grab");
                }
                return this.grabCursor;
            }
            case 2: {
                if (this.grabbingCursor == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "grabbing32.png"));
                    this.grabbingCursor = toolkit.createCustomCursor(image, new Point(8, 8), "grabbing");
                }
                return this.grabbingCursor;
            }
            case 4: {
                if (this.panCursor == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "pan32.png"));
                    this.panCursor = toolkit.createCustomCursor(image, new Point(10, 10), "pan");
                }
                return this.panCursor;
            }
            case 5: {
                if (this.panCursorL == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "panl32.png"));
                    this.panCursorL = toolkit.createCustomCursor(image, new Point(11, 10), "panl");
                }
                return this.panCursorL;
            }
            case 6: {
                if (this.panCursorTL == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "pantl32.png"));
                    this.panCursorTL = toolkit.createCustomCursor(image, new Point(10, 10), "pantl");
                }
                return this.panCursorTL;
            }
            case 7: {
                if (this.panCursorT == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "pant32.png"));
                    this.panCursorT = toolkit.createCustomCursor(image, new Point(10, 11), "pant");
                }
                return this.panCursorT;
            }
            case 8: {
                if (this.panCursorTR == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "pantr32.png"));
                    this.panCursorTR = toolkit.createCustomCursor(image, new Point(10, 10), "pantr");
                }
                return this.panCursorTR;
            }
            case 9: {
                if (this.panCursorR == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "panr32.png"));
                    this.panCursorR = toolkit.createCustomCursor(image, new Point(10, 10), "panr");
                }
                return this.panCursorR;
            }
            case 10: {
                if (this.panCursorBR == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "panbr32.png"));
                    this.panCursorBR = toolkit.createCustomCursor(image, new Point(10, 10), "panbr");
                }
                return this.panCursorBR;
            }
            case 11: {
                if (this.panCursorB == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "panb32.png"));
                    this.panCursorB = toolkit.createCustomCursor(image, new Point(10, 10), "panb");
                }
                return this.panCursorB;
            }
            case 12: {
                if (this.panCursorBL == null) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(this.getURLForImage(this.iconLocation + "panbl32.png"));
                    this.panCursorBL = toolkit.createCustomCursor(image, new Point(10, 10), "panbl");
                }
                return this.panCursorBL;
            }
        }
        return Cursor.getDefaultCursor();
    }

    public void setIconLocation(String string) {
        this.iconLocation = string;
    }

    public URL getURLForImage(String string) {
        string = this.iconLocation + string;
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        string = string.substring(0, string.indexOf(46)) + ".gif";
        File file = new File(string);
        URL uRL = this.getClass().getResource(string);
        if (file.exists()) {
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                LogWriter.writeLog("Exception attempting get path for image " + malformedURLException);
            }
        }
        if (uRL == null) {
            string = string.substring(0, string.indexOf(46)) + ".png";
            file = new File(string);
            uRL = this.getClass().getResource(string);
            if (file.exists()) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    LogWriter.writeLog("Exception attempting get path for image " + malformedURLException);
                }
            }
        }
        if (uRL != null) {
            return uRL;
        }
        string = "/org/jpedal/examples/viewer/res/" + string2;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    public BufferedImage getCursorImageForFX(int n) {
        switch (n) {
            case 1: {
                try {
                    return ImageIO.read(this.getURLForImage("grab32.png"));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in getting image " + exception);
                    return null;
                }
            }
            case 2: {
                try {
                    return ImageIO.read(this.getURLForImage("grabbing32.png"));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in getting image " + exception);
                    return null;
                }
            }
        }
        return null;
    }
}

