/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.util.Duration;
import org.jpedal.PdfDecoderFX;

public class FXViewerTransitions {
    public static Transition entryTransition(PdfDecoderFX pdfDecoderFX, TransitionType transitionType, TransitionDirection transitionDirection) {
        Transition transition = null;
        switch (transitionType) {
            case Fade: {
                transition = FXViewerTransitions.fadeIn(pdfDecoderFX);
                break;
            }
            case Scale: {
                transition = FXViewerTransitions.scaleIn(pdfDecoderFX, transitionDirection);
                break;
            }
            case CardStack: {
                transition = FXViewerTransitions.cardStackIn(pdfDecoderFX, transitionDirection);
                break;
            }
            case Rotate: {
                transition = FXViewerTransitions.rotateIn(pdfDecoderFX, transitionDirection);
            }
        }
        return transition;
    }

    public static Transition exitTransition(PdfDecoderFX pdfDecoderFX, TransitionType transitionType, TransitionDirection transitionDirection) {
        Transition transition = null;
        switch (transitionType) {
            case Fade: {
                transition = FXViewerTransitions.fadeOut(pdfDecoderFX);
                break;
            }
            case Scale: {
                transition = FXViewerTransitions.scaleOut(pdfDecoderFX, transitionDirection);
                break;
            }
            case CardStack: {
                transition = FXViewerTransitions.cardStackOut(pdfDecoderFX, transitionDirection);
                break;
            }
            case Rotate: {
                transition = FXViewerTransitions.rotateOut(pdfDecoderFX, transitionDirection);
            }
        }
        return transition;
    }

    private static Transition fadeIn(PdfDecoderFX pdfDecoderFX) {
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        return fadeTransition;
    }

    private static Transition fadeOut(PdfDecoderFX pdfDecoderFX) {
        FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        return fadeTransition;
    }

    private static Transition rotateIn(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setByX(1.0);
            scaleTransition.setByY(1.0);
            RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
            rotateTransition.setFromAngle(0.0);
            rotateTransition.setToAngle(360.0);
            return new ParallelTransition((Node)pdfDecoderFX, new Animation[]{scaleTransition, rotateTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setByX(1.0);
            scaleTransition.setByY(1.0);
            RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
            rotateTransition.setFromAngle(360.0);
            rotateTransition.setToAngle(0.0);
            return new ParallelTransition((Node)pdfDecoderFX, new Animation[]{scaleTransition, rotateTransition});
        }
        return null;
    }

    private static Transition rotateOut(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setToX(0.0);
            scaleTransition.setToY(0.0);
            RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
            rotateTransition.setFromAngle(0.0);
            rotateTransition.setToAngle(360.0);
            return new ParallelTransition((Node)pdfDecoderFX, new Animation[]{scaleTransition, rotateTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setToX(0.0);
            scaleTransition.setToY(0.0);
            RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX);
            rotateTransition.setFromAngle(360.0);
            rotateTransition.setToAngle(0.0);
            return new ParallelTransition((Node)pdfDecoderFX, new Animation[]{scaleTransition, rotateTransition});
        }
        return null;
    }

    private static Transition scaleIn(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            pdfDecoderFX.getParent().setScaleX(0.0);
            pdfDecoderFX.getParent().setScaleY(0.0);
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setByX(1.0);
            scaleTransition.setByY(1.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            pdfDecoderFX.getParent().setScaleX(0.0);
            pdfDecoderFX.getParent().setScaleY(0.0);
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setToX(1.0);
            scaleTransition.setToY(1.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition});
        }
        return null;
    }

    private static Transition scaleOut(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setToX(0.0);
            scaleTransition.setToY(0.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0));
            scaleTransition.setToX(0.0);
            scaleTransition.setToY(0.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition});
        }
        return null;
    }

    private static Transition cardStackIn(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            pdfDecoderFX.getParent().setScaleX(0.0);
            pdfDecoderFX.getParent().setScaleY(0.0);
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            scaleTransition.setToX(1.0);
            scaleTransition.setToY(1.0);
            FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            fadeTransition.setFromValue(0.0);
            fadeTransition.setToValue(1.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition, fadeTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            double d = pdfDecoderFX.getParent() != null ? pdfDecoderFX.getParent().getTranslateX() : 0.0;
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            scaleTransition.setToX(1.0);
            scaleTransition.setToY(1.0);
            TranslateTransition translateTransition = new TranslateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            translateTransition.setFromX(-pdfDecoderFX.getWidth());
            translateTransition.setByX(pdfDecoderFX.getWidth());
            translateTransition.setToX(d);
            FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            fadeTransition.setFromValue(0.0);
            fadeTransition.setToValue(1.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{fadeTransition, scaleTransition, translateTransition});
        }
        return null;
    }

    private static Transition cardStackOut(PdfDecoderFX pdfDecoderFX, TransitionDirection transitionDirection) {
        if (transitionDirection == TransitionDirection.RIGHT) {
            ScaleTransition scaleTransition = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            scaleTransition.setToX(0.0);
            scaleTransition.setToY(0.0);
            FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            fadeTransition.setFromValue(1.0);
            fadeTransition.setToValue(0.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{scaleTransition, fadeTransition});
        }
        if (transitionDirection == TransitionDirection.LEFT) {
            TranslateTransition translateTransition = new TranslateTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            translateTransition.setByX(-pdfDecoderFX.getWidth());
            FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)pdfDecoderFX.getParent());
            fadeTransition.setFromValue(1.0);
            fadeTransition.setToValue(0.0);
            return new ParallelTransition((Node)pdfDecoderFX.getParent(), new Animation[]{fadeTransition, translateTransition});
        }
        return null;
    }

    public static enum TransitionDirection {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum TransitionType {
        None,
        Fade,
        Scale,
        Rotate,
        CardStack;

    }
}

