/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseEvent;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUIButton;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButton;
import org.jpedal.gui.GUIFactory;

public class JavaFXButtons
implements GUIButtons {
    private ToolBar topButtons = new ToolBar();
    ArrayList<CheckMenuItem> layoutGroup = new ArrayList();
    private GUIButton mouseMode;
    private GUIButton nextSearch;
    private GUIButton previousSearch;
    private GUIButton searchButton;
    private GUIButton openButton;
    private GUIButton printButton;
    private GUIButton docPropButton;
    private GUIButton infoButton;
    private GUIButton snapshotButton;
    private GUIButton singleButton;
    private GUIButton continuousButton;
    private GUIButton continuousFacingButton;
    private GUIButton facingButton;
    private GUIButton pageFlowButton;
    private GUIButton first;
    private GUIButton fback;
    private GUIButton back;
    private GUIButton forward;
    private GUIButton fforward;
    private GUIButton last;
    private boolean isSingle;

    public void init(boolean bl) {
        this.isSingle = bl;
        this.previousSearch = new JavaFXButton();
        this.nextSearch = new JavaFXButton();
        this.searchButton = new JavaFXButton();
        this.first = new JavaFXButton();
        this.fback = new JavaFXButton();
        this.back = new JavaFXButton();
        this.forward = new JavaFXButton();
        this.fforward = new JavaFXButton();
        this.last = new JavaFXButton();
        this.snapshotButton = new JavaFXButton();
        this.singleButton = new JavaFXButton();
        this.continuousButton = new JavaFXButton();
        this.continuousFacingButton = new JavaFXButton();
        this.facingButton = new JavaFXButton();
        this.pageFlowButton = new JavaFXButton();
        this.openButton = new JavaFXButton();
        this.printButton = new JavaFXButton();
        this.docPropButton = new JavaFXButton();
        this.infoButton = new JavaFXButton();
        this.mouseMode = new JavaFXButton();
        JavaFXButtons.setupButtonStyle();
    }

    @Override
    public GUIButton getButton(int n) {
        switch (n) {
            case 13: {
                return this.snapshotButton;
            }
            case 1: {
                return this.infoButton;
            }
            case 9: {
                return this.docPropButton;
            }
            case 6: {
                return this.printButton;
            }
            case 10: {
                return this.openButton;
            }
            case 59: {
                return this.continuousFacingButton;
            }
            case 58: {
                return this.continuousButton;
            }
            case 61: {
                return this.pageFlowButton;
            }
            case 60: {
                return this.facingButton;
            }
            case 57: {
                return this.singleButton;
            }
            case 29: {
                return this.mouseMode;
            }
            case 52: {
                return this.back;
            }
            case 50: {
                return this.first;
            }
            case 51: {
                return this.fback;
            }
            case 53: {
                return this.forward;
            }
            case 54: {
                return this.fforward;
            }
            case 55: {
                return this.last;
            }
            case 12: {
                return this.searchButton;
            }
            case 18: {
                return this.previousSearch;
            }
            case 19: {
                return this.nextSearch;
            }
        }
        return null;
    }

    public void dispose() {
        this.searchButton = null;
        this.nextSearch = null;
        this.previousSearch = null;
        this.first = null;
        this.fback = null;
        this.back = null;
        this.forward = null;
        this.fforward = null;
        this.last = null;
        this.singleButton = null;
        this.continuousButton = null;
        this.continuousFacingButton = null;
        this.facingButton = null;
        this.pageFlowButton = null;
        this.snapshotButton = null;
        this.layoutGroup = null;
        if (this.topButtons != null) {
            this.topButtons.getItems().removeAll((Collection)this.topButtons.getItems());
        }
        this.topButtons = null;
    }

    @Override
    public void setBackNavigationButtonsEnabled(boolean bl) {
        this.back.setEnabled(bl);
        this.first.setEnabled(bl);
        this.fback.setEnabled(bl);
    }

    @Override
    public void setForwardNavigationButtonsEnabled(boolean bl) {
        this.forward.setEnabled(bl);
        this.last.setEnabled(bl);
        this.fforward.setEnabled(bl);
    }

    @Override
    public void setPageLayoutButtonsEnabled(boolean bl) {
        if (!this.isSingle) {
            return;
        }
        this.continuousButton.setEnabled(bl);
        this.continuousFacingButton.setEnabled(bl);
        this.facingButton.setEnabled(bl);
        this.pageFlowButton.setEnabled(bl);
        for (int i = 60; i < 62; ++i) {
            if (i == 61) continue;
            this.disableUnimplementedItems(i);
        }
        Iterator<CheckMenuItem> iterator = this.layoutGroup.iterator();
        if (iterator.hasNext()) {
            CheckMenuItem checkMenuItem = iterator.next();
            checkMenuItem.setDisable(false);
            while (iterator.hasNext()) {
                checkMenuItem = iterator.next();
                checkMenuItem.setDisable(!bl);
            }
        }
    }

    @Override
    public void alignLayoutMenuOption(int n) {
        int n2 = 1;
        for (CheckMenuItem checkMenuItem : this.layoutGroup) {
            checkMenuItem.setSelected(n2 == n);
            ++n2;
        }
    }

    public ArrayList<CheckMenuItem> getLayoutGroup() {
        return this.layoutGroup;
    }

    @Override
    public void checkButtonSeparators() {
        boolean bl = false;
        boolean bl2 = false;
        Separator separator = null;
        for (int i = 0; i != this.topButtons.getItems().size(); ++i) {
            if (this.topButtons.getItems().get(i) instanceof Separator) {
                if (separator == null) {
                    separator = (Separator)this.topButtons.getItems().get(i);
                    continue;
                }
                if (!bl || !bl2) {
                    separator.setVisible(false);
                } else {
                    separator.setVisible(true);
                }
                bl = bl || bl2;
                bl2 = false;
                separator = (Separator)this.topButtons.getItems().get(i);
                continue;
            }
            if (!((Node)this.topButtons.getItems().get(i)).isVisible()) continue;
            if (separator == null) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (separator != null) {
            if (!bl || !bl2) {
                separator.setVisible(false);
            } else {
                separator.setVisible(true);
            }
        }
    }

    public ToolBar getTopButtons() {
        return this.topButtons;
    }

    public void addButton(int n, String string, String string2, int n2, final GUIMenuItems gUIMenuItems, final GUIFactory gUIFactory, CommandListener commandListener, ToolBar toolBar, ToolBar toolBar2) {
        GUIButton gUIButton = new JavaFXButton();
        switch (n2) {
            case 50: {
                gUIButton = this.getButton(50);
                break;
            }
            case 51: {
                gUIButton = this.getButton(51);
                break;
            }
            case 52: {
                gUIButton = this.getButton(52);
                break;
            }
            case 53: {
                gUIButton = this.getButton(53);
                break;
            }
            case 54: {
                gUIButton = this.getButton(54);
                break;
            }
            case 55: {
                gUIButton = this.getButton(55);
                break;
            }
            case 13: {
                gUIButton = this.getButton(13);
                break;
            }
            case 57: {
                gUIButton = this.getButton(57);
                gUIButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        gUIMenuItems.setMenusForDisplayMode(57, -1);
                    }
                });
                break;
            }
            case 58: {
                gUIButton = this.getButton(58);
                gUIButton.setEnabled(false);
                ((JavaFXButton)gUIButton).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        gUIMenuItems.setMenusForDisplayMode(58, -1);
                    }
                });
                break;
            }
            case 59: {
                gUIButton = this.getButton(59);
                gUIButton.setEnabled(false);
                ((JavaFXButton)gUIButton).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        gUIMenuItems.setMenusForDisplayMode(59, -1);
                    }
                });
                break;
            }
            case 60: {
                gUIButton = this.getButton(60);
                gUIButton.setEnabled(false);
                break;
            }
            case 61: {
                gUIButton = this.getButton(61);
                gUIButton.setEnabled(false);
                break;
            }
            case 18: {
                gUIButton = this.getButton(18);
                gUIButton.setEnabled(false);
                gUIButton.setName("PREVIOUSRESULT");
                break;
            }
            case 19: {
                gUIButton = this.getButton(19);
                gUIButton.setEnabled(false);
                gUIButton.setName("NEXTRESULT");
                break;
            }
            case 10: {
                gUIButton = this.getButton(10);
                gUIButton.setName("open");
                break;
            }
            case 6: {
                gUIButton = this.getButton(6);
                gUIButton.setName("print");
                break;
            }
            case 12: {
                gUIButton = this.getButton(12);
                gUIButton.setName("search");
                break;
            }
            case 9: {
                gUIButton = this.getButton(9);
                break;
            }
            case 1: {
                gUIButton = this.getButton(1);
                break;
            }
            case 29: {
                gUIButton = this.getButton(29);
                gUIButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        if (gUIFactory.getPdfDecoder().getDisplayView() == 1) {
                            gUIMenuItems.setMenusForDisplayMode(29, gUIFactory.getCommand().getMouseMode().getMouseMode());
                        }
                    }
                });
                gUIButton.setName("mousemode");
            }
        }
        gUIButton.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    ((JavaFXButton)mouseEvent.getSource()).setCursor(Cursor.HAND);
                }
            }
        });
        ((JavaFXButton)gUIButton).setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    ((JavaFXButton)mouseEvent.getSource()).setCursor(Cursor.DEFAULT);
                }
            }
        });
        gUIButton.init(gUIFactory.getGUICursor().getURLForImage(string2), n2, string);
        ((JavaFXButton)gUIButton).setOnAction((EventHandler)commandListener.getCommandListener());
        int n3 = gUIFactory.getValues().getModeOfOperation();
        if (n == 0 || n3 == 4) {
            this.topButtons.getItems().add((Object)((Button)gUIButton));
        } else if (n == 1) {
            toolBar2.getItems().add((Object)((Button)gUIButton));
        } else if (n == 2) {
            toolBar.getItems().add((Object)((Button)gUIButton));
        }
        this.disableUnimplementedItems(n2);
    }

    @Override
    public void hideRedundentNavButtons(GUIFactory gUIFactory) {
        int n = gUIFactory.getPdfDecoder().getPageCount();
        if (gUIFactory.getValues().isMultiTiff()) {
            n = gUIFactory.getValues().getPageCount();
        }
        if ((gUIFactory.getPdfDecoder().getDisplayView() == 4 && gUIFactory.getPdfDecoder().getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || gUIFactory.getPdfDecoder().getDisplayView() == 3) && (n & 1) == 1) {
            --n;
        }
        if (gUIFactory.getValues().getCurrentPage() == 1) {
            this.setBackNavigationButtonsEnabled(false);
            gUIFactory.getMenuItems().setBackNavigationItemsEnabled(false);
        } else {
            this.setBackNavigationButtonsEnabled(true);
            gUIFactory.getMenuItems().setBackNavigationItemsEnabled(true);
        }
        if (gUIFactory.getValues().getCurrentPage() == n) {
            this.setForwardNavigationButtonsEnabled(false);
            gUIFactory.getMenuItems().setForwardNavigationItemsEnabled(false);
        } else {
            this.setForwardNavigationButtonsEnabled(true);
            gUIFactory.getMenuItems().setForwardNavigationItemsEnabled(true);
        }
        gUIFactory.getMenuItems().setGoToNavigationItemEnabled(n != 1);
        if (gUIFactory.getThumbnailScrollBar() != null) {
            if (gUIFactory.getPdfDecoder().getDisplayView() == 1) {
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_NEVER);
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_NEVER);
                gUIFactory.setThumbnailScrollBarVisibility(true);
            } else if (gUIFactory.getPdfDecoder().getDisplayView() == 5) {
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_NEVER);
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_NEVER);
                gUIFactory.setThumbnailScrollBarVisibility(false);
            } else {
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.VERTICAL_AS_NEEDED);
                gUIFactory.setScrollBarPolicy(GUI.ScrollPolicy.HORIZONTAL_AS_NEEDED);
                gUIFactory.setThumbnailScrollBarVisibility(false);
            }
        }
    }

    public static void setupButtonStyle() {
    }

    @Override
    public void setVisible(boolean bl) {
        this.topButtons.setVisible(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.topButtons.setDisable(!bl);
    }

    public void disableUnimplementedItems(int n) {
        if (n != -10) {
            switch (n) {
                case 6: {
                    this.printButton.setEnabled(false);
                    break;
                }
                case 13: {
                    this.snapshotButton.setEnabled(false);
                    break;
                }
                case 59: {
                    this.continuousFacingButton.setEnabled(false);
                    break;
                }
                case 61: {
                    this.pageFlowButton.setEnabled(false);
                    break;
                }
                case 58: {
                    this.continuousButton.setEnabled(false);
                }
            }
        } else {
            this.printButton.setEnabled(false);
            this.snapshotButton.setEnabled(false);
            this.continuousFacingButton.setEnabled(false);
            this.facingButton.setEnabled(false);
            this.continuousButton.setEnabled(false);
        }
    }
}

