/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Map;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.generic.GUILayersPanel;
import org.jpedal.objects.layers.PdfLayerList;

public class JavaFXLayersPanel
extends Tab
implements GUILayersPanel {
    private final BorderPane content;
    private final TreeItem<String> metaDataRoot;
    private final TreeView<String> layersTree;

    public JavaFXLayersPanel() {
        TreeView treeView = new TreeView();
        this.content = new BorderPane();
        this.layersTree = new TreeView();
        this.metaDataRoot = new TreeItem((Object)"Info");
        treeView.setRoot(this.metaDataRoot);
        treeView.setShowRoot(true);
        treeView.setTooltip(new Tooltip("Double click to see any metadata"));
        treeView.setPrefHeight(60.0);
        this.layersTree.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> treeView) {
                return new LayersCell();
            }
        });
        this.layersTree.setShowRoot(true);
        this.content.setTop((Node)treeView);
        this.content.setCenter(this.layersTree);
        this.setContent((Node)this.content);
    }

    @Override
    public void reinitialise(final PdfLayerList pdfLayerList, final PdfDecoderInt pdfDecoderInt, Object object, final int n) {
        this.metaDataRoot.getChildren().clear();
        this.layersTree.setRoot(null);
        Map map = pdfLayerList.getMetaData();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            this.metaDataRoot.getChildren().add((Object)new TreeItem((Object)(k + "=" + v)));
        }
        Object[] objectArray = pdfLayerList.getDisplayTree();
        if (objectArray != null) {
            TreeItem treeItem = new TreeItem((Object)"Layers");
            JavaFXLayersPanel.addLayersToTree(objectArray, (TreeItem<String>)treeItem, true, pdfLayerList);
            treeItem.addEventHandler(CheckBoxTreeItem.checkBoxSelectionChangedEvent(), (EventHandler)new EventHandler<CheckBoxTreeItem.TreeModificationEvent<String>>(){

                public void handle(CheckBoxTreeItem.TreeModificationEvent<String> treeModificationEvent) {
                    final CheckBoxTreeItem checkBoxTreeItem = treeModificationEvent.getTreeItem();
                    StringBuilder stringBuilder = new StringBuilder((String)checkBoxTreeItem.getValue());
                    TreeItem treeItem = checkBoxTreeItem.getParent();
                    while (treeItem.getParent() != null) {
                        stringBuilder.append('\uffff').append(treeItem.getValue());
                        treeItem = treeItem.getParent();
                    }
                    final String string = stringBuilder.toString();
                    if (pdfLayerList.isLayerName(string) && !pdfLayerList.isLocked(string)) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                pdfLayerList.setVisiblity(string, checkBoxTreeItem.isSelected());
                                try {
                                    pdfDecoderInt.decodePage(n);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        };
                        if (Platform.isFxApplicationThread()) {
                            runnable.run();
                        } else {
                            Platform.runLater((Runnable)runnable);
                        }
                    }
                }
            });
            treeItem.setExpanded(true);
            this.layersTree.setRoot(treeItem);
        }
    }

    private static void addLayersToTree(Object[] objectArray, TreeItem<String> treeItem, boolean bl, PdfLayerList pdfLayerList) {
        TreeItem treeItem2 = treeItem;
        boolean bl2 = bl;
        boolean bl3 = true;
        for (Object object : objectArray) {
            Object object2;
            if (object instanceof Object[]) {
                object2 = treeItem2;
                JavaFXLayersPanel.addLayersToTree((Object[])object, treeItem2, bl && bl3, pdfLayerList);
                treeItem2 = object2;
                bl = bl2;
                continue;
            }
            bl2 = bl;
            if (object == null) continue;
            String string = object instanceof String ? (String)object : new String((byte[])object);
            object2 = string;
            int n = string.indexOf(65535);
            if (n != -1) {
                object2 = ((String)object2).substring(0, n);
            }
            if (string.endsWith(" R")) continue;
            if (!pdfLayerList.isLayerName(string)) {
                treeItem2 = new TreeItem(object2);
                treeItem.getChildren().add((Object)treeItem2);
                treeItem = treeItem2;
                bl3 = true;
                continue;
            }
            if (treeItem == null) continue;
            treeItem2 = new CheckBoxTreeItem(object2);
            treeItem.getChildren().add((Object)treeItem2);
            if (pdfLayerList.isVisible(string)) {
                ((CheckBoxTreeItem)treeItem2).setSelected(true);
                bl3 = true;
            } else {
                ((CheckBoxTreeItem)treeItem2).setSelected(false);
                bl3 = false;
            }
            if (!bl) continue;
            bl = !pdfLayerList.isLocked(string);
        }
    }

    @Override
    public void rescanPdfLayers() {
    }

    @Override
    public void resetLayers() {
    }

    private static class LayersCell
    extends CheckBoxTreeCell<String> {
        private LayersCell() {
        }

        public void updateItem(String string, boolean bl) {
            super.updateItem((Object)string, bl);
            if (bl) {
                this.setGraphic(null);
                this.setText(null);
            } else if (!(this.getTreeItem() instanceof CheckBoxTreeItem)) {
                this.setGraphic(null);
            }
        }
    }
}

