/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCombination;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButtons;
import org.jpedal.examples.viewer.gui.javafx.JavaFXCheckBoxMenuItem;
import org.jpedal.examples.viewer.gui.javafx.JavaFXID;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMenuItem;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class JavaFXMenuItems
extends GUIMenuItems {
    private MenuBar currentMenu = new MenuBar();
    private Menu fileMenu;
    private Menu openMenu;
    private MenuItem open;
    private MenuItem openUrl;
    private MenuItem save;
    private MenuItem reSaveAsForms;
    private MenuItem find;
    private MenuItem documentProperties;
    private MenuItem signPDF;
    private MenuItem print;
    private MenuItem exit;
    private Menu editMenu;
    private MenuItem copy;
    private MenuItem selectAll;
    private MenuItem deselectAll;
    private MenuItem preferences;
    private Menu viewMenu;
    private Menu goToMenu;
    private MenuItem firstPage;
    private MenuItem backPage;
    private MenuItem forwardPage;
    private MenuItem lastPage;
    private MenuItem goTo;
    private MenuItem previousDocument;
    private MenuItem nextDocument;
    private Menu pageLayoutMenu;
    private MenuItem single;
    private MenuItem continuous;
    private MenuItem facing;
    private MenuItem continuousFacing;
    private MenuItem pageFlow;
    private CheckMenuItem textSelect;
    private CheckMenuItem separateCover;
    private CheckMenuItem panMode;
    private MenuItem fullscreen;
    private Menu windowMenu;
    private MenuItem cascade;
    private MenuItem tile;
    private Menu helpMenu;
    private MenuItem visitWebsite;
    private MenuItem tipOfTheDay;
    private MenuItem about;
    private Menu exportMenu;
    private Menu pdfMenu;
    private Menu contentMenu;
    private Menu pageToolsMenu;
    private MenuItem onePerPage;
    private MenuItem nup;
    private MenuItem handouts;
    private MenuItem images;
    private MenuItem text;
    private MenuItem bitmap;
    private MenuItem rotatePages;
    private MenuItem deletePages;
    private MenuItem addPage;
    private MenuItem addHeaderFooter;
    private MenuItem stampText;
    private MenuItem stampImage;
    private MenuItem crop;

    public JavaFXMenuItems(PropertiesFile propertiesFile) {
        super(propertiesFile);
    }

    private Menu getMenu(int n) {
        switch (n) {
            case 317: {
                return this.fileMenu;
            }
            case 310: {
                return this.editMenu;
            }
            case 316: {
                return this.openMenu;
            }
            case 312: {
                return this.viewMenu;
            }
            case 311: {
                return this.goToMenu;
            }
            case 309: {
                return this.pageLayoutMenu;
            }
            case 998: {
                return this.helpMenu;
            }
            case 308: {
                return this.windowMenu;
            }
        }
        return null;
    }

    private MenuItem getMenuItem(int n) {
        switch (n) {
            case 317: {
                return this.fileMenu;
            }
            case 316: {
                return this.openMenu;
            }
            case 10: {
                return this.open;
            }
            case 14: {
                return this.openUrl;
            }
            case 5: {
                return this.save;
            }
            case 315: {
                return this.reSaveAsForms;
            }
            case 12: {
                return this.find;
            }
            case 9: {
                return this.documentProperties;
            }
            case 512: {
                return this.signPDF;
            }
            case 6: {
                return this.print;
            }
            case 7: {
                return this.exit;
            }
            case 310: {
                return this.editMenu;
            }
            case 25: {
                return this.copy;
            }
            case 26: {
                return this.selectAll;
            }
            case 27: {
                return this.deselectAll;
            }
            case 24: {
                return this.preferences;
            }
            case 312: {
                return this.viewMenu;
            }
            case 311: {
                return this.goToMenu;
            }
            case 50: {
                return this.firstPage;
            }
            case 52: {
                return this.backPage;
            }
            case 53: {
                return this.forwardPage;
            }
            case 55: {
                return this.lastPage;
            }
            case 56: {
                return this.goTo;
            }
            case 16: {
                return this.previousDocument;
            }
            case 17: {
                return this.nextDocument;
            }
            case 309: {
                return this.pageLayoutMenu;
            }
            case 57: {
                return this.single;
            }
            case 58: {
                return this.continuous;
            }
            case 60: {
                return this.facing;
            }
            case 59: {
                return this.continuousFacing;
            }
            case 61: {
                return this.pageFlow;
            }
            case 31: {
                return this.textSelect;
            }
            case 32: {
                return this.separateCover;
            }
            case 30: {
                return this.panMode;
            }
            case 62: {
                return this.fullscreen;
            }
            case 308: {
                return this.windowMenu;
            }
            case 21: {
                return this.cascade;
            }
            case 22: {
                return this.tile;
            }
            case 307: {
                return this.exportMenu;
            }
            case 306: {
                return this.pdfMenu;
            }
            case 305: {
                return this.onePerPage;
            }
            case 510: {
                return this.nup;
            }
            case 304: {
                return this.contentMenu;
            }
            case 3: {
                return this.images;
            }
            case 4: {
                return this.text;
            }
            case 2: {
                return this.bitmap;
            }
            case 511: {
                return this.handouts;
            }
            case 303: {
                return this.pageToolsMenu;
            }
            case 502: {
                return this.rotatePages;
            }
            case 503: {
                return this.deletePages;
            }
            case 504: {
                return this.addPage;
            }
            case 506: {
                return this.addHeaderFooter;
            }
            case 507: {
                return this.stampText;
            }
            case 508: {
                return this.stampImage;
            }
            case 301: {
                return this.crop;
            }
            case 998: {
                return this.helpMenu;
            }
            case 15: {
                return this.visitWebsite;
            }
            case 20: {
                return this.tipOfTheDay;
            }
            case 1: {
                return this.about;
            }
        }
        return null;
    }

    public MenuBar getCurrentMenuFX() {
        return this.currentMenu;
    }

    @Override
    public void dispose() {
        if (this.currentMenu != null) {
            this.currentMenu.getMenus().removeAll((Collection)this.currentMenu.getMenus());
        }
        this.currentMenu = null;
    }

    @Override
    public void setCheckMenuItemSelected(int n, boolean bl) {
        switch (n) {
            case 31: {
                this.textSelect.setSelected(bl);
                break;
            }
            case 30: {
                this.panMode.setSelected(bl);
                break;
            }
            case 32: {
                this.separateCover.setSelected(bl);
                break;
            }
        }
    }

    @Override
    public void setBackNavigationItemsEnabled(boolean bl) {
        this.backPage.setDisable(!bl);
        this.firstPage.setDisable(!bl);
    }

    @Override
    public void setForwardNavigationItemsEnabled(boolean bl) {
        this.forwardPage.setDisable(!bl);
        this.lastPage.setDisable(!bl);
    }

    @Override
    public void setGoToNavigationItemEnabled(boolean bl) {
        this.goTo.setDisable(!bl);
    }

    protected void addMenuItem(Menu menu, String string, String string2, int n) {
        JavaFXID javaFXID;
        boolean bl = false;
        if (n == 32 || n == 30 || n == 31) {
            bl = true;
        }
        if (bl) {
            javaFXID = new JavaFXCheckBoxMenuItem(string);
            menu.getItems().add((Object)((CheckMenuItem)javaFXID));
        } else {
            javaFXID = new JavaFXMenuItem(string);
            menu.getItems().add((Object)((MenuItem)javaFXID));
        }
        if (!string2.isEmpty()) {
            javaFXID.setToolTipText(string2);
        }
        javaFXID.setID(n);
        JavaFXMenuItems.setKeyAccelerators(n, (MenuItem)javaFXID);
        javaFXID.setOnAction((EventHandler<ActionEvent>)((EventHandler)this.currentCommandListener.getCommandListener()));
        switch (n) {
            case 10: {
                this.open = (MenuItem)javaFXID;
                break;
            }
            case 14: {
                this.openUrl = (MenuItem)javaFXID;
                break;
            }
            case 5: {
                this.save = (MenuItem)javaFXID;
                break;
            }
            case 500: {
                this.reSaveAsForms = (MenuItem)javaFXID;
                this.reSaveAsForms.setId("resaveForms");
                break;
            }
            case 12: {
                this.find = (MenuItem)javaFXID;
                break;
            }
            case 9: {
                this.documentProperties = (MenuItem)javaFXID;
                break;
            }
            case 512: {
                this.signPDF = (MenuItem)javaFXID;
                break;
            }
            case 6: {
                this.print = (MenuItem)javaFXID;
                break;
            }
            case 7: {
                this.exit = (MenuItem)javaFXID;
                this.exit.setId("exit");
                break;
            }
            case 25: {
                this.copy = (MenuItem)javaFXID;
                break;
            }
            case 26: {
                this.selectAll = (MenuItem)javaFXID;
                break;
            }
            case 27: {
                this.deselectAll = (MenuItem)javaFXID;
                break;
            }
            case 24: {
                this.preferences = (MenuItem)javaFXID;
                break;
            }
            case 50: {
                this.firstPage = (MenuItem)javaFXID;
                break;
            }
            case 52: {
                this.backPage = (MenuItem)javaFXID;
                break;
            }
            case 53: {
                this.forwardPage = (MenuItem)javaFXID;
                break;
            }
            case 55: {
                this.lastPage = (MenuItem)javaFXID;
                break;
            }
            case 56: {
                this.goTo = (MenuItem)javaFXID;
                break;
            }
            case 16: {
                this.previousDocument = (MenuItem)javaFXID;
                break;
            }
            case 17: {
                this.nextDocument = (MenuItem)javaFXID;
                break;
            }
            case 62: {
                this.fullscreen = (MenuItem)javaFXID;
                break;
            }
            case 29: {
                this.fullscreen = (MenuItem)javaFXID;
                break;
            }
            case 30: {
                this.panMode = (CheckMenuItem)javaFXID;
                this.panMode.setSelected(false);
                break;
            }
            case 31: {
                this.textSelect = (CheckMenuItem)javaFXID;
                this.textSelect.setSelected(true);
                break;
            }
            case 32: {
                this.separateCover = (CheckMenuItem)javaFXID;
                boolean bl2 = this.properties.getValue("separateCoverOn").equalsIgnoreCase("true");
                this.separateCover.setSelected(true);
                GUIDisplay.default_separateCover = bl2;
                break;
            }
            case 21: {
                this.cascade = (MenuItem)javaFXID;
                break;
            }
            case 22: {
                this.tile = (MenuItem)javaFXID;
                break;
            }
            case 501: {
                this.onePerPage = (MenuItem)javaFXID;
                break;
            }
            case 510: {
                this.nup = (MenuItem)javaFXID;
                break;
            }
            case 511: {
                this.handouts = (MenuItem)javaFXID;
                break;
            }
            case 3: {
                this.images = (MenuItem)javaFXID;
                break;
            }
            case 4: {
                this.text = (MenuItem)javaFXID;
                break;
            }
            case 2: {
                this.bitmap = (MenuItem)javaFXID;
                break;
            }
            case 502: {
                this.rotatePages = (MenuItem)javaFXID;
                break;
            }
            case 503: {
                this.deletePages = (MenuItem)javaFXID;
                break;
            }
            case 504: {
                this.addPage = (MenuItem)javaFXID;
                break;
            }
            case 506: {
                this.addHeaderFooter = (MenuItem)javaFXID;
                break;
            }
            case 507: {
                this.stampText = (MenuItem)javaFXID;
                break;
            }
            case 508: {
                this.stampImage = (MenuItem)javaFXID;
                break;
            }
            case 509: {
                this.crop = (MenuItem)javaFXID;
                break;
            }
            case 15: {
                this.visitWebsite = (MenuItem)javaFXID;
                break;
            }
            case 20: {
                this.tipOfTheDay = (MenuItem)javaFXID;
                break;
            }
            case 1: {
                this.about = (MenuItem)javaFXID;
                break;
            }
        }
        this.disableUnimplementedItems(n, false);
    }

    protected void initLayoutMenus(Menu menu, String[] stringArray, int[] nArray, GUIButtons gUIButtons, final Commands commands, boolean bl) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            CheckMenuItem checkMenuItem = new CheckMenuItem(stringArray[i]);
            if (i == 0) {
                checkMenuItem.setSelected(true);
            }
            if (menu != null) {
                switch (nArray[i]) {
                    case 1: {
                        ((JavaFXButtons)gUIButtons).getLayoutGroup().add(checkMenuItem);
                        this.single = checkMenuItem;
                        this.single.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent actionEvent) {
                                commands.executeCommand(57, null);
                            }
                        });
                        menu.getItems().add((Object)this.single);
                    }
                }
            }
            this.disableUnimplementedItems(nArray[i], true);
        }
        if (!bl) {
            return;
        }
        gUIButtons.setPageLayoutButtonsEnabled(false);
    }

    @Override
    public void setMenusForDisplayMode(int n, int n2) {
        block0 : switch (n) {
            case 57: {
                this.textSelect.setDisable(true);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(true);
                this.panMode.setSelected(false);
                break;
            }
            case 61: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(false);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 58: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 59: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 60: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 29: {
                switch (n2) {
                    case 0: {
                        this.textSelect.setSelected(true);
                        this.panMode.setSelected(false);
                        break block0;
                    }
                    case 1: {
                        this.textSelect.setSelected(false);
                        this.panMode.setSelected(true);
                    }
                }
            }
        }
    }

    protected void addToMainMenu(Menu menu) {
        this.currentMenu.getMenus().add((Object)menu);
        this.currentMenu.setUseSystemMenuBar(true);
    }

    @Override
    public void createMainMenu(boolean bl, CommandListener commandListener, boolean bl2, Values values, Commands commands, GUIButtons gUIButtons) {
        this.currentCommandListener = commandListener;
        this.fileMenu = new Menu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.addToMainMenu(this.fileMenu);
        this.openMenu = new Menu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
        this.fileMenu.getItems().add((Object)this.openMenu);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
        String string = this.properties.getValue("Save") + this.properties.getValue("Resaveasforms") + this.properties.getValue("Find");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        if (bl) {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuFind.text"), Messages.getMessage("PdfViewerFileMenuTooltip.find"), 12);
        string = this.properties.getValue("Documentproperties");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        if (values.isEncrypOnClasspath()) {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSignPDF.text"), Messages.getMessage("PdfViewerFileMenuTooltip.sign"), 512);
        } else {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSignPDF.text"), Messages.getMessage("PdfViewerFileMenuSignPDF.NotPath"), 512);
        }
        string = this.properties.getValue("Print");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
        string = this.properties.getValue("Recentdocuments");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
            commands.recentDocumentsOption();
        }
        if (!(string = this.properties.getValue("Exit")).isEmpty() && string.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        this.editMenu = new Menu(Messages.getMessage("PdfViewerEditMenu.text"));
        this.addToMainMenu(this.editMenu);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuCopy.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Copy"), 25);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuSelectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Selectall"), 26);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuDeselectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Deselectall"), 27);
        string = this.properties.getValue("Preferences");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.editMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuPreferences.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Preferences"), 24);
        this.viewMenu = new Menu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.addToMainMenu(this.viewMenu);
        this.goToMenu = new Menu(Messages.getMessage("GoToViewMenuGoto.text"));
        this.viewMenu.getItems().add((Object)this.goToMenu);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        string = this.properties.getValue("Previousdocument") + this.properties.getValue("Nextdocument");
        if (!string.isEmpty() && string.equalsIgnoreCase("true")) {
            this.goToMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
        if (bl2) {
            this.pageLayoutMenu = new Menu(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            this.viewMenu.getItems().add((Object)this.pageLayoutMenu);
        }
        String[] stringArray = new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")};
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        if (bl2) {
            this.initLayoutMenus(this.pageLayoutMenu, stringArray, nArray, gUIButtons, commands, bl2);
        }
        if (this.properties.getValue("separateCover").equals("true")) {
            this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuSeparateCover.text"), Messages.getMessage("PdfViewerViewMenuTooltip.separateCover"), 32);
        }
        if (this.properties.getValue("panMode").equals("true") || this.properties.getValue("textSelect").equals("true")) {
            this.viewMenu.getItems().add((Object)new SeparatorMenuItem());
            if (this.properties.getValue("panMode").equals("true")) {
                this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuPanMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.panMode"), 30);
            }
            if (this.properties.getValue("textSelect").equals("true")) {
                this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuTextSelectMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.textSelect"), 31);
            }
            this.viewMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        if (!(string = this.properties.getValue("Fullscreen")).isEmpty() && string.equalsIgnoreCase("true")) {
            this.goToMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 62);
        if (!bl2) {
            this.windowMenu = new Menu(Messages.getMessage("PdfViewerWindowMenu.text"));
            this.addToMainMenu(this.windowMenu);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuCascade.text"), "", 21);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuTile.text"), "", 22);
        }
        this.exportMenu = new Menu(Messages.getMessage("PdfViewerExportMenu.text"));
        this.addToMainMenu(this.exportMenu);
        this.pdfMenu = new Menu(Messages.getMessage("PdfViewerExportMenuPDF.text"));
        this.exportMenu.getItems().add((Object)this.pdfMenu);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuOnePerPage.text"), "", 501);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuNUp.text"), "", 510);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuHandouts.text"), "", 511);
        this.contentMenu = new Menu(Messages.getMessage("PdfViewerExportMenuContent.text"));
        this.exportMenu.getItems().add((Object)this.contentMenu);
        this.addMenuItem(this.contentMenu, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
        this.addMenuItem(this.contentMenu, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
        this.addMenuItem(this.exportMenu, Messages.getMessage("PdfViewerExportMenuBitmap.text"), "", 2);
        this.pageToolsMenu = new Menu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
        this.addToMainMenu(this.pageToolsMenu);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
        if (bl) {
            // empty if block
        }
        this.helpMenu = new Menu(Messages.getMessage("PdfViewerHelpMenu.text"));
        this.addToMainMenu(this.helpMenu);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuTip.text"), "", 20);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
    }

    static void setKeyAccelerators(int n, MenuItem menuItem) {
        switch (n) {
            case 12: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+F"));
                break;
            }
            case 5: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+S"));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+P"));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+Q"));
                break;
            }
            case 9: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+D"));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+O"));
                break;
            }
            case 14: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+U"));
                break;
            }
            case 16: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+LEFT+SHIFT"));
                break;
            }
            case 17: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+RIGHT+SHIFT"));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+HOME"));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+UP"));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+DOWN"));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+END"));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+N+SHIFT"));
                break;
            }
            case 2: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+B"));
                break;
            }
            case 25: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+C"));
                break;
            }
            case 26: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+A"));
                break;
            }
            case 27: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+A+SHIFT"));
                break;
            }
            case 24: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+K"));
            }
        }
    }

    @Override
    public void ensureNoSeperators() {
        this.ensureNoSeperators(317);
        this.ensureNoSeperators(310);
        this.ensureNoSeperators(312);
        this.ensureNoSeperators(311);
    }

    @Override
    public void ensureNoSeperators(int n) {
        for (int i = 0; i != ((Menu)this.getMenuItem(n)).getItems().size(); ++i) {
            if (!((MenuItem)((Menu)this.getMenuItem(n)).getItems().get(i)).isVisible()) continue;
            if (!(((Menu)this.getMenuItem(n)).getItems().get(i) instanceof SeparatorMenuItem)) break;
            ((Menu)this.getMenuItem(n)).getItems().remove(i);
            break;
        }
    }

    @Override
    public boolean isMenuItemExist(int n) {
        return this.getMenuItem(n) != null;
    }

    @Override
    public void setMenuItem(int n, boolean bl, boolean bl2) {
        if (n == 300 && this.currentMenu != null) {
            this.currentMenu.setDisable(!bl);
            this.currentMenu.setVisible(bl2);
        } else if (this.getMenuItem(n) != null) {
            this.getMenuItem(n).setDisable(!bl);
            this.getMenuItem(n).setVisible(bl2);
        }
        if (n == 62 && DecoderOptions.isRunningOnMac) {
            this.fullscreen.setDisable(true);
        }
    }

    @Override
    public void addToMenu(Object object, int n) {
        this.getMenu(n).getItems().add((Object)((MenuItem)object));
    }

    public void disableUnimplementedItems(int n, boolean bl) {
        if (n != -10) {
            if (!bl) {
                switch (n) {
                    case 32: {
                        this.separateCover.setDisable(true);
                        break;
                    }
                    case 12: {
                        this.find.setDisable(true);
                        break;
                    }
                    case 500: {
                        this.reSaveAsForms.setDisable(true);
                        break;
                    }
                    case 512: {
                        this.signPDF.setDisable(true);
                        break;
                    }
                    case 6: {
                        this.print.setDisable(true);
                    }
                }
            }
        } else {
            this.separateCover.setDisable(true);
            this.reSaveAsForms.setDisable(true);
            this.signPDF.setDisable(true);
            this.print.setDisable(true);
        }
    }
}

