/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.io.File;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMousePageTurn;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMousePanMode;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseSelector;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;

public class JavaFXMouseListener
extends MouseSelector
implements GUIMouseHandler {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    final JavaFXMouseSelector selectionFunctions;
    final JavaFXMousePanMode panningFunctions;
    final JavaFXMousePageTurn pageTurnFunctions;
    private boolean dragging = false;
    private static JavaFXMouseFunctionality customMouseFunctions;
    private double cx;
    private double cy;
    private static final String message = "";
    private MouseMode mouseMode = new MouseMode();

    public JavaFXMouseListener(PdfDecoderFX pdfDecoderFX, GUIFactory gUIFactory, Values values, Commands commands) {
        this.decode_pdf = pdfDecoderFX;
        this.currentGUI = gUIFactory;
        this.commonValues = values;
        this.currentCommands = commands;
        this.mouseMode = commands.getMouseMode();
        this.selectionFunctions = new JavaFXMouseSelector(pdfDecoderFX, gUIFactory, values, commands);
        this.panningFunctions = new JavaFXMousePanMode(pdfDecoderFX);
        this.pageTurnFunctions = new JavaFXMousePageTurn(pdfDecoderFX, gUIFactory, values, commands);
    }

    @Override
    public void setupMouse() {
        this.decode_pdf.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.dragging = true;
                JavaFXMouseListener.this.mouseDragged(mouseEvent);
            }
        });
        this.decode_pdf.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.mouseMoved(mouseEvent);
            }
        });
        this.decode_pdf.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (JavaFXMouseListener.this.dragging) {
                    JavaFXMouseListener.this.dragging = false;
                } else {
                    JavaFXMouseListener.this.mouseClicked(mouseEvent);
                }
            }
        });
        this.decode_pdf.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.mouseEntered(mouseEvent);
            }
        });
        this.decode_pdf.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.mouseExited(mouseEvent);
            }
        });
        this.decode_pdf.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.dragging = false;
                JavaFXMouseListener.this.mousePressed(mouseEvent);
            }
        });
        this.decode_pdf.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXMouseListener.this.mouseReleased(mouseEvent);
            }
        });
        this.decode_pdf.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                JavaFXMouseListener.mouseDragOver(dragEvent);
            }
        });
        this.decode_pdf.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent dragEvent) {
                JavaFXMouseListener.this.mouseDragDropped(dragEvent);
            }
        });
        this.decode_pdf.setDefaultCursor(Cursor.DEFAULT);
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mouseReleased(mouseEvent);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mouseReleased(mouseEvent);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseReleased(mouseEvent);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseReleased(mouseEvent);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseReleased(mouseEvent);
            }
        }
    }

    public static void setCustomMouseFunctions(JavaFXMouseFunctionality javaFXMouseFunctionality) {
        customMouseFunctions = javaFXMouseFunctionality;
    }

    private void mouseDragDropped(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        boolean bl = false;
        if (dragboard.hasFiles()) {
            bl = true;
            final File file = (File)dragboard.getFiles().get(0);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        JavaFXMouseListener.this.currentCommands.handleTransferedFile(file.getAbsolutePath());
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            });
        }
        dragEvent.setDropCompleted(bl);
        dragEvent.consume();
    }

    private static void mouseDragOver(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        boolean bl = ((File)dragboard.getFiles().get(0)).getName().toLowerCase().endsWith(".pdf");
        if (dragboard.hasFiles()) {
            if (bl) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        } else {
            dragEvent.consume();
        }
    }

    private void mouseClicked(MouseEvent mouseEvent) {
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                if (!this.decode_pdf.isOpen()) break;
                this.selectionFunctions.mouseClicked(mouseEvent);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseClicked(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseClicked(mouseEvent);
        }
    }

    private void mouseEntered(MouseEvent mouseEvent) {
        this.currentGUI.enableMemoryBar(true, false);
        this.currentGUI.enableCursor(true, true);
        this.currentGUI.setMultibox(new int[]{1, 1});
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseEntered(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseEntered(mouseEvent);
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mousePressed(mouseEvent);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mousePressed(mouseEvent);
                    break;
                }
                case 1: {
                    this.panningFunctions.mousePressed(mouseEvent);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mousePressed(mouseEvent);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mousePressed(mouseEvent);
            }
        }
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        int n = (int)mouseEvent.getX();
        int n2 = (int)mouseEvent.getY();
        this.updateCoords(n, n2);
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                if (!this.currentCommands.extractingAsImage && this.decode_pdf.isOpen()) {
                    int n3 = this.decode_pdf.getPageNumber();
                    int n4 = this.decode_pdf.getPdfPageData().getCropBoxX(n3);
                    int n5 = this.decode_pdf.getPdfPageData().getCropBoxY(n3);
                    this.getObjectUnderneath((int)this.cx + n4, (int)this.cy + n5);
                }
                this.selectionFunctions.mouseMoved(mouseEvent);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseMoved(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseMoved(mouseEvent);
        }
    }

    private void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.panningFunctions.mouseDragged(mouseEvent);
        } else {
            switch (this.mouseMode.getMouseMode()) {
                case 0: {
                    this.selectionFunctions.mouseDragged(mouseEvent);
                    break;
                }
                case 1: {
                    this.panningFunctions.mouseDragged(mouseEvent);
                }
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
                this.pageTurnFunctions.mouseDragged(mouseEvent);
            }
            if (customMouseFunctions != null) {
                customMouseFunctions.mouseDragged(mouseEvent);
            }
        }
    }

    private void mouseExited(MouseEvent mouseEvent) {
        this.currentGUI.enableCursor(true, false);
        this.currentGUI.enableMemoryBar(true, true);
        this.currentGUI.setMultibox(new int[]{1, 0});
        switch (this.mouseMode.getMouseMode()) {
            case 0: {
                this.selectionFunctions.mouseExited(mouseEvent);
                break;
            }
        }
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.pageTurnFunctions.mouseExited(mouseEvent);
        }
        if (customMouseFunctions != null) {
            customMouseFunctions.mouseExited(mouseEvent);
        }
    }

    public double[] getCursorLocation() {
        return new double[]{this.cx, this.cy};
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader) {
        this.pageTurnFunctions.checkLinks(bl, pdfObjectReader, this.cx, this.cy);
    }

    public void updateCordsFromFormComponent(MouseEvent mouseEvent) {
        double d = (int)mouseEvent.getX();
        double d2 = (int)mouseEvent.getY();
        this.updateCoords(d, d2);
    }

    public void updateCoords(double d, double d2) {
        int n;
        this.cx = d;
        this.cy = d2;
        if (this.decode_pdf.getDisplayView() != 1) {
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 3) {
                if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPageNumber() < this.decode_pdf.getPageCount() && this.cx >= (double)(n = this.decode_pdf.getPdfPageData().getCropBoxWidth(this.decode_pdf.getPageNumber()))) {
                    this.cx -= (double)n;
                }
            } else {
                this.cx = 0.0;
                this.cy = 0.0;
            }
        }
        n = this.decode_pdf.getPageNumber();
        int n2 = this.decode_pdf.getPdfPageData().getCropBoxX(n);
        int n3 = this.decode_pdf.getPdfPageData().getCropBoxY(n);
        Bounds bounds = this.decode_pdf.getBoundsInLocal();
        if (Values.isProcessing() || this.commonValues.getSelectedFile() == null) {
            this.currentGUI.setCoordText("  X:  Y:   ");
        } else if (this.cx >= 0.0 && this.cy >= 0.0 && this.cx <= bounds.getMaxX() - (double)this.currentGUI.getDropShadowDepth() && this.cy <= bounds.getMaxY() - (double)this.currentGUI.getDropShadowDepth()) {
            this.currentGUI.setCoordText("  X: " + (this.cx + (double)n2) + " Y: " + (this.cy + (double)n3) + ' ' + ' ' + message);
        }
    }

    protected void scrollAndUpdateCoords(MouseEvent mouseEvent) {
        int n = (int)mouseEvent.getX();
        int n2 = (int)mouseEvent.getY();
        this.updateCoords(n, n2);
    }

    private void getObjectUnderneath(int n, int n2) {
        if (this.decode_pdf.getDisplayView() == 1) {
            int n3 = this.decode_pdf.getDynamicRenderer().getObjectUnderneath(n, n2);
            switch (n3) {
                case -1: {
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    break;
                }
                case 1: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 3: {
                    this.decode_pdf.setCursor(Cursor.CROSSHAIR);
                    break;
                }
                case 4: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 5: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                    break;
                }
                case 6: {
                    this.decode_pdf.setCursor(Cursor.TEXT);
                }
            }
        }
    }
}

