/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.Light;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPageNavigator;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class JavaFXMousePageTurn
extends MouseSelector
implements JavaFXMouseFunctionality {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private long lastPress;
    private boolean drawingTurnover;
    private boolean previewTurnover;
    private double middleDragStartX;
    private double middleDragStartY;
    private double xVelocity;
    private double yVelocity;
    private Timer middleDragTimer;
    long timeOfLastPageChange;
    final DisplayOffsets offsets;

    public JavaFXMousePageTurn(PdfDecoderFX pdfDecoderFX, GUIFactory gUIFactory, Values values, Commands commands) {
        this.decode_pdf = pdfDecoderFX;
        this.currentGUI = gUIFactory;
        this.commonValues = values;
        this.currentCommands = commands;
        this.offsets = (DisplayOffsets)pdfDecoderFX.getExternalHandler(37);
    }

    public void checkLinks(boolean bl, PdfObjectReader pdfObjectReader, double d, double d2) {
        Map map = this.currentGUI.getHotspots();
        if (map != null) {
            ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).checkLinks(map, bl, pdfObjectReader, (int)d, (int)d2, this.currentGUI, this.commonValues);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 1 && mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && this.decode_pdf.getExternalHandler(25) != null) {
            double d = mouseEvent.getX();
            double d2 = mouseEvent.getY();
            int[] nArray = JavaFXMousePageTurn.updateXY((int)d, (int)d2, this.decode_pdf, this.commonValues);
            this.checkLinks(true, this.decode_pdf.getIO(), nArray[0], nArray[1]);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.previewTurnover && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4 && mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.drawingTurnover = true;
            this.decode_pdf.setCursor(Cursor.CLOSED_HAND);
            this.lastPress = System.currentTimeMillis();
        }
        if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.middleDragStartX = mouseEvent.getX() - this.decode_pdf.getLayoutX();
            this.middleDragStartY = mouseEvent.getY() - this.decode_pdf.getLayoutY();
            this.decode_pdf.setCursor(Cursor.MOVE);
            if (this.middleDragTimer == null) {
                this.middleDragTimer = new Timer();
            }
            this.middleDragTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (JavaFXMousePageTurn.this.xVelocity < -2.0) {
                                if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.NW_RESIZE);
                                } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.SW_RESIZE);
                                } else {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.E_RESIZE);
                                }
                            } else if (JavaFXMousePageTurn.this.xVelocity > 2.0) {
                                if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.NE_RESIZE);
                                } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.SE_RESIZE);
                                } else {
                                    JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.E_RESIZE);
                                }
                            } else if (JavaFXMousePageTurn.this.yVelocity < -2.0) {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.N_RESIZE);
                            } else if (JavaFXMousePageTurn.this.yVelocity > 2.0) {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.S_RESIZE);
                            } else {
                                JavaFXMousePageTurn.this.decode_pdf.setCursor(Cursor.MOVE);
                            }
                        }
                    });
                }
            }, 100L);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && this.decode_pdf.getDisplayView() == 4) {
            this.drawingTurnover = false;
            boolean bl = this.offsets.getDragLeft();
            boolean bl2 = this.offsets.getDragTop();
            if (this.lastPress + 200L > System.currentTimeMillis()) {
                if (bl) {
                    this.currentCommands.executeCommand(52, null);
                } else {
                    this.currentCommands.executeCommand(53, null);
                }
                this.previewTurnover = false;
                this.decode_pdf.setCursor(Cursor.DEFAULT);
            } else {
                Light.Point point = new Light.Point();
                point.setY((double)this.decode_pdf.getInsetH());
                if (!bl2) {
                    point.setY(point.getY() + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling()));
                }
                if (bl) {
                    point.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                } else {
                    point.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)((float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling()));
                }
                Light.Point point2 = new Light.Point();
                point2.setX(mouseEvent.getX());
                point2.setY(mouseEvent.getY());
                this.testFall(point, point2, bl);
            }
        }
        if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.xVelocity = 0.0;
            this.yVelocity = 0.0;
            this.decode_pdf.setCursor(Cursor.DEFAULT);
            this.middleDragTimer.cancel();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            if (this.decode_pdf.getExternalHandler(25) != null) {
                int[] nArray = JavaFXMousePageTurn.updateXY((int)mouseEvent.getX(), (int)mouseEvent.getY(), this.decode_pdf, this.commonValues);
                this.checkLinks(true, this.decode_pdf.getIO(), nArray[0], nArray[1]);
            }
            if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && (this.drawingTurnover || this.previewTurnover) && this.decode_pdf.getDisplayView() == 4) {
                this.decode_pdf.setCursor(Cursor.CLOSED_HAND);
                if (this.offsets.getDragLeft()) {
                    if (this.offsets.getDragTop()) {
                        this.decode_pdf.setUserOffsets((int)mouseEvent.getX(), (int)mouseEvent.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)mouseEvent.getX(), (int)mouseEvent.getY(), 998);
                    }
                } else if (this.offsets.getDragTop()) {
                    this.decode_pdf.setUserOffsets((int)mouseEvent.getX(), (int)mouseEvent.getY(), 997);
                } else {
                    this.decode_pdf.setUserOffsets((int)mouseEvent.getX(), (int)mouseEvent.getY(), 999);
                }
            }
        } else if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
            this.xVelocity = (mouseEvent.getX() - this.decode_pdf.getLayoutX() - this.middleDragStartX) / 4.0;
            this.yVelocity = (mouseEvent.getY() - this.decode_pdf.getLayoutY() - this.middleDragStartY) / 4.0;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.TURNOVER_ON) && ((JavaFxGUI)this.decode_pdf.getExternalHandler(11)).getPageTurnScalingAppropriate() && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !JavaFXPageNavigator.getPageTurnAnimating()) {
            Light.Point point;
            float f = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling() - 1.0f;
            float f2 = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
            if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
                float f3 = f;
                f = f2 + 1.0f;
                f2 = f3;
            }
            Light.Point point2 = new Light.Point();
            if (this.commonValues.getCurrentPage() + 1 < this.commonValues.getPageCount()) {
                point2.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)f2);
                point2.setY((double)((float)this.decode_pdf.getInsetH() + f));
                point = new Light.Point();
                point.setX(mouseEvent.getX());
                point.setY(mouseEvent.getY());
                if (point.getX() > point2.getX() - 30.0 && point.getX() <= point2.getX() && point.getY() > point2.getY() - 30.0 && point.getY() <= point2.getY() || point.getY() >= point2.getY() - (double)f && point.getY() < point2.getY() - (double)f + 30.0) {
                    this.decode_pdf.setCursor(Cursor.OPEN_HAND);
                    this.previewTurnover = true;
                    if (point.getY() >= point2.getY() - (double)f && point.getY() < point2.getY() - (double)f + 30.0) {
                        point2.setY(point2.getY() - (double)f);
                        this.decode_pdf.setUserOffsets((int)point.getX(), (int)point.getY(), 997);
                    } else {
                        this.decode_pdf.setUserOffsets((int)point.getX(), (int)point.getY(), 999);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        point2.setY(point2.getY() - (double)f);
                    }
                    this.testFall(point2, point, false);
                }
            }
            if (this.commonValues.getCurrentPage() != 1) {
                point2.setX(this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)f2);
                point2.setY((double)((float)this.decode_pdf.getInsetH() + f));
                point = new Light.Point();
                point.setX(mouseEvent.getX());
                point.setY(mouseEvent.getY());
                if (point.getX() < point2.getX() + 30.0 && point.getX() >= point2.getX() && (point.getY() > point2.getY() - 30.0 && point.getY() <= point2.getY() || point.getY() >= point2.getY() - (double)f && point.getY() < point2.getY() - (double)f + 30.0)) {
                    this.decode_pdf.setCursor(Cursor.OPEN_HAND);
                    this.previewTurnover = true;
                    if (point.getY() >= point2.getY() - (double)f && point.getY() < point2.getY() - (double)f + 30.0) {
                        point2.setX(point2.getY() - (double)f);
                        this.decode_pdf.setUserOffsets((int)point.getX(), (int)point.getY(), 996);
                    } else {
                        this.decode_pdf.setUserOffsets((int)point.getX(), (int)point.getY(), 998);
                    }
                } else {
                    if (this.offsets.getDragTop()) {
                        point2.setY(point2.getY() - (double)f);
                    }
                    this.testFall(point2, point, true);
                }
            }
        }
        if (this.decode_pdf.getExternalHandler(25) != null) {
            int[] nArray = JavaFXMousePageTurn.updateXY((int)mouseEvent.getX(), (int)mouseEvent.getY(), this.decode_pdf, this.commonValues);
            this.checkLinks(false, this.decode_pdf.getIO(), nArray[0], nArray[1]);
        }
    }

    public void mouseWheelMoved(ScrollEvent scrollEvent) {
        if (this.decode_pdf.getDisplayView() == 5) {
            return;
        }
        if (this.currentGUI.getProperties().getValue("allowScrollwheelZoom").equalsIgnoreCase("true") && scrollEvent.isControlDown()) {
            int n;
            block17: {
                n = ((GUI)this.currentGUI).getSelectedComboIndex(252);
                if (n != -1) {
                    n = (int)this.decode_pdf.getDPIFactory().removeScaling(this.decode_pdf.getScaling() * 100.0f);
                } else {
                    String string = ((GUI)this.currentGUI).getSelectedComboItem(252).toString();
                    try {
                        n = (int)Float.parseFloat(string);
                    }
                    catch (Exception exception) {
                        char c;
                        int n2;
                        LogWriter.writeLog("Exception in handling scaling " + exception);
                        n = -1;
                        int n3 = string.length();
                        for (n2 = 0; n2 < n3 && ((c = string.charAt(n2)) >= '0' && c <= '9') | c == '.'; ++n2) {
                        }
                        if (n2 > 0) {
                            string = string.substring(0, n2);
                        }
                        if (n != -1) break block17;
                        try {
                            n = (int)Float.parseFloat(string);
                        }
                        catch (Exception exception2) {
                            LogWriter.writeLog("Exception in handling scaling " + exception2);
                            n = -1;
                        }
                    }
                }
            }
            float f = scrollEvent.getTouchCount();
            if ((n != 1 || f < 0.0f) && !((float)n + (f = f < 0.0f ? 1.25f : 0.8f) < 0.0f)) {
                float f2 = (float)n * f;
                f2 = (int)f2 == n ? (float)(n + 1) : (float)((int)f2);
                if (f2 < 1.0f) {
                    f2 = 1.0f;
                }
                if (f2 > 1000.0f) {
                    f2 = 1000.0f;
                }
                this.currentGUI.snapScalingToDefaults(f2);
            }
        } else {
            final ScrollPane scrollPane = (ScrollPane)this.decode_pdf.getParent();
            if ((scrollPane.getVvalue() == scrollPane.getVmax() - scrollPane.getHeight() || scrollPane.getHeight() == 0.0) && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() < this.decode_pdf.getPageCount()) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(53, null);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scrollPane.setVvalue(scrollPane.getVmin());
                    }
                });
            } else if (scrollPane.getVvalue() == scrollPane.getVmin() && this.timeOfLastPageChange + 700L < System.currentTimeMillis() && this.currentGUI.getValues().getCurrentPage() > 1) {
                this.timeOfLastPageChange = System.currentTimeMillis();
                this.currentCommands.executeCommand(52, null);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scrollPane.setVvalue(scrollPane.getVmax());
                    }
                });
            }
        }
    }

    private void testFall(final Light.Point point, final Light.Point point2, boolean bl) {
        if (!this.previewTurnover) {
            return;
        }
        float f = (float)this.decode_pdf.getPdfPageData().getCropBoxWidth(1) * this.decode_pdf.getScaling() - 1.0f;
        if ((this.decode_pdf.getPdfPageData().getRotation(1) + this.currentGUI.getRotation()) % 180 == 90) {
            f = (float)this.decode_pdf.getPdfPageData().getCropBoxHeight(1) * this.decode_pdf.getScaling();
        }
        final float f2 = f;
        if (!bl) {
            if (!this.offsets.getDragLeft()) {
                this.decode_pdf.setCursor(Cursor.DEFAULT);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        point.setX(JavaFXMousePageTurn.this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 + (double)f2);
                        boolean bl = true;
                        if (point2.getX() < point.getX() - (double)f2) {
                            point.setX(point.getX() - (double)(2.0f * f2));
                            bl = false;
                        }
                        int n = 1;
                        if (bl && point2.getX() >= point.getX()) {
                            point2.setX(point.getX() - 1.0);
                        }
                        if (!bl && point2.getX() <= point.getX()) {
                            point2.setX(point.getX() + 1.0);
                        }
                        if (!JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() >= point.getY()) {
                            point2.setY(point.getY() - 1.0);
                        }
                        if (JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() <= point.getY()) {
                            point2.setY(point.getY() + 1.0);
                        }
                        double d = point.getX() - point2.getX();
                        double d2 = point.getY() - point2.getY();
                        while (bl && point2.getX() <= point.getX() || !bl && point2.getX() >= point.getX() || !JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() <= point.getY() || JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() >= point.getY()) {
                            double d3 = (double)n * d * 0.002;
                            double d4 = (double)n * d2 * 0.002;
                            if (Math.abs(d3) < 1.0) {
                                d3 /= Math.abs(d3);
                            }
                            if (Math.abs(d4) < 1.0) {
                                d4 /= Math.abs(d4);
                            }
                            point2.setX(point2.getX() + d3);
                            point2.setY(point2.getY() + d4);
                            if (JavaFXMousePageTurn.this.offsets.getDragTop()) {
                                JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 997);
                            } else {
                                JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                            }
                            if (n < 32) {
                                n *= 2;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (!bl) {
                            int n2 = JavaFXMousePageTurn.this.commonValues.getCurrentPage() + 1;
                            if (JavaFXMousePageTurn.this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && n2 % 2 == 1) {
                                ++n2;
                            } else if (!JavaFXMousePageTurn.this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && n2 % 2 == 0) {
                                ++n2;
                            }
                            JavaFXMousePageTurn.this.commonValues.setCurrentPage(n2);
                            JavaFXMousePageTurn.this.currentGUI.setPageNumber();
                            JavaFXMousePageTurn.this.decode_pdf.setPageParameters(JavaFXMousePageTurn.this.currentGUI.getScaling(), JavaFXMousePageTurn.this.commonValues.getCurrentPage());
                            JavaFXMousePageTurn.this.currentGUI.decodePage();
                        }
                        JavaFXMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                        JavaFXPageNavigator.setPageTurnAnimating(false, JavaFXMousePageTurn.this.currentGUI);
                    }
                };
                thread.setDaemon(true);
                JavaFXPageNavigator.setPageTurnAnimating(true, this.currentGUI);
                thread.start();
                this.previewTurnover = false;
            }
        } else if (this.previewTurnover && this.offsets.getDragLeft()) {
            this.decode_pdf.setCursor(Cursor.DEFAULT);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    point.setX(JavaFXMousePageTurn.this.decode_pdf.getBoundsInLocal().getWidth() / 2.0 - (double)f2);
                    boolean bl = true;
                    if (point2.getX() > point.getX() + (double)f2) {
                        point.setX(point.getX() + (double)(2.0f * f2));
                        bl = false;
                    }
                    int n = 1;
                    if (!bl && point2.getX() >= point.getX()) {
                        point2.setX(point.getX() - 1.0);
                    }
                    if (bl && point2.getX() <= point.getX()) {
                        point2.setX(point.getX() + 1.0);
                    }
                    if (!JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() >= point.getY()) {
                        point2.setY(point.getY() - 1.0);
                    }
                    if (JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() <= point.getY()) {
                        point2.setY(point.getY() + 1.0);
                    }
                    double d = point.getX() - point2.getX();
                    double d2 = point.getY() - point2.getY();
                    while (!bl && point2.getX() <= point.getX() || bl && point2.getX() >= point.getX() || !JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() <= point.getY() || JavaFXMousePageTurn.this.offsets.getDragTop() && point2.getY() >= point.getY()) {
                        double d3 = (double)n * d * 0.002;
                        double d4 = (double)n * d2 * 0.002;
                        if (Math.abs(d3) < 1.0) {
                            d3 /= Math.abs(d3);
                        }
                        if (Math.abs(d4) < 1.0) {
                            d4 /= Math.abs(d4);
                        }
                        point2.setX(point2.getX() + d3);
                        point2.setY(point2.getY() + d4);
                        if (JavaFXMousePageTurn.this.offsets.getDragTop()) {
                            JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 996);
                        } else {
                            JavaFXMousePageTurn.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 998);
                        }
                        if (n < 32) {
                            n *= 2;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (!bl) {
                        int n2 = JavaFXMousePageTurn.this.commonValues.getCurrentPage() - 2;
                        if (n2 == 0) {
                            n2 = 1;
                        }
                        JavaFXMousePageTurn.this.commonValues.setCurrentPage(n2);
                        JavaFXMousePageTurn.this.currentGUI.setPageNumber();
                        JavaFXMousePageTurn.this.decode_pdf.setPageParameters(JavaFXMousePageTurn.this.currentGUI.getScaling(), JavaFXMousePageTurn.this.commonValues.getCurrentPage());
                        JavaFXMousePageTurn.this.currentGUI.decodePage();
                    }
                    JavaFXMousePageTurn.this.decode_pdf.setUserOffsets(0, 0, 995);
                    JavaFXPageNavigator.setPageTurnAnimating(false, JavaFXMousePageTurn.this.currentGUI);
                }
            };
            thread.setDaemon(true);
            JavaFXPageNavigator.setPageTurnAnimating(true, this.currentGUI);
            thread.start();
            this.previewTurnover = false;
        }
    }
}

