/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.io.File;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.Light;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.text.TextLines;
import org.jpedal.utils.Messages;

public class JavaFXMouseSelector
extends MouseSelector
implements JavaFXMouseFunctionality {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private PdfPageData page_data;
    public static final boolean activateMultipageHighlight = true;
    private int clickCount;
    private long lastTime = -1L;
    private boolean startHighlighting;
    public int id = -1;
    public int lastId = -1;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    MenuItem copy;
    MenuItem selectAll;
    MenuItem deselectall;
    Menu extract;
    MenuItem extractText;
    MenuItem extractImage;
    Image snapshotIcon;
    MenuItem snapShot;
    MenuItem find;
    MenuItem speakHighlighted;
    ContextMenu cm;

    public JavaFXMouseSelector(PdfDecoderFX pdfDecoderFX, GUIFactory gUIFactory, Values values, Commands commands) {
        this.decode_pdf = pdfDecoderFX;
        this.currentGUI = gUIFactory;
        this.commonValues = values;
        this.currentCommands = commands;
        this.page_data = pdfDecoderFX.getPdfPageData();
    }

    private void createRightClickMenu() {
        boolean bl;
        this.cm = new ContextMenu();
        this.copy = new MenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new MenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new MenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new Menu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new MenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new MenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        this.snapshotIcon = new Image("/org/jpedal/examples/viewer/res/snapshot_menu.gif");
        this.snapShot = new MenuItem(Messages.getMessage("PdfRightClick.snapshot"), (Node)new ImageView(this.snapshotIcon));
        this.extract.getItems().addAll((Object[])new MenuItem[]{this.extractText, this.extractImage});
        this.find = new MenuItem(Messages.getMessage("PdfRightClick.find"));
        this.speakHighlighted = new MenuItem("Speak Highlighted text");
        this.copy.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JavaFXMouseSelector.this.currentCommands.executeCommand(25, null);
                } else if (GUI.showMessages) {
                    JavaFXMouseSelector.this.currentGUI.showMessageDialog("Copy is only avalible in single page display mode");
                }
            }
        });
        this.selectAll.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(26, null);
            }
        });
        this.deselectall.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(27, null);
            }
        });
        this.extractText.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JavaFXMouseSelector.this.currentCommands.executeCommand(33, null);
                } else if (GUI.showMessages) {
                    JavaFXMouseSelector.this.currentGUI.showMessageDialog("Text Extraction is only avalible in single page display mode");
                }
            }
        });
        this.extractImage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (JavaFXMouseSelector.this.decode_pdf.getPages().getHighlightedImage() != null && JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    FileChooser fileChooser = new FileChooser();
                    FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("JPG (*jpg)", new String[]{"*.jpg"});
                    FileChooser.ExtensionFilter extensionFilter2 = new FileChooser.ExtensionFilter("PNG (*PNG)", new String[]{"*.png"});
                    FileChooser.ExtensionFilter extensionFilter3 = new FileChooser.ExtensionFilter("Tiff (*TIFF)", new String[]{"*.tiff"});
                    fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extensionFilter, extensionFilter2, extensionFilter3});
                    File file = fileChooser.showSaveDialog((Window)((Stage)JavaFXMouseSelector.this.currentGUI.getFrame()));
                    String string = file.getName();
                    string = string.substring(string.indexOf(46) + 1, string.length());
                    JavaFXMouseSelector.this.decode_pdf.getDynamicRenderer().saveImage(JavaFXMouseSelector.this.id, file.getAbsolutePath(), string);
                }
            }
        });
        this.snapShot.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(13, null);
            }
        });
        this.find.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                int n;
                int n2;
                int n3;
                int[] nArray = JavaFXMouseSelector.this.decode_pdf.getPages().getCursorBoxOnScreenAsArray();
                if (nArray == null) {
                    if (GUI.showMessages) {
                        JavaFXMouseSelector.this.currentGUI.showMessageDialog((Object)"There is no text selected.\nPlease highlight the text you wish to search.", "No Text selected", 0);
                    }
                    return;
                }
                String string = JavaFXMouseSelector.this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                if (string == null || string.length() < 1) {
                    return;
                }
                int n4 = nArray[0];
                int n5 = nArray[0] + nArray[2];
                int n6 = nArray[1] - 2;
                int n7 = nArray[1] + nArray[3] + 2;
                if (n6 < n7) {
                    n3 = n7;
                    n7 = n6;
                    n6 = n3;
                }
                if (n4 > n5) {
                    n3 = n5;
                    n5 = n4;
                    n4 = n3;
                }
                JavaFXMouseSelector.this.page_data = JavaFXMouseSelector.this.decode_pdf.getPdfPageData();
                n3 = JavaFXMouseSelector.this.page_data.getCropBoxX(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int n8 = JavaFXMouseSelector.this.page_data.getCropBoxY(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int n9 = JavaFXMouseSelector.this.page_data.getMediaBoxWidth(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int n10 = JavaFXMouseSelector.this.page_data.getMediaBoxHeight(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                if (n4 < n3) {
                    n4 = n3;
                }
                if (n4 > n9 - n3) {
                    n4 = n9 - n3;
                }
                if (n5 < n3) {
                    n5 = n3;
                }
                if (n5 > n9 - n3) {
                    n5 = n9 - n3;
                }
                if (n6 < n8) {
                    n6 = n8;
                }
                if (n6 > n10 - n8) {
                    n6 = n10 - n8;
                }
                if (n7 < n8) {
                    n7 = n8;
                }
                if (n7 > n10 - n8) {
                    n7 = n10 - n8;
                }
                int n11 = 0;
                int n12 = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                if (n12 == 0) {
                    n11 |= 2;
                }
                if ((n2 = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0)) == 1) {
                    n11 |= 4;
                }
                if ((n = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindHyphen.message"), null, 0)) == 0) {
                    n11 |= 8;
                }
                if (string != null) {
                    try {
                        float[] fArray = JavaFXMouseSelector.this.decode_pdf.getGroupingObject().findText(n4, n6, n5, n7, new String[]{string}, n11);
                        if (fArray.length >= 2) {
                            if (fArray.length < 3) {
                                JavaFXMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + fArray[0] + ',' + fArray[1]);
                            } else {
                                StringBuilder stringBuilder = new StringBuilder();
                                String string2 = Messages.getMessage("PdfViewerMessage.FoundAt");
                                for (int i = 0; i < fArray.length; i += 5) {
                                    stringBuilder.append(string2).append(' ');
                                    stringBuilder.append(fArray[i]);
                                    stringBuilder.append(',');
                                    stringBuilder.append(fArray[i + 1]);
                                    stringBuilder.append('\n');
                                    string2 = fArray[i + 4] == -101.0f ? Messages.getMessage("PdfViewerMessage.FoundAtHyphen") : Messages.getMessage("PdfViewerMessage.FoundAt");
                                }
                                JavaFXMouseSelector.this.currentGUI.showMessageDialog(stringBuilder.toString());
                            }
                        } else {
                            JavaFXMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        }
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        final Speech speech = (Speech)this.decode_pdf.getExternalHandler(32);
        boolean bl2 = bl = speech != null;
        if (bl) {
            speech.setVoice(this.currentGUI.getProperties().getValue("voice"));
        }
        this.speakHighlighted.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (bl) {
                    if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                String string = GUICopy.copySelectedText(JavaFXMouseSelector.this.decode_pdf, JavaFXMouseSelector.this.currentGUI, JavaFXMouseSelector.this.commonValues);
                                speech.speakText(string);
                            }
                        });
                        thread.setDaemon(true);
                        thread.start();
                    } else if (GUI.showMessages) {
                        JavaFXMouseSelector.this.currentGUI.showMessageDialog("Speak text is only avalible in single page display mode");
                    }
                }
            }
        });
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.cm.getItems().add((Object)this.copy);
            this.cm.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), this.selectAll, this.deselectall});
            this.cm.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), this.extract});
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) {
            long l = new Date().getTime();
            if (this.lastTime + 500L < l) {
                this.clickCount = 0;
            }
            this.lastTime = l;
            if (JavaFXMouseSelector.isOtherKey(mouseEvent)) {
                int n;
                Object object;
                if (this.clickCount != 4) {
                    ++this.clickCount;
                }
                int n2 = this.decode_pdf.getPageNumber();
                int n3 = this.page_data.getCropBoxX(n2);
                int n4 = this.page_data.getCropBoxY(n2);
                this.commonValues.m_x1 = (int)mouseEvent.getX() + n3;
                this.commonValues.m_y1 = (int)mouseEvent.getY() + n4;
                this.id = this.decode_pdf.getDisplayView() == 1 ? this.decode_pdf.getDynamicRenderer().isInsideImage(this.commonValues.m_x1, this.commonValues.m_y1) : -1;
                if (this.lastId != this.id && this.id != -1) {
                    object = this.decode_pdf.getDynamicRenderer().getAreaAsArray(this.id);
                    if (object != null) {
                        int n5 = object[3];
                        n = object[2];
                        int n6 = object[0];
                        int n7 = object[1];
                        this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(false);
                        this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(false);
                        if (n < 0) {
                            this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(true);
                            n = -n;
                            n6 -= n;
                        }
                        if (n5 < 0) {
                            this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(true);
                            n5 = -n5;
                            n7 -= n5;
                        }
                        this.decode_pdf.getPages().setHighlightedImage(new int[]{n6, n7, n, n5});
                    }
                    this.lastId = this.id;
                } else {
                    this.decode_pdf.getPages().setHighlightedImage(null);
                    this.lastId = -1;
                }
                if (this.id == -1 && this.clickCount > 1) {
                    switch (this.clickCount) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            object = this.decode_pdf.getTextLines().getLineAreasAs2DArray(this.commonValues.getCurrentPage());
                            if (object == null) break;
                            int[] nArray = new int[]{this.commonValues.m_x1, this.commonValues.m_y1, 1, 1};
                            for (n = 0; n != ((int[])object).length; ++n) {
                                if (!TextLines.intersects(nArray, (int[])object[n])) continue;
                                this.decode_pdf.updateCursorBoxOnScreen((int[])object[n], DecoderOptions.highlightColor.getRGB());
                                this.decode_pdf.getTextLines().addHighlights(new int[][]{(int[])object[n]}, false, this.commonValues.getCurrentPage());
                            }
                            break;
                        }
                        case 3: {
                            int[] nArray = this.decode_pdf.getTextLines().setFoundParagraphAsArray(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.getCurrentPage());
                            if (nArray == null) break;
                            this.decode_pdf.updateCursorBoxOnScreen(nArray, DecoderOptions.highlightColor.getRGB());
                            break;
                        }
                        case 4: {
                            this.currentCommands.executeCommand(26, null);
                        }
                    }
                }
                this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if ((this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) && JavaFXMouseSelector.isOtherKey(mouseEvent)) {
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.requestFocus();
            int n = this.decode_pdf.getPageNumber();
            int n2 = this.page_data.getCropBoxX(n);
            int n3 = this.page_data.getCropBoxY(n);
            this.commonValues.m_x1 = (int)mouseEvent.getX() + n2;
            this.commonValues.m_y1 = (int)mouseEvent.getY() + n3;
            int[][] nArray = this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage());
            if (nArray != null && nArray.length > 0) {
                this.decode_pdf.getPages().refreshDisplay();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) {
            if (this.cm != null && this.cm.isShowing()) {
                this.cm.hide();
            }
            if (JavaFXMouseSelector.isOtherKey(mouseEvent)) {
                if (this.startHighlighting) {
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    this.startHighlighting = false;
                }
                this.page_data = this.decode_pdf.getPdfPageData();
                if (this.currentCommands.extractingAsImage) {
                    this.decode_pdf.updateCursorBoxOnScreen(null, 0);
                    this.decode_pdf.getTextLines().clearHighlights();
                    this.decode_pdf.getPages().setHighlightedImage(null);
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    this.currentCommands.executeCommand(34, null);
                    this.currentCommands.extractingAsImage = false;
                    DecoderOptions.showMouseBox = false;
                }
            } else if (mouseEvent.getButton().equals((Object)MouseButton.SECONDARY) && this.currentGUI.getProperties().getValue("allowRightClick").toLowerCase().equals("true")) {
                if (this.cm == null) {
                    this.createRightClickMenu();
                }
                this.cm.show((Node)((JavaFxGUI)this.currentGUI).getRoot(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
                if (this.decode_pdf.getPages().getHighlightedImage() == null) {
                    this.extractImage.setDisable(true);
                } else {
                    this.extractImage.setDisable(false);
                }
                if (this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage()) == null) {
                    this.extractText.setDisable(true);
                    this.find.setDisable(true);
                    this.speakHighlighted.setDisable(true);
                    this.copy.setDisable(true);
                } else {
                    this.extractText.setDisable(false);
                    this.find.setDisable(false);
                    this.speakHighlighted.setDisable(false);
                    this.copy.setDisable(false);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (JavaFXMouseSelector.isOtherKey(mouseEvent)) {
            if (!this.startHighlighting) {
                this.startHighlighting = true;
            }
            int n = this.decode_pdf.getPageNumber();
            int n2 = this.decode_pdf.getPdfPageData().getCropBoxX(n);
            int n3 = this.decode_pdf.getPdfPageData().getCropBoxY(n);
            this.commonValues.m_x2 = (int)mouseEvent.getX() + n2;
            this.commonValues.m_y2 = (int)mouseEvent.getY() + n3;
            if (this.commonValues.isPDF()) {
                this.decode_pdf.setCursor(Cursor.TEXT);
                this.generateNewCursorBox();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Light.Point getCoordsOnPage(double d, double d2, int n) {
        throw new UnsupportedOperationException("We do not currently use this method for JavaFX as it appears the X and Y coords\n can be retrieved from the bottom left in JavaFX compared to the top left in Swing");
    }

    private static boolean isOtherKey(MouseEvent mouseEvent) {
        return mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) || mouseEvent.getButton().equals((Object)MouseButton.NONE);
    }

    protected void generateNewCursorBox() {
        if (this.old_m_x2 != -1 || this.old_m_y2 != -1 || Math.abs(this.commonValues.m_x2 - this.old_m_x2) > 5 || Math.abs(this.commonValues.m_y2 - this.old_m_y2) > 5) {
            int n = this.commonValues.m_x1;
            if (this.commonValues.m_x1 > this.commonValues.m_x2) {
                n = this.commonValues.m_x2;
            }
            int n2 = this.commonValues.m_y1;
            if (this.commonValues.m_y1 > this.commonValues.m_y2) {
                n2 = this.commonValues.m_y2;
            }
            int n3 = Math.abs(this.commonValues.m_x2 - this.commonValues.m_x1);
            int n4 = Math.abs(this.commonValues.m_y2 - this.commonValues.m_y1);
            int[] nArray = new int[]{n, n2, n3, n4};
            this.decode_pdf.updateCursorBoxOnScreen(nArray, DecoderOptions.highlightColor.getRGB());
            if (!this.currentCommands.extractingAsImage) {
                int[] nArray2 = new int[]{this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2 - this.commonValues.m_x1, this.commonValues.m_y2 - this.commonValues.m_y1};
                this.decode_pdf.getTextLines().addHighlights(new int[][]{nArray2}, false, this.commonValues.getCurrentPage());
            }
            this.old_m_x2 = this.commonValues.m_x2;
            this.old_m_y2 = this.commonValues.m_y2;
        }
        this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
    }
}

