/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaFXOutline
extends Tab
implements GUIOutline {
    private Map<String, String> pageLookupTableViaTitle = new HashMap<String, String>();
    private boolean hasDuplicateTitles = false;
    private final Map<Integer, String> nodeToRef = new HashMap<Integer, String>();
    private final TreeView<Label> list = new TreeView();

    public JavaFXOutline() {
        this.pageLookupTableViaTitle = new HashMap<String, String>();
        ScrollPane scrollPane = new ScrollPane();
        this.setContent((Node)scrollPane);
        scrollPane.setContent(this.list);
        this.list.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty());
        this.list.prefHeightProperty().bind((ObservableValue)scrollPane.heightProperty());
        this.list.setShowRoot(false);
    }

    @Override
    public Object getTree() {
        return this.list;
    }

    @Override
    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return null;
    }

    @Override
    public String getPage(String string) {
        if (this.hasDuplicateTitles) {
            return null;
        }
        return this.pageLookupTableViaTitle.get(string);
    }

    @Override
    public void selectBookmark() {
    }

    @Override
    public void reset(org.w3c.dom.Node node) {
        TreeItem treeItem = new TreeItem();
        this.nodeToRef.clear();
        this.pageLookupTableViaTitle.clear();
        this.hasDuplicateTitles = false;
        this.readChildNodes(node, (TreeItem<Label>)treeItem, 0);
        this.list.setRoot(treeItem);
    }

    @Override
    public String convertNodeIDToRef(int n) {
        return this.nodeToRef.get(n);
    }

    private void readChildNodes(org.w3c.dom.Node node, TreeItem<Label> treeItem, int n) {
        if (node == null) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("title");
            String string2 = element.getAttribute("page");
            String string3 = element.getAttribute("isClosed");
            String string4 = element.getAttribute("objectRef");
            OutlineNode outlineNode = new OutlineNode(string, string4, string3);
            ((Label)outlineNode.getValue()).setUserData((Object)outlineNode);
            outlineNode.setPage(string2);
            if (this.pageLookupTableViaTitle.containsKey(string)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(string, string2);
            }
            this.nodeToRef.put(n, string4);
            treeItem.getChildren().add((Object)outlineNode);
            this.readChildNodes(nodeList.item(i), outlineNode, ++n);
        }
    }

    public class OutlineNode
    extends TreeItem<Label> {
        private final String objectRef;
        private String page;

        private OutlineNode() {
            this.objectRef = null;
        }

        private OutlineNode(String string, String string2, String string3) {
            this.objectRef = string2;
            Label label = new Label(string);
            label.prefWidthProperty().bind((ObservableValue)JavaFXOutline.this.list.prefWidthProperty().subtract(20));
            label.setTextFill((Paint)Color.BLACK);
            this.setValue(label);
            this.setExpanded(!string3.equals("true"));
            JavaFXOutline.this.setTooltip(new Tooltip(string));
        }

        public String getObjectRef() {
            return this.objectRef;
        }

        public String getPage() {
            return this.page;
        }

        private void setPage(String string) {
            this.page = string;
        }
    }
}

