/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.awt.image.BufferedImage;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.utils.LogWriter;

public class JavaFXScrollListener
implements ChangeListener<Number>,
EventHandler<MouseEvent> {
    private final Timeline trapMultipleMovements;
    private boolean requestMade = false;
    private boolean setValueLocally = false;
    private final GUI gui;
    private int nextPage = -1;
    private int lastPageSent = -1;
    private boolean decodeLock;
    private final ScrollBar scroll;
    public BufferedImage lastImage;

    public JavaFXScrollListener(GUI gUI, ScrollBar scrollBar) {
        this.gui = gUI;
        this.scroll = scrollBar;
        this.trapMultipleMovements = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (!JavaFXScrollListener.this.requestMade) {
                    JavaFXScrollListener.this.requestMade = true;
                    if (JavaFXScrollListener.this.nextPage > 0) {
                        JavaFXScrollListener.this.decodeLock = true;
                        JavaFXScrollListener.this.setThumbnail();
                        JavaFXScrollListener.this.decodeLock = false;
                    }
                    JavaFXScrollListener.this.requestMade = false;
                }
            }
        }, new KeyValue[0])});
        this.scroll.setOnMouseReleased((EventHandler)this);
    }

    private void gotoPage(int n) {
        this.gui.getCommand().executeCommand(56, new Object[]{Integer.toString(n)});
    }

    public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
        if (this.setValueLocally || number2 == null) {
            this.setValueLocally = false;
            return;
        }
        int n = number2.intValue() + 1;
        if (this.decodeLock) {
            this.setValueLocally = true;
            this.scroll.setValue((double)number.intValue());
            return;
        }
        if (number2.intValue() >= 0 && this.nextPage != n) {
            int n2 = this.nextPage = n <= this.gui.getPdfDecoder().getPageCount() ? n : this.gui.getPdfDecoder().getPageCount();
            if (this.trapMultipleMovements.getStatus() == Animation.Status.RUNNING) {
                this.trapMultipleMovements.stop();
            }
            if (this.scroll.isPressed()) {
                this.trapMultipleMovements.setCycleCount(1);
                this.trapMultipleMovements.playFromStart();
            }
        }
    }

    public synchronized void setThumbnail() {
        if (this.lastPageSent != this.nextPage) {
            this.lastPageSent = this.nextPage;
            try {
                BufferedImage bufferedImage;
                this.lastImage = bufferedImage = ((GUIThumbnailPanel)this.gui.getThumbnailPanel()).getImage(this.nextPage);
                this.gui.getPdfDecoder().setPreviewThumbnail(bufferedImage, "Page " + this.nextPage + " of " + this.gui.getPdfDecoder().getPageCount());
                this.gui.getPdfDecoder().repaintPane(this.nextPage);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Caught an Exception " + exception);
            }
        }
    }

    public void handle(MouseEvent mouseEvent) {
        if (!this.requestMade) {
            this.requestMade = true;
            if (this.nextPage > 0) {
                this.decodeLock = true;
                this.lastPageSent = this.nextPage;
                this.gotoPage(this.nextPage);
                this.gui.setPageNumber();
                this.gui.getPdfDecoder().waitForDecodingToFinish();
                this.decodeLock = false;
            }
            this.requestMade = false;
        }
    }
}

