/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchList;
import org.jpedal.grouping.DefaultSearchListener;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class JavaFXSearchWindow
extends Stage
implements GUISearchWindow {
    public boolean hasSearched;
    public boolean isSearch;
    int firstPageWithResults;
    int searchTypeParameters;
    private int style;
    Values commonValues;
    final GUIFactory currentGUI;
    PdfDecoderInt decode_pdf;
    private boolean isSetup;
    boolean usingMenuBarSearch;
    private boolean endSearch;
    private boolean backGroundSearch;
    private Map searchAreas;
    VBox contentVB = new VBox();
    private int searchKey;
    private Thread searchThread;
    private final Runnable searchRunner = new Runnable(){

        @Override
        public void run() {
            JavaFXSearchWindow.this.resultsList.setStatus(4);
            boolean bl = JavaFXSearchWindow.this.backGroundSearch;
            JavaFXSearchWindow.this.backGroundSearch = false;
            int n = JavaFXSearchWindow.this.searchKey;
            try {
                ObservableList observableList = JavaFXSearchWindow.this.updateListDuringSearch ? JavaFXSearchWindow.this.listModel : FXCollections.observableArrayList();
                int n2 = 1;
                int n3 = JavaFXSearchWindow.this.decode_pdf.getPageCount() + 1;
                if (JavaFXSearchWindow.this.singlePageSearch) {
                    n2 = JavaFXSearchWindow.this.decode_pdf.getPageNumber();
                    n3 = n2 + 1;
                }
                int n4 = JavaFXSearchWindow.this.commonValues.getCurrentPage();
                boolean bl2 = true;
                while (n2 != n3) {
                    int n5;
                    if (JavaFXSearchWindow.this.usingMenuBarSearch) {
                        if (JavaFXSearchWindow.this.resultsList.getResultCount() >= 1) break;
                        n5 = n4 + (n2 - 1);
                        if (n5 > JavaFXSearchWindow.this.commonValues.getPageCount()) {
                            n5 -= JavaFXSearchWindow.this.commonValues.getPageCount();
                        }
                    } else {
                        n5 = n2;
                    }
                    if (JavaFXSearchWindow.this.searchAreas != null) {
                        int[][] nArray = (int[][])JavaFXSearchWindow.this.searchAreas.get(n5);
                        if (nArray != null) {
                            for (int i = nArray.length - 1; i > -1; --i) {
                                int[] nArray2 = nArray[i];
                                bl2 = JavaFXSearchWindow.this.searchPage(n5, nArray2[0], nArray2[1], nArray2[0] + nArray2[2], nArray2[1] + nArray2[3], n, observableList);
                            }
                        }
                    } else {
                        bl2 = JavaFXSearchWindow.this.searchPage(n5, n, observableList);
                    }
                    if (!bl2) break;
                    if (!bl && !observableList.isEmpty() | n5 % 16 == 0) {
                        final int n6 = n5;
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JavaFXSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + JavaFXSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage("PdfViewerSearch.Scanning") + n6);
                            }
                        });
                    }
                    ++n2;
                }
                if (!bl) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + JavaFXSearchWindow.this.itemFoundCount + "  " + Messages.getMessage("PdfViewerSearch.Done"));
                        }
                    });
                }
                if (!JavaFXSearchWindow.this.usingMenuBarSearch) {
                    while (observableList.size() != JavaFXSearchWindow.this.itemFoundCount) {
                        Thread.sleep(200L);
                    }
                }
                JavaFXSearchWindow.this.listModel = observableList;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (JavaFXSearchWindow.this.resultsList != null && JavaFXSearchWindow.this.listModel != null) {
                            JavaFXSearchWindow.this.resultsList.setItems(JavaFXSearchWindow.this.listModel);
                        }
                    }
                });
                if (bl2) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.setResults(JavaFXSearchWindow.this.resultsList);
                            JavaFXSearchWindow.this.resultsList.scrollTo(0);
                            JavaFXSearchWindow.this.resultsList.getSelectionModel().clearAndSelect(0);
                        }
                    });
                }
                if (JavaFXSearchWindow.this.itemFoundCount > 0) {
                    JavaFXSearchWindow.this.resultsList.setStatus(2);
                } else {
                    JavaFXSearchWindow.this.resultsList.setStatus(1);
                }
                if (!bl) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(true);
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(true);
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!bl) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(true);
                            JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(true);
                        }
                    });
                }
                JavaFXSearchWindow.this.resultsList.setStatus(8);
            }
        }
    };
    int lastPage = -1;
    String defaultMessage = "Search PDF Here";
    public boolean requestInterupt;
    private boolean deleteOnClick;
    final ProgressBar progress = new ProgressBar(100.0);
    TextField searchText;
    Label searchCount;
    JavaFXSearchList resultsList;
    Button advOpts;
    private final VBox nav = new VBox();
    private VBox advancedPanel;
    private ComboBox searchType;
    private CheckBox wholeWordsOnlyBox;
    private CheckBox caseSensitiveBox;
    private CheckBox multiLineBox;
    private CheckBox highlightAll;
    private CheckBox searchAll;
    private CheckBox useRegEx;
    private CheckBox searchHighlightedOnly;
    Button searchButton;
    ObservableList listModel;
    boolean singlePageSearch;
    String[] searchTerms = new String[]{""};
    private int itemFoundCount;
    final Map textPages = new HashMap();
    final Map textRectangles = new HashMap();
    boolean updateListDuringSearch = true;

    public JavaFXSearchWindow(GUIFactory gUIFactory) {
        this.currentGUI = gUIFactory;
    }

    @Override
    public void find(PdfDecoderInt pdfDecoderInt, Values values) {
        if (!this.backGroundSearch) {
            this.init(pdfDecoderInt, values);
            if (this.style == 0) {
                this.show();
            }
        } else {
            try {
                this.searchText();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void findWithoutWindow(PdfDecoderInt pdfDecoderInt, Values values, int n, boolean bl, boolean bl2, String string) {
        if (!this.isSearch) {
            this.backGroundSearch = true;
            this.isSearch = true;
            this.decode_pdf = pdfDecoderInt;
            this.commonValues = values;
            this.progress.setProgress(0.0);
            this.progress.setVisible(true);
            if (!bl) {
                this.searchTerms = new String[]{string};
            } else {
                this.searchTerms = string.split(" ");
                for (int i = 0; i < this.searchTerms.length; ++i) {
                    this.searchTerms[i] = this.searchTerms[i].trim();
                }
            }
            this.searchTypeParameters = n;
            this.singlePageSearch = bl2;
            this.find(pdfDecoderInt, values);
        } else {
            this.currentGUI.showMessageDialog("Please wait for search to finish before starting another.");
        }
    }

    @Override
    public void grabFocusInInput() {
        this.searchText.requestFocus();
    }

    @Override
    public boolean isSearchVisible() {
        return this.isShowing();
    }

    @Override
    public void init(PdfDecoderInt pdfDecoderInt, Values values) {
        this.decode_pdf = pdfDecoderInt;
        this.commonValues = values;
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
        } else {
            this.isSetup = true;
            this.setTitle(Messages.getMessage("PdfViewerSearchGUITitle.DefaultMessage"));
            this.defaultMessage = Messages.getMessage("PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new TextField();
            this.searchText.setText(this.defaultMessage);
            this.searchText.setId("searchText");
            this.searchButton = new Button(Messages.getMessage("PdfViewerSearch.Button"));
            this.advancedPanel = new VBox();
            ObservableList observableList = FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PdfViewerSearch.MatchWhole"), Messages.getMessage("PdfViewerSearch.MatchAny")});
            this.searchType = new ComboBox(observableList);
            this.searchType.setValue(this.searchType.getItems().get(0));
            this.wholeWordsOnlyBox = new CheckBox(Messages.getMessage("PdfViewerSearch.WholeWords"));
            this.wholeWordsOnlyBox.setId("wholeWords");
            this.caseSensitiveBox = new CheckBox(Messages.getMessage("PdfViewerSearch.CaseSense"));
            this.caseSensitiveBox.setId("caseSensitive");
            this.multiLineBox = new CheckBox(Messages.getMessage("PdfViewerSearch.MultiLine"));
            this.multiLineBox.setId("multiLine");
            this.highlightAll = new CheckBox(Messages.getMessage("PdfViewerSearch.HighlightsCheckBox"));
            this.highlightAll.setId("highlightAll");
            this.useRegEx = new CheckBox(Messages.getMessage("PdfViewerSearch.RegExCheckBox"));
            this.useRegEx.setId("useregex");
            this.searchHighlightedOnly = new CheckBox(Messages.getMessage("PdfViewerSearch.HighlightsOnly"));
            this.searchHighlightedOnly.setId("highlightsOnly");
            this.searchType.setId("combo");
            this.advancedPanel.getChildren().add((Object)new Label(Messages.getMessage("PdfViewerSearch.ReturnResultsAs")));
            this.advancedPanel.getChildren().add((Object)this.searchType);
            this.advancedPanel.getChildren().add((Object)new Label(Messages.getMessage("PdfViewerSearch.AdditionalOptions")));
            this.advancedPanel.getChildren().add((Object)this.wholeWordsOnlyBox);
            this.advancedPanel.getChildren().add((Object)this.caseSensitiveBox);
            this.advancedPanel.getChildren().add((Object)this.multiLineBox);
            this.advancedPanel.getChildren().add((Object)this.highlightAll);
            this.advancedPanel.getChildren().add((Object)this.useRegEx);
            this.advancedPanel.getChildren().add((Object)this.searchHighlightedOnly);
            this.advancedPanel.setVisible(false);
            this.searchAll = new CheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage("PdfViewerSearch.CheckBox"));
            VBox vBox = new VBox();
            vBox.getChildren().add((Object)this.searchAll);
            this.advOpts = new Button(Messages.getMessage("PdfViewerSearch.ShowOptions"));
            this.advOpts.setId("advSearch");
            this.advOpts.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (GUIDisplay.allowChangeCursor) {
                        JavaFXSearchWindow.this.nav.setCursor(Cursor.HAND);
                    }
                }
            });
            this.advOpts.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (GUIDisplay.allowChangeCursor) {
                        JavaFXSearchWindow.this.nav.setCursor(Cursor.DEFAULT);
                    }
                }
            });
            this.advOpts.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){
                boolean isVisible;

                public void handle(MouseEvent mouseEvent) {
                    if (this.isVisible) {
                        JavaFXSearchWindow.this.advOpts.setText(Messages.getMessage("PdfViewerSearch.ShowOptions"));
                        JavaFXSearchWindow.this.advancedPanel.setVisible(false);
                    } else {
                        JavaFXSearchWindow.this.advOpts.setText(Messages.getMessage("PdfViewerSearch.HideOptions"));
                        JavaFXSearchWindow.this.advancedPanel.setVisible(true);
                    }
                    this.isVisible = !this.isVisible;
                }
            });
            vBox.getChildren().add((Object)this.advOpts);
            this.nav.getChildren().add((Object)vBox);
            HBox hBox = new HBox();
            hBox.getChildren().addAll((Object[])new Node[]{this.searchText, this.searchButton});
            this.nav.getChildren().add((Object)hBox);
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.searchCount = new Label(Messages.getMessage("PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.nav.getChildren().add((Object)this.searchCount);
            this.listModel = FXCollections.observableArrayList();
            this.listModel = FXCollections.observableArrayList();
            this.resultsList = new JavaFXSearchList(this.listModel, this.textPages, this.textRectangles);
            this.resultsList.setId("results");
            this.resultsList.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    if (!Values.isProcessing()) {
                        Integer n;
                        Object v;
                        float f = JavaFXSearchWindow.this.currentGUI.getScaling();
                        int n2 = (Integer)number2;
                        JavaFXSearchWindow.this.decode_pdf.getTextLines().clearHighlights();
                        if (n2 != -1 && (v = JavaFXSearchWindow.this.textPages.get(n = Integer.valueOf(n2))) != null) {
                            int n3 = (Integer)v;
                            if (JavaFXSearchWindow.this.commonValues.getCurrentPage() != n3) {
                                JavaFXSearchWindow.this.commonValues.setCurrentPage(n3);
                                JavaFXSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                JavaFXSearchWindow.this.decode_pdf.setPageParameters(f, JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                JavaFXSearchWindow.this.currentGUI.decodePage();
                            }
                            while (Values.isProcessing()) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            if ((JavaFXSearchWindow.this.searchTypeParameters & 0x10) == 16) {
                                int[][] nArray;
                                Vector_Rectangle_Int vector_Rectangle_Int = new Vector_Rectangle_Int();
                                int n4 = -1;
                                for (int i = 0; i != JavaFXSearchWindow.this.resultsList.getItems().size(); ++i) {
                                    Object v2;
                                    Object v3 = JavaFXSearchWindow.this.textPages.get(i);
                                    if (v3 == null) continue;
                                    int n5 = (Integer)v3;
                                    if (n5 != n4) {
                                        vector_Rectangle_Int.trim();
                                        nArray = vector_Rectangle_Int.get();
                                        for (int j = 0; j != nArray.length; ++j) {
                                            System.out.println(Arrays.toString(nArray[j]));
                                        }
                                        JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(nArray, true, n4);
                                        n4 = n5;
                                        vector_Rectangle_Int = new Vector_Rectangle_Int();
                                    }
                                    if ((v2 = JavaFXSearchWindow.this.textRectangles.get(i)) instanceof int[]) {
                                        vector_Rectangle_Int.addElement((int[])v2);
                                    }
                                    if (!(v2 instanceof int[][])) continue;
                                    int[][] nArray2 = (int[][])v2;
                                    for (int j = 0; j != nArray2.length; ++j) {
                                        vector_Rectangle_Int.addElement(nArray2[j]);
                                    }
                                }
                                vector_Rectangle_Int.trim();
                                nArray = vector_Rectangle_Int.get();
                                JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(nArray, true, n4);
                            } else {
                                Object v4 = JavaFXSearchWindow.this.textPages.get(n);
                                int n6 = (Integer)v4;
                                Vector_Rectangle_Int vector_Rectangle_Int = new Vector_Rectangle_Int();
                                Object v5 = JavaFXSearchWindow.this.textRectangles.get(n);
                                if (v5 instanceof int[]) {
                                    vector_Rectangle_Int.addElement((int[])v5);
                                }
                                if (v5 instanceof int[][]) {
                                    int[][] nArray = (int[][])v5;
                                    for (int i = 0; i != nArray.length; ++i) {
                                        vector_Rectangle_Int.addElement(nArray[i]);
                                    }
                                }
                                vector_Rectangle_Int.trim();
                                JavaFXSearchWindow.this.decode_pdf.getTextLines().addHighlights(vector_Rectangle_Int.get(), true, n6);
                            }
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    JavaFXSearchWindow.this.decode_pdf.repaintPane(JavaFXSearchWindow.this.commonValues.getCurrentPage());
                                    JavaFXSearchWindow.this.currentGUI.scaleAndRotate();
                                }
                            });
                        }
                    }
                    if (JavaFXSearchWindow.this.commonValues.getCurrentPage() == 1) {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setBackNavigationButtonsEnabled(false);
                    } else {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setBackNavigationButtonsEnabled(true);
                    }
                    if (JavaFXSearchWindow.this.commonValues.getCurrentPage() == JavaFXSearchWindow.this.decode_pdf.getPageCount()) {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setForwardNavigationButtonsEnabled(false);
                    } else {
                        JavaFXSearchWindow.this.currentGUI.getButtons().setForwardNavigationButtonsEnabled(true);
                    }
                }
            });
            this.searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    if (!JavaFXSearchWindow.this.isSearch) {
                        try {
                            JavaFXSearchWindow.this.searchTypeParameters = 0;
                            if (JavaFXSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 1;
                            }
                            if (JavaFXSearchWindow.this.caseSensitiveBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 2;
                            }
                            if (JavaFXSearchWindow.this.multiLineBox.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 8;
                            }
                            if (JavaFXSearchWindow.this.highlightAll.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x10;
                            }
                            if (JavaFXSearchWindow.this.useRegEx.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x20;
                            }
                            if (JavaFXSearchWindow.this.searchHighlightedOnly.isSelected()) {
                                JavaFXSearchWindow.this.searchTypeParameters |= 0x40;
                            }
                            String string = JavaFXSearchWindow.this.searchText.getText().trim();
                            if (JavaFXSearchWindow.this.searchType.getValue() == JavaFXSearchWindow.this.searchType.getItems().get(0)) {
                                JavaFXSearchWindow.this.searchTerms = new String[]{string};
                            } else {
                                JavaFXSearchWindow.this.searchTerms = string.split(" ");
                                for (int i = 0; i < JavaFXSearchWindow.this.searchTerms.length; ++i) {
                                    JavaFXSearchWindow.this.searchTerms[i] = JavaFXSearchWindow.this.searchTerms[i].trim();
                                }
                            }
                            JavaFXSearchWindow.this.singlePageSearch = !JavaFXSearchWindow.this.searchAll.isSelected();
                            JavaFXSearchWindow.this.searchText();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        JavaFXSearchWindow.this.requestInterupt = true;
                        JavaFXSearchWindow.this.isSearch = false;
                        JavaFXSearchWindow.this.searchButton.setText(Messages.getMessage("PdfViewerSearch.Button"));
                    }
                    ((JavaFxGUI)JavaFXSearchWindow.this.currentGUI).getPdfDecoder().requestFocus();
                }
            });
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.searchText.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    JavaFXSearchWindow.this.currentGUI.getButtons().getButton(19).setEnabled(false);
                    JavaFXSearchWindow.this.currentGUI.getButtons().getButton(18).setEnabled(false);
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        if (!JavaFXSearchWindow.this.decode_pdf.isOpen()) {
                            JavaFXSearchWindow.this.currentGUI.showMessageDialog("File must be open before you can search.");
                        } else {
                            try {
                                JavaFXSearchWindow.this.isSearch = false;
                                JavaFXSearchWindow.this.searchTypeParameters = 0;
                                if (JavaFXSearchWindow.this.wholeWordsOnlyBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 1;
                                }
                                if (JavaFXSearchWindow.this.caseSensitiveBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 2;
                                }
                                if (JavaFXSearchWindow.this.multiLineBox.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 8;
                                }
                                if (JavaFXSearchWindow.this.highlightAll.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x10;
                                }
                                if (JavaFXSearchWindow.this.useRegEx.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x20;
                                }
                                if (JavaFXSearchWindow.this.searchHighlightedOnly.isSelected()) {
                                    JavaFXSearchWindow.this.searchTypeParameters |= 0x40;
                                }
                                String string = JavaFXSearchWindow.this.searchText.getText().trim();
                                if (JavaFXSearchWindow.this.searchType.getValue() == JavaFXSearchWindow.this.searchType.getItems().get(0)) {
                                    JavaFXSearchWindow.this.searchTerms = new String[]{string};
                                } else {
                                    JavaFXSearchWindow.this.searchTerms = string.split(" ");
                                    for (int i = 0; i < JavaFXSearchWindow.this.searchTerms.length; ++i) {
                                        JavaFXSearchWindow.this.searchTerms[i] = JavaFXSearchWindow.this.searchTerms[i].trim();
                                    }
                                }
                                JavaFXSearchWindow.this.singlePageSearch = !JavaFXSearchWindow.this.searchAll.isSelected();
                                JavaFXSearchWindow.this.searchText();
                                ((JavaFxGUI)JavaFXSearchWindow.this.currentGUI).getPdfDecoder().requestFocus();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
            });
            this.searchText.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue() && JavaFXSearchWindow.this.deleteOnClick) {
                        JavaFXSearchWindow.this.deleteOnClick = false;
                        JavaFXSearchWindow.this.searchText.setText("");
                    } else if (JavaFXSearchWindow.this.searchText.getText().isEmpty()) {
                        JavaFXSearchWindow.this.searchText.setText(JavaFXSearchWindow.this.defaultMessage);
                        JavaFXSearchWindow.this.deleteOnClick = true;
                    }
                }
            });
            if (this.style == 0 || this.style == 1) {
                BorderPane borderPane = new BorderPane();
                this.contentVB = new VBox();
                this.contentVB.getChildren().addAll((Object[])new Node[]{this.nav, this.resultsList, this.advancedPanel});
                borderPane.setCenter((Node)this.contentVB);
                Scene scene = new Scene((Parent)borderPane);
                this.setScene(scene);
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
    }

    public VBox getContentVB() {
        return this.contentVB;
    }

    @Override
    public void removeSearchWindow(boolean bl) {
        this.close();
        if (this.isSetup && !bl) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
        if (this.decode_pdf != null) {
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
        }
    }

    @Override
    public void resetSearchWindow() {
        if (this.isSetup) {
            this.searchText.setText(this.defaultMessage);
            this.deleteOnClick = true;
            if (this.hasSearched) {
                this.currentGUI.getButtons().getButton(19).setEnabled(false);
                this.currentGUI.getButtons().getButton(18).setEnabled(false);
                this.hasSearched = false;
            }
            this.decode_pdf.requestFocus();
        }
    }

    @Override
    public GUISearchList getResults() {
        return this.resultsList;
    }

    @Override
    public GUISearchList getResults(int n) {
        boolean bl = this.usingMenuBarSearch = this.style == 2;
        if (n != this.lastPage && this.usingMenuBarSearch) {
            try {
                ++this.searchKey;
                if (this.searchKey > 3000) {
                    this.searchKey = 0;
                }
                this.clearCurrentResults();
                this.searchPage(n, this.searchKey, this.listModel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.resultsList;
    }

    @Override
    public Map getTextRectangles() {
        return Collections.unmodifiableMap(this.textRectangles);
    }

    @Override
    public int getViewStyle() {
        return this.style;
    }

    @Override
    public void setViewStyle(int n) {
        this.style = n;
    }

    @Override
    public int getFirstPageWithResults() {
        return this.firstPageWithResults;
    }

    @Override
    public void setWholeWords(boolean bl) {
        this.wholeWordsOnlyBox.setSelected(bl);
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.caseSensitiveBox.setSelected(bl);
    }

    @Override
    public void setMultiLine(boolean bl) {
        this.multiLineBox.setSelected(bl);
    }

    @Override
    public void setSearchText(String string) {
        this.searchText.setText(string);
    }

    private void searchText() throws Exception {
        this.usingMenuBarSearch = this.style == 2;
        ++this.searchKey;
        this.lastPage = -1;
        if (this.searchKey > 3000) {
            this.searchKey = 0;
        }
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.endSearch = true;
            this.searchThread.interrupt();
            while (this.searchThread.isAlive()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to set propeties values " + exception);
                }
            }
            this.endSearch = false;
        }
        this.searchAreas = !this.usingMenuBarSearch && (this.searchTypeParameters & 0x40) == 64 ? this.decode_pdf.getTextLines().getAllHighlights() : null;
        this.clearCurrentResults();
        this.searchThread = new Thread(this.searchRunner);
        this.searchThread.start();
    }

    private void clearCurrentResults() {
        this.listModel.clear();
        this.resultsList.getItems().clear();
        this.textPages.clear();
        this.textRectangles.clear();
        this.itemFoundCount = 0;
        this.decode_pdf.getTextLines().clearHighlights();
    }

    private boolean searchPage(int n, int n2, ObservableList observableList) throws Exception {
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        int n3 = pdfPageData.getMediaBoxX(n);
        int n4 = pdfPageData.getMediaBoxWidth(n) + n3;
        int n5 = pdfPageData.getMediaBoxY(n);
        int n6 = pdfPageData.getMediaBoxHeight(n) + n5;
        return this.searchPage(n, n3, n6, n4, n5, n2, observableList);
    }

    private boolean searchPage(int n, int n2, int n3, int n4, int n5, int n6, ObservableList observableList) throws Exception {
        PdfGroupingAlgorithms pdfGroupingAlgorithms;
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        if (n == this.commonValues.getCurrentPage()) {
            pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
        } else {
            this.decode_pdf.decodePageInBackground(n);
            pdfGroupingAlgorithms = this.decode_pdf.getBackgroundGroupingObject();
        }
        DefaultSearchListener defaultSearchListener = new DefaultSearchListener();
        pdfGroupingAlgorithms.generateTeasers();
        pdfGroupingAlgorithms.setIncludeHTML(false);
        this.resultsList.setSearchTerm(this.searchText.getText().trim());
        SortedMap sortedMap = pdfGroupingAlgorithms.findTextWithinInAreaWithTeasers(n2, n3, n4, n5, pdfPageData.getRotation(n), n, this.searchTerms, this.searchTypeParameters, defaultSearchListener);
        if (!sortedMap.isEmpty()) {
            this.itemFoundCount += sortedMap.size();
            Iterator iterator = sortedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Object k = entry2.getKey();
                String string = (String)entry2.getValue();
                if (n6 == this.searchKey) {
                    observableList.add((Object)string);
                }
                Integer n7 = this.textRectangles.size();
                this.textRectangles.put(n7, k);
                this.textPages.put(n7, n);
            }
        }
        this.lastPage = n;
        return !this.endSearch;
    }

    @Override
    public void setUpdateListDuringSearch(boolean bl) {
        this.updateListDuringSearch = bl;
    }
}

