/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.awt.Font;
import java.awt.image.BufferedImage;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jpedal.PdfDecoderInt;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.objects.PdfPageData;

public class JavaFXThumbnailPanel
extends Tab
implements GUIThumbnailPanel {
    private static final boolean debugThumbnails = false;
    private boolean showThumbnailsdefault;
    private boolean generateOtherVisibleThumbnails;
    private boolean showThumbnails;
    private final PdfDecoderInt decode_pdf;
    private final ThumbnailDecoder thumbDecoder;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    private Task<Void> worker;
    private boolean drawing;
    private static final boolean debug = true;
    private boolean interrupt;
    private Button[] pageButton;
    private final VBox content;
    private final ScrollPane scroll;
    private int lastPage;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private BufferedImage[] images;
    private boolean[] buttonDrawn;
    private final ThumbPainter painter;
    private final BorderListener border;
    private final Border selectedBorder;
    private final Border hoverBorder;
    private final Border emptyBorder;

    public JavaFXThumbnailPanel(final PdfDecoderInt pdfDecoderInt) {
        this.showThumbnails = this.showThumbnailsdefault = true;
        this.border = new BorderListener();
        this.painter = new ThumbPainter();
        this.decode_pdf = pdfDecoderInt;
        this.thumbDecoder = new ThumbnailDecoder(pdfDecoderInt);
        this.content = new VBox();
        this.scroll = new ScrollPane((Node)this.content);
        this.content.setAlignment(Pos.CENTER);
        this.scroll.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observableValue, Bounds bounds, Bounds bounds2) {
                JavaFXThumbnailPanel.this.content.setPrefWidth(bounds2.getWidth());
                if (JavaFXThumbnailPanel.this.drawing) {
                    JavaFXThumbnailPanel.this.terminateDrawing();
                }
                pdfDecoderInt.waitForDecodingToFinish();
                if (pdfDecoderInt.isOpen()) {
                    JavaFXThumbnailPanel.this.drawThumbnails();
                }
            }
        });
        this.selectedBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.RED, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.hoverBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.emptyBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.setContent((Node)this.scroll);
    }

    @Override
    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    @Override
    public void terminateDrawing() {
        this.generateOtherVisibleThumbnails = false;
        if (this.drawing) {
            this.interrupt = true;
        }
    }

    @Override
    public void setIsDisplayedOnscreen(boolean bl) {
        this.showThumbnails = bl;
    }

    @Override
    public Object[] getButtons() {
        return this.pageButton;
    }

    @Override
    public void addComponentListener() {
        this.scroll.vvalueProperty().addListener((ChangeListener)this.painter);
    }

    @Override
    public synchronized void generateOtherVisibleThumbnails(int n) {
        this.generateOtherVisibleThumbnails = true;
        if (n == -1 || n == this.lastPage || this.pageButton == null) {
            return;
        }
        int n2 = this.decode_pdf.getPageCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            this.pageButton[i].setBorder(this.emptyBorder);
        }
        if (n - 1 < this.pageButton.length && n2 > 1 && n > 0) {
            this.pageButton[n - 1].setBorder(this.selectedBorder);
        }
        double d = this.scroll.getVmax() / (double)n2 * (double)(n - 1);
        this.scroll.setVvalue(d);
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        this.drawThumbnails();
    }

    @Override
    public void setupThumbnails(int n, Font font, String string, PdfPageData pdfPageData) {
        this.lastPage = -1;
        this.content.getChildren().clear();
        Image image = JavaFXThumbnailPanel.createBlankThumbnail(70, 100);
        Image image2 = JavaFXThumbnailPanel.createBlankThumbnail(100, 70);
        this.isLandscape = new boolean[n];
        this.pageHeight = new int[n];
        this.pageButton = new Button[n];
        this.images = new BufferedImage[n];
        this.buttonDrawn = new boolean[n];
        for (int i = 0; i < n; ++i) {
            Button button;
            Image image3;
            int n2;
            int n3 = i + 1;
            int n4 = pdfPageData.getCropBoxWidth(n3);
            int n5 = pdfPageData.getCropBoxHeight(n3);
            int n6 = pdfPageData.getRotation(n3);
            if (n6 == 0 | n6 == 180) {
                n2 = pdfPageData.getMediaBoxHeight(n3);
                image3 = image;
            } else {
                n2 = pdfPageData.getMediaBoxWidth(n3);
                image3 = image2;
            }
            if (n4 > n5) {
                this.pageButton[i] = button = new Button(string + ' ' + n3, (Node)new ImageView(image3));
                this.isLandscape[i] = true;
            } else {
                this.pageButton[i] = button = new Button(string + ' ' + n3, (Node)new ImageView(image3));
                this.isLandscape[i] = false;
            }
            this.pageHeight[i] = n2;
            this.pageButton[i].setContentDisplay(ContentDisplay.TOP);
            this.pageButton[i].setStyle("-fx-padding:0;-fx-background-color:transparent;");
            if (i == 0 && n > 1) {
                this.pageButton[0].setBorder(this.selectedBorder);
            } else {
                this.pageButton[i].setBorder(this.emptyBorder);
            }
            this.pageButton[i].prefWidthProperty().bind((ObservableValue)this.content.prefWidthProperty());
            this.content.getChildren().add((Object)this.pageButton[i]);
            this.pageButton[i].setOnMouseEntered((EventHandler)this.border);
            this.pageButton[i].setOnMouseExited((EventHandler)this.border);
        }
    }

    @Override
    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    @Override
    public void removeAllListeners() {
        this.scroll.vvalueProperty().removeListener((ChangeListener)this.painter);
        for (Button button : this.pageButton) {
            button.setOnMouseExited(null);
            button.setOnMouseEntered(null);
            button.setOnAction(null);
        }
    }

    @Override
    public void setThumbnailsEnabled(boolean bl) {
        this.showThumbnailsdefault = bl;
        this.showThumbnails = bl;
    }

    @Override
    public void dispose() {
    }

    @Override
    public synchronized BufferedImage getImage(int n) {
        if (this.images == null || this.images[--n] == null) {
            if (n > -1) {
                BufferedImage bufferedImage;
                int n2 = 100;
                if (this.isLandscape[n]) {
                    n2 = 70;
                }
                this.images[n] = bufferedImage = this.thumbDecoder.getPageAsThumbnail(n + 1, n2);
                return bufferedImage;
            }
            return null;
        }
        return this.images[n];
    }

    @Override
    public void drawThumbnails() {
        if (!this.isSelected()) {
            return;
        }
        if (this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new Task<Void>(){

            protected Void call() throws Exception {
                if (JavaFXThumbnailPanel.this.buttonDrawn != null && JavaFXThumbnailPanel.this.pageButton != null) {
                    JavaFXThumbnailPanel.this.drawing = true;
                    try {
                        double d = JavaFXThumbnailPanel.this.scroll.getVvalue() * JavaFXThumbnailPanel.this.content.getHeight() - JavaFXThumbnailPanel.this.scroll.getHeight() * JavaFXThumbnailPanel.this.scroll.getVvalue();
                        Rectangle rectangle = new Rectangle(0.0, d, JavaFXThumbnailPanel.this.scroll.getWidth(), JavaFXThumbnailPanel.this.scroll.getHeight());
                        int n = JavaFXThumbnailPanel.this.decode_pdf.getPageCount();
                        for (int i = 0; i < n; ++i) {
                            JavaFXThumbnailPanel.this.decode_pdf.waitForDecodingToFinish();
                            if (JavaFXThumbnailPanel.this.interrupt || i > JavaFXThumbnailPanel.this.pageButton.length) {
                                i = n;
                                continue;
                            }
                            if (JavaFXThumbnailPanel.this.buttonDrawn[i] || JavaFXThumbnailPanel.this.pageButton[i] == null || !rectangle.intersects(JavaFXThumbnailPanel.this.pageButton[i].getBoundsInParent())) continue;
                            int n2 = 100;
                            if (JavaFXThumbnailPanel.this.isLandscape[i]) {
                                n2 = 70;
                            }
                            BufferedImage bufferedImage = JavaFXThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i + 1, n2);
                            if (JavaFXThumbnailPanel.this.interrupt) continue;
                            JavaFXThumbnailPanel.this.createThumbnail(bufferedImage, i);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                JavaFXThumbnailPanel.this.interrupt = false;
                JavaFXThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        new Thread((Runnable)this.worker, "Thumbnail Thread").start();
    }

    private static Image createBlankThumbnail(int n, int n2) {
        Canvas canvas = new Canvas((double)n, (double)n2);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setFill((Paint)Color.WHITE);
        graphicsContext.fillRect(0.2, 0.2, (double)n - 0.5, (double)n2 - 0.5);
        graphicsContext.setFill((Paint)Color.BLACK);
        graphicsContext.strokeRect(0.2, 0.2, (double)n - 0.5, (double)n2 - 0.5);
        graphicsContext.strokeLine(0.0, 0.0, (double)n, (double)n2);
        graphicsContext.strokeLine(0.0, (double)n2, (double)n, 0.0);
        return canvas.snapshot(null, null);
    }

    private void createThumbnail(BufferedImage bufferedImage, final int n) {
        if (bufferedImage != null) {
            WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
            if (Platform.isFxApplicationThread()) {
                ((ImageView)this.pageButton[n].getGraphic()).setImage((Image)writableImage);
                this.buttonDrawn[n] = true;
                this.images[n] = bufferedImage;
            } else {
                Platform.runLater((Runnable)new Runnable((Image)writableImage, bufferedImage){
                    final /* synthetic */ Image val$image;
                    final /* synthetic */ BufferedImage val$page;
                    {
                        this.val$image = image;
                        this.val$page = bufferedImage;
                    }

                    @Override
                    public void run() {
                        ((ImageView)JavaFXThumbnailPanel.this.pageButton[n].getGraphic()).setImage(this.val$image);
                        ((JavaFXThumbnailPanel)JavaFXThumbnailPanel.this).buttonDrawn[n] = true;
                        ((JavaFXThumbnailPanel)JavaFXThumbnailPanel.this).images[n] = this.val$page;
                    }
                });
            }
        }
    }

    private class BorderListener
    implements EventHandler<MouseEvent> {
        private BorderListener() {
        }

        public void handle(MouseEvent mouseEvent) {
            Button button = (Button)mouseEvent.getSource();
            boolean bl = button.getBorder().equals((Object)JavaFXThumbnailPanel.this.selectedBorder);
            if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_ENTERED) && !bl) {
                button.setBorder(JavaFXThumbnailPanel.this.hoverBorder);
            } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_EXITED) && !bl) {
                button.setBorder(JavaFXThumbnailPanel.this.emptyBorder);
            }
        }
    }

    private class ThumbPainter
    implements ChangeListener<Number> {
        private boolean requestMade;
        private final Timeline trapMultipleMovements = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    if (!Values.isProcessing) {
                        if (JavaFXThumbnailPanel.this.drawing) {
                            JavaFXThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        JavaFXThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        }, new KeyValue[0])});

        private ThumbPainter() {
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (this.trapMultipleMovements.getStatus() == Animation.Status.RUNNING) {
                this.trapMultipleMovements.stop();
            }
            this.trapMultipleMovements.setCycleCount(1);
            this.trapMultipleMovements.playFromStart();
        }
    }
}

