/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx.dialog;

import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FXDialog {
    protected Stage parent;
    protected Stage dialog;
    private Parent content;
    private final Group dummyPane = new Group();
    protected boolean isCancelled;
    private boolean disposeOnExit = true;

    protected FXDialog() {
    }

    public FXDialog(Stage stage, Modality modality, Pane pane) {
        this.init(stage, modality, (Parent)pane);
        Scene scene = new Scene((Parent)pane);
        this.setScene(scene);
    }

    public FXDialog(Stage stage, Modality modality, Parent parent, double d, double d2) {
        this.init(stage, modality, parent);
        this.dialog.setWidth(d);
        this.dialog.setHeight(d2);
        Scene scene = new Scene(parent, d, d2);
        this.setScene(scene);
    }

    protected final void init(Stage stage, Modality modality, Parent parent) {
        this.dialog = new Stage(StageStyle.UTILITY);
        this.parent = stage;
        this.content = parent;
        this.dialog.initOwner((Window)stage);
        this.dialog.initModality(modality);
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                FXDialog.this.freeContent();
                FXDialog.this.isCancelled = true;
            }
        });
        this.dialog.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                FXDialog.this.centerOnParent();
            }
        });
    }

    protected final void setScene(Scene scene) {
        this.dialog.setScene(scene);
        this.dialog.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                KeyCode keyCode = keyEvent.getCode();
                if (keyCode == KeyCode.F4 && keyEvent.isAltDown() || keyCode == KeyCode.ESCAPE) {
                    FXDialog.this.cancel();
                } else if (keyCode == KeyCode.ENTER) {
                    FXDialog.this.positiveClose();
                    FXDialog.this.close();
                }
            }
        });
    }

    public void show() {
        this.dialog.show();
    }

    public void close() {
        this.freeContent();
        this.dialog.close();
    }

    public void showAndWait() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXDialog.this.dialog.showAndWait();
                }
            });
        } else {
            this.dialog.showAndWait();
        }
    }

    private void centerOnParent() {
        if (this.parent == null) {
            this.dialog.centerOnScreen();
            return;
        }
        double d = this.parent.getX();
        double d2 = this.parent.getY();
        double d3 = this.dialog.getWidth();
        double d4 = this.dialog.getHeight();
        double d5 = d + this.parent.getWidth() / 2.0 - d3 / 2.0;
        double d6 = d2 + this.parent.getHeight() / 2.0 - d4 / 2.0;
        this.dialog.setX(d5);
        this.dialog.setY(d6);
    }

    protected void cancel() {
        this.freeContent();
        this.isCancelled = true;
        this.dialog.close();
    }

    protected final void freeContent() {
        if (this.disposeOnExit) {
            this.dialog.getScene().setRoot((Parent)this.dummyPane);
        }
    }

    protected void positiveClose() {
        this.freeContent();
    }

    public Stage getDialog() {
        return this.dialog;
    }

    public void setWidth(double d) {
        this.dialog.setWidth(d);
    }

    public void setHeight(double d) {
        this.dialog.setHeight(d);
    }

    public double getWidth() {
        return this.dialog.getWidth();
    }

    public double getHeight() {
        return this.dialog.getHeight();
    }

    public void setResizeable(boolean bl) {
        this.dialog.setResizable(bl);
    }

    public boolean isResizeable() {
        return this.dialog.isResizable();
    }

    public Parent getContent() {
        return this.content;
    }

    public void setContent(Pane pane) {
        this.content = pane;
    }

    public void setTitle(String string) {
        this.dialog.setTitle(string);
    }

    public void setDisposeOnExit(boolean bl) {
        this.disposeOnExit = bl;
    }

    public boolean getDisposeOnExit() {
        return this.disposeOnExit;
    }
}

