/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx.dialog;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;

public class FXMessageDialog
extends FXDialog {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    protected static final int FONTSIZE = 14;
    protected static final int BUTTONWIDTH = 55;
    private final BorderPane content = new BorderPane();
    private final StringProperty message;
    private final ImageView iconView = new ImageView();
    private final HBox bottom;
    private final VBox center;

    public FXMessageDialog(Stage stage, Modality modality) {
        this.message = new SimpleStringProperty();
        Button button = new Button("OK");
        button.setPrefWidth(55.0);
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXMessageDialog.this.positiveClose();
            }
        });
        this.init(stage, Modality.APPLICATION_MODAL, (Parent)this.content);
        this.dialog.setResizable(false);
        this.center = new VBox();
        Label label = new Label();
        label.setWrapText(true);
        label.textProperty().bind((ObservableValue)this.message);
        label.setFont(Font.font((double)14.0));
        this.center.getChildren().add((Object)label);
        this.center.setAlignment(Pos.CENTER);
        this.center.setPadding(new Insets(20.0));
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        this.iconView.setPreserveRatio(true);
        this.iconView.setFitWidth(0.0);
        vBox.getChildren().add((Object)this.iconView);
        this.bottom = new HBox(5.0);
        this.bottom.setAlignment(Pos.CENTER);
        this.bottom.getChildren().add((Object)button);
        this.bottom.setPadding(new Insets(5.0, 5.0, 10.0, 5.0));
        this.content.setCenter((Node)this.center);
        this.content.setLeft((Node)vBox);
        this.content.setBottom((Node)this.bottom);
        this.setScene(new Scene((Parent)this.content));
        this.dialog.sizeToScene();
    }

    public FXMessageDialog(Stage stage, Modality modality, String string) {
        this(stage, modality);
        this.message.set((Object)string);
    }

    public FXMessageDialog(Stage stage, Modality modality, Image image) {
        this(stage, modality);
        this.setImage(image);
    }

    public FXMessageDialog(Stage stage, Modality modality, Image image, String string) {
        this(stage, modality);
        this.setImage(image);
        this.message.set((Object)string);
    }

    public FXMessageDialog(Stage stage, Modality modality, Parent parent) {
        this(stage, modality);
        this.content.setCenter((Node)parent);
    }

    public final void setImage(Image image) {
        if (image == null) {
            this.iconView.setFitWidth(0.0);
            return;
        }
        this.iconView.setFitWidth(image.getWidth());
        this.iconView.setImage(image);
    }

    protected BorderPane getBorderPane() {
        return this.content;
    }

    public void setCenterAlignment(Pos pos) {
        ((VBox)this.content.getCenter()).setAlignment(pos);
    }

    protected HBox getButtonGroup() {
        return this.bottom;
    }

    protected VBox getCenterGroup() {
        return this.center;
    }

    protected StringProperty getMessage() {
        return this.message;
    }

    @Override
    protected void positiveClose() {
        this.isCancelled = false;
        this.dialog.close();
    }
}

