/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.text.DecimalFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.ResolutionSyntax;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterResolution;
import org.jpedal.DevFlags;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.gui.popups.PrintPanelInt;
import org.jpedal.examples.viewer.paper.MarginPaper;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.objects.PrinterOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PrintPanelFX
extends Pane
implements PrintPanelInt {
    private FXDialog printPopup;
    private TabPane tabs;
    private final BorderPane border = new BorderPane();
    private final Tab printer = new Tab("Printer");
    private final Tab range = new Tab("Range");
    private final Tab handling = new Tab("Handling");
    private final float[] margins = new float[4];
    private final PdfDecoderInt pdf;
    Button ok;
    Button cancel;
    ComboBox<String> printers;
    ComboBox pagesOptions;
    ComboBox resolutionOptions;
    TextField leftT;
    TextField rightT;
    TextField topT;
    TextField bottomT;
    RadioButton all;
    RadioButton currentView;
    RadioButton currentPage;
    RadioButton pagesFrom;
    TextField numberFrom;
    TextField numberTo;
    ComboBox subSet;
    CheckBox reverse;
    TextField copies;
    ComboBox scaling;
    CheckBox autoRotateCenter;
    CheckBox paperSourceByPDF;
    CheckBox grayscale;
    private boolean debugPrinterChange;
    int pageCount;
    int currentPageNo;
    private boolean okClicked;
    private String[] printersList;
    private final PaperSizes paperDefinitions;
    private int defaultResolution;
    private static final double mmPerSubInch = 0.35277777777777775;
    final double[] minimumMargins = new double[]{0.0, 0.0, 0.0, 0.0};
    final DecimalFormat df = new DecimalFormat("#.###");

    public PrintPanelFX(String[] stringArray, String string, PaperSizes paperSizes, int n, int n2, PdfDecoderInt pdfDecoderInt) {
        this.pdf = pdfDecoderInt;
        this.pageCount = this.pdf.getPageCount();
        this.currentPageNo = n2;
        this.defaultResolution = n;
        this.paperDefinitions = paperSizes;
        this.resetDefaults(stringArray, string, this.pageCount, this.currentPageNo);
    }

    private void setupStage() {
        this.printPopup = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)this.border, 700.0, 300.0);
        this.printPopup.setTitle("Print");
        this.initPreview();
        this.bottomButtons();
        this.printPopup.show();
        this.printPopup.setResizeable(false);
    }

    private void bottomButtons() {
        HBox hBox = new HBox(5.0);
        this.ok = new Button();
        this.ok.setText(Messages.getMessage("PdfMessage.Ok"));
        this.ok.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PrintPanelFX.this.okEvent();
            }
        });
        this.cancel = new Button();
        this.cancel.setText(Messages.getMessage("PdfMessage.Cancel"));
        hBox.getChildren().addAll((Object[])new Node[]{this.ok, this.cancel});
        this.cancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PrintPanelFX.this.cancelEvent();
            }
        });
        hBox.setAlignment(Pos.BOTTOM_RIGHT);
        hBox.setPadding(new Insets(10.0, 10.0, 10.0, 0.0));
        this.border.setBottom((Node)hBox);
    }

    private void initPreview() {
        VBox vBox = new VBox();
        Label label = new Label("Preview");
        label.setPadding(new Insets(0.0, 0.0, 0.0, 75.0));
        Slider slider = new Slider();
        slider.setPadding(new Insets(190.0, 0.0, 0.0, 0.0));
        vBox.setPrefWidth(50.0);
        vBox.getChildren().addAll((Object[])new Node[]{label, slider});
        vBox.setStyle("-fx-border-style: solid;-fx-border-width: 0.5;-fx-border-color: black");
        this.border.setCenter((Node)vBox);
    }

    private void setupTabs() {
        HBox hBox = new HBox();
        this.tabs = new TabPane();
        hBox.getChildren().addAll((Object[])new Node[]{this.tabs});
        this.tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.initprintTab();
        this.initRangeTab();
        this.initHandlingTab();
        this.border.setLeft((Node)hBox);
        this.tabs.getStyleClass().add((Object)"floating");
    }

    private void initprintTab() {
        HBox hBox = new HBox();
        GridPane gridPane = new GridPane();
        this.printers = new ComboBox(FXCollections.observableArrayList((Object[])this.printersList));
        this.printers.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("repainted preview component");
                }
                PrintPanelFX.this.ok.setDisable(true);
                PrintPanelFX.this.pagesOptions.setDisable(true);
                PrintPanelFX.this.pagesOptions.setItems(FXCollections.observableArrayList((Object[])new String[]{"Loading..."}));
                PrintPanelFX.this.resolutionOptions.setDisable(true);
                PrintPanelFX.this.resolutionOptions.setItems(FXCollections.observableArrayList((Object[])new String[]{"Loading..."}));
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("GUI options disabled");
                }
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Thread invoked.");
                }
                PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Found print services.");
                }
                PrintService printService = null;
                for (PrintService printService2 : printServiceArray) {
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("checking " + printService2.getName());
                    }
                    if (!printService2.getName().equals(PrintPanelFX.this.printers.getSelectionModel().getSelectedItem())) continue;
                    printService = printService2;
                    if (!PrintPanelFX.this.debugPrinterChange) continue;
                    System.out.println("Match!");
                }
                if (printService != null) {
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting available resolutions...");
                    }
                    PrintPanelFX.this.resolutionOptions.setItems(FXCollections.observableArrayList((Object[])PrintPanelFX.getAvailableResolutions(printService)));
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting default resolution...");
                    }
                    int n = PrintPanelFX.this.getDefaultResolutionIndex();
                    if (PrintPanelFX.this.resolutionOptions.getItems().size() > n) {
                        PrintPanelFX.this.resolutionOptions.getSelectionModel().select(n);
                    }
                    PrintPanelFX.this.resolutionOptions.setDisable(false);
                    PrintPanelFX.this.paperDefinitions.setPrintService(printService);
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting available paper sizes...");
                    }
                    PrintPanelFX.this.pagesOptions.setItems(FXCollections.observableArrayList((Object[])PrintPanelFX.this.getAvailablePaperSizes()));
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Getting default pagesize...");
                    }
                    int n2 = PrintPanelFX.this.paperDefinitions.getDefaultPageIndex();
                    if (PrintPanelFX.this.pagesOptions.getItems().size() > n2) {
                        PrintPanelFX.this.pagesOptions.getSelectionModel().select(n2);
                    }
                    PrintPanelFX.this.pagesOptions.setDisable(false);
                    PrintPanelFX.this.ok.setDisable(false);
                    if (PrintPanelFX.this.debugPrinterChange) {
                        System.out.println("Reenabled GUI");
                    }
                }
                if (PrintPanelFX.this.debugPrinterChange) {
                    System.out.println("Updating margins");
                }
                PrintPanelFX.this.updateMargins();
            }
        });
        this.pagesOptions = new ComboBox();
        this.resolutionOptions = new ComboBox();
        this.leftT = new TextField();
        this.leftT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.leftT.setText(string2);
                } else {
                    PrintPanelFX.this.leftT.setText(string);
                }
            }
        });
        this.leftT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    double d = 0.0;
                    if (!PrintPanelFX.this.leftT.getText().isEmpty()) {
                        d = Double.parseDouble(PrintPanelFX.this.leftT.getText());
                    }
                    if (d < PrintPanelFX.this.minimumMargins[0]) {
                        d = PrintPanelFX.this.minimumMargins[0];
                    }
                    PrintPanelFX.this.leftT.setText(PrintPanelFX.this.df.format(d));
                    ((PrintPanelFX)PrintPanelFX.this).margins[0] = Float.parseFloat(PrintPanelFX.this.leftT.getText());
                }
            }
        });
        this.rightT = new TextField();
        this.rightT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.rightT.setText(string2);
                } else {
                    PrintPanelFX.this.rightT.setText(string);
                }
            }
        });
        this.rightT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    double d = 0.0;
                    if (!PrintPanelFX.this.rightT.getText().isEmpty()) {
                        d = Double.parseDouble(PrintPanelFX.this.rightT.getText());
                    }
                    if (d < PrintPanelFX.this.minimumMargins[2]) {
                        d = PrintPanelFX.this.minimumMargins[2];
                    }
                    PrintPanelFX.this.rightT.setText(PrintPanelFX.this.df.format(d));
                    ((PrintPanelFX)PrintPanelFX.this).margins[2] = Float.parseFloat(PrintPanelFX.this.rightT.getText());
                }
            }
        });
        this.topT = new TextField();
        this.topT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.topT.setText(string2);
                } else {
                    PrintPanelFX.this.topT.setText(string);
                }
            }
        });
        this.topT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    double d = 0.0;
                    if (!PrintPanelFX.this.topT.getText().isEmpty()) {
                        d = Double.parseDouble(PrintPanelFX.this.topT.getText());
                    }
                    if (d < PrintPanelFX.this.minimumMargins[1]) {
                        d = PrintPanelFX.this.minimumMargins[1];
                    }
                    PrintPanelFX.this.topT.setText(PrintPanelFX.this.df.format(d));
                    ((PrintPanelFX)PrintPanelFX.this).margins[1] = Float.parseFloat(PrintPanelFX.this.topT.getText());
                }
            }
        });
        this.bottomT = new TextField();
        this.bottomT.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("[0-9]*\\.?[0-9]*")) {
                    PrintPanelFX.this.bottomT.setText(string2);
                } else {
                    PrintPanelFX.this.bottomT.setText(string);
                }
            }
        });
        this.bottomT.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    double d = 0.0;
                    if (!PrintPanelFX.this.bottomT.getText().isEmpty()) {
                        d = Double.parseDouble(PrintPanelFX.this.bottomT.getText());
                    }
                    if (d < PrintPanelFX.this.minimumMargins[3]) {
                        d = PrintPanelFX.this.minimumMargins[3];
                    }
                    PrintPanelFX.this.bottomT.setText(PrintPanelFX.this.df.format(d));
                    ((PrintPanelFX)PrintPanelFX.this).margins[3] = Float.parseFloat(PrintPanelFX.this.bottomT.getText());
                }
            }
        });
        Label label = new Label();
        label.setText(Messages.getMessage("PdfViewerPrint.Name"));
        Label label2 = new Label();
        label2.setText(Messages.getMessage("PdfViewerPrint.PageSize"));
        Label label3 = new Label();
        label3.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        Label label4 = new Label();
        label4.setText(Messages.getMessage("PdfViewerPrintMargins.left"));
        Label label5 = new Label();
        label5.setText(Messages.getMessage("PdfViewerPrintMargins.right"));
        Label label6 = new Label();
        label6.setText(Messages.getMessage("PdfViewerPrintMargins.top"));
        Label label7 = new Label();
        label7.setText(Messages.getMessage("PdfViewerPrintMargins.bottom"));
        Label label8 = new Label();
        label8.setText(Messages.getMessage("PdfViewerPrintResolution.text"));
        gridPane.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        gridPane.setVgap(6.0);
        gridPane.add((Node)label, 0, 0);
        gridPane.add(this.printers, 1, 0, 4, 1);
        gridPane.add((Node)label2, 0, 1);
        gridPane.add((Node)this.pagesOptions, 1, 1, 4, 1);
        gridPane.add((Node)label3, 0, 2);
        gridPane.add((Node)label4, 1, 2);
        gridPane.add((Node)this.leftT, 2, 2);
        gridPane.add((Node)label5, 3, 2);
        gridPane.add((Node)this.rightT, 4, 2);
        gridPane.add((Node)label6, 1, 3);
        gridPane.add((Node)this.topT, 2, 3);
        gridPane.add((Node)label7, 3, 3);
        gridPane.add((Node)this.bottomT, 4, 3);
        gridPane.add((Node)label8, 0, 4);
        gridPane.add((Node)this.resolutionOptions, 1, 4, 4, 1);
        hBox.getChildren().addAll((Object[])new Node[]{gridPane});
        this.tabs.getTabs().add((Object)this.printer);
        this.printer.setContent((Node)gridPane);
    }

    private void initRangeTab() {
        HBox hBox = new HBox();
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        ToggleGroup toggleGroup = new ToggleGroup();
        this.all = new RadioButton("All");
        this.all.setSelected(true);
        this.all.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    PrintPanelFX.this.allStateChanged();
                }
            }
        });
        this.all.setToggleGroup(toggleGroup);
        this.currentView = new RadioButton("Current View");
        this.currentView.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    PrintPanelFX.this.printRangeCurrentView();
                }
            }
        });
        this.currentView.setToggleGroup(toggleGroup);
        this.currentPage = new RadioButton("Current Page");
        this.currentPage.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    PrintPanelFX.this.currentPageStateChanged();
                }
            }
        });
        this.currentPage.setToggleGroup(toggleGroup);
        this.pagesFrom = new RadioButton("Pages From:");
        this.pagesFrom.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    PrintPanelFX.this.pagesFromStateChanged();
                }
            }
        });
        this.pagesFrom.setToggleGroup(toggleGroup);
        this.numberFrom = new TextField();
        this.numberFrom.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("\\d*")) {
                    PrintPanelFX.this.numberFrom.setText(string2);
                } else {
                    PrintPanelFX.this.numberFrom.setText(string);
                }
            }
        });
        this.numberFrom.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    int n = 1;
                    if (!PrintPanelFX.this.numberFrom.getText().isEmpty()) {
                        n = Integer.parseInt(PrintPanelFX.this.numberFrom.getText());
                    }
                    if (n > PrintPanelFX.this.pdf.getPageCount()) {
                        n = PrintPanelFX.this.pdf.getPageCount();
                    }
                    PrintPanelFX.this.numberFrom.setText(String.valueOf(n));
                } else {
                    PrintPanelFX.this.pagesBoxPressed();
                }
            }
        });
        this.numberTo = new TextField();
        this.numberTo.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("\\d*")) {
                    PrintPanelFX.this.numberTo.setText(string2);
                } else {
                    PrintPanelFX.this.numberTo.setText(string);
                }
            }
        });
        this.numberTo.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    int n = PrintPanelFX.this.pdf.getPageCount();
                    if (!PrintPanelFX.this.numberTo.getText().isEmpty()) {
                        n = Integer.parseInt(PrintPanelFX.this.numberTo.getText());
                    }
                    if (n > PrintPanelFX.this.pdf.getPageCount()) {
                        n = PrintPanelFX.this.pdf.getPageCount();
                    }
                    PrintPanelFX.this.numberTo.setText(String.valueOf(n));
                } else {
                    PrintPanelFX.this.pagesBoxPressed();
                }
            }
        });
        this.subSet = new ComboBox();
        this.subSet.setItems(FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PdfViewerPrint.AllPagesInRange"), Messages.getMessage("PdfViewerPrint.OddPagesOnly"), Messages.getMessage("PdfViewerPrint.EvenPagesOnly")}));
        this.reverse = new CheckBox();
        this.reverse.setText(Messages.getMessage("PdfViewerPrint.ReversePages"));
        Label label = new Label();
        label.setText(Messages.getMessage("PdfViewerPrint.Subset"));
        gridPane.setVgap(6.0);
        gridPane.add((Node)this.all, 0, 0);
        gridPane.add((Node)this.currentView, 0, 1);
        gridPane.add((Node)this.currentPage, 0, 2);
        gridPane.add((Node)this.pagesFrom, 0, 3);
        gridPane.add((Node)this.numberFrom, 1, 3);
        gridPane.add((Node)new Label(" to "), 2, 3);
        gridPane.add((Node)this.numberTo, 3, 3);
        gridPane.add((Node)label, 0, 4);
        gridPane.add((Node)this.subSet, 1, 4);
        gridPane.add((Node)this.reverse, 0, 5);
        hBox.getChildren().add((Object)gridPane);
        this.tabs.getTabs().add((Object)this.range);
        this.range.setContent((Node)hBox);
    }

    private void initHandlingTab() {
        HBox hBox = new HBox();
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        this.copies = new TextField();
        this.copies.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                if (string2.matches("\\d*")) {
                    PrintPanelFX.this.copies.setText(string2);
                } else {
                    PrintPanelFX.this.copies.setText(string);
                }
            }
        });
        this.scaling = new ComboBox();
        this.scaling.setItems(FXCollections.observableArrayList((Object[])PrinterOptions.PRINT_SCALING_OPTIONS));
        this.scaling.getSelectionModel().select(PrinterOptions.LAST_SCALING_CHOICE);
        this.autoRotateCenter = new CheckBox();
        this.paperSourceByPDF = new CheckBox();
        this.grayscale = new CheckBox();
        Label label = new Label();
        label.setText(Messages.getMessage("PdfViewerPrint.Copies"));
        Label label2 = new Label();
        label2.setText(Messages.getMessage("PdfViewerPrint.PageScaling"));
        this.autoRotateCenter.setText(Messages.getMessage("PdfViewerPrint.AutoRotateAndCenter"));
        this.paperSourceByPDF.setText(Messages.getMessage("PdfViewerPrint.ChoosePaperByPdfSize"));
        this.grayscale.setText(Messages.getMessage("PdfViewerPrint.Grayscale"));
        gridPane.setVgap(6.0);
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)this.copies, 1, 0);
        gridPane.add((Node)label2, 0, 1);
        gridPane.add((Node)this.scaling, 1, 1);
        gridPane.add((Node)this.autoRotateCenter, 0, 2);
        gridPane.add((Node)this.paperSourceByPDF, 0, 3);
        gridPane.add((Node)this.grayscale, 0, 4);
        hBox.getChildren().add((Object)gridPane);
        this.tabs.getTabs().add((Object)this.handling);
        this.handling.setContent((Node)hBox);
    }

    @Override
    public void resetDefaults(String[] stringArray, String string, int n, int n2) {
        this.printersList = stringArray;
        this.pageCount = n;
        this.currentPageNo = n2;
        this.initComponents();
        String string2 = System.getProperty("org.jpedal.defaultPrinter");
        if (string2 != null) {
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                this.printers.getSelectionModel().select((Object)string3);
            }
        } else {
            this.printers.getSelectionModel().select((Object)string);
        }
        if (this.pagesOptions.getItems().isEmpty()) {
            return;
        }
        int n3 = this.paperDefinitions.getDefaultPageIndex();
        if (n3 < this.pagesOptions.getItems().size()) {
            this.pagesOptions.getSelectionModel().select(n3);
        }
        this.numberFrom.setText("1");
        this.numberTo.setText(String.valueOf(this.pdf.getPageCount()));
        this.subSet.getSelectionModel().select(0);
        this.copies.setText("1");
        if (DevFlags.testing) {
            this.printers.getSelectionModel().select((Object)"Zan Image Printer(color)");
        }
    }

    private void initComponents() {
        this.setupStage();
        this.setupTabs();
    }

    private static String[] getAvailableResolutions(PrintService printService) {
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (printerResolutionArray == null) {
            return new String[]{"Default"};
        }
        String[] stringArray = new String[printerResolutionArray.length];
        for (int i = 0; i < printerResolutionArray.length; ++i) {
            PrinterResolution printerResolution = printerResolutionArray[i];
            stringArray[i] = printerResolution.getCrossFeedResolution(100) + "x" + printerResolution.getFeedResolution(100) + " dpi";
        }
        return stringArray;
    }

    @Override
    public PrinterResolution getResolution() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printService = null;
        for (PrintService printService2 : printServiceArray) {
            if (!printService2.getName().equals(this.printers.getSelectionModel().getSelectedItem())) continue;
            printService = printService2;
        }
        Object[] objectArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (objectArray == null) {
            return null;
        }
        return objectArray[this.resolutionOptions.getSelectionModel().getSelectedIndex()];
    }

    private int getDefaultResolutionIndex() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService printService = null;
        for (PrintService printService2 : printServiceArray) {
            if (!printService2.getName().equals(this.printers.getSelectionModel().getSelectedItem())) continue;
            printService = printService2;
        }
        Object[] objectArray = (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (objectArray == null) {
            return 0;
        }
        if (this.defaultResolution == -1) {
            this.defaultResolution = 600;
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n3;
            Object object = objectArray[i];
            int n4 = ((ResolutionSyntax)object).getCrossFeedResolution(100) - this.defaultResolution;
            if (n4 < 0) {
                n4 = -n4;
            }
            if ((n3 = ((ResolutionSyntax)object).getFeedResolution(100) - this.defaultResolution) < 0) {
                n3 = -n3;
            }
            if (n4 + n3 >= n) continue;
            n = n4 + n3;
            n2 = i;
        }
        return n2;
    }

    private void updateMargins() {
        this.df.setMinimumFractionDigits(1);
        MarginPaper marginPaper = this.getSelectedPaper();
        if (marginPaper == null) {
            return;
        }
        this.minimumMargins[0] = marginPaper.getMinX() * 0.35277777777777775;
        this.minimumMargins[1] = marginPaper.getMinY() * 0.35277777777777775;
        this.minimumMargins[2] = (marginPaper.getWidth() - marginPaper.getMaxRX()) * 0.35277777777777775;
        this.minimumMargins[3] = (marginPaper.getHeight() - marginPaper.getMaxBY()) * 0.35277777777777775;
        this.leftT.setText(this.df.format(this.minimumMargins[0]));
        this.margins[0] = Float.parseFloat(this.leftT.getText());
        this.topT.setText(this.df.format(this.minimumMargins[1]));
        this.margins[1] = Float.parseFloat(this.topT.getText());
        this.rightT.setText(this.df.format(this.minimumMargins[2]));
        this.margins[2] = Float.parseFloat(this.rightT.getText());
        this.bottomT.setText(this.df.format(this.minimumMargins[3]));
        this.margins[3] = Float.parseFloat(this.bottomT.getText());
    }

    private void pagesBoxPressed() {
        this.pagesFrom.setSelected(true);
        this.subSet.setDisable(false);
        this.reverse.setDisable(false);
    }

    private void pagesFromStateChanged() {
        if (this.pagesFrom.isSelected()) {
            this.subSet.setDisable(false);
            this.reverse.setDisable(false);
        }
    }

    private void printRangeCurrentView() {
        if (this.currentView.isSelected()) {
            this.subSet.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    private void currentPageStateChanged() {
        if (this.currentPage.isSelected()) {
            this.subSet.setDisable(true);
            this.reverse.setDisable(true);
        }
    }

    private void allStateChanged() {
        if (this.all.isSelected()) {
            this.subSet.setDisable(false);
            this.reverse.setDisable(false);
        }
    }

    private void cancelEvent() {
        this.okClicked = false;
        this.setVisible(false);
        this.printPopup.close();
    }

    private void okEvent() {
        this.okClicked = true;
        this.setVisible(false);
        this.printPopup.close();
    }

    @Override
    public SetOfIntegerSyntax getPrintRange() {
        PageRanges pageRanges = null;
        if (this.all.isSelected()) {
            pageRanges = new PageRanges(1, this.pageCount);
            if (this.subSet.getSelectionModel().getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.subSet.getSelectionModel().getSelectedIndex() == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 1) continue;
                    stringBuilder.append(n).append(',');
                }
                String string = stringBuilder.toString();
                StringBuilder stringBuilder2 = new StringBuilder(string);
                stringBuilder2.deleteCharAt(string.length() - 1);
                string = stringBuilder2.toString();
                pageRanges = new PageRanges(string);
            } else if (this.subSet.getSelectionModel().getSelectedIndex() == 2) {
                StringBuilder stringBuilder = new StringBuilder();
                int n = -1;
                while ((n = pageRanges.next(n)) != -1) {
                    if (n % 2 != 0) continue;
                    stringBuilder.append(n).append(',');
                }
                String string = stringBuilder.toString();
                StringBuilder stringBuilder3 = new StringBuilder(string);
                stringBuilder3.deleteCharAt(string.length() - 1);
                string = stringBuilder3.toString();
                pageRanges = new PageRanges(string);
            }
        } else if (this.currentPage.isSelected()) {
            pageRanges = new PageRanges(this.currentPageNo);
        } else if (this.currentView.isSelected()) {
            pageRanges = new PageRanges(this.currentPageNo);
        } else if (this.pagesFrom.isSelected()) {
            int n;
            int n2;
            try {
                n2 = Integer.parseInt(this.numberFrom.getText());
            }
            catch (NumberFormatException numberFormatException) {
                LogWriter.writeLog("Exception in setting page range " + numberFormatException);
                this.numberFrom.setText("1");
                n2 = 1;
            }
            try {
                n = Integer.parseInt(this.numberTo.getText());
            }
            catch (NumberFormatException numberFormatException) {
                LogWriter.writeLog("Exception in setting page range " + numberFormatException);
                this.numberTo.setText(String.valueOf(this.pageCount));
                n = this.pageCount;
            }
            if (n2 < 0) {
                n2 = 1;
                this.pagesFrom.setText("1");
            } else if (n2 > this.pageCount) {
                n2 = this.pageCount;
                this.pagesFrom.setText(String.valueOf(this.pageCount));
            }
            if (n < 0) {
                n = 1;
                this.numberTo.setText("1");
            } else if (n > this.pageCount) {
                n = this.pageCount;
                this.numberTo.setText(String.valueOf(this.pageCount));
            }
            if (n2 > n) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            pageRanges = new PageRanges(n2, n);
            if (this.subSet.getSelectionModel().getSelectedIndex() == 0) {
                return pageRanges;
            }
            if (this.subSet.getSelectionModel().getSelectedIndex() == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                int n4 = -1;
                while ((n4 = pageRanges.next(n4)) != -1) {
                    if (n4 % 2 != 1) continue;
                    stringBuilder.append(n4).append(',');
                }
                String string = stringBuilder.toString();
                StringBuilder stringBuilder4 = new StringBuilder(string);
                if (string.isEmpty()) {
                    return null;
                }
                stringBuilder4.deleteCharAt(string.length() - 1);
                string = stringBuilder4.toString();
                pageRanges = new PageRanges(string);
            } else if (this.subSet.getSelectionModel().getSelectedIndex() == 2) {
                StringBuilder stringBuilder = new StringBuilder();
                int n5 = -1;
                while ((n5 = pageRanges.next(n5)) != -1) {
                    if (n5 % 2 != 0) continue;
                    stringBuilder.append(n5).append(',');
                }
                String string = stringBuilder.toString();
                StringBuilder stringBuilder5 = new StringBuilder(string);
                int n6 = string.length();
                if (n6 > 0) {
                    stringBuilder5.deleteCharAt(n6 - 1);
                }
                pageRanges = !(string = stringBuilder5.toString()).isEmpty() ? new PageRanges(string) : null;
            }
        }
        return pageRanges;
    }

    @Override
    public int getCopies() {
        String string = this.copies.getText();
        return Integer.parseInt(string);
    }

    @Override
    public int getPageScaling() {
        int n = this.scaling.getSelectionModel().getSelectedIndex();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        PrinterOptions.LAST_SCALING_CHOICE = n2;
        return n2;
    }

    @Override
    public String getPrinter() {
        if (this.printers == null) {
            return "";
        }
        if (this.printers.getSelectionModel().getSelectedItem() == null) {
            return "";
        }
        return (String)this.printers.getSelectionModel().getSelectedItem();
    }

    @Override
    public boolean okClicked() {
        return this.okClicked;
    }

    @Override
    public boolean isAutoRotateAndCenter() {
        return this.autoRotateCenter.isSelected();
    }

    @Override
    public boolean isPaperSourceByPDFSize() {
        return this.paperSourceByPDF.isSelected();
    }

    @Override
    public boolean isPrintingCurrentView() {
        return this.currentView.isSelected();
    }

    @Override
    public String[] getAvailablePaperSizes() {
        return this.paperDefinitions.getAvailablePaperSizes();
    }

    @Override
    public MarginPaper getSelectedPaper() {
        return this.paperDefinitions.getSelectedPaper(this.pagesOptions.getSelectionModel().getSelectedItem());
    }

    @Override
    public int getSelectedPrinterOrientation() {
        return this.paperDefinitions.getDefaultPageOrientation();
    }

    @Override
    public boolean isPagesReversed() {
        return this.reverse.isSelected();
    }

    @Override
    public boolean isOddPagesOnly() {
        return this.subSet.getSelectionModel().getSelectedIndex() == 1;
    }

    @Override
    public boolean isEvenPagesOnly() {
        return this.subSet.getSelectionModel().getSelectedIndex() == 2;
    }

    @Override
    public boolean isMonochrome() {
        return this.grayscale.isSelected();
    }

    public float[] getMargins() {
        return this.margins;
    }
}

