/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Save
extends JComponent {
    protected final JTextField startPage = new JTextField();
    protected final JTextField endPage = new JTextField();
    protected final JTextField rootDir = new JTextField();
    protected final Object[] scales = new Object[]{"10", "25", "50", "75", "100"};
    protected final JComboBox scaling = new JComboBox<Object>(this.scales);
    protected final JLabel scalingLabel = new JLabel();
    protected final JLabel rootFilesLabel = new JLabel();
    protected final JButton changeButton = new JButton();
    protected final JLabel endLabel = new JLabel();
    protected final JLabel startLabel = new JLabel();
    protected final JLabel pageRangeLabel = new JLabel();
    protected final String root_dir;
    protected final int end_page;
    protected final int currentPage;
    protected final JLabel optionsForFilesLabel = new JLabel();

    public Save(final String string, int n, int n2) {
        this.currentPage = n2;
        this.root_dir = string;
        this.end_page = n;
        this.scalingLabel.setFont(new Font("Dialog", 1, 14));
        this.scalingLabel.setText(Messages.getMessage("PdfViewerOption.Scaling") + '\n');
        this.scaling.setSelectedItem("100");
        this.scaling.setName("exportScaling");
        this.rootFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.rootFilesLabel.setDisplayedMnemonic('0');
        this.rootFilesLabel.setText(Messages.getMessage("PdfViewerOption.RootDir"));
        this.rootDir.setText(string);
        this.rootDir.setName("extRootDir");
        this.changeButton.setText(Messages.getMessage("PdfViewerOption.Browse"));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(string);
                jFileChooser.setFileSelectionMode(0);
                String[] stringArray = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
                jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Images (Tiff, Jpeg,Png)"));
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showOpenDialog(null);
                File file = jFileChooser.getSelectedFile();
                if (file != null && n == 0) {
                    Save.this.rootDir.setText(file.getAbsolutePath());
                }
            }
        });
        this.optionsForFilesLabel.setText(Messages.getMessage("PdfViewerOption.Output"));
        this.optionsForFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.optionsForFilesLabel.setDisplayedMnemonic('0');
        this.pageRangeLabel.setText(Messages.getMessage("PdfViewerOption.PageRange"));
        this.pageRangeLabel.setFont(new Font("Dialog", 1, 14));
        this.pageRangeLabel.setDisplayedMnemonic('0');
        this.startLabel.setText(Messages.getMessage("PdfViewerOption.StartPage"));
        this.endLabel.setText(Messages.getMessage("PdfViewerOption.EndPage"));
        this.startPage.setText("1");
        this.endPage.setText(String.valueOf(n));
    }

    public final int getScaling() {
        return Integer.parseInt((String)this.scaling.getSelectedItem());
    }

    public int display(Component component, String string) {
        this.setSize(400, 200);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this, "Center");
        jPanel.setSize(400, 200);
        Object[] objectArray = new Object[]{Messages.getMessage("PdfMessage.Ok"), Messages.getMessage("PdfMessage.Cancel")};
        if (GUI.showMessages) {
            return JOptionPane.showOptionDialog(component, jPanel, string, -1, -1, null, objectArray, objectArray[0]);
        }
        return 0;
    }

    public final int getStartPage() {
        int n;
        block5: {
            n = -1;
            try {
                n = Integer.parseInt(this.startPage.getText());
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in exporting");
                if (!GUI.showMessages) break block5;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        if (n < 1 && GUI.showMessages) {
            JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.NegativePageValue"));
        }
        if (n > this.end_page) {
            if (GUI.showMessages) {
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + n + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
            }
            n = -1;
        }
        return n;
    }

    public final String getRootDir() {
        return this.rootDir.getText();
    }

    public final int getEndPage() {
        int n;
        block5: {
            n = -1;
            try {
                n = Integer.parseInt(this.endPage.getText());
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in exporting");
                if (!GUI.showMessages) break block5;
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.InvalidSyntax"));
            }
        }
        if (n < 1 && GUI.showMessages) {
            JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerError.NegativePageValue"));
        }
        if (n > this.end_page) {
            if (GUI.showMessages) {
                JOptionPane.showMessageDialog(this, Messages.getMessage("PdfViewerText.Page") + ' ' + n + ' ' + Messages.getMessage("PdfViewerError.OutOfBounds") + ' ' + Messages.getMessage("PdfViewerText.PageCount") + ' ' + this.end_page);
            }
            n = -1;
        }
        return n;
    }

    @Override
    public final Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 330);
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

