/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.CheckRenderer;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.JavaFXHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.mozilla.javascript.ScriptRuntime;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    private final int TRUE_HASH = "true".hashCode();
    final Speech speech;
    final Map reverseMessage = new HashMap();
    final String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    String propertiesLocation = "";
    PropertiesFile properties;
    JDialog propertiesDialog;
    final JButton confirm = new JButton("OK");
    final JButton cancel = new JButton("Cancel");
    JTabbedPane tabs = new JTabbedPane();
    JTextField resolution;
    JComboBox searchStyle;
    JCheckBox liveSearchResuts;
    JCheckBox border;
    JCheckBox HiResPrint;
    JCheckBox constantTabs;
    JCheckBox enhancedViewer;
    JCheckBox enhancedFacing;
    JCheckBox thumbnailScroll;
    JCheckBox rightClick;
    JCheckBox scrollwheelZoom;
    final JCheckBox update = new JCheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
    JTextField maxMultiViewers;
    JTextField pageInsets;
    JLabel pageInsetsText;
    JTextField windowTitle;
    JLabel windowTitleText;
    JTextField iconLocation;
    JLabel iconLocationText;
    JTextField printerBlacklist;
    JLabel printerBlacklistText;
    JComboBox defaultPrinter;
    JLabel defaultPrinterText;
    JComboBox defaultPagesize;
    JLabel defaultPagesizeText;
    JTextField defaultDPI;
    JLabel defaultDPIText;
    JTextField sideTabLength;
    JLabel sideTabLengthText;
    JCheckBox useHinting;
    JCheckBox autoScroll;
    JCheckBox confirmClose;
    JCheckBox openLastDoc;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing", "PageFlow"});
    JComboBox voiceSelect;
    final JPanel highlightBoxColor = new JPanel();
    final JPanel viewBGColor = new JPanel();
    final JPanel pdfDecoderBackground = new JPanel();
    final JPanel foreGroundColor = new JPanel();
    final JCheckBox invertHighlight = new JCheckBox("Highlight Inverts Page");
    final JCheckBox replaceDocTextCol = new JCheckBox("Replace Document Text Colors");
    final JCheckBox replaceDisplayBGCol = new JCheckBox("Replace Display Background Color");
    final JCheckBox changeTextAndLineArt = new JCheckBox("Change Color of Text and Line art");
    final JCheckBox showMouseSelectionBox = new JCheckBox("Show Mouse Selection Box");
    final JTextField highlightComposite = new JTextField(String.valueOf(DecoderOptions.highlightComposite));
    private boolean preferencesSetup;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    final KeyListener numericalKeyListener = new KeyListener(){
        boolean consume;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.consume = !(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.consume) {
                keyEvent.consume();
            }
        }
    };

    private void loadBooleanValue(JCheckBox jCheckBox, String string) {
        String string2 = this.properties.getValue(string).toLowerCase();
        jCheckBox.setSelected(!string2.isEmpty() && string2.hashCode() == this.TRUE_HASH);
    }

    private void loadBooleanValue(CheckNode checkNode, String string) {
        String string2 = this.properties.getValue(string).toLowerCase();
        checkNode.setSelected(!string2.isEmpty() && string2.hashCode() == this.TRUE_HASH);
    }

    private void loadStringValue(JTextField jTextField, String string) {
        String string2 = this.properties.getValue(string);
        if (string2 != null && !string2.isEmpty()) {
            jTextField.setText(string2);
        }
    }

    private void loadStringValue(JTextField jTextField, String string, String string2) {
        String string3 = this.properties.getValue(string);
        if (string3 != null && !string3.isEmpty()) {
            jTextField.setText(string3);
        } else {
            jTextField.setText(string2);
        }
    }

    public SwingProperties(GUIFactory gUIFactory) {
        this.speech = (Speech)gUIFactory.getPdfDecoder().getExternalHandler(32);
        this.showPreferenceWindow(gUIFactory);
    }

    private void showPreferenceWindow(GUIFactory gUIFactory) {
        this.propertiesDialog = gUIFactory.getFrame() instanceof JFrame ? new JDialog((JFrame)gUIFactory.getFrame()) : new JDialog();
        this.propertiesDialog.setModal(true);
        this.propertiesDialog.setDefaultCloseOperation(2);
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(gUIFactory);
        }
        if (this.properties.getValue("readOnly").equalsIgnoreCase("true")) {
            JOptionPane.showMessageDialog(this, "You do not have permission alter jPedal properties.\nAccess to the properties window has therefore been disabled.", "Can not write to properties file", 1);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, "Current properties file is read only.\nAny alteration can only be saved as another properties file.", "Properties file is read only", 1);
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        this.propertiesDialog.setLocationRelativeTo((Container)gUIFactory.getFrame());
        this.propertiesDialog.setVisible(true);
    }

    private void saveGUIPreferences(GUIFactory gUIFactory) {
        Component[] componentArray = this.tabs.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JPanel)) continue;
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j != componentArray2.length; ++j) {
                Object object;
                if (componentArray2[j] instanceof JScrollPane) {
                    object = ((JScrollPane)componentArray2[j]).getComponents();
                    for (int k = 0; k != ((Component[])object).length; ++k) {
                        if (!(object[k] instanceof JViewport)) continue;
                        Component[] componentArray3 = ((JViewport)object[k]).getComponents();
                        for (int i2 = 0; i2 != componentArray3.length; ++i2) {
                            JTree jTree;
                            CheckNode checkNode;
                            if (!(componentArray3[i2] instanceof JTree) || (checkNode = (CheckNode)(jTree = (JTree)componentArray3[i2]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(checkNode, gUIFactory);
                        }
                    }
                }
                if (!(componentArray2[j] instanceof JButton)) continue;
                object = (JButton)componentArray2[j];
                String string = (String)this.reverseMessage.get(((AbstractButton)object).getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ').length()));
                if (((AbstractButton)object).getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ')) {
                    this.properties.setValue(string, "true");
                    gUIFactory.alterProperty(string, true);
                    continue;
                }
                this.properties.setValue(string, "false");
                gUIFactory.alterProperty(string, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode checkNode, GUIFactory gUIFactory) {
        for (int i = 0; i != checkNode.getChildCount(); ++i) {
            CheckNode checkNode2 = (CheckNode)checkNode.getChildAt(i);
            String string = (String)this.reverseMessage.get(checkNode2.getText());
            if (checkNode2.isSelected()) {
                this.properties.setValue(string, "true");
                gUIFactory.alterProperty(string, true);
            } else {
                this.properties.setValue(string, "false");
                gUIFactory.alterProperty(string, false);
            }
            if (checkNode2.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(checkNode2, gUIFactory);
        }
    }

    private void createPreferenceWindow(final GUIFactory gUIFactory) {
        this.properties = gUIFactory.getProperties();
        this.propertiesLocation = gUIFactory.getPropertiesFileLocation();
        this.propertiesDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        this.update.setToolTipText(Messages.getMessage("PdfPreferences.update.toolTip"));
        this.invertHighlight.setText(Messages.getMessage("PdfPreferences.InvertHighlight"));
        this.showMouseSelectionBox.setText(Messages.getMessage("PdfPreferences.ShowSelectionBow"));
        this.invertHighlight.setToolTipText(Messages.getMessage("PdfPreferences.invertHighlight.toolTip"));
        this.showMouseSelectionBox.setToolTipText(Messages.getMessage("PdfPreferences.showMouseSelection.toolTip"));
        this.highlightBoxColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightBox.toolTip"));
        this.resolution = new JTextField();
        this.loadStringValue(this.resolution, "resolution", "72");
        this.resolution.setToolTipText(Messages.getMessage("PdfPreferences.resolutionInput.toolTip"));
        this.maxMultiViewers = new JTextField();
        this.loadStringValue(this.maxMultiViewers, "maxmultiviewers", "20");
        this.maxMultiViewers.setToolTipText(Messages.getMessage("PdfPreferences.maxMultiViewer.toolTip"));
        this.searchStyle = gUIFactory.isSingle() ? new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")}) : new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch")});
        this.searchStyle.setToolTipText(Messages.getMessage("PdfPreferences.searchStyle.toolTip"));
        this.liveSearchResuts = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.LiveSearchResults"));
        this.liveSearchResuts.setToolTipText(Messages.getMessage("PdfPreferences.LiveSearchResults.toolTip"));
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText(Messages.getMessage("PdfPreferences.pageLayout.toolTip"));
        this.pageInsetsText = new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText(Messages.getMessage("PdfPreferences.pageInsets.toolTip"));
        this.windowTitleText = new JLabel(Messages.getMessage("PdfCustomGui.windowTitle"));
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText(Messages.getMessage("PdfPreferences.windowTitle.toolTip"));
        this.iconLocationText = new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation"));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText(Messages.getMessage("PdfPreferences.iconLocation.toolTip"));
        this.printerBlacklistText = new JLabel(Messages.getMessage("PdfViewerPrint.blacklist"));
        this.printerBlacklist = new JTextField();
        this.printerBlacklist.setToolTipText(Messages.getMessage("PdfPreferences.printerBlackList.toolTip"));
        this.defaultPrinterText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultPrinter"));
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null) {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text") + " (" + printService.getName() + ')');
        } else {
            this.defaultPrinter.addItem(Messages.getMessage("PdfPreferences.systemDefault.text"));
        }
        this.defaultPrinter.setToolTipText(Messages.getMessage("PdfPreferences.defaultPrinter.toolTip"));
        this.defaultPagesizeText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultPagesize"));
        this.defaultPagesize = new JComboBox();
        this.defaultPagesize.setModel(new DefaultComboBoxModel<String>(gUIFactory.getPaperSizes().getPaperSizes()));
        this.defaultPagesize.setSelectedIndex(gUIFactory.getPaperSizes().getDefaultPageIndex());
        this.defaultPagesize.setToolTipText(Messages.getMessage("PdfPreferences.defaultPageSize.toolTip"));
        this.defaultDPIText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultDPI"));
        this.defaultDPI = new JTextField();
        this.defaultDPI.setToolTipText(Messages.getMessage("PdfPreferences.defaultDPI.toolTip"));
        this.sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText(Messages.getMessage("PdfPreferences.sideTabLength.toolTip"));
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.setToolTipText(Messages.getMessage("PdfPreferences.useHinting.toolTip"));
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText("Set if autoscroll should be enabled / disabled");
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText("Set if we should confirm closing the viewer");
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText("Set if last document should be opened upon start up");
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText("Set if we should display a border for the page");
        this.HiResPrint = new JCheckBox(Messages.getMessage("Printing.HiRes"));
        this.HiResPrint.setToolTipText("Set if hi res printing should be enabled / disabled");
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText("Set to keep sidetabs consistant between files");
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText("Set to use enahnced viewer mode");
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText("Set to turn facing mode to page turn mode");
        this.thumbnailScroll = new JCheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        this.thumbnailScroll.setToolTipText("Set to show thumbnail whilst scrolling");
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText("Set to enable / disable the right click functionality");
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText("Set to enable zooming when scrolling with ctrl pressed");
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText("Clears the history of previous files");
        this.clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                gUIFactory.getRecentDocument().clearRecentDocuments(gUIFactory.getProperties());
                SwingWorker swingWorker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        for (int i = 0; i < 6; ++i) {
                            SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                LogWriter.writeLog("Exception " + interruptedException);
                            }
                        }
                        return null;
                    }
                };
                swingWorker.start();
            }
        });
        JButton jButton = new JButton(Messages.getMessage("PdfPreferences.SaveAs"));
        jButton.setToolTipText("Save preferences in a new file");
        JButton jButton2 = new JButton(Messages.getMessage("PdfPreferences.ResetToDefault"));
        jButton2.setToolTipText("Reset  and save preferences to program defaults");
        this.propertiesDialog.getContentPane().setLayout(new BorderLayout());
        this.propertiesDialog.getContentPane().add((Component)this, "Center");
        this.propertiesDialog.pack();
        if (DecoderOptions.isRunningOnMac) {
            this.propertiesDialog.setSize(600, 475);
        } else {
            this.propertiesDialog.setSize(550, 450);
        }
        this.confirm.setText(Messages.getMessage("PdfPreferences.OK"));
        this.cancel.setText(Messages.getMessage("PdfPreferences.Cancel"));
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.setPreferences(gUIFactory);
                try {
                    SwingProperties.this.properties.writeDoc();
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to write properties " + exception);
                }
                if (GUI.showMessages) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + SwingProperties.this.propertiesLocation + '\n' + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
                }
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.confirm.setToolTipText("Save the preferences in the current loaded preferences file");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.cancel.setToolTipText("Leave preferences window without saving changes");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = gUIFactory.getPropertiesFileLocation();
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return ".xml";
                    }

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getAbsolutePath().endsWith(".xml");
                    }
                });
                int n = jFileChooser.showSaveDialog(SwingProperties.this.propertiesDialog);
                if (n != 1 && n != -1 && n == 0) {
                    String string2 = jFileChooser.getFileFilter().getDescription();
                    File file = jFileChooser.getSelectedFile();
                    String string3 = jFileChooser.getName(file);
                    if (!string2.equals("All Files") && !string3.endsWith(string2)) {
                        string3 = string3 + string2;
                        file = new File(file.getParent() + System.getProperty("file.separator") + string3);
                    }
                    if (file.exists()) {
                        file.delete();
                    }
                    gUIFactory.setPropertiesFileLocation(file.getAbsolutePath());
                    SwingProperties.this.setPreferences(gUIFactory);
                    try {
                        SwingProperties.this.properties.writeDoc();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Attempting to write properties " + actionEvent);
                    }
                }
                gUIFactory.setPropertiesFileLocation(string);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0);
                if (n == 0) {
                    String string = gUIFactory.getPropertiesFileLocation();
                    File file = new File(string);
                    if (file.exists()) {
                        file.delete();
                    }
                    gUIFactory.getProperties().loadProperties(string);
                    try {
                        SwingProperties.this.properties.writeDoc();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Attempting to write properties " + actionEvent);
                    }
                    if (GUI.showMessages) {
                        JOptionPane.showMessageDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.restart"));
                    }
                    SwingProperties.this.propertiesDialog.setVisible(false);
                }
            }
        });
        this.highlightComposite.addKeyListener(new KeyListener(){
            boolean consume;

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.consume = !(!((JTextField)keyEvent.getSource()).getText().contains(".") || keyEvent.getKeyChar() != '.' || keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText("Set the transparency of the highlight");
        this.resolution.addKeyListener(this.numericalKeyListener);
        this.maxMultiViewers.addKeyListener(this.numericalKeyListener);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.add((Component)new ButtonBarPanel(jPanel), "Center");
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        if (this.properties.isReadOnly()) {
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        jPanel2.add(Box.createHorizontalStrut(4));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.confirm);
        jPanel2.add(jButton);
        this.getRootPane().setDefaultButton(this.confirm);
        jPanel2.add(filler);
        jPanel2.add(this.cancel);
        jPanel2.add(filler);
        jPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)jPanel2, "South");
    }

    private void setPreferences(GUIFactory gUIFactory) {
        int n = 0;
        int n2 = this.pageLayout.getSelectedIndex() + 1;
        if (n2 < 1 || n2 > 5) {
            n2 = 1;
        }
        if (this.border.isSelected()) {
            n = 1;
        }
        this.properties.setValue("borderType", String.valueOf(n));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("startView", String.valueOf(n2));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String string = this.iconLocation.getText();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + '/';
        }
        this.properties.setValue("iconLocation", String.valueOf(string));
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("resolution", String.valueOf(this.resolution.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("updateResultsDuringSearch", String.valueOf(this.liveSearchResuts.isSelected()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("maxmultiviewers", String.valueOf(this.maxMultiViewers.getText()));
        this.properties.setValue("useHiResPrinting", String.valueOf(this.HiResPrint.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(this.highlightBoxColor.getBackground().getRGB()));
        this.properties.setValue("vbgColor", String.valueOf(this.viewBGColor.getBackground().getRGB()));
        this.properties.setValue("pdfDisplayBackground", String.valueOf(this.pdfDecoderBackground.getBackground().getRGB()));
        this.properties.setValue("vfgColor", String.valueOf(this.foreGroundColor.getBackground().getRGB()));
        this.properties.setValue("replaceDocumentTextColors", String.valueOf(this.replaceDocTextCol.isSelected()));
        this.properties.setValue("replacePdfDisplayBackground", String.valueOf(this.replaceDisplayBGCol.isSelected()));
        this.properties.setValue("changeTextAndLineart", String.valueOf(this.changeTextAndLineArt.isSelected()));
        this.properties.setValue("invertHighlights", String.valueOf(this.invertHighlight.isSelected()));
        this.properties.setValue("showMouseSelectionBox", String.valueOf(this.showMouseSelectionBox.isSelected()));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("previewOnSingleScroll", String.valueOf(this.thumbnailScroll.isSelected()));
        this.properties.setValue("printerBlacklist", String.valueOf(this.printerBlacklist.getText()));
        if (((String)this.defaultPrinter.getSelectedItem()).startsWith("System Default")) {
            this.properties.setValue("defaultPrinter", "");
        } else {
            this.properties.setValue("defaultPrinter", String.valueOf(this.defaultPrinter.getSelectedItem()));
        }
        this.properties.setValue("defaultDPI", String.valueOf(this.defaultDPI.getText()));
        this.properties.setValue("defaultPagesize", String.valueOf(this.defaultPagesize.getSelectedItem()));
        if (this.speech != null) {
            this.properties.setValue("voice", String.valueOf(this.voiceSelect.getSelectedItem()));
        }
        this.saveGUIPreferences(gUIFactory);
    }

    class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;

        ButtonBarPanel(JPanel jPanel) {
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(22);
            this.add((Component)jScrollPane, "West");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.addButton(Messages.getMessage("PdfPreferences.GeneralTitle"), "/org/jpedal/examples/viewer/res/display.png", this.createGeneralSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), "/org/jpedal/examples/viewer/res/pagedisplay.png", this.createPageDisplaySettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), "/org/jpedal/examples/viewer/res/interface.png", this.createInterfaceSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.ColorTitle"), "/org/jpedal/examples/viewer/res/color.png", this.createColorSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.MenuTitle"), "/org/jpedal/examples/viewer/res/menu.png", this.createMenuSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.PrintingTitle"), "/org/jpedal/examples/viewer/res/printing.png", this.createPrintingSettings(), jPanel, buttonGroup);
            this.addButton(Messages.getMessage("PdfPreferences.ExtensionsTitle"), "/org/jpedal/examples/viewer/res/extensions.png", this.createExtensionsPane(), jPanel, buttonGroup);
        }

        private JPanel makePanel(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setOpaque(true);
            jLabel.setBackground(jPanel.getBackground().brighter());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel2.setFont(jPanel2.getFont().deriveFont(1));
            jPanel2.setOpaque(true);
            jPanel2.setBackground(jPanel.getBackground().brighter());
            jPanel2.add((Component)jLabel, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel.setPreferredSize(new Dimension(400, 300));
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return jPanel;
        }

        private JPanel createGeneralSettings() {
            SwingProperties.this.loadStringValue(SwingProperties.this.resolution, "resolution");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.useHinting, "useHinting");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.autoScroll, "autoScroll");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.confirmClose, "confirmClose");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.update, "automaticupdate");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.openLastDoc, "openLastDocument");
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Resolution"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.resolution, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.useHinting.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.useHinting, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.autoScroll, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.confirmClose, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfPreferences.StartUp"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.update.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.update, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.openLastDoc, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(SwingProperties.this.clearHistory);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(SwingProperties.this.historyClearedLabel);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createPageDisplaySettings() {
            SwingProperties.this.loadBooleanValue(SwingProperties.this.enhancedViewer, "enhancedViewerMode");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.border, "borderType");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.enhancedFacing, "enhancedFacingMode");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.thumbnailScroll, "previewOnSingleScroll");
            SwingProperties.this.loadStringValue(SwingProperties.this.pageInsets, "pageInsets", "25");
            String string = SwingProperties.this.properties.getValue("startView");
            if (!string.isEmpty()) {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 5) {
                    n = 1;
                }
                SwingProperties.this.pageLayout.setSelectedIndex(n - 1);
            }
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.enhancedViewer.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedViewer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedViewer, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.border.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.border, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.pageInsetsText, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageInsets, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfPreferences.DisplayModes"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageLayout, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.enhancedFacing.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedFacing.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedFacing, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.thumbnailScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.thumbnailScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.thumbnailScroll, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private void loadCreateInterfaceSettings() {
            SwingProperties.this.loadBooleanValue(SwingProperties.this.rightClick, "allowRightClick");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.scrollwheelZoom, "allowScrollwheelZoom");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.liveSearchResuts, "updateResultsDuringSearch");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.constantTabs, "consistentTabBar");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.showMouseSelectionBox, "showMouseSelectionBox");
            SwingProperties.this.loadStringValue(SwingProperties.this.windowTitle, "windowTitle");
            SwingProperties.this.loadStringValue(SwingProperties.this.maxMultiViewers, "maxmultiviewers");
            SwingProperties.this.loadStringValue(SwingProperties.this.iconLocation, "iconLocation", "/org/jpedal/examples/viewer/res/");
            SwingProperties.this.loadStringValue(SwingProperties.this.sideTabLength, "sideTabBarCollapseLength", "30");
            String string = SwingProperties.this.properties.getValue("searchWindowType");
            int n = 0;
            if (!string.isEmpty() && (n = Integer.parseInt(string)) >= SwingProperties.this.searchStyle.getItemCount()) {
                n = 0;
            }
            SwingProperties.this.searchStyle.setSelectedIndex(n);
        }

        private void setLayoutConstraints(GridBagConstraints gridBagConstraints, Insets insets, int n, int n2, int n3, int n4, int n5, int n6) {
            gridBagConstraints.insets = insets;
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            gridBagConstraints.weightx = n5;
            gridBagConstraints.weighty = n6;
        }

        private JScrollPane createAppearanceTab() {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            int n = 0;
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, n, 1, 1, 0, 0);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(3, 5, 0, 5), 0, ++n, 1, 1, 0, 0);
            jPanel.add((Component)SwingProperties.this.windowTitleText, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(3, 5, 0, 5), 1, n, 1, 1, 0, 0);
            jPanel.add((Component)SwingProperties.this.windowTitle, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 1, 1, 0, 0);
            jPanel.add((Component)SwingProperties.this.iconLocationText, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 1, n, 1, 1, 0, 0);
            jPanel.add((Component)SwingProperties.this.iconLocation, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 1, 1, 0, 0);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)jLabel2, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 1, n, 1, 1, 1, 0);
            jPanel.add((Component)SwingProperties.this.searchStyle, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 0, 0, 5), 0, ++n, 1, 1, 1, 0);
            jPanel.add((Component)SwingProperties.this.liveSearchResuts, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(10, 5, 5, 5), 0, ++n, 1, 1, 0, 0);
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfPreferences.MaxMultiViewers"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)jLabel3, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 1, n, 1, 1, 1, 0);
            jPanel.add((Component)SwingProperties.this.maxMultiViewers, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(15, 5, 5, 5), 0, ++n, 1, 1, 0, 0);
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfPreferences.SideTab"));
            jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            jPanel.add((Component)jLabel4, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 1, 1, 0, 0);
            SwingProperties.this.sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)SwingProperties.this.sideTabLengthText, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 1, n, 1, 1, 1, 0);
            jPanel.add((Component)SwingProperties.this.sideTabLength, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 2, 1, 1, 0);
            SwingProperties.this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)SwingProperties.this.constantTabs, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 2, 1, 1, 1);
            jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            return jScrollPane;
        }

        private JScrollPane createMouseTab() {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            int n = 0;
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, n, 1, 1, 0, 0);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 2, 1, 0, 0);
            SwingProperties.this.rightClick.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)SwingProperties.this.rightClick, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 5, 5, 5), 0, ++n, 2, 1, 0, 0);
            SwingProperties.this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)SwingProperties.this.scrollwheelZoom, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(0, 0, 0, 5), 0, ++n, 1, 1, 0, 0);
            jPanel.add((Component)SwingProperties.this.showMouseSelectionBox, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(0, 0, 0, 5), 0, ++n, 1, 1, 1, 0);
            jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            return jScrollPane;
        }

        private JScrollPane createSpeechTab() {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            int n = 0;
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 0, 0, 5), 0, n, 1, 1, 0, 0);
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel.add((Component)jLabel, gridBagConstraints);
            SwingProperties.this.voiceSelect = new JComboBox<String>(SwingProperties.this.speech.listVoices());
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 0, 0, 5), 0, ++n, 1, 1, 0, 0);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfPreferences.Voice"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)jLabel2, gridBagConstraints);
            SwingProperties.this.voiceSelect.setSelectedItem(SwingProperties.this.properties.getValue("voice"));
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 0, 0, 0), 1, n, 1, 1, 1, 0);
            jPanel.add((Component)SwingProperties.this.voiceSelect, gridBagConstraints);
            this.setLayoutConstraints(gridBagConstraints, new Insets(5, 0, 0, 0), 0, ++n, 1, 1, 1, 1);
            jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            return jScrollPane;
        }

        private JPanel createInterfaceSettings() {
            this.loadCreateInterfaceSettings();
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.InterfaceTitle"));
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.add(Messages.getMessage("PdfPreferences.AppearanceTab"), this.createAppearanceTab());
            jTabbedPane.add(Messages.getMessage("PdfPreferences.Mouse"), this.createMouseTab());
            if (SwingProperties.this.speech != null) {
                jTabbedPane.add(Messages.getMessage("PdfPreferences.Speech"), this.createSpeechTab());
            }
            jPanel.add((Component)jTabbedPane, "Center");
            return jPanel;
        }

        private JPanel createPrintingSettings() {
            Object object;
            SwingProperties.this.loadBooleanValue(SwingProperties.this.HiResPrint, "useHiResPrinting");
            SwingProperties.this.loadStringValue(SwingProperties.this.printerBlacklist, "printerBlacklist");
            String string = SwingProperties.this.properties.getValue("defaultPrinter");
            if (string != null && !string.isEmpty()) {
                SwingProperties.this.defaultPrinter.setSelectedItem(string);
            } else {
                object = PrintServiceLookup.lookupDefaultPrintService();
                if (object != null) {
                    SwingProperties.this.defaultPrinter.setSelectedItem("System Default (" + object.getName() + ')');
                } else {
                    SwingProperties.this.defaultPrinter.setSelectedItem("System Default");
                }
            }
            string = SwingProperties.this.properties.getValue("defaultDPI");
            if (string != null && !string.isEmpty()) {
                try {
                    string = string.replaceAll("[^0-9]", "");
                    SwingProperties.this.defaultDPI.setText(Integer.parseInt(string) + "dpi");
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Attempting to get Properties values " + exception);
                }
            }
            object = this.makePanel(Messages.getMessage("PdfPreferences.PrintingTitle"));
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.HiResPrint.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.HiResPrint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add((Component)SwingProperties.this.HiResPrint, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)SwingProperties.this.defaultPrinterText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)SwingProperties.this.defaultPrinter, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)SwingProperties.this.defaultPagesizeText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)SwingProperties.this.defaultPagesize, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)SwingProperties.this.defaultDPIText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel.add((Component)SwingProperties.this.defaultDPI, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)SwingProperties.this.printerBlacklistText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)SwingProperties.this.printerBlacklist, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
            ((Container)object).add(jScrollPane);
            return object;
        }

        private JPanel createColorSettings() {
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            String string = SwingProperties.this.properties.getValue("highlightBoxColor");
            int n = !string.isEmpty() ? Integer.parseInt(string) : DecoderOptions.highlightColor.getRGB();
            final Color color = new Color(n);
            SwingProperties.this.highlightBoxColor.setBackground(color);
            final JButton jButton = new JButton(Messages.getMessage("PdfPreferences.ChangeHighlightColor"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color2 = JColorChooser.showDialog(null, "Highlight Color", color);
                    SwingProperties.this.highlightBoxColor.setBackground(color2);
                }
            });
            SwingProperties.this.loadStringValue(SwingProperties.this.highlightComposite, "highlightComposite");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.invertHighlight, "invertHighlights");
            final JLabel jLabel = new JLabel(Messages.getMessage("PdfPreferences.ChangeHighlightTransparency"));
            if (SwingProperties.this.invertHighlight.isSelected()) {
                SwingProperties.this.highlightBoxColor.setEnabled(false);
                SwingProperties.this.highlightComposite.setEnabled(false);
                jButton.setEnabled(false);
                jLabel.setEnabled(false);
            } else {
                SwingProperties.this.highlightBoxColor.setEnabled(true);
                SwingProperties.this.highlightComposite.setEnabled(true);
                jButton.setEnabled(true);
                jLabel.setEnabled(true);
            }
            SwingProperties.this.invertHighlight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                        SwingProperties.this.highlightBoxColor.setEnabled(false);
                        SwingProperties.this.highlightComposite.setEnabled(false);
                        jButton.setEnabled(false);
                        jLabel.setEnabled(false);
                    } else {
                        SwingProperties.this.highlightBoxColor.setEnabled(true);
                        SwingProperties.this.highlightComposite.setEnabled(true);
                        jButton.setEnabled(true);
                        jLabel.setEnabled(true);
                    }
                }
            });
            string = SwingProperties.this.properties.getValue("vbgColor");
            int n2 = 0;
            if (!string.isEmpty()) {
                n2 = Integer.parseInt(string);
            } else if (DecoderOptions.backgroundColor != null) {
                n2 = DecoderOptions.backgroundColor.getRGB();
            }
            final Color color2 = new Color(n2);
            SwingProperties.this.viewBGColor.setBackground(color2);
            JButton jButton2 = new JButton(Messages.getMessage("PdfPreferences.ChangeBackgroundColor"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, "BackGround Color", color2);
                    SwingProperties.this.viewBGColor.setBackground(color);
                }
            });
            string = SwingProperties.this.properties.getValue("vfgColor");
            int n3 = 0;
            if (!string.isEmpty()) {
                n3 = Integer.parseInt(string);
            }
            final Color color3 = new Color(n3);
            SwingProperties.this.foreGroundColor.setBackground(color3);
            final JButton jButton3 = new JButton(Messages.getMessage("PdfPreferences.ChangeForegroundColor"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, "Foreground Color", color3);
                    SwingProperties.this.foreGroundColor.setBackground(color);
                }
            });
            SwingProperties.this.loadBooleanValue(SwingProperties.this.changeTextAndLineArt, "changeTextAndLineart");
            SwingProperties.this.loadBooleanValue(SwingProperties.this.replaceDocTextCol, "replaceDocumentTextColors");
            if (SwingProperties.this.replaceDocTextCol.isSelected()) {
                jButton3.setEnabled(true);
                SwingProperties.this.foreGroundColor.setEnabled(true);
                SwingProperties.this.changeTextAndLineArt.setEnabled(true);
            } else {
                jButton3.setEnabled(false);
                SwingProperties.this.foreGroundColor.setEnabled(false);
                SwingProperties.this.changeTextAndLineArt.setEnabled(false);
            }
            SwingProperties.this.replaceDocTextCol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                        jButton3.setEnabled(true);
                        SwingProperties.this.foreGroundColor.setEnabled(true);
                        SwingProperties.this.changeTextAndLineArt.setEnabled(true);
                    } else {
                        jButton3.setEnabled(false);
                        SwingProperties.this.foreGroundColor.setEnabled(false);
                        SwingProperties.this.changeTextAndLineArt.setEnabled(false);
                    }
                }
            });
            string = SwingProperties.this.properties.getValue("pdfDisplayBackground");
            int n4 = 0;
            if (!string.isEmpty()) {
                n4 = Integer.parseInt(string);
            }
            final Color color4 = new Color(n4);
            SwingProperties.this.pdfDecoderBackground.setBackground(color4);
            final JButton jButton4 = new JButton(Messages.getMessage("PdfPreferences.ChangeDisplayBackgroundColor"));
            jButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(null, "Display Background Color", color4);
                    SwingProperties.this.pdfDecoderBackground.setBackground(color);
                }
            });
            SwingProperties.this.loadBooleanValue(SwingProperties.this.replaceDisplayBGCol, "replacePdfDisplayBackground");
            if (SwingProperties.this.replaceDisplayBGCol.isSelected()) {
                jButton4.setEnabled(true);
                SwingProperties.this.pdfDecoderBackground.setEnabled(true);
            } else {
                jButton4.setEnabled(false);
                SwingProperties.this.pdfDecoderBackground.setEnabled(false);
            }
            SwingProperties.this.replaceDisplayBGCol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                        jButton4.setEnabled(true);
                        SwingProperties.this.pdfDecoderBackground.setEnabled(true);
                    } else {
                        jButton4.setEnabled(false);
                        SwingProperties.this.pdfDecoderBackground.setEnabled(false);
                    }
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel("Highlights");
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            SwingProperties.this.highlightBoxColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel2.add((Component)SwingProperties.this.highlightBoxColor, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)jButton, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.highlightComposite, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 25, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.invertHighlight, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel("Dispaly Colors");
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            SwingProperties.this.viewBGColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel2.add((Component)SwingProperties.this.viewBGColor, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)jButton2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)SwingProperties.this.replaceDocTextCol, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            SwingProperties.this.foreGroundColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel2.add((Component)SwingProperties.this.foreGroundColor, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)jButton3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.changeTextAndLineArt, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)SwingProperties.this.replaceDisplayBGCol, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pdfDecoderBackground.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel2.add((Component)SwingProperties.this.pdfDecoderBackground, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)jButton4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(Box.createHorizontalGlue());
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createMenuSettings() {
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.MenuTitle"));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            SwingProperties.this.tabs = new JTabbedPane();
            for (int i = 0; i != SwingProperties.this.menuTabs.length; ++i) {
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]), SwingProperties.this.menuTabs[i]);
                CheckNode checkNode = new CheckNode(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                checkNode.setEnabled(true);
                checkNode.setSelected(true);
                ArrayList<CheckNode> arrayList = new ArrayList<CheckNode>();
                arrayList.add(checkNode);
                NodeList nodeList = SwingProperties.this.properties.getChildren(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]) + "Menu");
                this.addMenuToTree(i, nodeList, checkNode, arrayList);
                final JTree jTree = new JTree(checkNode);
                JScrollPane jScrollPane = new JScrollPane(jTree);
                jTree.setCellRenderer(new CheckRenderer());
                jTree.getSelectionModel().setSelectionMode(1);
                jTree.addTreeSelectionListener(new TreeSelectionListener(){

                    private void setChildrenValue(CheckNode checkNode, boolean bl) {
                        for (int i = 0; i != checkNode.getChildCount(); ++i) {
                            ((CheckNode)checkNode.getChildAt(i)).setSelected(bl);
                            if (checkNode.getChildAt(i).getChildCount() <= 0) continue;
                            this.setChildrenValue((CheckNode)checkNode.getChildAt(i), bl);
                        }
                    }

                    private void setParentValue(CheckNode checkNode, boolean bl) {
                        checkNode.setSelected(bl);
                        if (checkNode.getParent() != null) {
                            this.setParentValue((CheckNode)checkNode.getParent(), bl);
                        }
                    }

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                CheckNode checkNode = (CheckNode)defaultMutableTreeNode;
                                if (checkNode != null) {
                                    int n;
                                    boolean bl;
                                    boolean bl2 = bl = !checkNode.isSelected();
                                    if (SwingProperties.this.reverseMessage.get(checkNode.getText()).equals("Preferences") && !bl && (n = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, "Disabling this option will mean you can not acces this menu using this properties file. Do you want to continue?", "Preferences Access", 0)) == 1) {
                                        boolean bl3 = bl = !bl;
                                    }
                                    if (checkNode.getChildCount() > 0) {
                                        this.setChildrenValue(checkNode, bl);
                                    }
                                    if (checkNode.getParent() != null && bl) {
                                        this.setParentValue((CheckNode)checkNode.getParent(), bl);
                                    }
                                    checkNode.setSelected(bl);
                                    jTree.invalidate();
                                    jTree.clearSelection();
                                    jTree.repaint();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                });
                JPanel jPanel3 = new JPanel(new BorderLayout());
                final JButton jButton = new JButton();
                String string = SwingProperties.this.properties.getValue(SwingProperties.this.menuTabs[i]);
                if (string.equalsIgnoreCase("true")) {
                    jButton.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                } else {
                    jButton.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                }
                final int n = i;
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jButton.getText().startsWith("Click here to show ")) {
                            jButton.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[n]));
                        } else {
                            jButton.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + ' ' + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[n]));
                        }
                    }
                });
                jPanel3.add((Component)jScrollPane, "Center");
                jPanel3.add((Component)jButton, "South");
                SwingProperties.this.tabs.add((Component)jPanel3, Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
            }
            jPanel2.add((Component)SwingProperties.this.tabs, "Center");
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private boolean removeOption(String string) {
            if (string.equals("Helpbutton")) {
                return true;
            }
            if (string.equals("RSSbutton")) {
                return true;
            }
            return string.equals("Helpforum");
        }

        private void addMenuToTree(int n, NodeList nodeList, CheckNode checkNode, List list) {
            for (int i = 0; i != nodeList.getLength(); ++i) {
                String string;
                if (i >= nodeList.getLength() || this.removeOption(string = nodeList.item(i).getNodeName()) || string.startsWith("#")) continue;
                CheckNode checkNode2 = new CheckNode(Messages.getMessage("PdfCustomGui." + string));
                checkNode2.setEnabled(true);
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + string), string);
                SwingProperties.this.loadBooleanValue(checkNode2, string);
                if (nodeList.item(i).hasChildNodes()) {
                    list.add(checkNode);
                    checkNode.add(checkNode2);
                    this.addMenuToTree(n, nodeList.item(i).getChildNodes(), checkNode2, list);
                    continue;
                }
                checkNode.add(checkNode2);
            }
        }

        private JPanel createExtensionsPane() {
            class Link
            extends MouseAdapter {
                private final String url;

                Link(String string) {
                    this.url = string;
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (GUIDisplay.allowChangeCursor) {
                        jPanel2.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (GUIDisplay.allowChangeCursor) {
                        jPanel2.setCursor(Cursor.getDefaultCursor());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    try {
                        BrowserLauncher.openURL(this.url);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(jPanel2, Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            }
            Object object;
            Object object2;
            JLabel jLabel;
            Object object3;
            Serializable serializable;
            Object object4;
            Object object5;
            Serializable serializable2;
            JPanel jPanel = this.makePanel(Messages.getMessage("PdfPreferences.ExtensionsTitle"));
            final JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(12, 2, 5, 2);
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfPreferences.ExtensionName"));
            Font font = jLabel2.getFont().deriveFont(1, jLabel2.getFont().getSize2D());
            jLabel2.setFont(font);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            JLabel jLabel3 = new JLabel(Messages.getMessage("PdfPreferences.ExtensionDescription"));
            jLabel3.setFont(font);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            JLabel jLabel4 = new JLabel(Messages.getMessage("PdfPreferences.ExtensionVersion"));
            jLabel4.setFont(font);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 2;
            jPanel2.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            String string = "java: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + '\n';
            string = string + "os: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n';
            string = string + "jpedal: 6.6.30\n";
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)new JLabel("BCMail"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.BCMail.text")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            String string2 = "Unknown version";
            try {
                serializable2 = Class.forName("org.bouncycastle.jcajce.JcaJceHelper");
                object5 = ((Class)serializable2).getName().replace('.', '/');
                object4 = ((Class)serializable2).getResource('/' + (String)object5 + ".class").getPath().split("!");
                serializable = new URL(object4[0]);
                object3 = new JarFile(((URL)serializable).getFile());
                if (!((JarFile)object3).getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                    string2 = ((JarFile)object3).getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                jLabel = new JLabel("<html>" + string2);
                string = string + "bcmail: " + string2 + '\n';
            }
            catch (Exception exception) {
                jLabel = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + exception + "</u></html>");
                jLabel.setForeground(Color.BLUE);
                jLabel.addMouseListener(new Link(Messages.getMessage("PdfExtensions.BCMail.link")));
            }
            catch (Error error) {
                jLabel = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + error + "</u></html>");
                jLabel.setForeground(Color.BLUE);
                jLabel.addMouseListener(new Link(Messages.getMessage("PdfExtensions.BCMail.link")));
            }
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)new JLabel("CID"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.CID.text")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            try {
                if (SwingProperties.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf") != null) {
                    serializable2 = new JLabel("<html>1.0");
                    string = string + "cid: 1.0\n";
                } else {
                    serializable2 = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                    ((JComponent)serializable2).setForeground(Color.BLUE);
                    ((Component)serializable2).addMouseListener(new Link(Messages.getMessage("PdfExtensions.CID.link")));
                }
                jPanel2.add((Component)serializable2, gridBagConstraints);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)new JLabel("JavaFX"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.JavaFX.text")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            if (JavaFXHelper.isJavaFXAvailable()) {
                string2 = JavaFXHelper.getVersion();
                object5 = new JLabel("<html>" + string2.replaceAll("build", "b").replaceAll("[(|)]", ""));
                string = string + "javafx: " + string2 + '\n';
            } else {
                object5 = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                ((JComponent)object5).setForeground(Color.BLUE);
                ((Component)object5).addMouseListener(new Link(Messages.getMessage("PdfExtensions.JavaFX.link")));
            }
            jPanel2.add((Component)object5, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)new JLabel("JCE"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.JCE.text")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            string2 = "Unknown version";
            try {
                serializable = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                object3 = ((Class)serializable).getName().replace('.', '/');
                object2 = ((Class)serializable).getResource('/' + (String)object3 + ".class").getPath().split("!");
                object = new URL(object2[0]);
                JarFile jarFile = new JarFile(((URL)object).getFile());
                if (!jarFile.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                    string2 = jarFile.getManifest().getMainAttributes().getValue("Implementation-Version");
                }
                object4 = new JLabel("<html>" + string2);
                string = string + "jce: " + string2 + '\n';
            }
            catch (Exception exception) {
                object4 = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + ' ' + exception + "</u></html>");
                ((JComponent)object4).setForeground(Color.BLUE);
                ((Component)object4).addMouseListener(new Link(Messages.getMessage("PdfExtensions.JCE.link")));
            }
            jPanel2.add((Component)object4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)new JLabel("Rhino"), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)new JLabel("<html>" + Messages.getMessage("PdfExtensions.Rhino.text")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            object3 = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
            if (object3 != null) {
                string2 = ScriptRuntime.getMessage0((String)"implementation.version");
                string = string + "rhino: " + string2 + '\n';
                object2 = "";
                if (!string2.replaceAll("release 1", "").equals(string2)) {
                    object2 = " R1";
                }
                if (!string2.replaceAll("release 2", "").equals(string2)) {
                    object2 = " R2";
                }
                string2 = string2.substring(0, 12).replaceAll("[^0-9|.]", "");
                serializable = new JLabel("<html>" + string2 + (String)object2);
            } else {
                serializable = new JLabel("<html><u>" + Messages.getMessage("PdfExtensions.getText") + "</u></html>");
                ((JComponent)serializable).setForeground(Color.BLUE);
                ((Component)serializable).addMouseListener(new Link(Messages.getMessage("PdfExtensions.Rhino.link")));
            }
            jPanel2.add((Component)serializable, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 26;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 13;
            object2 = new JButton(Messages.getMessage("PdfPreferences.CopyToClipboard"));
            object = string;
            ((AbstractButton)object2).addActionListener(new ActionListener((String)object, jPanel2){
                final /* synthetic */ String val$finalDetails;
                final /* synthetic */ JPanel val$pane;
                {
                    this.val$finalDetails = string;
                    this.val$pane = jPanel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.val$finalDetails), null);
                    JOptionPane.showMessageDialog(this.val$pane, Messages.getMessage("PdfExtensions.clipboard"));
                }
            });
            jPanel2.add((Component)object2, gridBagConstraints);
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String string, String string2, final Component component, JPanel jPanel, ButtonGroup buttonGroup) {
            AbstractAction abstractAction = new AbstractAction(string, new ImageIcon(this.getClass().getResource(string2))){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton jToggleButton = new JToggleButton(abstractAction);
            jToggleButton.setVerticalTextPosition(3);
            jToggleButton.setHorizontalTextPosition(0);
            jToggleButton.setContentAreaFilled(false);
            if (DecoderOptions.isRunningOnMac) {
                jToggleButton.setHorizontalAlignment(2);
            }
            jToggleButton.setAlignmentX(0.5f);
            jPanel.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (buttonGroup.getSelection() == null) {
                jToggleButton.setSelected(true);
                this.show(component);
            }
        }
    }
}

