/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;

public class TipOfTheDay
extends JDialog {
    private final List tipPaths = new ArrayList();
    private boolean tipLoadingFailed;
    private int currentTip;
    private final JEditorPane tipPane = new JEditorPane();
    private final JCheckBox showTipsOnStartup = new JCheckBox("Show Tips on Startup");

    public TipOfTheDay(Container container, String string, PropertiesFile propertiesFile) {
        super((Frame)null, "Tip of the Day", true);
        this.setDefaultCloseOperation(2);
        try {
            this.populateTipsList(string, this.tipPaths);
        }
        catch (IOException iOException) {
            this.tipLoadingFailed = true;
            LogWriter.writeLog("Exception " + iOException.getMessage());
        }
        Random random = new Random();
        this.currentTip = random.nextInt(this.tipPaths.size());
        this.setSize(550, 350);
        this.init(propertiesFile);
        this.setLocationRelativeTo(container);
    }

    private void init(PropertiesFile propertiesFile) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.addTopPanel(gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.addCenterTip(gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 10);
        this.addDisplayOnStartup(gridBagConstraints, propertiesFile);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.addBottomButtons(gridBagConstraints);
    }

    private void addDisplayOnStartup(GridBagConstraints gridBagConstraints, final PropertiesFile propertiesFile) {
        String string = propertiesFile.getValue("displaytipsonstartup");
        if (!string.isEmpty()) {
            this.showTipsOnStartup.setSelected(string.equals("true"));
        }
        this.showTipsOnStartup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propertiesFile.setValue("displaytipsonstartup", String.valueOf(TipOfTheDay.this.showTipsOnStartup.isSelected()));
            }
        });
        this.getContentPane().add((Component)this.showTipsOnStartup, gridBagConstraints);
    }

    private void addBottomButtons(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Previous Tip");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TipOfTheDay.this.changeTip(-1);
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton2 = new JButton("Next Tip");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TipOfTheDay.this.changeTip(1);
            }
        });
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton3 = new JButton("Close");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TipOfTheDay.this.dispose();
                TipOfTheDay.this.setVisible(false);
            }
        });
        jButton3.setPreferredSize(jButton.getPreferredSize());
        this.setFocusTraversalPolicy(new MyFocus(this.getFocusTraversalPolicy(), jButton3));
        jButton3.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TipOfTheDay.this.dispose();
                    TipOfTheDay.this.setVisible(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
    }

    private void changeTip(int n) {
        this.currentTip += n;
        if (this.currentTip == this.tipPaths.size()) {
            this.currentTip = 0;
        } else if (this.currentTip == -1) {
            this.currentTip = this.tipPaths.size() - 1;
        }
        if (!this.tipLoadingFailed) {
            try {
                this.tipPane.setPage(this.getClass().getResource((String)this.tipPaths.get(this.currentTip)));
            }
            catch (IOException iOException) {
                this.tipLoadingFailed = true;
                LogWriter.writeLog("Exception " + iOException.getMessage());
            }
        }
        if (this.tipLoadingFailed) {
            this.tipPane.setText("Error displaying tips, no tip to display");
        }
    }

    private void populateTipsList(String string, List list) throws IOException {
        try {
            URL uRL = this.getClass().getResource(string);
            if (uRL.toString().startsWith("jar")) {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string2 = jarEntry.getName();
                    if (jarEntry.isDirectory() || !string2.contains("/res/tips/") || !string2.endsWith(".html")) continue;
                    list.add('/' + string2);
                }
            } else {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.indexOf(46) == -1) {
                        this.populateTipsList(string + '/' + string3, list);
                        continue;
                    }
                    if (!string3.endsWith(".htm") && !string3.endsWith(".html")) continue;
                    list.add(string + '/' + string3);
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception " + iOException.getMessage());
            throw iOException;
        }
    }

    private void addCenterTip(GridBagConstraints gridBagConstraints) {
        this.tipPane.setEditable(false);
        this.tipPane.setAutoscrolls(true);
        this.tipPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    try {
                        BrowserLauncher.openURL(hyperlinkEvent.getURL().toExternalForm());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(TipOfTheDay.class.getName()).log(Level.SEVERE, null, exception);
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.tipPane);
        jScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        this.changeTip(0);
    }

    private void addTopPanel(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/viewer/res/tip.png")));
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Did you know ... ?");
        Font font = jLabel2.getFont().deriveFont(16.0f);
        jLabel2.setFont(font);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jLabel2);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
    }

    static class MyFocus
    extends FocusTraversalPolicy {
        final FocusTraversalPolicy original;
        final JButton close;

        MyFocus(FocusTraversalPolicy focusTraversalPolicy, JButton jButton) {
            this.original = focusTraversalPolicy;
            this.close = jButton;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return this.original.getComponentAfter(container, component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return this.original.getComponentBefore(container, component);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.original.getFirstComponent(container);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.original.getLastComponent(container);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.close;
        }
    }
}

