/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jpedal.examples.viewer.gui.popups.WizardPanelModel;

public class Wizard {
    private static final String BACK_TEXT = "< Back";
    private static final String NEXT_TEXT = "Next >";
    private static final String CANCEL_TEXT = "Cancel";
    private static final String FINISH_TEXT = "Finish";
    private final JDialog wizardDialog;
    private final WizardPanelModel panelManager;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton advanceButton;
    private JButton cancelButton;
    private int returnCode = 2;

    public Wizard(Frame frame, WizardPanelModel wizardPanelModel) {
        this.wizardDialog = new JDialog(frame);
        this.panelManager = wizardPanelModel;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        Box box = new Box(0);
        this.wizardDialog.setDefaultCloseOperation(2);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        Map map = this.panelManager.getJPanels();
        Set set = map.keySet();
        for (Object k : set) {
            String string = (String)k;
            this.cardPanel.add(string, (JPanel)map.get(string));
        }
        this.backButton = new JButton(BACK_TEXT);
        this.advanceButton = new JButton(NEXT_TEXT);
        this.cancelButton = new JButton(CANCEL_TEXT);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.previousPanel();
            }
        });
        this.advanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.nextPanel();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.returnCode = 2;
                Wizard.this.panelManager.close();
                Wizard.this.wizardDialog.dispose();
            }
        });
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JSeparator(), "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.advanceButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        jPanel.add((Component)box, "East");
        this.wizardDialog.getContentPane().add((Component)jPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
        this.cardLayout.show(this.cardPanel, this.panelManager.getStartPanelID());
        this.setBackButtonEnabled(this.panelManager.hasPrevious());
        this.setNextButtonEnabled(this.panelManager.canAdvance());
        this.panelManager.registerNextChangeListeners(new buttonNextState());
        this.panelManager.registerNextKeyListeners(new textboxPressState());
    }

    private void setBackButtonEnabled(boolean bl) {
        this.backButton.setEnabled(bl);
    }

    private void setNextButtonEnabled(boolean bl) {
        this.advanceButton.setEnabled(bl);
    }

    private void nextPanel() {
        if (this.advanceButton.getText().equals(FINISH_TEXT)) {
            this.panelManager.close();
            this.returnCode = 0;
            this.wizardDialog.dispose();
        } else {
            this.cardLayout.show(this.cardPanel, this.panelManager.next());
            this.setBackButtonEnabled(this.panelManager.hasPrevious());
            this.setNextButtonEnabled(this.panelManager.canAdvance());
            if (this.panelManager.isFinishPanel()) {
                this.advanceButton.setText(FINISH_TEXT);
            }
        }
    }

    private void previousPanel() {
        if (this.panelManager.isFinishPanel()) {
            this.advanceButton.setText(NEXT_TEXT);
        }
        this.cardLayout.show(this.cardPanel, this.panelManager.previous());
        this.setBackButtonEnabled(this.panelManager.hasPrevious());
        this.setNextButtonEnabled(this.panelManager.canAdvance());
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        this.wizardDialog.setLocationRelativeTo(null);
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    private class textboxPressState
    implements KeyListener {
        private textboxPressState() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            Wizard.this.setNextButtonEnabled(Wizard.this.panelManager.canAdvance());
        }
    }

    private class buttonNextState
    implements ChangeListener {
        private buttonNextState() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Wizard.this.setNextButtonEnabled(Wizard.this.panelManager.canAdvance());
        }
    }
}

