/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.paper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.jpedal.examples.viewer.paper.MarginPaper;

public class PaperSizes {
    Map paperDefinitions = new HashMap();
    ArrayList paperList = new ArrayList();
    private static final double mmToSubInch = 2.834645669291339;
    final Map paperNames = new HashMap();
    private int defaultPageIndex;
    private String defaultSize;
    private PrintService printService;

    public PaperSizes(PrintService printService) {
        this.defaultSize = null;
        this.populateNameMap();
        PaperSizes.addCustomPaperSizes();
        this.setPrintService(printService);
    }

    public PaperSizes(String string) {
        this.defaultSize = string;
        this.populateNameMap();
        PaperSizes.addCustomPaperSizes();
    }

    public String[] getAvailablePaperSizes() {
        Object[] objectArray = this.paperList.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public MarginPaper getSelectedPaper(Object object) {
        return (MarginPaper)this.paperDefinitions.get(object);
    }

    private static void addCustomPaperSizes() {
    }

    private void setDefault() {
        int n;
        if (this.paperList == null) {
            return;
        }
        this.defaultPageIndex = -1;
        String string = System.getProperty("org.jpedal.printPaperSize");
        if (string != null) {
            for (n = 0; n < this.paperList.size(); ++n) {
                if (!this.paperList.get(n).equals(string)) continue;
                this.defaultPageIndex = n;
            }
        }
        if (this.defaultPageIndex == -1 && this.defaultSize != null && !this.defaultSize.isEmpty()) {
            for (n = 0; n < this.paperList.size(); ++n) {
                if (!this.defaultSize.equals(this.paperList.get(n))) continue;
                this.defaultPageIndex = n;
            }
        }
        if (this.defaultPageIndex == -1) {
            this.defaultSize = "A4";
            String[] stringArray = new String[]{"US", "CA", "MX", "CO", "VE", "AR", "CL", "PH"};
            String string2 = Locale.getDefault().getCountry();
            for (String string3 : stringArray) {
                if (!string2.equals(string3)) continue;
                this.defaultSize = "North American Letter";
            }
            for (int i = 0; i < this.paperList.size(); ++i) {
                if (!this.defaultSize.equals(this.paperList.get(i))) continue;
                this.defaultPageIndex = i;
            }
            if (this.defaultPageIndex == -1) {
                this.defaultPageIndex = 0;
            }
        }
    }

    public synchronized void setPrintService(PrintService printService) {
        this.printService = printService;
        this.paperDefinitions = new HashMap();
        this.paperList = new ArrayList();
        this.checkAndAddSize(MediaSizeName.ISO_A4);
        this.checkAndAddSize(MediaSizeName.NA_LETTER);
        this.checkAndAddSize(MediaSizeName.ISO_A0);
        this.checkAndAddSize(MediaSizeName.ISO_A1);
        this.checkAndAddSize(MediaSizeName.ISO_A2);
        this.checkAndAddSize(MediaSizeName.ISO_A3);
        this.checkAndAddSize(MediaSizeName.ISO_A5);
        this.checkAndAddSize(MediaSizeName.ISO_A6);
        this.checkAndAddSize(MediaSizeName.ISO_A7);
        this.checkAndAddSize(MediaSizeName.ISO_A8);
        this.checkAndAddSize(MediaSizeName.ISO_A9);
        this.checkAndAddSize(MediaSizeName.ISO_A10);
        this.checkAndAddSize(MediaSizeName.ISO_B0);
        this.checkAndAddSize(MediaSizeName.ISO_B1);
        this.checkAndAddSize(MediaSizeName.ISO_B2);
        this.checkAndAddSize(MediaSizeName.ISO_B3);
        this.checkAndAddSize(MediaSizeName.ISO_B4);
        this.checkAndAddSize(MediaSizeName.ISO_B5);
        this.checkAndAddSize(MediaSizeName.ISO_B6);
        this.checkAndAddSize(MediaSizeName.ISO_B7);
        this.checkAndAddSize(MediaSizeName.ISO_B8);
        this.checkAndAddSize(MediaSizeName.ISO_B9);
        this.checkAndAddSize(MediaSizeName.ISO_B10);
        this.checkAndAddSize(MediaSizeName.JIS_B0);
        this.checkAndAddSize(MediaSizeName.JIS_B1);
        this.checkAndAddSize(MediaSizeName.JIS_B2);
        this.checkAndAddSize(MediaSizeName.JIS_B3);
        this.checkAndAddSize(MediaSizeName.JIS_B4);
        this.checkAndAddSize(MediaSizeName.JIS_B5);
        this.checkAndAddSize(MediaSizeName.JIS_B6);
        this.checkAndAddSize(MediaSizeName.JIS_B7);
        this.checkAndAddSize(MediaSizeName.JIS_B8);
        this.checkAndAddSize(MediaSizeName.JIS_B9);
        this.checkAndAddSize(MediaSizeName.JIS_B10);
        this.checkAndAddSize(MediaSizeName.ISO_C0);
        this.checkAndAddSize(MediaSizeName.ISO_C1);
        this.checkAndAddSize(MediaSizeName.ISO_C2);
        this.checkAndAddSize(MediaSizeName.ISO_C3);
        this.checkAndAddSize(MediaSizeName.ISO_C4);
        this.checkAndAddSize(MediaSizeName.ISO_C5);
        this.checkAndAddSize(MediaSizeName.ISO_C6);
        this.checkAndAddSize(MediaSizeName.NA_LEGAL);
        this.checkAndAddSize(MediaSizeName.EXECUTIVE);
        this.checkAndAddSize(MediaSizeName.LEDGER);
        this.checkAndAddSize(MediaSizeName.TABLOID);
        this.checkAndAddSize(MediaSizeName.INVOICE);
        this.checkAndAddSize(MediaSizeName.FOLIO);
        this.checkAndAddSize(MediaSizeName.QUARTO);
        this.checkAndAddSize(MediaSizeName.JAPANESE_POSTCARD);
        this.checkAndAddSize(MediaSizeName.JAPANESE_DOUBLE_POSTCARD);
        this.checkAndAddSize(MediaSizeName.A);
        this.checkAndAddSize(MediaSizeName.B);
        this.checkAndAddSize(MediaSizeName.C);
        this.checkAndAddSize(MediaSizeName.D);
        this.checkAndAddSize(MediaSizeName.E);
        this.checkAndAddSize(MediaSizeName.ISO_DESIGNATED_LONG);
        this.checkAndAddSize(MediaSizeName.ITALY_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.MONARCH_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.PERSONAL_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_10_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_11_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_12_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_NUMBER_14_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_6X9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_7X9_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_9X11_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_9X12_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X13_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X14_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_10X15_ENVELOPE);
        this.checkAndAddSize(MediaSizeName.NA_5X7);
        this.checkAndAddSize(MediaSizeName.NA_8X10);
        PaperSizes.addCustomPaperSizes();
        this.setDefault();
    }

    public String[] getPaperSizes() {
        return new String[]{(String)this.paperNames.get(MediaSizeName.ISO_A4.toString()), (String)this.paperNames.get(MediaSizeName.NA_LETTER.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A0.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A1.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A2.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A3.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A5.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A6.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A7.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A8.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A9.toString()), (String)this.paperNames.get(MediaSizeName.ISO_A10.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B0.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B1.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B2.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B3.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B4.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B5.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B6.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B7.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B8.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B9.toString()), (String)this.paperNames.get(MediaSizeName.ISO_B10.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B0.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B1.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B2.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B3.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B4.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B5.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B6.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B7.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B8.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B9.toString()), (String)this.paperNames.get(MediaSizeName.JIS_B10.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C0.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C1.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C2.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C3.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C4.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C5.toString()), (String)this.paperNames.get(MediaSizeName.ISO_C6.toString()), (String)this.paperNames.get(MediaSizeName.NA_LEGAL.toString()), (String)this.paperNames.get(MediaSizeName.EXECUTIVE.toString()), (String)this.paperNames.get(MediaSizeName.LEDGER.toString()), (String)this.paperNames.get(MediaSizeName.TABLOID.toString()), (String)this.paperNames.get(MediaSizeName.INVOICE.toString()), (String)this.paperNames.get(MediaSizeName.FOLIO.toString()), (String)this.paperNames.get(MediaSizeName.QUARTO.toString()), (String)this.paperNames.get(MediaSizeName.JAPANESE_POSTCARD.toString()), (String)this.paperNames.get(MediaSizeName.JAPANESE_DOUBLE_POSTCARD.toString()), (String)this.paperNames.get(MediaSizeName.A.toString()), (String)this.paperNames.get(MediaSizeName.B.toString()), (String)this.paperNames.get(MediaSizeName.C.toString()), (String)this.paperNames.get(MediaSizeName.D.toString()), (String)this.paperNames.get(MediaSizeName.E.toString()), (String)this.paperNames.get(MediaSizeName.ISO_DESIGNATED_LONG.toString()), (String)this.paperNames.get(MediaSizeName.ITALY_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.MONARCH_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.PERSONAL_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_NUMBER_9_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_NUMBER_10_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_NUMBER_11_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_NUMBER_12_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_NUMBER_14_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_6X9_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_7X9_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_9X11_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_9X12_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_10X13_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_10X14_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_10X15_ENVELOPE.toString()), (String)this.paperNames.get(MediaSizeName.NA_5X7.toString()), (String)this.paperNames.get(MediaSizeName.NA_8X10.toString())};
    }

    private void checkAndAddSize(MediaSizeName mediaSizeName) {
        float[] fArray;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (!this.printService.isAttributeValueSupported(mediaSizeName, new DocFlavor.BYTE_ARRAY(DocFlavor.BYTE_ARRAY.PNG.getMimeType()), hashPrintRequestAttributeSet)) {
            return;
        }
        Object v = this.paperNames.get(mediaSizeName.toString());
        String string = v != null ? v.toString() : mediaSizeName.toString();
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        double d = mediaSize.getX(1000);
        double d2 = mediaSize.getY(1000);
        hashPrintRequestAttributeSet.add(mediaSizeName);
        MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])this.printService.getSupportedAttributeValues(MediaPrintableArea.class, null, hashPrintRequestAttributeSet);
        if (mediaPrintableAreaArray.length == 0) {
            return;
        }
        int n = 0;
        if (mediaPrintableAreaArray[n] == null) {
            int n2 = 0;
            while (n2 != mediaPrintableAreaArray.length && mediaPrintableAreaArray[n] == null) {
                n = n2++;
            }
        }
        if ((double)(fArray = mediaPrintableAreaArray[n].getPrintableArea(1000))[2] > d - 0.5 && (double)fArray[2] < d + 0.5) {
            fArray[2] = (float)d;
        }
        if ((double)fArray[3] > d2 - 0.5 && (double)fArray[3] < d2 + 0.5) {
            fArray[3] = (float)d2;
        }
        if ((double)fArray[2] > d ^ (double)fArray[3] > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        MarginPaper marginPaper = new MarginPaper();
        marginPaper.setSize(d * 2.834645669291339, d2 * 2.834645669291339);
        marginPaper.setMinImageableArea((double)fArray[0] * 2.834645669291339, (double)fArray[1] * 2.834645669291339, (double)fArray[2] * 2.834645669291339, (double)fArray[3] * 2.834645669291339);
        this.paperDefinitions.put(string, marginPaper);
        this.paperList.add(string);
    }

    public int getDefaultPageIndex() {
        return this.defaultPageIndex;
    }

    public int getDefaultPageOrientation() {
        OrientationRequested orientationRequested = (OrientationRequested)this.printService.getDefaultAttributeValue(OrientationRequested.class);
        int n = 1;
        if (orientationRequested != null) {
            switch (orientationRequested.getValue()) {
                case 4: {
                    n = 0;
                    break;
                }
                case 5: {
                    n = 2;
                }
            }
        }
        return n;
    }

    private void populateNameMap() {
        this.paperNames.put("iso-a0", "A0");
        this.paperNames.put("iso-a1", "A1");
        this.paperNames.put("iso-a2", "A2");
        this.paperNames.put("iso-a3", "A3");
        this.paperNames.put("iso-a4", "A4");
        this.paperNames.put("iso-a5", "A5");
        this.paperNames.put("iso-a6", "A6");
        this.paperNames.put("iso-a7", "A7");
        this.paperNames.put("iso-a8", "A8");
        this.paperNames.put("iso-a9", "A9");
        this.paperNames.put("iso-a10", "A10");
        this.paperNames.put("iso-b0", "B0");
        this.paperNames.put("iso-b1", "B1");
        this.paperNames.put("iso-b2", "B2");
        this.paperNames.put("iso-b3", "B3");
        this.paperNames.put("iso-b4", "B4");
        this.paperNames.put("iso-b5", "B5");
        this.paperNames.put("iso-b6", "B6");
        this.paperNames.put("iso-b7", "B7");
        this.paperNames.put("iso-b8", "B8");
        this.paperNames.put("iso-b9", "B9");
        this.paperNames.put("iso-b10", "B10");
        this.paperNames.put("na-letter", "North American Letter");
        this.paperNames.put("na-legal", "North American Legal");
        this.paperNames.put("na-8x10", "North American 8x10 inch");
        this.paperNames.put("na-5x7", "North American 5x7 inch");
        this.paperNames.put("executive", "Executive");
        this.paperNames.put("folio", "Folio");
        this.paperNames.put("invoice", "Invoice");
        this.paperNames.put("tabloid", "Tabloid");
        this.paperNames.put("ledger", "Ledger");
        this.paperNames.put("quarto", "Quarto");
        this.paperNames.put("iso-c0", "C0");
        this.paperNames.put("iso-c1", "C1");
        this.paperNames.put("iso-c2", "C2");
        this.paperNames.put("iso-c3", "C3");
        this.paperNames.put("iso-c4", "C4");
        this.paperNames.put("iso-c5", "C5");
        this.paperNames.put("iso-c6", "C6");
        this.paperNames.put("iso-designated-long", "ISO Designated Long size");
        this.paperNames.put("na-10x13-envelope", "North American 10x13 inch");
        this.paperNames.put("na-9x12-envelope", "North American 9x12 inch");
        this.paperNames.put("na-number-10-envelope", "North American number 10 business envelope");
        this.paperNames.put("na-7x9-envelope", "North American 7x9 inch envelope");
        this.paperNames.put("na-9x11-envelope", "North American 9x11 inch envelope");
        this.paperNames.put("na-10x14-envelope", "North American 10x14 inch envelope");
        this.paperNames.put("na-number-9-envelope", "North American number 9 business envelope");
        this.paperNames.put("na-6x9-envelope", "North American 6x9 inch envelope");
        this.paperNames.put("na-10x15-envelope", "North American 10x15 inch envelope");
        this.paperNames.put("monarch-envelope", "Monarch envelope");
        this.paperNames.put("jis-b0", "Japanese B0");
        this.paperNames.put("jis-b1", "Japanese B1");
        this.paperNames.put("jis-b2", "Japanese B2");
        this.paperNames.put("jis-b3", "Japanese B3");
        this.paperNames.put("jis-b4", "Japanese B4");
        this.paperNames.put("jis-b5", "Japanese B5");
        this.paperNames.put("jis-b6", "Japanese B6");
        this.paperNames.put("jis-b7", "Japanese B7");
        this.paperNames.put("jis-b8", "Japanese B8");
        this.paperNames.put("jis-b9", "Japanese B9");
        this.paperNames.put("jis-b10", "Japanese B10");
        this.paperNames.put("a", "Engineering ANSI A");
        this.paperNames.put("b", "Engineering ANSI B");
        this.paperNames.put("c", "Engineering ANSI C");
        this.paperNames.put("d", "Engineering ANSI D");
        this.paperNames.put("e", "Engineering ANSI E");
        this.paperNames.put("arch-a", "Architectural A");
        this.paperNames.put("arch-b", "Architectural B");
        this.paperNames.put("arch-c", "Architectural C");
        this.paperNames.put("arch-d", "Architectural D");
        this.paperNames.put("arch-e", "Architectural E");
        this.paperNames.put("japanese-postcard", "Japanese Postcard");
        this.paperNames.put("oufuko-postcard", "Oufuko Postcard");
        this.paperNames.put("italian-envelope", "Italian Envelope");
        this.paperNames.put("personal-envelope", "Personal Envelope");
        this.paperNames.put("na-number-11-envelope", "North American Number 11 Envelope");
        this.paperNames.put("na-number-12-envelope", "North American Number 12 Envelope");
        this.paperNames.put("na-number-14-envelope", "North American Number 14 Envelope");
    }
}

