/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FontMappings {
    public static boolean fontsInitialised;
    public static String defaultFont;
    public static boolean enforceFontSubstitution;
    public static Map fontSubstitutionTable;
    public static Map fontPropertiesTable;
    public static Map fontPossDuplicates;
    public static Map fontSubstitutionFontID;
    public static Map fontSubstitutionLocation;
    public static Map fontSubstitutionAliasTable;
    private static boolean fontsSet;
    private static final String separator;
    public static String[] defaultFontDirs;
    private static int fontSubstitutionMode;

    private FontMappings() {
    }

    public static void initFonts() {
        Object object;
        String string;
        try {
            string = System.getProperty("org.jpedal.fontmaps");
            if (string != null) {
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "=:");
                    int n = stringTokenizer.countTokens() - 1;
                    String[] stringArray = new String[n];
                    String string3 = stringTokenizer.nextToken();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = stringTokenizer.nextToken();
                    }
                    FontMappings.setSubstitutedFontAliases(string3, stringArray);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + exception.getMessage());
        }
        try {
            string = System.getProperty("org.jpedal.fontdirs");
            object = null;
            if (string != null) {
                object = FontMappings.addFonts(string, (String)object);
            }
            if (object != null) {
                LogWriter.writeLog("Could not find " + (String)object);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read FontDirs " + exception.getMessage());
        }
    }

    public static void setFontSubstitutionMode(int n) {
        fontSubstitutionMode = n;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = string.toLowerCase();
            for (String string3 : stringArray) {
                String string4 = string3.toLowerCase();
                if (string4.equals(string2)) continue;
                fontSubstitutionAliasTable.put(string4, string2);
            }
        }
    }

    public static String addFonts(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.endsWith("/") && !string3.endsWith("\\")) {
                string3 = string3 + separator;
            }
            FontMappings.addTTDir(string3, string2);
        }
        return string2;
    }

    public static void dispose() {
        fontSubstitutionTable = null;
        fontPropertiesTable = null;
        fontPossDuplicates = null;
        fontSubstitutionFontID = null;
        fontSubstitutionLocation = null;
        fontSubstitutionAliasTable = null;
    }

    public static String addTTDir(String string, String string2) {
        File file;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        if ((file = new File(string)).exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    FontMappings.addFontFile(string3, string);
                }
            }
        } else {
            string2 = string2 == null ? string : string2 + ',' + string;
        }
        return string2;
    }

    public static void setFontReplacements() {
        String[] stringArray = new String[]{"acarialunicodems__cn"};
        FontMappings.setSubstitutedFontAliases("adobeheitistd-regular", stringArray);
        if (DecoderOptions.isRunningOnMac) {
            FontMappings.setSubstitutedFontAliases("Courier italic", new String[]{"Courier-Oblique"});
            FontMappings.setSubstitutedFontAliases("Courier bold", new String[]{"Courier-Bold"});
            FontMappings.setSubstitutedFontAliases("Courier bold italic", new String[]{"Courier-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("Courier new italic", new String[]{"CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new bold", new String[]{"CourierNew,Bold", "Courier-Bold", "CourierStd-Bold", "CourierNewPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("Courier new bold italic", new String[]{"CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courier new", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            FontMappings.setSubstitutedFontAliases("arial italic", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            FontMappings.setSubstitutedFontAliases("arial bold", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold"});
            FontMappings.setSubstitutedFontAliases("arial bold italic", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique"});
            FontMappings.setSubstitutedFontAliases("arial Narrow", new String[]{"ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("arial Narrow italic", new String[]{"ArialNarrow-italic"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold", new String[]{"ArialNarrow-bold", "ArialNarrow,Bold"});
            FontMappings.setSubstitutedFontAliases("arial Narrow bold italic", new String[]{"ArialNarrow-bolditalic"});
            FontMappings.setSubstitutedFontAliases("times new roman bold", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("times new roman bold italic", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman italic", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("times new roman", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        } else {
            FontMappings.setSubstitutedFontAliases("Couri", new String[]{"Courier-Oblique", "CourierNew,italic", "CourierStd-Oblique", "CourierNewPS-ItalicMT"});
            FontMappings.setSubstitutedFontAliases("Courbd", new String[]{"Courier-Bold", "CourierNew,Bold", "CourierStd-Bold", "CourierNewPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("Courbi", new String[]{"Courier-BoldOblique", "CourierNew-BoldOblique", "CourierStd-BoldOblique", "CourierNewPS-BoldItalicMT"});
            FontMappings.setSubstitutedFontAliases("Cour", new String[]{"CourierNew", "Courier", "CourierStd", "CourierNewPSMT", "CourierNewPSMT"});
            FontMappings.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt", "ArialNarrow"});
            FontMappings.setSubstitutedFontAliases("ariali", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic", "ArialNarrow-Italic"});
            FontMappings.setSubstitutedFontAliases("arialbd", new String[]{"arial-boldmt,bold", "arial-boldmt", "Helvetica-Bold", "Arial,bold", "arial bold", "ArialNarrow-Bold"});
            FontMappings.setSubstitutedFontAliases("arialbi", new String[]{"Arial-BoldItalicMT", "Helvetica-BoldOblique", "ArialNarrow-BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbd", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            FontMappings.setSubstitutedFontAliases("timesi", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic"});
            FontMappings.setSubstitutedFontAliases("timesbi", new String[]{"Times-Italic", "TimesNewRoman,Italic"});
            FontMappings.setSubstitutedFontAliases("times", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            FontMappings.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        }
        FontMappings.setSubstitutedFontAliases("AdobeSongStd-Light", new String[]{"STSong-Light"});
        if (!fontsSet) {
            File file;
            fontsSet = true;
            FontMappings.setFontDirs(defaultFontDirs);
            if (DecoderOptions.isRunningOnWindows && (file = new File("C:\\Program Files\\Adobe\\")).exists()) {
                String[] stringArray2;
                for (String string : stringArray2 = file.list()) {
                    String string2 = "C:\\Program Files\\Adobe\\" + string + "\\Resource\\CIDFont";
                    File file2 = new File(string2);
                    if (!file2.exists()) continue;
                    FontMappings.addTTDir(string2, "");
                }
            }
        }
    }

    public static String setFontDirs(String[] stringArray) {
        String string = null;
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        try {
            if (stringArray == null) {
                LogWriter.writeLog("Null font parameter passed");
                fontSubstitutionAliasTable.clear();
                fontSubstitutionLocation.clear();
                fontSubstitutionTable.clear();
                fontSubstitutionFontID.clear();
                fontPossDuplicates.clear();
                fontPropertiesTable.clear();
                fontsSet = false;
            } else {
                for (String string2 : stringArray) {
                    String string3 = string2;
                    if (!string3.endsWith("/") && !string3.endsWith("\\")) {
                        string3 = string3 + separator;
                    }
                    string = FontMappings.addTTDir(string3, string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to run setFontDirs " + exception.getMessage());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSubstituteFonts(String string, boolean bl) {
        boolean bl2;
        block36: {
            bl2 = false;
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                String[] stringArray = new String[]{"tt", "t1c", "t1"};
                String[] stringArray2 = new String[]{"/TrueType", "/Type1C", "/Type1"};
                enforceFontSubstitution = bl;
                ClassLoader classLoader = FontMappings.class.getClass().getClassLoader();
                inputStream2 = classLoader.getResourceAsStream(string);
                LogWriter.writeLog("Looking for root " + string);
                if (inputStream != null) {
                    LogWriter.writeLog("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + string);
                    bl2 = true;
                    block28: for (int i = 0; i < stringArray.length; ++i) {
                        String string2;
                        if (!string.endsWith("/")) {
                            string = string + '/';
                        }
                        if ((inputStream = classLoader.getResourceAsStream(string2 = string + stringArray[i] + '/')) == null) continue;
                        System.out.println("Found  " + string2 + ' ' + inputStream);
                        try {
                            ArrayList arrayList = inputStream instanceof ByteArrayInputStream ? FontMappings.readIndirectValues(inputStream) : FontMappings.getDirectoryMatches(string2);
                            for (Object e : arrayList) {
                                String string3 = (String)e;
                                if (string3 == null) {
                                    continue block28;
                                }
                                int n = string3.indexOf(46);
                                String string4 = n == -1 ? string3.toLowerCase() : string3.substring(0, n).toLowerCase();
                                fontSubstitutionTable.put(string4, stringArray2[i]);
                                fontSubstitutionLocation.put(string4, string2 + string3);
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception " + exception + " reading substitute fonts");
                            continue;
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {
                                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                                }
                            }
                        }
                    }
                    break block36;
                }
                LogWriter.writeLog("No fonts found at " + string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception adding substitute fonts " + exception.getMessage());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
            }
        }
        return bl2;
    }

    public static void addFontFile(String string, String string2) {
        if (fontSubstitutionTable == null) {
            fontSubstitutionTable = new ConcurrentHashMap();
            fontSubstitutionFontID = new ConcurrentHashMap();
            fontPossDuplicates = new ConcurrentHashMap();
            fontPropertiesTable = new ConcurrentHashMap();
        }
        if (string2 != null && !string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + separator;
        }
        String string3 = string.toLowerCase();
        int n = StandardFonts.getFontType(string3);
        InputStream inputStream = null;
        if (n != 8 && new File(string2 + string).exists()) {
            boolean bl = false;
            try {
                inputStream = new FileInputStream(string2 + string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
                bl = true;
            }
            catch (Error error) {
                LogWriter.writeLog("Error: " + error.getMessage());
                bl = true;
            }
            if (!bl) {
                int n2 = string.indexOf(46);
                String string4 = n2 == -1 ? string.toLowerCase() : string.substring(0, n2).toLowerCase();
                if (fontSubstitutionMode == 1 || n == 6) {
                    if (n == 1228944677) {
                        fontSubstitutionTable.put(string4, "/Type1");
                    } else {
                        fontSubstitutionTable.put(string4, "/TrueType");
                    }
                    fontSubstitutionLocation.put(string4, string2 + string);
                    fontPropertiesTable.put(string4 + "_type", n);
                    fontPropertiesTable.put(string4 + "_path", string2 + string);
                } else if (n == 7 || n == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] stringArray = null;
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, 2);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        String[] stringArray2 = null;
                        try {
                            stringArray2 = StandardFonts.readNamesFromFont(n, string2 + string, 3);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        int n3 = 0;
                        if (stringArray != null) {
                            n3 = stringArray.length;
                        }
                        for (int i = 0; i < n3; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            if (stringArray2[i] == null) {
                                stringArray2[i] = Strip.stripAllSpaces(string4);
                            }
                            Object v = fontSubstitutionTable.get(stringArray[i]);
                            Object v2 = fontPossDuplicates.get(stringArray[i]);
                            if (v == null && v2 == null) {
                                fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                fontSubstitutionFontID.put(stringArray[i], i);
                                fontPossDuplicates.put(stringArray[i], stringArray2[i]);
                                continue;
                            }
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            fontSubstitutionFontID.put(stringArray[i], i);
                            fontPropertiesTable.put(stringArray[i] + "_type", n);
                            fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            if (v2.equals("DONE")) continue;
                            fontPossDuplicates.put(stringArray[i], "DONE");
                            fontSubstitutionTable.remove(stringArray[i]);
                            fontSubstitutionTable.put(stringArray2[i], "/TrueType");
                            String string5 = (String)fontSubstitutionLocation.get(stringArray[i]);
                            fontSubstitutionLocation.remove(stringArray[i]);
                            fontSubstitutionLocation.put(stringArray2[i], string5);
                            fontSubstitutionFontID.remove(stringArray[i]);
                            fontSubstitutionFontID.put(stringArray2[i], i);
                            fontPropertiesTable.remove(stringArray2[i] + "_path");
                            fontPropertiesTable.remove(stringArray2[i] + "_type");
                            fontPropertiesTable.put(stringArray2[i] + "_type", n);
                            fontPropertiesTable.put(stringArray2[i] + "_path", string2 + string);
                        }
                    } else {
                        String[] stringArray = null;
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                        }
                        catch (Exception exception) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        if (stringArray != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i] == null) {
                                    stringArray[i] = Strip.stripAllSpaces(string4);
                                }
                                fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                fontSubstitutionFontID.put(stringArray[i], i);
                                fontPropertiesTable.put(stringArray[i] + "_type", n);
                                fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            }
                        }
                    }
                } else if (n == 1228944677) {
                    String[] stringArray = null;
                    try {
                        stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            fontSubstitutionTable.put(stringArray[i], "/Type1");
                            fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            fontSubstitutionFontID.put(stringArray[i], i);
                            fontPropertiesTable.put(stringArray[i] + "_type", n);
                            fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                        }
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + string2);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    private static ArrayList getDirectoryMatches(String string) throws IOException {
        string = string.replaceAll("\\.", "/");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        String string2 = uRL.toString();
        System.out.println("scanning " + string2);
        if (string2.startsWith("jar:") && string2.endsWith(string)) {
            int n = string2.lastIndexOf(string);
            string2 = string2.substring(0, n);
            System.out.println("entry= " + string2);
            URL uRL2 = new URL(string2);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(string)) continue;
                String string3 = jarEntry.getName();
                int n2 = string3.lastIndexOf(47);
                arrayList.add(string3.substring(n2 + 1));
            }
        }
        return arrayList;
    }

    private static ArrayList readIndirectValues(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>(0);
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static void setDefaultDisplayFont(String string) throws PdfFontException {
        boolean bl = false;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string.toLowerCase())) continue;
            bl = true;
            defaultFont = stringArray[i];
            i = n;
        }
        if (!bl) {
            throw new PdfFontException("Font " + string + " is not available.");
        }
    }

    static {
        fontSubstitutionLocation = new ConcurrentHashMap();
        fontSubstitutionAliasTable = new ConcurrentHashMap();
        separator = System.getProperty("file.separator");
        defaultFontDirs = new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/Library/Fonts/", "/usr/share/fonts/truetype/msttcorefonts/", "usr/local/Fonts/"};
        fontSubstitutionMode = 1;
    }
}

