/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import org.jpedal.utils.LogWriter;

class UnicodeReader {
    private static final int[] powers = new int[]{1, 16, 256, 4096};
    int ptr;
    final byte[] data;
    boolean hasDoubleBytes;

    UnicodeReader(byte[] byArray) {
        this.data = byArray;
    }

    public String[] readUnicode() {
        if (this.data == null) {
            return null;
        }
        int n = 0;
        String[] stringArray = new String[65536];
        int n2 = this.data.length;
        boolean bl = false;
        try {
            while (true) {
                if (this.ptr < n2 && this.data[this.ptr] == 9) {
                    ++this.ptr;
                    continue;
                }
                if (this.ptr < n2) {
                    if (this.ptr + 4 < n2 && this.data[this.ptr] == 101 && this.data[this.ptr + 1] == 110 && this.data[this.ptr + 2] == 100 && this.data[this.ptr + 3] == 98 && this.data[this.ptr + 4] == 102) {
                        n = 0;
                        bl = false;
                    } else if (bl) {
                        this.readLineValue(stringArray, n);
                    }
                    if (this.ptr < n2) {
                        if (this.data[this.ptr] == 98 && this.data[this.ptr + 1] == 101 && this.data[this.ptr + 2] == 103 && this.data[this.ptr + 3] == 105 && this.data[this.ptr + 4] == 110 && this.data[this.ptr + 5] == 98 && this.data[this.ptr + 6] == 102 && this.data[this.ptr + 7] == 99 && this.data[this.ptr + 8] == 104 && this.data[this.ptr + 9] == 97 && this.data[this.ptr + 10] == 114) {
                            n = 1;
                            this.ptr += 10;
                            bl = true;
                        } else if (this.data[this.ptr] == 98 && this.data[this.ptr + 1] == 101 && this.data[this.ptr + 2] == 103 && this.data[this.ptr + 3] == 105 && this.data[this.ptr + 4] == 110 && this.data[this.ptr + 5] == 98 && this.data[this.ptr + 6] == 102 && this.data[this.ptr + 7] == 114 && this.data[this.ptr + 8] == 97 && this.data[this.ptr + 9] == 110 && this.data[this.ptr + 10] == 103 && this.data[this.ptr + 11] == 101) {
                            n = 2;
                            this.ptr += 11;
                            bl = true;
                        }
                        ++this.ptr;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up text object " + exception);
        }
        return stringArray;
    }

    private void readLineValue(String[] stringArray, int n) {
        int n2 = n + 1;
        int n3 = this.data.length;
        int[] nArray = new int[2000];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (!bl) {
                while (this.ptr < this.data.length && this.data[this.ptr] != 60) {
                    if (i == 2 && n2 == 3 && this.data[this.ptr] == 91) {
                        n = 4;
                        n4 = this.ptr;
                        while (this.data[n4] != 93) {
                            if (this.data[n4] == 60) {
                                ++n2;
                            }
                            ++n4;
                        }
                        --n2;
                    }
                    ++this.ptr;
                }
                ++this.ptr;
            }
            n4 = 0;
            int n5 = 0;
            while (this.ptr < n3 && this.data[this.ptr] != 62) {
                if (this.data[this.ptr] != 10 && this.data[this.ptr] != 13 && this.data[this.ptr] != 32) {
                    ++n5;
                }
                ++this.ptr;
                ++n4;
                if (n5 != 5) continue;
                n4 = 4;
                --this.ptr;
                ++n2;
                bl = true;
                break;
            }
            int n6 = 0;
            for (int j = 0; j < n4; ++j) {
                int n7;
                while ((n7 = this.data[this.ptr - 1 - j]) == 10 || n7 == 13 || n7 == 32) {
                    ++j;
                }
                if (n7 >= 65 && n7 <= 70) {
                    n7 -= 55;
                } else if (n7 >= 97 && n7 <= 102) {
                    n7 -= 87;
                } else if (n7 >= 48 && n7 <= 57) {
                    n7 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)n7);
                }
                int n8 = i;
                nArray[n8] = nArray[n8] + n7 * powers[n6];
                ++n6;
            }
        }
        while (this.ptr < n3 && (this.data[this.ptr] == 62 || this.data[this.ptr] == 32 || this.data[this.ptr] == 10 || this.data[this.ptr] == 13 || this.data[this.ptr] == 93)) {
            ++this.ptr;
        }
        --this.ptr;
        this.fillValues(stringArray, n2, nArray, n);
    }

    private void fillValues(String[] stringArray, int n, int[] nArray, int n2) {
        switch (n2) {
            case 1: {
                if (n == 2) {
                    if (nArray[n2] <= 0) break;
                    stringArray[nArray[0]] = String.valueOf((char)nArray[n2]);
                    if (nArray[0] <= 255) break;
                    this.hasDoubleBytes = true;
                    break;
                }
                char[] cArray = new char[n - 1];
                for (int i = 0; i < n - 1; ++i) {
                    cArray[i] = (char)nArray[n2 + i];
                }
                stringArray[nArray[0]] = new String(cArray);
                if (nArray[0] <= 255) break;
                this.hasDoubleBytes = true;
                break;
            }
            case 4: {
                int n3 = 2;
                for (int i = nArray[0]; i < nArray[1] + 1; ++i) {
                    if (n > 1 && nArray[0] == nArray[1]) {
                        stringArray[i] = String.valueOf((char)nArray[2]);
                        if (i > 255) {
                            this.hasDoubleBytes = true;
                        }
                        for (int j = 1; j < n; ++j) {
                            int n4 = i;
                            stringArray[n4] = stringArray[n4] + String.valueOf((char)nArray[2 + j]);
                            if (i <= 255) continue;
                            this.hasDoubleBytes = true;
                        }
                        continue;
                    }
                    int n5 = nArray[n3];
                    ++n3;
                    if (n5 <= 0) continue;
                    stringArray[i] = String.valueOf((char)n5);
                    if (i <= 255) continue;
                    this.hasDoubleBytes = true;
                }
                break;
            }
            default: {
                for (int i = nArray[0]; i < nArray[1] + 1; ++i) {
                    int n6 = nArray[n2] + i - nArray[0];
                    if (n6 <= 0) continue;
                    stringArray[i] = String.valueOf((char)n6);
                    if (i <= 255) continue;
                    this.hasDoubleBytes = true;
                }
            }
        }
    }

    public boolean hasDoubleByteValues() {
        return this.hasDoubleBytes;
    }
}

