/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.geom.GeneralPath;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Path;

public class T1GlyphFactory
implements GlyphFactory {
    private static JavaFXSupport javaFXSupport;
    final boolean useFX;
    private static final float zero = 0.0f;
    private Vector_Float shape_primitive_x2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y = new Vector_Float(1000);
    private Vector_Int shape_primitives = new Vector_Int(1000);
    private Vector_Float shape_primitive_x3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_x = new Vector_Float(1000);
    protected static final int H = 3;
    protected static final int L = 2;
    protected static final int M = 1;
    protected static final int C = 5;
    private float ymin;
    private int leftSideBearing;

    public T1GlyphFactory(boolean bl) {
        this.useFX = bl;
        if (bl) {
            javaFXSupport = ExternalHandlers.getFXHandler();
        }
    }

    @Override
    public PdfGlyph getGlyph() {
        if (this.useFX) {
            return this.getFXGlyph();
        }
        return this.getSwingGlyph();
    }

    private PdfGlyph getSwingGlyph() {
        Vector_Path vector_Path = new Vector_Path(100);
        GeneralPath generalPath = new GeneralPath(1);
        generalPath.moveTo(0.0f, 0.0f);
        float[] fArray = this.shape_primitive_x.get();
        float[] fArray2 = this.shape_primitive_y.get();
        float[] fArray3 = this.shape_primitive_x2.get();
        float[] fArray4 = this.shape_primitive_y2.get();
        float[] fArray5 = this.shape_primitive_x3.get();
        float[] fArray6 = this.shape_primitive_y3.get();
        int n = this.shape_primitives.size() - 1;
        int[] nArray = this.shape_primitives.get();
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 2) {
                generalPath.lineTo(fArray[i], fArray2[i] - this.ymin);
                continue;
            }
            if (nArray[i] == 3) {
                generalPath.closePath();
                vector_Path.addElement(generalPath);
                generalPath = new GeneralPath(1);
                generalPath.moveTo(0.0f, 0.0f);
                continue;
            }
            if (nArray[i] == 1) {
                generalPath.moveTo(fArray[i], fArray2[i] - this.ymin);
                continue;
            }
            if (nArray[i] != 5) continue;
            generalPath.curveTo(fArray[i], fArray2[i] - this.ymin, fArray3[i], fArray4[i] - this.ymin, fArray5[i], fArray6[i] - this.ymin);
        }
        this.shape_primitive_x2.reuse();
        this.shape_primitive_y.reuse();
        this.shape_primitives.reuse();
        this.shape_primitive_x3.reuse();
        this.shape_primitive_y3.reuse();
        this.shape_primitive_y2.reuse();
        this.shape_primitive_x.reuse();
        return new T1Glyph(vector_Path);
    }

    private PdfGlyph getFXGlyph() {
        float[] fArray = this.shape_primitive_x.get();
        float[] fArray2 = this.shape_primitive_y.get();
        float[] fArray3 = this.shape_primitive_x2.get();
        float[] fArray4 = this.shape_primitive_y2.get();
        float[] fArray5 = this.shape_primitive_x3.get();
        float[] fArray6 = this.shape_primitive_y3.get();
        int n = this.shape_primitives.size() - 1;
        int[] nArray = this.shape_primitives.get();
        this.shape_primitive_x2 = new Vector_Float(1000);
        this.shape_primitive_y = new Vector_Float(1000);
        this.shape_primitives = new Vector_Int(1000);
        this.shape_primitive_x3 = new Vector_Float(1000);
        this.shape_primitive_y3 = new Vector_Float(1000);
        this.shape_primitive_y2 = new Vector_Float(1000);
        this.shape_primitive_x = new Vector_Float(1000);
        if (javaFXSupport == null) {
            return null;
        }
        return javaFXSupport.getGlyph(fArray, fArray2, fArray3, fArray4, fArray5, fArray6, this.ymin, n, nArray);
    }

    @Override
    public final void closePath() {
        this.shape_primitives.addElement(3);
        this.shape_primitive_x.addElement(0.0f);
        this.shape_primitive_y.addElement(0.0f);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.shape_primitives.addElement(5);
        this.shape_primitive_x.addElement(f);
        this.shape_primitive_y.addElement(f2);
        this.shape_primitive_x2.addElement(f3);
        this.shape_primitive_y2.addElement(f4);
        this.shape_primitive_x3.addElement(f5);
        this.shape_primitive_y3.addElement(f6);
    }

    @Override
    public final void lineTo(float f, float f2) {
        this.shape_primitives.addElement(2);
        this.shape_primitive_x.addElement(f);
        this.shape_primitive_y.addElement(f2);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public final void moveTo(float f, float f2) {
        this.shape_primitives.addElement(1);
        this.shape_primitive_x.addElement(f);
        this.shape_primitive_y.addElement(f2);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    @Override
    public void setYMin(float f) {
        this.ymin = f;
    }

    @Override
    public int getLSB() {
        return this.leftSideBearing;
    }

    @Override
    public boolean useFX() {
        return this.useFX;
    }

    @Override
    public PdfGlyph getGlyph(Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, TTVM tTVM, String string) {
        if (javaFXSupport != null) {
            return javaFXSupport.getGlyph(glyf, fontFile2, hmtx, n, f, tTVM, string);
        }
        return null;
    }
}

