/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.objects.T1GlyphNumber;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class T1Glyphs
extends PdfJavaGlyphs {
    private boolean is1C;
    private String[] charForGlyphIndex;
    private DynamicVectorRenderer dynamicVectorRenderer;
    private final Map<String, byte[]> charStrings = new HashMap<String, byte[]>();
    private final Map<String, Integer> glyphNumbers = new HashMap<String, Integer>();
    private static final int max = 100;
    private double[] operandsRead = new double[100];
    private int operandReached;
    private float[] pt;
    private double xs = -1.0;
    private double ys = -1.0;
    private double x;
    private double y;
    private int ptCount;
    private int currentOp;
    private int hintCount;
    private boolean allowAll;
    private double h;
    private boolean isCID;
    private int[] nominalWidthX = new int[]{0};
    private int[] defaultWidthX = new int[0];
    private boolean defaultWidthsPassed;
    private int[] fdSelect;

    public T1Glyphs(boolean bl) {
        this.isCID = bl;
    }

    public T1Glyphs(boolean bl, boolean bl2) {
        this.charForGlyphIndex = new String[65536];
    }

    public static String[] readFontNames(FontData fontData) {
        BufferedReader bufferedReader;
        String[] stringArray;
        block7: {
            int n;
            int n2;
            stringArray = new String[]{null};
            bufferedReader = new BufferedReader(new StringReader(new String(fontData.getBytes(0, fontData.length()))));
            String string = null;
            do {
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
                if (string == null) break block7;
            } while (!string.startsWith("/FontName") || (n2 = string.indexOf(47, 9)) == -1 || (n = string.indexOf(32, n2)) == -1);
            String string2 = string.substring(n2 + 1, n);
            stringArray[0] = string2.toLowerCase();
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " closing stream");
            }
        }
        if (fontData != null) {
            fontData.close();
        }
        return stringArray;
    }

    private boolean processFlex(GlyphFactory glyphFactory, boolean bl, int n) {
        if (bl && this.ptCount == 14 && n == 0) {
            bl = false;
            for (int i = 0; i < 12; i += 6) {
                glyphFactory.curveTo(this.pt[i], this.pt[i + 1], this.pt[i + 2], this.pt[i + 3], this.pt[i + 4], this.pt[i + 5]);
            }
        } else if (!bl && n >= 0 && n <= 2) {
            bl = true;
            this.ptCount = 0;
            this.pt = new float[16];
        }
        return bl;
    }

    private void endchar(GlyphFactory glyphFactory, int n) {
        if (this.operandReached == 5) {
            --this.operandReached;
            ++this.currentOp;
        }
        if (this.operandReached == 4) {
            StandardFonts.checkLoaded(1);
            float f = (float)(this.x + this.operandsRead[this.currentOp]);
            float f2 = (float)(this.y + this.operandsRead[this.currentOp + 1]);
            String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 2]);
            String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[this.currentOp + 3]);
            this.x = 0.0;
            this.y = 0.0;
            this.decodeGlyph(null, glyphFactory, string, n, "");
            glyphFactory.closePath();
            glyphFactory.moveTo(f, f2);
            this.x = f;
            this.y = f2;
            this.decodeGlyph(null, glyphFactory, string2, n, "");
            if (this.xs == -1.0) {
                this.xs = this.x;
                this.ys = this.y;
            }
        } else {
            glyphFactory.closePath();
        }
    }

    private int mask(int n) {
        this.hintCount += this.operandReached / 2;
        for (int i = this.hintCount; i > 0; i -= 8) {
            ++n;
        }
        return n;
    }

    private double sbw() {
        double d;
        this.y = d = this.operandsRead[this.operandReached - 2];
        this.xs = this.x = (d = this.operandsRead[this.operandReached - 1]);
        this.ys = this.y;
        this.allowAll = true;
        double d2 = this.y;
        this.h = this.operandsRead[this.operandReached - 3];
        return d2;
    }

    private void hmoveto(GlyphFactory glyphFactory, boolean bl) {
        if (bl && this.operandReached == 2) {
            ++this.currentOp;
        }
        double d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rmoveto(GlyphFactory glyphFactory, boolean bl) {
        if (bl && this.operandReached == 3) {
            ++this.currentOp;
        }
        double d = this.operandsRead[this.currentOp + 1];
        this.y += d;
        d = this.operandsRead[this.currentOp];
        this.x += d;
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void vhhvcurveto(GlyphFactory glyphFactory, int n) {
        boolean bl;
        boolean bl2 = bl = n == 31;
        while (this.operandReached >= 4) {
            this.operandReached -= 4;
            if (bl) {
                this.x += this.operandsRead[this.currentOp];
            } else {
                this.y += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl) {
                this.y += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.x += this.operandsRead[this.currentOp + 4];
                }
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
                if (this.operandReached == 1) {
                    this.y += this.operandsRead[this.currentOp + 4];
                }
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
            this.currentOp += 4;
            bl = !bl;
        }
    }

    private void vvhhcurveto(GlyphFactory glyphFactory, int n) {
        boolean bl;
        boolean bl2 = bl = n == 26;
        if ((this.operandReached & 1) == 1) {
            if (bl) {
                this.x += this.operandsRead[0];
            } else {
                this.y += this.operandsRead[0];
            }
            ++this.currentOp;
        }
        while (this.currentOp < this.operandReached) {
            if (bl) {
                this.y += this.operandsRead[this.currentOp];
            } else {
                this.x += this.operandsRead[this.currentOp];
            }
            this.pt[0] = (float)this.x;
            this.pt[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 1];
            this.y += this.operandsRead[this.currentOp + 2];
            this.pt[2] = (float)this.x;
            this.pt[3] = (float)this.y;
            if (bl) {
                this.y += this.operandsRead[this.currentOp + 3];
            } else {
                this.x += this.operandsRead[this.currentOp + 3];
            }
            this.pt[4] = (float)this.x;
            this.pt[5] = (float)this.y;
            this.currentOp += 4;
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void rlinecurve(GlyphFactory glyphFactory) {
        for (int i = (this.operandReached - 6) / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
        float[] fArray = new float[6];
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 2];
        this.y += this.operandsRead[this.currentOp + 3];
        fArray[2] = (float)this.x;
        fArray[3] = (float)this.y;
        this.x += this.operandsRead[this.currentOp + 4];
        this.y += this.operandsRead[this.currentOp + 5];
        fArray[4] = (float)this.x;
        fArray[5] = (float)this.y;
        glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        this.currentOp += 6;
    }

    private void closepath(GlyphFactory glyphFactory) {
        if (this.xs != -1.0) {
            glyphFactory.lineTo((float)this.xs, (float)this.ys);
        }
        this.xs = -1.0;
    }

    private void hsbw(GlyphFactory glyphFactory, String string) {
        this.x += this.operandsRead[0];
        glyphFactory.moveTo((float)this.x, 0.0f);
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, string, (int)this.ys);
        }
        this.allowAll = true;
    }

    private void pop() {
        if (this.operandReached > 0) {
            --this.operandReached;
        }
    }

    private void div() {
        double d = this.operandsRead[this.operandReached - 2] / this.operandsRead[this.operandReached - 1];
        if (this.operandReached > 0) {
            --this.operandReached;
        }
        this.operandsRead[this.operandReached - 1] = d;
    }

    private void vmoveto(GlyphFactory glyphFactory, boolean bl) {
        if (bl && this.operandReached == 2) {
            ++this.currentOp;
        }
        this.y += this.operandsRead[this.currentOp];
        glyphFactory.moveTo((float)this.x, (float)this.y);
        this.xs = this.x;
        this.ys = this.y;
    }

    private void rlineto(GlyphFactory glyphFactory) {
        for (int i = this.operandReached / 2; i > 0; --i) {
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            glyphFactory.lineTo((float)this.x, (float)this.y);
            this.currentOp += 2;
        }
    }

    private void hvlineto(GlyphFactory glyphFactory, int n) {
        boolean bl = n == 6;
        for (int i = 0; i < this.operandReached; ++i) {
            if (bl) {
                this.x += this.operandsRead[i];
            } else {
                this.y += this.operandsRead[i];
            }
            glyphFactory.lineTo((float)this.x, (float)this.y);
            bl = !bl;
        }
    }

    private void rrcurveto(GlyphFactory glyphFactory) {
        for (int i = this.operandReached / 6; i > 0; --i) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            this.currentOp += 6;
        }
    }

    private void rcurveline(GlyphFactory glyphFactory) {
        for (int i = (this.operandReached - 2) / 6; i > 0; --i) {
            float[] fArray = new float[6];
            this.x += this.operandsRead[this.currentOp];
            this.y += this.operandsRead[this.currentOp + 1];
            fArray[0] = (float)this.x;
            fArray[1] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 2];
            this.y += this.operandsRead[this.currentOp + 3];
            fArray[2] = (float)this.x;
            fArray[3] = (float)this.y;
            this.x += this.operandsRead[this.currentOp + 4];
            this.y += this.operandsRead[this.currentOp + 5];
            fArray[4] = (float)this.x;
            fArray[5] = (float)this.y;
            glyphFactory.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
            this.currentOp += 6;
        }
        this.x += this.operandsRead[this.currentOp];
        this.y += this.operandsRead[this.currentOp + 1];
        glyphFactory.lineTo((float)this.x, (float)this.y);
        this.currentOp += 2;
    }

    private void seac(GlyphFactory glyphFactory, int n, int n2) {
        StandardFonts.checkLoaded(1);
        float f = (float)this.operandsRead[n2 + 1];
        float f2 = (float)this.operandsRead[n2 + 2];
        String string = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 3]);
        String string2 = StandardFonts.getUnicodeChar(1, (int)this.operandsRead[n2 + 4]);
        double d = this.x;
        this.y = 0.0;
        this.decodeGlyph(null, glyphFactory, string, n, "");
        glyphFactory.closePath();
        glyphFactory.moveTo(0.0f, 0.0f);
        this.x = (double)f + d;
        this.y = f2;
        this.decodeGlyph(null, glyphFactory, string2, n, "");
    }

    private void flex1(GlyphFactory glyphFactory) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.x;
        double d4 = this.y;
        for (n2 = 0; n2 < 10; n2 += 2) {
            d += this.operandsRead[n2];
            d2 += this.operandsRead[n2 + 1];
        }
        n2 = Math.abs(d) > Math.abs(d2) ? 1 : 0;
        for (n = 0; n < 6; n += 2) {
            this.x += this.operandsRead[n];
            this.y += this.operandsRead[n + 1];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        for (n = 0; n < 4; n += 2) {
            this.x += this.operandsRead[n + 6];
            this.y += this.operandsRead[n + 7];
            this.pt[n] = (float)this.x;
            this.pt[n + 1] = (float)this.y;
        }
        if (n2 != 0) {
            this.x += this.operandsRead[10];
            this.y = d4;
        } else {
            this.x = d3;
            this.y += this.operandsRead[10];
        }
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void flex(GlyphFactory glyphFactory) {
        for (int i = 0; i < 12; i += 6) {
            for (int j = 0; j < 6; j += 2) {
                this.x += this.operandsRead[i + j];
                this.y += this.operandsRead[i + j + 1];
                this.pt[j] = (float)this.x;
                this.pt[j + 1] = (float)this.y;
            }
            glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        }
    }

    private void hflex(GlyphFactory glyphFactory) {
        this.x += this.operandsRead[0];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[1];
        this.y += this.operandsRead[2];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[3];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[4];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[5];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[6];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    private void hflex1(GlyphFactory glyphFactory) {
        this.x += this.operandsRead[0];
        this.y += this.operandsRead[1];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[2];
        this.y += this.operandsRead[3];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[4];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
        this.x += this.operandsRead[5];
        this.pt[0] = (float)this.x;
        this.pt[1] = (float)this.y;
        this.x += this.operandsRead[6];
        this.y += this.operandsRead[7];
        this.pt[2] = (float)this.x;
        this.pt[3] = (float)this.y;
        this.x += this.operandsRead[8];
        this.pt[4] = (float)this.x;
        this.pt[5] = (float)this.y;
        glyphFactory.curveTo(this.pt[0], this.pt[1], this.pt[2], this.pt[3], this.pt[4], this.pt[5]);
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        Integer n2;
        PdfGlyph pdfGlyph;
        if (fArray != null && (this.lastTrm[0][0] != fArray[0][0] || this.lastTrm[1][0] != fArray[1][0] || this.lastTrm[0][1] != fArray[0][1] || this.lastTrm[1][1] != fArray[1][1])) {
            this.lastTrm = fArray;
            this.flush();
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n)) == null) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.x = -glyphFactory.getLSB();
            this.y = 0.0;
            this.decodeGlyph(string3, glyphFactory, string, n, string2);
            pdfGlyph = glyphFactory.getGlyph();
            this.setEmbeddedCachedShape(n, pdfGlyph);
        }
        if ((n2 = this.glyphNumbers.get(string)) == null) {
            n2 = this.glyphNumbers.get(Integer.toString(n));
        }
        if (n2 == null) {
            n2 = this.glyphNumbers.get(string3);
        }
        if (n2 != null) {
            pdfGlyph.setGlyphNumber(n2);
        }
        return pdfGlyph;
    }

    void decodeGlyph(String string, GlyphFactory glyphFactory, String string2, int n, String string3) {
        byte[] byArray;
        this.allowAll = false;
        if (this.isCID) {
            byArray = this.charStrings.get(String.valueOf(n));
        } else {
            if (string2 == null) {
                string2 = string3;
            }
            if (string2 == null && (string2 = string) == null) {
                string2 = ".notdef";
            }
            if ((byArray = this.charStrings.get(string2)) == null) {
                if (string != null) {
                    byArray = this.charStrings.get(string);
                }
                if (byArray == null) {
                    byArray = this.charStrings.get(".notdef");
                }
            }
        }
        if (byArray != null) {
            this.decodeGlyphStream(glyphFactory, string2, n, byArray);
        }
    }

    private void decodeGlyphStream(GlyphFactory glyphFactory, String string, int n, byte[] byArray) {
        boolean bl = true;
        this.ptCount = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = byArray.length;
        int n7 = 0;
        this.currentOp = 0;
        this.hintCount = 0;
        double d = 999999.0;
        double d2 = 0.0;
        double d3 = 1000.0;
        boolean bl2 = false;
        this.pt = new float[6];
        int n8 = 0;
        this.h = 100000.0;
        if (this.is1C) {
            this.operandsRead = new double[100];
            this.operandReached = 0;
            this.allowAll = true;
        }
        while (n3 < n6) {
            int n9;
            int n10 = byArray[n3] & 0xFF;
            if (n10 > 31 || n10 == 28) {
                n4 = n3;
                n3 = T1GlyphNumber.getNumber(byArray, n3, this.operandsRead, this.operandReached, this.is1C);
                n7 = (int)this.operandsRead[this.operandReached];
                ++this.operandReached;
                if (n4 != 0) continue;
                if (this.nominalWidthX.length == 1) {
                    n8 = this.nominalWidthX[0] + n7;
                    continue;
                }
                n9 = this.glyphNumbers.get(String.valueOf(n)) - 1;
                if (n9 >= this.fdSelect.length) continue;
                n8 = this.nominalWidthX[this.fdSelect[n9]] + n7;
                continue;
            }
            if (this.is1C && n2 == 0 && n10 != 10 && n10 != 11 && n10 != 29) {
                n9 = 0;
                if (n10 == 22 || n10 == 4 || n10 == 12 && (byArray[n3 + 1] == 9 || byArray[n3 + 1] == 14 || byArray[n3 + 1] == 26 || byArray[n3 + 1] == 18 || byArray[n3 + 1] == 27 || byArray[n3 + 1] == 21 || byArray[n3 + 1] == 5)) {
                    n9 = 1;
                }
                if (n9 == 0 && this.operandReached % 2 == 1 || n9 != 0 && this.operandReached % 2 == 0) {
                    this.saveWidth(string, n, n8);
                }
            }
            ++n2;
            int n11 = n5;
            n5 = n10;
            ++n3;
            this.currentOp = 0;
            if (n5 == 12) {
                n5 = byArray[n3] & 0xFF;
                ++n3;
                if (n5 == 7) {
                    d3 = this.sbw();
                    this.operandReached = 0;
                } else if (n5 == 16 && this.allowAll || n5 != 16) {
                    bl2 = this.handle2ByteOp(glyphFactory, n, n5, n7, bl2);
                }
            } else if (n5 == 13) {
                this.hsbw(glyphFactory, string);
                this.operandReached = 0;
            } else if (this.allowAll && n5 != 0) {
                if (n5 == 1 || n5 == 3 || n5 == 18 || n5 == 23) {
                    this.hintCount += this.operandReached / 2;
                    this.operandReached = 0;
                } else if (n5 == 4) {
                    if (bl2) {
                        this.flex();
                    } else {
                        this.vmoveto(glyphFactory, bl);
                    }
                    this.operandReached = 0;
                } else if (n5 == 5) {
                    this.rlineto(glyphFactory);
                    this.operandReached = 0;
                } else if (n5 == 6 || n5 == 7) {
                    this.hvlineto(glyphFactory, n5);
                    this.operandReached = 0;
                } else if (n5 == 8) {
                    this.rrcurveto(glyphFactory);
                    this.operandReached = 0;
                } else if (n5 == 9) {
                    this.closepath(glyphFactory);
                    this.operandReached = 0;
                } else if (n5 == 10 || n5 == 29) {
                    --n2;
                    if (!this.is1C && n5 == 10 && n7 >= 0 && n7 <= 2 && n11 != 11 && this.operandReached > 5) {
                        bl2 = this.processFlex(glyphFactory, bl2, n7);
                        this.operandReached = 0;
                    } else {
                        n7 = n5 == 10 ? (n7 += this.localBias) : (n7 += this.globalBias);
                        byte[] byArray2 = n5 == 10 ? this.charStrings.get("subrs" + n7) : this.charStrings.get("global" + n7);
                        if (byArray2 != null) {
                            int n12 = byArray2.length;
                            int n13 = byArray.length;
                            int n14 = n12 + n13 - 2;
                            n6 = n6 + n12 - 2;
                            byte[] byArray3 = new byte[n14];
                            System.arraycopy(byArray, 0, byArray3, 0, n4);
                            System.arraycopy(byArray2, 0, byArray3, n4, n12);
                            System.arraycopy(byArray, n3, byArray3, n4 + n12, n13 - n3);
                            byArray = byArray3;
                            n3 = n4;
                            if (this.operandReached > 0) {
                                --this.operandReached;
                            }
                        }
                    }
                } else if (n5 == 11) {
                    --n2;
                } else if (n5 == 14) {
                    this.endchar(glyphFactory, n);
                    this.operandReached = 0;
                    n3 = n6 + 1;
                } else if (n5 == 16) {
                    this.operandReached = 0;
                } else if (n5 == 19 || n5 == 20) {
                    n3 = this.mask(n3);
                    this.operandReached = 0;
                } else if (n5 == 21) {
                    if (bl2) {
                        this.moveToAsFlex();
                    } else {
                        this.rmoveto(glyphFactory, bl);
                    }
                    this.operandReached = 0;
                } else if (n5 == 22) {
                    if (bl2) {
                        double d4 = this.operandsRead[this.currentOp];
                        this.x += d4;
                        this.pt[this.ptCount] = (float)this.x;
                        ++this.ptCount;
                        this.pt[this.ptCount] = (float)this.y;
                        ++this.ptCount;
                    } else {
                        this.hmoveto(glyphFactory, bl);
                    }
                    this.operandReached = 0;
                } else if (n5 == 24) {
                    this.rcurveline(glyphFactory);
                    this.operandReached = 0;
                } else if (n5 == 25) {
                    this.rlinecurve(glyphFactory);
                    this.operandReached = 0;
                } else if (n5 == 26 || n5 == 27) {
                    this.vvhhcurveto(glyphFactory, n5);
                    this.operandReached = 0;
                } else if (n5 == 30 || n5 == 31) {
                    this.vhhvcurveto(glyphFactory, n5);
                    this.operandReached = 0;
                }
            }
            if (d > this.y) {
                d = this.y;
            }
            if (d2 < this.y) {
                d2 = this.y;
            }
            if (n5 == 19 || n5 == 29 || n5 == 10) continue;
            bl = false;
        }
        if (d3 > this.h) {
            d = d3 - this.h;
        }
        if (d2 < d3) {
            d = 0.0;
        } else if (d3 != d2) {
            float f = (float)(d2 - (d3 - d));
            d = f < 0.0f ? (d3 - d2 <= (double)f ? (double)f : (d -= (double)f)) : 0.0;
            if (d < 0.0) {
                d = 0.0;
            }
        }
        glyphFactory.setYMin((float)d);
    }

    private boolean handle2ByteOp(GlyphFactory glyphFactory, int n, int n2, int n3, boolean bl) {
        switch (n2) {
            case 0: {
                this.operandReached = 0;
                break;
            }
            case 6: {
                this.seac(glyphFactory, n, this.currentOp);
                this.operandReached = 0;
                break;
            }
            case 12: {
                this.div();
                break;
            }
            case 16: {
                bl = this.processFlex(glyphFactory, bl, n3);
                this.operandReached = 0;
                break;
            }
            case 17: {
                this.pop();
                break;
            }
            case 33: {
                this.operandReached = 0;
                break;
            }
            case 34: {
                this.hflex(glyphFactory);
                this.operandReached = 0;
                break;
            }
            case 35: {
                this.flex(glyphFactory);
                this.operandReached = 0;
                break;
            }
            case 36: {
                this.hflex1(glyphFactory);
                this.operandReached = 0;
                break;
            }
            case 37: {
                this.flex1(glyphFactory);
                this.operandReached = 0;
                break;
            }
            default: {
                this.operandReached = 0;
            }
        }
        return bl;
    }

    private void moveToAsFlex() {
        double d = this.operandsRead[this.currentOp + 1];
        this.y += d;
        d = this.operandsRead[this.currentOp];
        this.x += d;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void flex() {
        double d = this.operandsRead[this.currentOp];
        this.y += d;
        this.pt[this.ptCount] = (float)this.x;
        ++this.ptCount;
        this.pt[this.ptCount] = (float)this.y;
        ++this.ptCount;
    }

    private void saveWidth(String string, int n, int n2) {
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            if ("notdef".equals(string)) {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, String.valueOf(n), n2);
            } else {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, string, n2);
            }
            if (!this.defaultWidthsPassed) {
                for (int i = 0; i < this.defaultWidthX.length; ++i) {
                    this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
                }
                this.defaultWidthsPassed = true;
            }
        }
    }

    @Override
    public void setCharString(String string, byte[] byArray, int n) {
        this.charStrings.put(string, byArray);
        this.glyphNumbers.put(string, n);
    }

    @Override
    public void setIndexForCharString(int n, String string) {
        if (this.charForGlyphIndex == null) {
            this.charForGlyphIndex = new String[65536];
        }
        if (n < this.charForGlyphIndex.length) {
            this.charForGlyphIndex[n] = string;
        }
    }

    @Override
    public String getIndexForCharString(int n) {
        return this.charForGlyphIndex[n];
    }

    @Override
    public boolean is1C() {
        return this.is1C;
    }

    public void setWidthValues(int[] nArray, int[] nArray2) {
        this.nominalWidthX = nArray2;
        this.defaultWidthX = nArray;
    }

    @Override
    public void setis1C(boolean bl) {
        this.is1C = bl;
    }

    @Override
    public void setRenderer(DynamicVectorRenderer dynamicVectorRenderer) {
        this.dynamicVectorRenderer = dynamicVectorRenderer;
        if (this.baseFontName != null && this.dynamicVectorRenderer != null && this.dynamicVectorRenderer.isHTMLorSVG()) {
            for (int i = 0; i < this.defaultWidthX.length; ++i) {
                this.dynamicVectorRenderer.saveAdvanceWidth(this.baseFontName, "JPedalDefaultWidth" + i, this.defaultWidthX[i]);
            }
        }
    }

    public void setFDSelect(int[] nArray) {
        this.fdSelect = nArray;
    }

    @Override
    public Map getCharStrings() {
        return Collections.unmodifiableMap(this.charStrings);
    }

    public int getGlyphNumber(String string) {
        return this.glyphNumbers.get(string);
    }
}

